![travis](https://travis-ci.org/sachinchoolur/lg-video.js.svg?branch=master)
![bower](https://img.shields.io/bower/v/lg-video.js.svg)
![npm](https://img.shields.io/npm/v/lg-video.js.svg)

# Video module for [lightgallery.js](http://sachinchoolur.github.io/lightgallery.js/)
Full featured javascript gallery. Zero dependencies.
![lightgallery](https://raw.githubusercontent.com/sachinchoolur/lightgallery.js/gh-pages/lightgallery.png)

Main features
---

* Youtube Videos Vimeo Dailymotion VK and html5 videos Support.
* Supports Videos posters.
* Supports Videojs.
* Automatically pause video when navigates to different slides.
* Option to add Youtube, Yimeo parameters.
* Automatically load youtube and vimeo thumbnails
 
Browser support
---
lightgallery supports all major browsers including IE 9 and above..


Installation
---
#### Install with Bower

You can install lightgallery video plugin using the [Bower](http://bower.io) package manager.

```sh
$ bower install lg-video.js --save
```

#### npm

You can also find lightgallery video plugin on [npm](http://npmjs.org).

```sh
$ npm install lg-video.js
```
#### Download from Github

You can also directly download lg-video from github.

#### Include Javascript files
Include lg-video plugin after lightgallery.min.js.
``` html
<body>
   ---
    <!-- Include lightgallery.js -->
    <script src="js/lightgallery.min.js"></script>
    
    <!-- Include lg-video.js -->
    <script src="js/lg-video.min.js"></script>
    
    <!-- Include other lightgallery plugins (Optional) -->
    <script src="js/lg-thumbnail.min.js"></script>
</body>  
```

Demos 
----
  * [Youtube, Vimeo Video Gallery](http://sachinchoolur.github.io/lightgallery.js/demos/videos.html)
  * [Video Gallery Without Poster](http://sachinchoolur.github.io/lightgallery.js/demos/videos.html#video-without-poster)
  * [Video Player Parameters](http://sachinchoolur.github.io/lightgallery.js/demos/videos.html#video-player-param)
  * [Automatically load thumbnails](http://sachinchoolur.github.io/lightgallery.js/demos/videos.html#auto-thumb)
  * [Html5 Video Gallery](http://sachinchoolur.github.io/lightgallery.js/demos/html5-videos.html)
  * [Html5 video gallery with videojs](http://sachinchoolur.github.io/lightgallery.js/demos/html5-videos.html#video-without-poster)
  
Docs
-----
[Options](http://sachinchoolur.github.io/lightgallery.js/docs/api.html#lg-video)

License
---

#### Commercial license
If you want to use lightgallery.js to develop commercial sites, themes, projects, and applications, the Commercial license is the appropriate license. With this option, your source code is kept proprietary. Purchase a lightgallery.js Commercial License at [uplabs.com/posts/lightgallery-js](https://www.uplabs.com/posts/lightgallery-js)

#### Open source license

If you are creating an open source application under a license compatible with the GNU GPL license v3, you may use this project under the terms of the GPLv3.

