<?php
session_start();

ini_set('display_errors', 0);              // No mostrar errores al usuario
ini_set('log_errors', 1);                  // Activar registro de errores
error_reporting(E_ALL);                    // Reportar todos los errores
// No necesitas ini_set('error_log', ...) si quieres usar el log global de PHP


if (!isset($lc_Path)) {
  $lc_Path = "./siev/";
  $lb_Ruta = false;
  $li_Iteraciones = 0;
  // BUSCAR EL ROOT ./siev
  do {
    if (file_exists($lc_Path . "Globales.php")) {
      $lb_Ruta = true;
    } else {
      $lc_Path  = "../" . preg_replace("/^\.\//", "", $lc_Path);
    }
    $li_Iteraciones++;
  } while ($lb_Ruta == false && $li_Iteraciones <= 6);
}

include_once $lc_Path . "Globales.php";
include_once $lc_Path . "php/Conexion_BD.php";


// Instanciar la variable conexin
$conn = new ConexionMySql();
$conexion = $conn->DB_conexion;

// Verificar si la conexin fue exitosa
if (!$conexion) {
  die("Error: No se pudo conectar a la base de datos.");
}

// Verificar si la base de datos es un string antes de seleccionarla
if (!isset($database_conexion) || !is_string($database_conexion)) {
  die("Error: No se ha definido el nombre de la base de datos correctamente.");
}

mysqli_select_db($conexion, $database_conexion) or die("Error al seleccionar la base de datos: " . mysqli_error($conexion));


require '../PHPMailer20/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../PHPMailer20/vendor/PHPMailer/src/PHPMailer.php';
require '../PHPMailer20/vendor/PHPMailer/src/SMTP.php';
require '../PHPMailer20/vendor/PHPMailer/src/Exception.php';



// SWITCH PARA CONTROLAR MAIL SMTP
$usar_smtp = defined('SMTP');

if (isset($_POST['codigo_robot'])) {
  $email = mysqli_real_escape_string($conexion, $_POST['email']);
  $cliente = mysqli_real_escape_string($conexion, $_POST['cliente']);

  // Consultar cliente
  $query_clientes = "SELECT * FROM clientes WHERE custom_cliente = '$cliente'";
  $clientes = mysqli_query($conexion, $query_clientes);
  if (!$clientes) {
    die("Error en la consulta de clientes: " . mysqli_error($conexion));
  }

  $row_clientes = mysqli_fetch_assoc($clientes);
  $totalRows_clientes = mysqli_num_rows($clientes);

  // Validar dominio WWW.
  $row_clientes['custom_dominio2'] = (preg_match("/www\./i", $row_clientes['custom_dominio2'])) ? $row_clientes['custom_dominio2'] : "www.todoventa.com";

  // Consultar usuario
  $query_usuarios = "SELECT * FROM usuarios WHERE email = '$email' AND usuario = '$cliente'";
  $usuarios = mysqli_query($conexion, $query_usuarios);
  if (!$usuarios) {
    die("Error en la consulta de usuarios: " . mysqli_error($conexion));
  }

  $row_usuarios = mysqli_fetch_assoc($usuarios);
  $totalRows_usuarios = mysqli_num_rows($usuarios);

  if ($totalRows_usuarios > 0) {
    $claveAleatoria = mt_rand(100000, 999999);
    $nclave = password_hash($claveAleatoria, PASSWORD_DEFAULT);

    // Actualizar contrasea en la base de datos
    $update_query = "UPDATE usuarios SET custom_password = '$nclave', estado_registro = 'A' WHERE custom_id = '" . $row_usuarios['custom_id'] . "'";


    if (!mysqli_query($conexion, $update_query)) {
      die("Error al actualizar la clave: " . mysqli_error($conexion));
    }

    // Generar URL de recuperacin
    $url = "https://" . $row_clientes['custom_dominio2'] . "/correo/recordar_clave.php?micro2=" . $row_clientes['custom_cliente'] . "&usu=" . $row_usuarios['custom_id'] . "&idcliente=" . $row_clientes['custom_cliente'] . "&clave=" . $claveAleatoria;


    // Obtener el contenido del correo
    $body = @file_get_contents($url);
    if ($body === false) {
      die("Error al obtener el contenido del correo.");
    }

    $mail = new PHPMailer(true);
    $mail->IsHTML(true);

    try {
      if (isset($usar_smtp)) {
        $mail->SMTPDebug = 0;
        $mail->isSMTP();
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = 'ssl';
        $mail->Host = trim($row_clientes['host']);
        $mail->Port = (int) $row_clientes['puerto'];
        $mail->Username = filter_var(trim($row_clientes['email_boletines']), FILTER_SANITIZE_EMAIL);
        $mail->Password = trim($row_clientes['clave']);
      }

      // FROM, Sender y nombre de empresa
      $from_email = (string)($row_clientes['email_boletines'] ?? '');
      $from_name = trim((string)($row_clientes['custom_empresa'] ?? ''));

      $mail->setFrom($from_email, $from_name);
      $mail->Sender = $from_email;
      $mail->From = $from_email;
      $mail->FromName = $from_name;

      // Asunto y cuerpo
      $mail->Subject = "Clave de acceso restablecida";
      $mail->Body = $body;
      $mail->AltBody = '';

      // List-Unsubscribe header
      $mail->AddCustomHeader("List-Unsubscribe: <mailto:{$from_email}?subject=Unsubscribe>");

      // Destinatario
      if (filter_var($row_usuarios['email'], FILTER_VALIDATE_EMAIL)) {
        $destinatario_nombre = trim($row_usuarios['first_name'] . ' ' . $row_usuarios['last_name']);
        $mail->addAddress($row_usuarios['email'], $destinatario_nombre);
      }

      // Responder al correo oficial
      $mail->addReplyTo($row_clientes['email'], $row_clientes['custom_empresa']);

      // Enviar correo
      if (!$mail->send()) {
        error_log("? No se pudo enviar el correo: {$mail->ErrorInfo} - " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
        echo "Error al enviar el correo.";
      } else {
        error_log("? Correo enviado exitosamente a: {$row_usuarios['email']} - " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
        echo "Si su correo est registrado, recibir un email de recuperacin.";
      }
    } catch (Exception $e) {
      error_log("? Error general en PHPMailer: {$mail->ErrorInfo} - " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
      echo "Error en el envo del correo.";
    }
  } else {
    echo "Si su correo esta registrado, recibira un email de recuperacin.";
    session_destroy();
  }

  mysqli_free_result($usuarios);
  mysqli_free_result($clientes);
  mysqli_close($conexion);
} else {
  echo "El cdigo de validacin no es correcto, intente de nuevo.";
}
