<?php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 'On');




$lc_Path = "./siev/";
$lb_Ruta = false;
$li_Iteraciones = 0;

// BUSCAR EL ROOT ./siev

do {
    if (file_exists($lc_Path . "Globales.php")) {
        $lb_Ruta = true;
    } else {
        $lc_Path  = "../" . preg_replace("/^\.\//", "", $lc_Path);
    }
    $li_Iteraciones++;
} while ($lb_Ruta == false && $li_Iteraciones <= 6);

include_once $lc_Path . "Globales.php";
include_once $lc_Path . "php/Conexion_BD.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../PHPMailer20/vendor/PHPMailer/src/PHPMailer.php';
require '../PHPMailer20/vendor/PHPMailer/src/SMTP.php';
require '../PHPMailer20/vendor/PHPMailer/src/Exception.php';

include_once "./identificar_dispositivo.php";


//ACTIVA FUNCION DE SEGURIDAD DE FORMULARIOS
validarFormularioSeguro();


// =======================
// Variables filtradas
// =======================

$email_contacto      = filter_var(limitarTexto($_POST['email_registro'] ?? ''), FILTER_VALIDATE_EMAIL) ?: '';
$telefono_contacto   = limitarTexto($_POST['telefono_registro'] ?? '');
$nombre_contacto     = limitarTexto($_POST['nombre_registro'] ?? '');
$apellido_contacto   = limitarTexto($_POST['apellido_registro'] ?? '');
$asunto_contacto     = 'Registro Web'; // fijo o ajustable
$pais_contacto       = limitarTexto($_POST['pais_registro'] ?? '');
$ciudad_contacto     = limitarTexto($_POST['ciudad_registro'] ?? '');
$mensaje_contacto    = mb_convert_encoding("Registro de usuario desde formulario Web", 'ISO-8859-1', 'UTF-8');
$nombre_ciudad       = limitarTexto($_POST['nombre_ciudad'] ?? '');
$condiciones         = isset($_POST['condiciones_registro']) ? '1' : '0';
$boletin             = isset($_POST['boletin']) ? '1' : '0';
$lista               = isset($_POST['lista']) ? limitarTexto($_POST['lista']) : '';
$codigo_robot        = isset($_POST['codigo_robot']) ? limitarTexto($_POST['codigo_robot']) : '';
$ipactivacion        = isset($_POST['ipactivacion']) ? limitarTexto($_POST['ipactivacion']) : '';
$clave_registro      = $_POST['clave_registro'] ?? '';
$clave2_registro     = $_POST['clave2_registro'] ?? '';
$cedula_registro     = limitarTexto($_POST['cedula_registro'] ?? '');
$direccion_registro  = limitarTexto($_POST['direccion_registro'] ?? '');
$micro2              = isset($_POST['micro2']) ? limitarTexto($_POST['micro2']) : '';


// ==============================
// DEPURACIN: Imprimir $_POST y $_GET en el log
// ==============================
// error_log("========= INICIO REQUEST =========");
// error_log("GET: " . print_r($_GET, true));
// error_log("POST: " . print_r($_POST, true));
// error_log("========= FIN REQUEST =========");


if (!isset($_SESSION['lenguaje'])) {
    $_SESSION['lenguaje'] = 'sp';
}

// SWITCH PARA CONTROLAR MAIL SMTP
if (defined('SMTP')) {
    $usar_smtp = true;
}

if (isset($_POST['codigo_robot']) && $_POST['codigo_robot'] != '') {

    $query_empresa      = "SELECT * FROM clientes WHERE custom_cliente = 'todoventa' ";
    $lo_Objeto_Empresa  = HacerConsultaQuery($query_empresa);
    $row_empresa        = $lo_Objeto_Empresa->DB_resultado[0];

    $query_clientes     = "SELECT * FROM clientes WHERE custom_cliente = '" . $lider . "' ";
    $lo_Objeto_Cliente  = HacerConsultaQuery($query_clientes);
    $row_clientes       = $lo_Objeto_Cliente->DB_resultado[0];



    /*****SQL:: Consulto si el usuario existe en la base de datos *****/

    //mysqli_select_db($conexion, $database_conexion);

    $email_contacto_sql = mysqli_real_escape_string($conexion, $email_contacto);

    $query_usuarios = "SELECT custom_id, custom_password FROM usuarios WHERE email = '$email_contacto_sql' ";

    $lo_Objeto_Usuarios = HacerConsultaQuery($query_usuarios);

    // Si el usuario ya existe en la base de datos se envia correo de notificacion.

    if ($lo_Objeto_Usuarios->DB_registros > 0) {

        if (isset($_POST['actualizacion']) && $_POST['actualizacion'] != '') {

            if (!empty($clave_registro)) {

                // COMPARAR PARA SABER SI SE REALIZA NUEVAMENTE UN LOGIN
                if (strlen($clave_registro) < 32) {
                    $clave_registro = password_hash($clave_registro, PASSWORD_DEFAULT);
                }
            }
            // 1. Definir los valores filtrados
            $cargo_registro         = isset($_POST['cargo_registro']) ? limitarTexto($_POST['cargo_registro']) : '';
            $custom_pais            = $pais_contacto;
            $custom_ciudad          = urldecode($nombre_ciudad);
            $custom_codciudad       = $ciudad_contacto;
            $first_name             = urldecode($nombre_contacto);
            $last_name              = urldecode($apellido_contacto);
            $custom_telefono        = $telefono_contacto;
            $custom_direccion       = urldecode($direccion_registro);
            $custom_cedula          = $cedula_registro;
            $custom_observaciones   = $datos_sesion;
            $custom_id              = intval($lo_Objeto_Usuarios->DB_resultado[0]['custom_id']);
            $fecha_actualizacion    = date('Y-m-d H:i:s');

            // 2. Construir el SQL preparado
            $sql = "UPDATE usuarios SET 
            custom_cargo = ?,
            custom_pais = ?,
            custom_ciudad = ?,
            custom_codciudad = ?,
            first_name = ?,
            last_name = ?,
            custom_telefono = ?,
            custom_direccion = ?,
            custom_fechactu = ?,
            custom_cedula = ?,
            custom_observaciones = ?
             WHERE 
            custom_id = ?";

            // 3. Definir los parmetros y tipos
            $params = [
                $cargo_registro,
                $custom_pais,
                $custom_ciudad,
                $custom_codciudad,
                $first_name,
                $last_name,
                $custom_telefono,
                $custom_direccion,
                $fecha_actualizacion,
                $custom_cedula,
                $custom_observaciones,
                $custom_id
            ];

            // Tipos de datos:
            // s = string
            // i = integer
            $types = "sssssssssssi";  // ? Correcto: 11 's' + 1 'i' = 12


            // 4. Ejecutar usando tu mtodo seguro
            $lo_Usuario = HacerConsultaPreparada($sql, $params, $types);

            // 5. Verificar resultado
            if ($lo_Usuario === false || $lo_Usuario->DB_error != 'No') {
                echo "error usuario";
            } else {
                // Actualizar sesin si es necesario
                if (isset($_SESSION['comprador'])) {
                    $_SESSION['comprador']['custom_pais']       = $pais_contacto;
                    $_SESSION['comprador']['custom_ciudad']     = $nombre_ciudad;
                    $_SESSION['comprador']['custom_codciudad']  = $ciudad_contacto;
                    $_SESSION['comprador']['first_name']        = $nombre_contacto;
                    $_SESSION['comprador']['last_name']         = $apellido_contacto;
                    $_SESSION['comprador']['custom_telefono']   = $telefono_contacto;
                    $_SESSION['comprador']['custom_direccion']  = $direccion_registro;
                    $_SESSION['comprador']['custom_cedula']     = $cedula_registro;
                    $_SESSION['comprador']['custom_cargo']     = $cargo_registro;
                }

                echo "ok";
            }
        } else {
            echo "email existente";
        }
    } else {
        // Definir clave aleatoria o usar la enviada filtrada
        $claveAleatoria = (!empty($clave_registro)) ? $clave_registro : (string)mt_rand(123456, 99999999);

        // Establecer si hay pedidos
        $_SESSION['pedidos'] = (!empty($clave_registro)) ? 'Y' : 'Y'; // siempre se forza a 'Y', pero la condicin no es necesaria

        // Encriptar la clave a 32 caracteres usando hash seguro
        $nclave = password_hash($claveAleatoria, PASSWORD_DEFAULT);
        // 1. Definir los valores filtrados
        $usuario             = $lider;
        $custom_estado       = 'Inscrito';
        $custom_password     = $nclave;
        $custom_nivelacceso  = 'Activado';
        $custom_fecingreso   = date('Y-m-d H:i:s');
        $custom_pais         = $pais_contacto;
        $custom_codciudad    = $ciudad_contacto;
        $custom_ciudad       = urldecode($nombre_ciudad);
        $first_name          = urldecode($nombre_contacto);
        $last_name           = urldecode($apellido_contacto);
        $email               = $email_contacto;
        $custom_telefono     = $telefono_contacto;
        $custom_direccion    = urldecode($direccion_registro);
        $tipoing             = 'Y'; // Tipo de ingreso
        $estado_registro     = 'A'; // Estado activo
        $idioma              = $_SESSION['lenguaje'];
        $custom_cedula       = $cedula_registro;
        $custom_empresa      = isset($_POST['empresa_registro']) ? limitarTexto($_POST['empresa_registro']) : '';
        $custom_cargo        = isset($_POST['cargo_registro']) ? limitarTexto($_POST['cargo_registro']) : '';
        $ip_activacion       = $ipactivacion;
        $custom_observaciones = $datos_sesion;

        // 2. Construir el SQL preparado
        $sql = "INSERT INTO usuarios (
    usuario, custom_estado, custom_password, custom_nivelacceso, custom_fecingreso,
    custom_pais, custom_codciudad, custom_ciudad, first_name, last_name, email,
    custom_telefono, custom_direccion, tipoing, estado_registro, idioma, custom_cedula,
    custom_empresa, custom_cargo, ip_activacion, custom_observaciones
) VALUES (
    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
)";

        // 3. Definir los parmetros y tipos
        $params = [
            $usuario,
            $custom_estado,
            $custom_password,
            $custom_nivelacceso,
            $custom_fecingreso,
            $custom_pais,
            $custom_codciudad,
            $custom_ciudad,
            $first_name,
            $last_name,
            $email,
            $custom_telefono,
            $custom_direccion,
            $tipoing,
            $estado_registro,
            $idioma,
            $custom_cedula,
            $custom_empresa,
            $custom_cargo,
            $ip_activacion,
            $custom_observaciones
        ];

        // Tipos de datos:
        // - 20 valores
        // - Todos son string ("s") salvo que tengas alguno que sea nmero (aqu, todos textos)
        $types = str_repeat('s', count($params)); // genera "ssssssssssssssssssss"

        // 4. Ejecutar usando tu mtodo seguro
        $lo_Usuario = HacerConsultaPreparada($sql, $params, $types);


        // CREAR UN LOG CON LAS CLAVES GENERADAS

        //error_log("Informacion: ".$lc_Query_Usuario ." Cambio Clave - Usuario : ".$_POST['emailinsins']." - Password : ".$claveAleatoria." ".Date('Y-m-d H:i:s'),3,'../siev/Log/claves.log');

        //echo "<br>".$lc_Query_Usuario." .--- ".$_SESSION['lenguaje']." ".$_POST['clave_registro'];



        if ($lo_Usuario->DB_error != "No") {

            //echo "error usuario ";

        } else {
            $idu = $lo_Usuario->DB_Id;
            // SI LA VARIABLE BOLETIN LLEGA EN 1, ENTONCES INGRESAR A UNA LISTA

            if ($boletin == '1') {

                // Variables listas
                $cliente         = $row_clientes['custom_cliente'];
                $usuario         = intval($idu);
                $lista_usuario   = $lista;
                $lista_general   = $row_clientes['lista_general'];

                // Insertar a lista especfica enviada
                $sql_lista = "INSERT INTO listas (cliente, usuario, lista) VALUES (?, ?, ?)";
                $params_lista = [$cliente, $usuario, $lista_usuario];
                $types_lista = "sis"; // s = string, i = integer, s = string

                $lo_Lista = HacerConsultaPreparada($sql_lista, $params_lista, $types_lista);

                // Insertar a lista general del cliente
                $sql_lista_general = "INSERT INTO listas (cliente, usuario, lista) VALUES (?, ?, ?)";
                $params_lista_general = [$cliente, $usuario, $lista_general];
                $types_lista_general = "sis"; // s = string, i = integer, s = string

                $lo_ListaGeneral = HacerConsultaPreparada($sql_lista_general, $params_lista_general, $types_lista_general);
            }



            // Asegurar que $idu es numrico
            $idu_sql = intval($idu);

            // 1. Armar el query preparado
            $sql_usuarioins = "SELECT * FROM usuarios WHERE custom_id = ?";

            // 2. Definir los parmetros y tipos
            $params_usuarioins = [intval($idu_sql)];
            $types_usuarioins = "i"; // i = integer

            // 3. Ejecutar con HacerConsultaPreparada
            $lo_Usuario = HacerConsultaPreparada($sql_usuarioins, $params_usuarioins, $types_usuarioins);


            if ($lo_Usuario->DB_registros > 0) {
                $row_usuarios = $lo_Usuario->DB_resultado[0];

                // Variables listas y filtradas
                $idu_sql           = intval($idu); // ID siempre como nmero entero
                $pais              = $pais_contacto;
                $ciudad            = $ciudad_contacto;
                $direccion         = urldecode($direccion_registro);
                $telefono          = $telefono_contacto;
                $fecha_ingreso     = date('Y-m-d H:i:s');
                $estado_registro   = 'A';
                $alias             = 'Principal';

                // Armar query preparado
                $sql_direccion = "INSERT INTO usuario_direccion (
        usuarios, pais, ciudades, direccion, telefono, fecha_ingreso, estado_registro, alias
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

                // Definir parmetros y tipos
                $params_direccion = [
                    $idu_sql,
                    $pais,
                    $ciudad,
                    $direccion,
                    $telefono,
                    $fecha_ingreso,
                    $estado_registro,
                    $alias
                ];
                $types_direccion = "isssssss"; // i = int, s = string (7 strings)

                // Ejecutar query seguro
                $la_Resultado_Direccion = HacerConsultaPreparada($sql_direccion, $params_direccion, $types_direccion);

                // Realizar Auto Login (sesin segura)
                $_SESSION['comprador'] = $idu_sql;
                $_SESSION["ultimoAcceso"] = date("Y-n-j H:i:s");
                $_SESSION['cliente_portal'] = $row_usuarios;
            }


            switch ($_SESSION['lenguaje']) {

                case 'sp':
                    include($lc_Path . '../idiomas/espanol.php');
                    break;

                case 'por':
                    include($lc_Path . '../idiomas/portugues.php');
                    break;

                case 'ing':
                    include($lc_Path . '../idiomas/ingles.php');
                    break;

                default:
                    include($lc_Path . '../idiomas/espanol.php');
                    break;
            }


            if (isset($_SESSION['pedidos']) && $_SESSION['pedidos'] == 'Y') {
                if (isset($row_clientes)) {
                    if (!empty($lista)) { // Usar variable filtrada $lista
                        $SITEguardainscripcion = "<script language='javascript'>
                            if (top == self) self.location.href = 'https://{$row_clientes['custom_dominio2']}/?f_registro=1&ver=1&micro2={$row_clientes['custom_cliente']}&leng=sp&msg=SITEmsginsy&lista={$lista}&tipo=1396&v_Pgral=1';
                        </script>";
                    }
                    if (isset($row_usuarios)) {
                        if (!empty($claveAleatoria)) {
                            $SITEurlinscripcion = "https://{$row_clientes['subdominio']}/correo/inscripcion_carro.php?micro2={$row_clientes['custom_cliente']}&usu={$row_usuarios['custom_id']}&idcliente={$row_clientes['custom_cliente']}&clave={$claveAleatoria}";
                        } else {
                            $SITEurlinscripcion = "https://{$row_clientes['subdominio']}/correo/inscripcion_carro.php?micro2={$row_clientes['custom_cliente']}&usu={$row_usuarios['custom_id']}&idcliente={$row_clientes['custom_cliente']}&clave=";
                        }
                    }
                    $SITEasuntoinscripcion = "Gracias por su Inscripcin de acceso a {$row_clientes['custom_empresa']}";
                }
                $SITEmsginsy = "Gracias por registrarse en el sistema, le hemos enviado un correo de confirmacin a su correo electrnico con informacin para acceder a su cuenta, realizar pedidos y actualizar sus datos. Ya puedes empezar a disfrutar de productos 100% colombianos hechos con el mayor cario por nuestros microempresarios.";
            }

            // ========================
            // ENVO DEL CORREO PRINCIPAL
            // ========================
            $body = file_get_contents($SITEurlinscripcion);
            $mail = new PHPMailer();
            $mail->IsHTML(true);

            if (isset($usar_smtp)) {
                $mail->SMTPDebug = 0;
                $mail->SMTPAuth = true;
                $mail->SMTPSecure = 'ssl';
                $mail->Host     = trim($row_clientes['host']);
                $mail->Port     = (int) $row_clientes['puerto'];
                $mail->Username = filter_var(trim($row_clientes['email_boletines']), FILTER_SANITIZE_EMAIL);
                $mail->Password = trim($row_clientes['clave']);
            }

            $mail->setFrom(
                (string)($row_clientes['email_boletines'] ?? ''),
                trim((string)($row_clientes['custom_empresa'] ?? ''))
            );


            $mail->Sender = (string)($row_clientes['email_boletines'] ?? '');


            $mail->From = $row_clientes['email_boletines'];
            $mail->FromName = $row_clientes['custom_empresa'];
            $mail->Subject = $SITEasuntoinscripcion;
            $mail->Body = $body;
            $mail->AltBody = '';
            $mail->AddCustomHeader("List-Unsubscribe: <mailto:{$row_clientes['email_boletines']}?subject=Unsubscribe>");

            if (filter_var($email_contacto, FILTER_VALIDATE_EMAIL)) {
                $nombre_destinatario = trim((string)urldecode(($nombre_contacto ?? '') . ' ' . ($apellido_contacto ?? '')));
                $mail->AddAddress((string)$email_contacto, $nombre_destinatario);
                $mail->addAddress($row_clientes['email'], $row_clientes['custom_empresa']);
            }

            //RESPONDER AL CORREO QUE ESTA EN SIEV
            $mail->addReplyTo($row_clientes['email'], $row_clientes['custom_empresa']);

            if (!$mail->send()) {
                echo 'Mailer Error: ' . $mail->ErrorInfo;
                error_log("Error envo mail {$row_clientes['email']} - {$email_contacto} - {$mail->ErrorInfo} " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
            } else {
                echo $SITErescontacto;
                error_log("Envo mail {$row_clientes['email']} - {$email_contacto} - {$mail->ErrorInfo} " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
            }

            // ========================
            // ENVO DEL CORREO ALERTA
            // ========================
            $urlalerta = "https://{$row_clientes['subdominio']}/correo/inscripcion_alerta.php?usu={$idu}&idcliente={$row_clientes['custom_cliente']}";
            $body = file_get_contents($urlalerta);
            $mail = new PHPMailer();
            $mail->IsHTML(true);

            if (isset($usar_smtp)) {
                $mail->SMTPDebug = 0;
                $mail->SMTPAuth = true;
                $mail->SMTPSecure = 'ssl';
                $mail->Host     = trim($row_clientes['host']);
                $mail->Port     = (int) $row_clientes['puerto'];
                $mail->Username = filter_var(trim($row_clientes['email_boletines']), FILTER_SANITIZE_EMAIL);
                $mail->Password = trim($row_clientes['clave']);
            }

            $mail->setFrom(
                (string)($row_clientes['email_boletines'] ?? ''),
                trim((string)($row_clientes['custom_empresa'] ?? ''))
            );

            $mail->Subject = "Alerta - Inscripcin Usuario al SIEV";
            $mail->Body = $body;
            $mail->AltBody = '';
            $mail->AddCustomHeader("List-Unsubscribe: <mailto:{$row_clientes['email']}?subject=Unsubscribe>");
            if (filter_var($row_clientes['email'], FILTER_VALIDATE_EMAIL)) {
                $nombre_cliente = trim((string)$row_clientes['custom_empresa']);
                $mail->AddAddress((string)$row_clientes['email'], $nombre_cliente);
            }
            //RESPONDER AL CORREO QUE ESTA EN SIEV
            $mail->addReplyTo($row_clientes['email'], $row_clientes['custom_empresa']);

            if (!$mail->send()) {
                echo 'Mailer Error: ' . $mail->ErrorInfo;
                error_log("Error envo alerta {$row_clientes['email']} - {$email_contacto} - {$mail->ErrorInfo} " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
            } else {
                echo $SITErescontacto;
                error_log("Envo alerta {$row_clientes['email']} - {$email_contacto} - {$mail->ErrorInfo} " . date('Y/m/d H:i:s') . "\n", 3, "../siev/Log/logerror.txt");
            }

            // ========================
            // ENVO DEL SMS
            // ========================
            $telefono_contacto_sql = mysqli_real_escape_string($conexion, $telefono_contacto);
            $mensaje_bienvenida_callback = urlencode("$nombre_contacto $apellido_contacto Gracias por registrarse en {$row_clientes['custom_dominio2']} Lo invitamos a hacer sus compras en nuestra tienda en lnea");

            $query_callback = "INSERT INTO callback (fecha, telefono_cliente, telefono_usuario, tipo) 
            VALUES ('" . date('Y-m-d H:i:s') . "', '{$row_clientes['tel_callback']}', '57{$telefono_contacto_sql}', 'SMS Inscritos')";

            $query_call = mysqli_query($conexion, $query_callback) or die(mysqli_error($conexion));


            /*				
		
	
//Seccion de integracin CRM Vtiger 
header("Content-Type: text/html; charset=utf-8");
// URL de procesamiento de captura de datos de Webform	  
$url_CRM = 'http://crm.nativos.com.co/modules/Webforms/capture.php';
// ID entregado por el CRM para el formulario Clave nica de Formularios.
$id__vtrftk_CRM = 'sid:ed25f0c07c6085012a93e661febeb779695edb87,1512070646';

// ID entregado por el CRM para el formulario Clave nica.
$id_Publico_CRM = 'ae5c17572f4b65a2845a3f6c0ec7a93a';
// Nombre del formulario en el CRM
$nom_Form_CRM = 'Contactenos_SIEV';
//Nombre del Usuario
$firstname_CRM = $_POST['nombre_registro'];
//Apellidos del Usuario
$lastname_CRM = $_POST['apellido_registro'];
//Telefono del contacto
$phone_CRM = $_POST['telefono_registro'];
//Direccion del contacto
$direccion_CRM = $_POST['direccion_registro'];
//Email del contacto
$email_CRM = $_POST['email_registro'];
//Pais del contacto
$pais_CRM = $_POST['pais_registro'];
//URL de procedencia contacto
$website_CRM = $_POST['interesado'];
//Ciudad del contacto
$ciudad_CRM = utf8_encode($_POST['nombre_ciudad']);

//Asunto del mensaje
$asunto_CRM = "Inscrito al Sitio - Comprador";
//Poner en el envio esta etiqueta

//Descripcin o solicitud del contacto
$description_CRM = "Inscrito al Sitio - Comprador";
//Procedencia del contacto
$leadsource_CRM = 'Sitio Web';

//INICIA ENVIO DE DATOS AL CRM VTIGER
$ch = curl_init($url_CRM);
//Inicializacion de variables 
curl_setopt ($ch, CURLOPT_POST, 1);
//Envio de campos generados en el formulario
curl_setopt ($ch, CURLOPT_POSTFIELDS, "__vtrftk=".urlencode($id__vtrftk_CRM)."&publicid=".urlencode($id_Publico_CRM)."&name=".urlencode($nom_Form_CRM)."&VTIGER_RECAPTCHA_PUBLIC_KEY=".urlencode('RECAPTCHA PUBLIC KEY FOR THIS DOMAIN')."&firstname=".$firstname_CRM."&lastname=".$lastname_CRM."&phone=".$phone_CRM."&mobile=".$phone_CRM."&city=".$ciudad_CRM."&country=".$pais_CRM."&email=".$email_CRM."&leadsource=".$leadsource_CRM."&description=".$description_CRM."&website=".$website_CRM."&lane=".$direccion_CRM."");

curl_exec ($ch);
curl_close ($ch);
//FINALIZA ENVIO DE DATOS AL CRM VTIGER



//	AUTO LOGUE EN EL SISTEMA POR CURL

// URL de procesamiento de captura de datos para proceder con logueo	  
$url_Logueo = "https://www.nativos.com.co/siev/php/Funciones_Generales.php";
//Email del contacto
$email_Logueo = $_POST['email_registro'];
//Pais del contacto
$accion_Logueo = 'Loguear';
//URL de procedencia contacto
$clave_Logueo = $_POST['clave_registro'];

//INICIA ENVIO DE DATOS AL CRM VTIGER
$ch = curl_init($url_Logueo);
//Inicializacion de variables 
curl_setopt ($ch, CURLOPT_POST, 1);
//Envio de campos generados en el formulario
curl_setopt ($ch, CURLOPT_POSTFIELDS, "email=".$email_Logueo."&accion=".$accion_Logueo."&clave=".$clave_Logueo."");
curl_exec ($ch);
curl_close ($ch);
//FINALIZA ENVIO DE DATOS AL CRM VTIGER

*/
        }
    }


    // ESTA SECCION ESTA PENDIENTE POR TERMINA, LA IDEA ES QUE REDIRECCIONE AL HOME Y LOGUEE EL CLIENTE
    /*
echo "<form name='form' id='form' action='../siev/php/Funciones_Generales.php' method='post'>";

echo "<input type='hidden' name='email' value='$_POST[email_registro]'>";
echo "<input type='hidden' name='accion' value='Loguear'>";
echo "<input type='hidden' name='clave' value='$_POST[clave_registro]'>";
echo "</form>";
echo "<script language='javascript'>document.form.submit();</script>";

*/
} else {

    echo "error verificacion";
}

//echo $_SESSION['lenguaje'] ;
//echo $SITEurlinscripcion;
//echo $_SESSION['pedidos'];
