<?php
error_reporting(E_ALL);
ini_set('display_errors', 'On');

$lc_Path_Funciones = "./siev/";
$lb_Ruta = false;
$li_Iteraciones = 0;
// BUSCAR EL ROOT ./siev
do {
    if (file_exists($lc_Path_Funciones . "Globales.php")) {
        $lb_Ruta = true;
    } else {
        $lc_Path_Funciones  = "../" . preg_replace("/^\.\//", "", $lc_Path_Funciones);
    }
    $li_Iteraciones++;
} while ($lb_Ruta == false && $li_Iteraciones <= 6);

if (!defined('DBNAME')) {
    include_once $lc_Path_Funciones . "Globales.php";
    include_once $lc_Path_Funciones . "php/Conexion_BD.php";
    include_once $lc_Path_Funciones . "php/Modulo_Variables_Get.php";
}

if (!function_exists('Combinar_Registro_Plantilla')) {
    function Combinar_Registro_Plantilla($row, $lc_Html)
    {
        $lb_Encontrado = false;

        // REEMPLAZAR LOS CARACTERES DE APERTURA Y CIERRE POR LOS TAGS       
        $lc_Html = str_replace("&raquo;", "", str_replace("&laquo;", "", $lc_Html ?? ''));

        if (preg_match_all("/\([0-9a-z\_]{1,})\/i", $lc_Html, $la_Atributos)) {
            $lb_Encontrado = true;
            array_shift($la_Atributos);
        }

        if ($lb_Encontrado == true) {
            $li_Total_Atributos = count($la_Atributos[0]);
            for ($li_Atributo = 0; $li_Atributo < $li_Total_Atributos; $li_Atributo++) {
                $lc_Atributo = $la_Atributos[0][$li_Atributo];
                if (in_array($lc_Atributo, array_keys($row))) {

                    //print_r( array_keys($row) ); 
                    $lc_Html = preg_replace("/\" . $lc_Atributo . "\/i", $row[$lc_Atributo] ?? '', $lc_Html);
                } else {
                    //print_r( array_keys($row) ); 
                }
            }
            // LIMPIAR LAS REFERENCIAS NULAS
            $lc_Html = preg_replace("/\[A-z]{1,}\/i", "", $lc_Html);
        }
        return $lc_Html;
    }
}

function Reemplaza_Ingles($lc_String, $lb_Parametro = true)
{
    $la_Salida = array();

    // REEMPLAZAR LOS TAGS POR SU HTML
    //$lc_String = str_replace("&lt;","<", (str_replace("&gt;",">",$lc_String)) );

    if (preg_match_all("/\[ingles\][\x20-\xFA\r\n\t]{1,}\[\/ingles\]/i", $lc_String, $la_Resultado)) {
        $li_Total_Coincidencias = count($la_Resultado);
        for ($li_Coincidencia = 0; $li_Coincidencia < $li_Total_Coincidencias; $li_Coincidencia++) {
            //echo str_replace("<ingles>","<div class='ingles'>", str_replace("</ingles>","</div>",$la_Resultado[$li_Coincidencia][0]));
            if ($lb_Parametro == false) {
                $lc_String = str_replace($la_Resultado[$li_Coincidencia][0], "", $lc_String);
            } else {
                $la_Salida[] = str_replace("[ingles]", "", str_replace("[/ingles]", "", $la_Resultado[$li_Coincidencia][0]));
            }
        }

        if ($lb_Parametro == false) {
            $la_Salida[] = $lc_String;
        }
    } else {
        $la_Salida[] = $lc_String;
    }
    //echo $lc_String;

    return implode("", $la_Salida);
}

function Leer_Contenido_Carpeta($lc_Ruta, $lc_Extension = "(\.jpg|\.gif|\.png)", $lc_Restriccion = "")
{
    $la_Ruta = array();

    if ($li_Consulta = @opendir($lc_Ruta)) {
        while (false !== ($lc_NombreArchivo = readdir($li_Consulta))) {
            if ($lc_NombreArchivo != "." && $lc_NombreArchivo != "..") {
                //echo "<br>".$lc_NombreArchivo;
                if (preg_match('/' . $lc_Extension . "$/", strtolower($lc_NombreArchivo))) {
                    $lb_Ok = true;
                    if ($lc_Restriccion != '') {
                        if (preg_match($lc_Restriccion, $lc_NombreArchivo)) {
                            $lb_Ok = false;
                        }
                    }
                    if ($lb_Ok == true) {
                        $la_Ruta[] = $lc_NombreArchivo;
                    }
                }
            }
        }
        closedir($li_Consulta);
    }
    sort($la_Ruta);
    return $la_Ruta;
}

function urls_amigables($url)
{
    // Tranformamos todo a minusculas
    $url = strtolower($url);
    //Rememplazamos caracteres especiales latinos
    $find = array('', '', '', '', '', '', 'á', 'é', '*', 'ó', 'ú', '', '', '', '', '', 'ä', 'ë', 'ï', 'ö', 'ü', '?', 'É', '?', 'Ó', 'Ú', 'Ä', 'Ë', '?', 'Ö', 'Ü', 'ñ');
    $repl = array('a', 'e', 'i', 'o', 'u', 'n', 'a',  'e',  'i',  'o',  'u',  'a', 'e', 'i', 'o', 'u', 'a',  'e',  'i',  'o',  'u',  'a',  'e',  'i',  'o',  'u',  'a',  'e',  'i',  'o',  'u',  'n');
    //$url = ereg_replace ($find, $repl, $url);

    $url  = array_replace($find, $repl);

    // Aaadimos los guiones
    $find = array(' ', '&', '\r\n', '\n', '+');
    $url = str_replace($find, '-', $url);
    // Eliminamos y Reemplazamos dems caracteres especiales
    $find = array('/[^a-z0-9\-<>]/', '/[\-]+/', '/<[^>]*>/');
    $repl = array('', '-', '');
    $url = preg_replace($find, $repl, $url);

    return $url;
}

function Dividir_Cadena($lc_Cadena)
{
    $la_Cadena          = explode(" ", $lc_Cadena);
    $li_Palabras        = count($la_Cadena);
    $la_Nueva_Cadena    = array();
    $lc_Segmento_Cadena = "";
    for ($li_Palabra = 0; $li_Palabra < $li_Palabras; $li_Palabra++) {
        $la_Nueva_Cadena[]   = $la_Cadena[$li_Palabra];
        $lc_Segmento_Cadena .= $la_Cadena[$li_Palabra];
        if (strlen($lc_Segmento_Cadena) > 35) {
            $la_Nueva_Cadena[] = "<br>";
            $lc_Segmento_Cadena = "";
        }
    }
    return implode(" ", $la_Nueva_Cadena);
}

function Caracteres_Especiales($lc_Cadena)
{
    $la_Valores     = array(chr(209), '', '', '', '', '', '', '', '', '', '', '', 'RO.', 'RO.', '', '', '', '', '', '', '', '', '', '');
    $la_Especiales  = array('&#209;', '&#211;', '&#218;', '&#201;', '&#193;', '&#205;', '', '', '', '', '', '', '', '&#186;', '', '', '', '', '', '', '', '', '', '');
    $lc_Cadena      = str_replace($la_Especiales, $la_Valores, $lc_Cadena);
    return $lc_Cadena;
}

function Caracteres_Especiales_Archivos($lc_Cadena)
{
    $la_Valores     = array('O', 'U', 'E', 'A', 'I', 'N', 'a', 'e', 'i', 'o', 'u', 'n', '-');
    $la_Especiales  = array('', '', '', '', '', '', '', '', '', '', '', '', ' ');
    $lc_Cadena      = preg_replace("/[^0-9a-z\x2E]/i", "-", str_replace($la_Especiales, $la_Valores, $lc_Cadena));
    return $lc_Cadena;
}

if (!function_exists("Eliminar_Caracteres_No_Numericos")) {
    function Eliminar_Caracteres_No_Numericos($lc_Cadena)
    {

        if ($_SESSION['tipo_distribuidor'] == 'productos_moneda') {
            $lc_Cadena      = preg_replace("/[^0-9]/", "", $lc_Cadena);
        } else {
            $lc_Cadena      = preg_replace("/[^0-9].[^0-9]/", "", $lc_Cadena);
        }
        return $lc_Cadena;
    }
}


function Formato_Fecha($ld_Fecha)
{
    $la_Mes    = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');

    if ($ld_Fecha != "0000-00-00" &&  $ld_Fecha != "00-00-0000") {
        if (preg_match("/([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/", $ld_Fecha, $la_Resultado)) {
            try {
                $lc_Fecha = $la_Resultado[1] . ' de ' . $la_Mes[preg_replace("/^0/", "", $la_Resultado[2]) - 1] . ' de ' . $la_Resultado[3];
            } catch (Exception $e) {
                $lc_Fecha = $ld_Fecha;
            }
        } else {
            if (preg_match("/([0-9]{4})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{1,2})/", $ld_Fecha, $la_Resultado)) {
                try {
                    $lc_Fecha = $la_Resultado[3] . ' de ' . $la_Mes[preg_replace("/^0/", "", $la_Resultado[2]) - 1] . ' de ' . $la_Resultado[1];
                } catch (Exception $e) {
                    $lc_Fecha = $ld_Fecha;
                }
            } else {
                $lc_Fecha = $ld_Fecha;
            }
        }
    } else {
        $lc_Fecha = $ld_Fecha;
    }
    return $lc_Fecha;
}

function Corregir_Fecha($lc_Fecha)
{
    $lb_Corregir = true;
    $lc_Fecha = (preg_match("/\//", $lc_Fecha, $la_Resultado)) ? str_replace('/', '-', $lc_Fecha) : $lc_Fecha;

    if (preg_match("/^([0-9]{2})\-([0-9]{2})\-([0-9]{4})/", $lc_Fecha, $la_Resultado)) {
        $lc_Fecha = $la_Resultado[3] . '-' . $la_Resultado[2] . '-' . $la_Resultado[1];
    }
    return $lc_Fecha;
}

function Eliminar_Caracteres_No_Autorizados($lc_Cadena)
{
    return preg_replace("/\x3C|\x3D|\x3E|\x28|\x29|\(|\)|\x60|\x5C|\'/i", "", $lc_Cadena);
}

function Reemplazar_Codigo_Query($lc_Cadena, $lc_Codigo)
{
    if (!preg_match("/\|/", Eliminar_Caracteres_No_Autorizados($lc_Codigo), $la_Arreglo)) {
        $lc_Cadena = str_replace("?", $lc_Codigo, $lc_Cadena);
    } else {
        $la_Codigo  = explode('|', $lc_Codigo);
        for ($li_Codigo = 0; $li_Codigo < count($la_Codigo); $li_Codigo++) {
            $li_Posicion = strpos($lc_Cadena, '?');
            if ($li_Posicion > 0) {
                $lc_Cadena = substr($lc_Cadena, 0, $li_Posicion) . Eliminar_Caracteres_No_Autorizados($la_Codigo[$li_Codigo]) . substr($lc_Cadena, ($li_Posicion + 1));
            }
        }
    }
    return $lc_Cadena;
}

function Cargar_Objeto_Select($lc_Query, $lc_Id_Objeto, $valor = "", $seleccion = true)
{
    $lo_ObjetoConsulta = HacerConsultaQuery($lc_Query);
    if ($lo_ObjetoConsulta->DB_registros > 0) {
        echo "<script type='text/javascript'>
                  //alert(document.domain);
                  var lo_Ventana = parent.top;
                  lo_Combo = (document.getElementById('" . $lc_Id_Objeto . "') != null) ? document.getElementById('" . $lc_Id_Objeto . "') : parent.document.getElementById('" . $lc_Id_Objeto . "');\n
                  if (lo_Combo != null) {
                      lo_Combo.length = 0;\n";
        if ($seleccion == true) {
            echo "lo_Combo[0] = new Option ('Seleccionar','');\n";
        }
        $li_Indice  = 0;
        for ($li_Contador = 0; $li_Contador < $lo_ObjetoConsulta->DB_registros; $li_Contador++) {
            if ($valor != '' && $valor == $lo_ObjetoConsulta->DB_resultado[$li_Contador][$lo_ObjetoConsulta->DB_atributos[0]]) {
                $li_Indice = $li_Contador;
            }
            echo " lo_Combo[lo_Combo.length] = new Option ('" . addslashes($lo_ObjetoConsulta->DB_resultado[$li_Contador][$lo_ObjetoConsulta->DB_atributos[1]]) . "','" . addslashes($lo_ObjetoConsulta->DB_resultado[$li_Contador][$lo_ObjetoConsulta->DB_atributos[0]]) . "');\n";
        }
        echo "lo_Combo.selectedIndex=" . $li_Indice . ";\n";
        echo "  }
                  // EJECUTAR LA FUNCION Datos_Carga_Id_Objeto
                  if (typeof Datos_Carga_" . $lc_Id_Objeto . " == 'function') { 
                      Datos_Carga_" . $lc_Id_Objeto . "();
                  } else {
                      if (typeof parent.Datos_Carga_" . $lc_Id_Objeto . " == 'function') { parent.Datos_Carga_" . $lc_Id_Objeto . "(); }
                  }
                </script>";
    } else {
        echo "<script type='text/javascript'>
                  lo_Combo = (document.getElementById('" . $lc_Id_Objeto . "') != null) ? document.getElementById('" . $lc_Id_Objeto . "') : parent.document.getElementById('" . $lc_Id_Objeto . "');\n
                  if (lo_Combo != null) {
                      lo_Combo.length = 0;
                      lo_Combo[0]     = new Option ('No se encontraron datos','');
                  }
                </script>";
    }
}

function Cargar_Combo_Consulta($id, $objeto, $codigo, $valor = "")
{
    global $la_Detalle_Select, $lc_Cookie_Usuario, $lc_Cookie_Codigo;


    if (isset($la_Detalle_Select[$id])) {
        $la_Detalle_Select[$id]["Query"] = Reemplazar_Codigo_Query($la_Detalle_Select[$id]["Query"], $codigo);
        // ESPECIFICAR QUERY POR PERFIL
        if (isset($la_Detalle_Select[$id]["Perfil"]) && $lc_Cookie_Usuario != 'admin') {
            $la_Detalle_Select[$id]["Query"] = $la_Detalle_Select[$id]["Query"] . str_replace('?', $lc_Cookie_Codigo, $la_Detalle_Select[$id]["Perfil"]);
        }
        if (isset($la_Detalle_Select[$id]["Orden"])) {
            $la_Detalle_Select[$id]["Query"] = $la_Detalle_Select[$id]["Query"] . $la_Detalle_Select[$id]["Orden"];
        } else {
            $la_Detalle_Select[$id]["Query"] = $la_Detalle_Select[$id]["Query"];
        }

        $seleccion = (isset($la_Detalle_Select[$id]["No_Seleccion"])) ? false : true;
        // CARGAR LOS DATOS EN EL OBJETO TIPO SELECT          
        Cargar_Objeto_Select($la_Detalle_Select[$id]["Query"], $objeto, $valor, $seleccion);
    } else {
        echo "no definido";
    }
    /*  echo "<script type='text/javascript'>parent.document.close();\n</script>";*/
}

function Traer_Tabla_Consulta($detalle, $codigo, $evento, $error, $id_tabla = '', $presentar = '', $frame = '')
{
    global $la_Tabla_Consulta;


    $lc_Query = Reemplazar_Codigo_Query($la_Tabla_Consulta[$detalle]['Query'], $codigo);
    $lo_ObjetoConsulta  = HacerConsultaQuery($lc_Query);

    // ESTADO DE LA INSERCIN DE LA TABLA
    $lb_Busqueda = false;

    echo "<script type='text/javascript'>
              la_Arreglo_Objeto = new Array();\n";


    if ($lo_ObjetoConsulta->DB_error == 'No') {
        if ($lo_ObjetoConsulta->DB_registros != 0) {
            // Datos
            $lb_Busqueda = true;
            for ($li_Registro = 0; $li_Registro < $lo_ObjetoConsulta->DB_registros; $li_Registro++) {
                echo "lo_Objeto = new Object();\n";
                for ($li_Atributo = 0; $li_Atributo < count($lo_ObjetoConsulta->DB_atributos); $li_Atributo++) {
                    echo "lo_Objeto." . $lo_ObjetoConsulta->DB_atributos[$li_Atributo] . " = '" . addslashes($lo_ObjetoConsulta->DB_resultado[$li_Registro][$lo_ObjetoConsulta->DB_atributos[$li_Atributo]]) . "';\n";
                }
                echo "la_Arreglo_Objeto[la_Arreglo_Objeto.length] = lo_Objeto;\n";
            }
            $id_tabla = ($id_tabla != '') ? $id_tabla : $la_Tabla_Consulta[$detalle]['Id_Tabla'];
            echo "parent.Insertar_Tabla_Consulta('" . $id_tabla . "',la_Arreglo_Objeto,\"" . $evento . "\",'" . $presentar . "');\n";
        } else {
            echo "parent.Mostrar_Mensaje('" . $error . "','ERROR');\n";
        }
    }
    if ($frame != '') {
        //echo "parent.EliminarNodoId('".$frame."');\n";
    }
    echo "parent.document.close();</script>";

    return $lb_Busqueda;
}


// INSERTAR UN REGISTRO CON SUS TTULOS
function Tabla_Registro_Unico($lo_ObjetoConsulta, $lc_Id)
{
    // titulo_tabla_consulta
    echo "<center><table border=1 style='width:700px;border-color:#000000;border-collapse:collapse;' id='" . $lc_Id . "'><tr>\n";
    if ($lo_ObjetoConsulta->DB_registros == 1) {
        foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Registro) {
            $li_Total_Atributos = 0;
            foreach ($lo_ObjetoConsulta->DB_atributos as $lc_Atributo) {
                $li_Total_Atributos += 1;
                if (preg_match("/hidden/", $lc_Atributo, $la_Oculto)) {
                    echo "<th style='display:none;'>" . $lc_Atributo . "</th>\n";
                } else {
                    echo "<th class='boton_cafe'>" . str_replace('_', ' ', $lc_Atributo) . "</th>\n";
                }
            }
            echo "</tr><tr>\n";

            foreach ($lo_ObjetoConsulta->DB_atributos as $lc_Atributo) {
                if (preg_match("/hidden/", strtolower($lc_Atributo), $la_Oculto)) {
                    echo "<td style='display:none'><input type='text' value='" . $lo_Registro[$lc_Atributo] . "'></td>\n";
                } else {
                    $lc_Valor = $lo_Registro[$lc_Atributo];
                    echo "<td style='background:#ffffff;padding-left:10;padding-right:10;' align='center'>" . $lc_Valor . "</td>\n";
                }
            }
        }
    } else {
        echo "<td><h3>&nbsp;<img src='./coti_planes/Iconos/alerta.png'>&nbsp;No existen datos para presentar</h3></td>";
    }
    echo "</tr></table></center>";
    return $lo_ObjetoConsulta->DB_error;
}

// INSERTAR VARIOS REGISTROS AGRUPADOS Y TOTALIZADOS CON SUS TTULOS
function Tabla_Multiple_Registro($lo_ObjetoConsulta, $lc_Id = '', $la_Opciones = array())
{
    // style='background:#999966;padding-left:10;padding-right:10;font-size:10'

    $lc_Estilo          = (isset($la_Opciones['estilo'])) ? $la_Opciones['estilo'] : "style='width:700px;margin-bottom:15px;'";

    $li_Total_Atributos = 0;
    echo "<center><table border=0 id='" . $lc_Id . "' class='tabla_consulta_multiple' " . $lc_Estilo . "><tr>\n";

    // SI HAY DATOS PARA PRESENTAR
    if ($lo_ObjetoConsulta->DB_registros > 0) {
        foreach ($lo_ObjetoConsulta->DB_atributos as $lc_Atributo) {
            $li_Total_Atributos += 1;
            if (strtolower($lc_Atributo) != 'objeto') {
                if (preg_match("/hidden/", strtolower($lc_Atributo), $la_Oculto)) {
                    echo "<th style='display:none;'>" . $lc_Atributo . "</th>\n";
                } else {
                    $lc_Atributo = preg_replace("/[I|i]nput_|[C|c]heckbox_|[L|l]abel_|[N|n]umeric_/", "", $lc_Atributo);
                    $lc_Atributo = ucwords(str_replace('_', ' ', $lc_Atributo));
                    echo "<th align='center' class='boton_cafe'>" . $lc_Atributo . "</th>\n";
                }
            }
        }
        echo "</tr>\n";

        $li_Total_Grupo       = 0;
        $lc_Valor_Totalizar   = '';

        foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Registro) {
            // SI SE DEFINE UN ROMPIMIENTO DE CONTROL
            if (isset($la_Opciones['Agrupar'])) {
                if ($lc_Valor_Totalizar == '') {
                    $lc_Valor_Totalizar = $lo_Registro[$la_Opciones['Agrupar']];
                }

                if ($lo_Registro[$la_Opciones['Agrupar']] != $lc_Valor_Totalizar) {
                    // IMPRIMIR EL TOTAL POR GRUPO
                    echo "<tr><td colspan='" . $li_Total_Atributos . "'>&nbsp;&nbsp;<b>Total " . $la_Opciones['Titulo'] . " : " . Formatear_Numero($li_Total_Grupo) . "</b></td></tr>";
                    $lc_Valor_Totalizar = $lo_Registro[$la_Opciones['Agrupar']];
                    $li_Total_Grupo     = str_replace(',', '', $lo_Registro[$la_Opciones['Acumular']]);
                } else {
                    $li_Total_Grupo = $li_Total_Grupo + str_replace(',', '', $lo_Registro[$la_Opciones['Acumular']]);
                }
            }
            // CARGAR EL EVENTO
            $lc_Evento = (isset($la_Opciones['Evento'])) ? $la_Opciones['Evento'] : '';

            echo "<tr>\n";
            foreach ($lo_ObjetoConsulta->DB_atributos as $lc_Atributo) {
                $lc_Contenido = $lo_Registro[$lc_Atributo];
                $lc_Celda     = "<td align='center' class='celda_tabla_detalle'>";
                $lb_Objeto    = false;

                if (preg_match("/hidden/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td style='display:none'>";
                    $lc_Contenido = "<input type='hidden' name='" . $lc_Atributo . "[]' value='" . $lo_Registro[$lc_Atributo] . "'>";
                    $lb_Objeto    = true;
                }
                if (preg_match("/input/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<input type='text' name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' style='vertical-align:middle;text-align:right;width:100;' value='" . $lo_Registro[$lc_Atributo] . "'>";
                    $lb_Objeto    = true;
                }
                if (preg_match("/label/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td class='celda_label' " . $lc_Evento . ">";
                    $lc_Contenido = Dividir_Cadena($lc_Contenido);
                    $lb_Objeto    = true;
                }
                if (preg_match("/numeric/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td class='celda_label' style='text-align:right;' " . $lc_Evento . ">";
                    $lc_Contenido = Dividir_Cadena($lc_Contenido);
                    $lb_Objeto    = true;
                }
                if (preg_match("/eliminar/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<img src='" . $lc_Path_Funciones . "aplicaciones/iconos/cerrar-ventana.gif' name='btn_Eliminar[]' id='btn_Eliminar' onclick='Eliminar_Fila(this)' style='vertical-align:middle;'>";
                    $lb_Objeto    = true;
                }
                if (preg_match("/opciones/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<img src='" . $lc_Path_Funciones . "aplicaciones/iconos/btn_delete.gif' name='btn_Eliminar[]' id='btn_Eliminar' onclick='Eliminar_Fila(this)' style='vertical-align:middle;'>
                                      <img src='" . $lc_Path_Funciones . "aplicaciones/iconos/btn_edit.gif' name='btn_Editar[]' id='btn_Editar' onclick='Editar_Fila(this)' style='vertical-align:middle;'>
                                      <img src='" . $lc_Path_Funciones . "aplicaciones/iconos/btn_save.gif' name='btn_Guardar[]' id='btn_Almacenar' onclick='Almacenar_Fila(this)' style='vertical-align:middle;'>
                                      ";
                    $lb_Objeto    = true;
                }
                if (preg_match("/checkbox/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<input type='checkbox' name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' value='" . $lo_Registro[$lc_Atributo] . "'>";
                    $lb_Objeto    = true;
                }

                if ($lb_Objeto == false) {
                    $lc_Celda = "<td align='center' class='celda_tabla_detalle' " . $lc_Evento . ">";
                    $lc_Contenido = Dividir_Cadena($lc_Contenido);
                }
                //echo $lc_Celda.Dividir_Cadena($lc_Contenido)."</td>\n";
                echo $lc_Celda . $lc_Contenido . "</td>\n";
            }
            echo "</tr>";
        }
        // SI SE DEFINE UN ROMPIMIENTO DE CONTROL
        if (isset($la_Opciones['Agrupar'])) {
            // IMPRIMIR EL TOTAL POR GRUPO
            echo "<tr><td colspan='" . $li_Total_Atributos . "'>&nbsp;&nbsp;<b>Total " . $la_Opciones['Titulo'] . " :  " . Formatear_Numero($li_Total_Grupo) . "</b></td></tr>";
        }
    } else {
        $lc_Mensaje = (isset($la_Opciones['error'])) ? $la_Opciones['error'] : "No existen datos para presentar";
        echo "<td><h3>&nbsp;<img src='" . $lc_Path_Funciones . "aplicaciones/alerta.png'>&nbsp;" . $lc_Mensaje . "</h3></td>";
    }
    echo "</table></center>\n";

    //return $lo_ObjetoConsulta->DB_error;
    return $lo_ObjetoConsulta;
}

function Crear_String_Tabla($lo_ObjetoConsulta, $lc_Id = '', $la_Opciones = array())
{
    global $lc_Path_Funciones;

    require "../Cgi/Configuracion_Lista_Desplegable.php";

    // style='background:#999966;padding-left:10;padding-right:10;font-size:10'
    //$lc_Estilo = (isset($la_Opciones['style'])) ? $la_Opciones['style'] : "style='width:700px'";

    $li_Total_Atributos = 0;
    $lc_String_Tabla = "<table id='" . $lc_Id . "' class='tabla_dinamica' cellspacing='3'><tr class='itemCabeceras'>\n";

    // SI HAY DATOS PARA PRESENTAR
    if ($lo_ObjetoConsulta->DB_registros > 0) {
        foreach ($lo_ObjetoConsulta->DB_atributos as $lc_Atributo) {
            $li_Total_Atributos += 1;
            if (strtolower($lc_Atributo) != 'objeto') {
                if (preg_match("/hidden/", strtolower($lc_Atributo), $la_Oculto)) {
                    $lc_String_Tabla .= "<td style='display:none;'>" . $lc_Atributo . "</td>\n";
                } else {
                    $lc_Atributo = preg_replace("/[I|i]nput_|[C|c]heckbox_|[L|l]abel_|[N|n]umeric_|select_|readonly_/i", "", $lc_Atributo);
                    $lc_Atributo = ucwords(str_replace('_', ' ', $lc_Atributo));
                    $lc_String_Tabla .= "<td class='itemCabecera'>" . $lc_Atributo . "</td>\n";
                }
            }
        }
        $lc_String_Tabla .= "</tr>\n";

        $li_Total_Grupo       = 0;
        $lc_Valor_Totalizar   = '';
        $li_Contador_Objeto   = 0;

        foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Registro) {
            // ACTUALIZAR EL CONTADOR
            $li_Contador_Objeto++;

            // SI SE DEFINE UN ROMPIMIENTO DE CONTROL
            if (isset($la_Opciones['Agrupar'])) {
                if ($lc_Valor_Totalizar == '') {
                    $lc_Valor_Totalizar = $lo_Registro[$la_Opciones['Agrupar']];
                }

                if ($lo_Registro[$la_Opciones['Agrupar']] != $lc_Valor_Totalizar) {
                    // IMPRIMIR EL TOTAL POR GRUPO
                    $lc_String_Tabla .= "<tr><td colspan='" . $li_Total_Atributos . "'>&nbsp;&nbsp;<b>Total " . $la_Opciones['Titulo'] . " : " . Formatear_Numero($li_Total_Grupo) . "</b></td></tr>";
                    $lc_Valor_Totalizar = $lo_Registro[$la_Opciones['Agrupar']];
                    $li_Total_Grupo     = str_replace(',', '', $lo_Registro[$la_Opciones['Acumular']]);
                } else {
                    $li_Total_Grupo = $li_Total_Grupo + str_replace(',', '', $lo_Registro[$la_Opciones['Acumular']]);
                }
            }
            // CARGAR EL EVENTO
            $lc_Evento = (isset($la_Opciones['Evento'])) ? $la_Opciones['Evento'] : '';

            $lc_String_Tabla .= "<tr class='item'>\n";
            foreach ($lo_ObjetoConsulta->DB_atributos as $lc_Atributo) {
                $lc_Contenido = $lo_Registro[$lc_Atributo];
                $lc_Celda     = "<td align='center' class='celda_tabla_detalle'>";
                $lb_Objeto    = false;

                if (preg_match("/hidden/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td style='display:none'>";
                    $lc_Contenido = "<input type='hidden' name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' value='" . $lo_Registro[$lc_Atributo] . "'>";
                    $lb_Objeto    = true;
                }

                if (preg_match("/select/", strtolower($lc_Atributo), $la_Resultado)) {
                    // TOMAR EL NOMBRE DEL OBJETO DESPLEGABLE
                    $lc_Nombre_Lista = str_replace("select_", "", $lc_Atributo);

                    $lc_Contenido = "<select name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' class='text'>";

                    if (isset($la_Detalle_Select[$lc_Nombre_Lista])) {
                        $lo_Objeto_Consulta = HacerConsultaQuery($la_Detalle_Select[$lc_Nombre_Lista]['Query']);
                        if ($lo_Objeto_Consulta->DB_registros > 0) {
                            foreach ($lo_Objeto_Consulta->DB_resultado as $lo_Registro_Select) {
                                $lc_Selected  = ($lo_Registro_Select['codigo'] == $lo_Registro[$lc_Atributo]) ? " SELECTED" : "";
                                $lc_Contenido .= "<option value='" . $lo_Registro_Select['codigo'] . "' " . $lc_Selected . ">" . $lo_Registro_Select['valor'] . "</option>";
                            }
                        }
                    } else {
                        $la_Path = pathinfo(getcwd());
                        //echo $la_Path['basename'];
                        print_r($la_Path);

                        echo "det ";
                        print_r($la_Detalle_Select);
                    }
                    $lc_Contenido .= "</select>";

                    $lb_Objeto    = true;
                }
                if (preg_match("/input/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<input type='text' name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' class='text' value='" . $lo_Registro[$lc_Atributo] . "'>";
                    $lb_Objeto    = true;
                }
                if (preg_match("/readonly/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<input type='text' name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' class='text' value='" . $lo_Registro[$lc_Atributo] . "' readOnly>";
                    $lb_Objeto    = true;
                }
                if (preg_match("/label/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td class='celda_label' " . $lc_Evento . ">";
                    $lc_Contenido = Dividir_Cadena($lc_Contenido);
                    $lb_Objeto    = true;
                }
                if (preg_match("/numeric/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td class='celda_label' style='text-align:right;' " . $lc_Evento . ">";
                    $lc_Contenido = Dividir_Cadena($lc_Contenido);
                    $lb_Objeto    = true;
                }
                if (preg_match("/eliminar/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<img src='" . Path_Host . "aplicaciones/iconos/cerrar-ventana.gif' name='btn_Eliminar[]' id='btn_Eliminar' onclick='Eliminar_Fila(this)' style='vertical-align:middle;'>";
                    $lb_Objeto    = true;
                }
                if (preg_match("/almanaque/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Celda = "<td nowrap align='center'>";
                    $lc_Contenido = "<input type='hidden' id='fecha_inhabil' value='" . $lc_Contenido . "'><input class='texto_centrado' name='fc_Almanaque[]' id='fc_Almanaque_" . $li_Contador_Objeto . "' type='hidden'>&nbsp;<img src='" . $lc_Path_Funciones . "aplicaciones/iconos/calendario.gif' style='width:16px;height:16px;border:none;' alt='Seleccionar fecha' onclick='Almanaque_Dinamico(this)' >";
                    $lb_Objeto    = true;
                }
                if (preg_match("/opciones/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Edita = ($lc_Contenido != '') ? ",'" . $lc_Contenido . "'" : "";
                    $lc_Celda = "<td nowrap align='center'>";
                    $lc_Contenido = "<img src='" . $lc_Path_Funciones . "aplicaciones/iconos/btn_delete.gif' name='btn_Eliminar[]' id='btn_Eliminar' onclick=\"Eliminar_Fila(this" . $lc_Edita . ")\" style='vertical-align:middle;'>
                                      <img src='" . $lc_Path_Funciones . "aplicaciones/iconos/btn_edit.gif' name='btn_Editar[]' id='btn_Editar' onclick=\"Editar_Fila(this" . $lc_Edita . ")\" style='vertical-align:middle;'>
                                      <img src='" . $lc_Path_Funciones . "aplicaciones/iconos/btn_save.gif' name='btn_Guardar[]' id='btn_Almacenar' onclick=\"Almacenar_Fila(this" . $lc_Edita . ")\" style='vertical-align:middle;'>
                                      ";
                    $lb_Objeto    = true;
                }
                if (preg_match("/checkbox/", strtolower($lc_Atributo), $la_Resultado)) {
                    $lc_Contenido = "<input type='checkbox' name='" . $lc_Atributo . "[]' id='" . $lc_Atributo . "' class='" . Caracteres_Especiales_Archivos($lc_Atributo) . "' >";
                    $lb_Objeto    = true;
                }

                if ($lb_Objeto == false) {
                    $lc_Celda = "<td align='center' class='celda_tabla_detalle' " . $lc_Evento . ">";
                    $lc_Contenido = Dividir_Cadena($lc_Contenido);
                }
                //echo $lc_Celda.Dividir_Cadena($lc_Contenido)."</td>\n";
                $lc_String_Tabla .= $lc_Celda . $lc_Contenido . "</td>\n";
            }
            $lc_String_Tabla .= "</tr>";
        }
        // SI SE DEFINE UN ROMPIMIENTO DE CONTROL
        if (isset($la_Opciones['Agrupar'])) {
            // IMPRIMIR EL TOTAL POR GRUPO
            $lc_String_Tabla .= "<tr><td colspan='" . $li_Total_Atributos . "'>&nbsp;&nbsp;<b>Total " . $la_Opciones['Titulo'] . " :  " . Formatear_Numero($li_Total_Grupo) . "</b></td></tr>";
        }
    } else {
        $lc_Mensaje = (isset($la_Opciones['error'])) ? $la_Opciones['error'] : "An no ha creado costos para este plan";
        $lc_String_Tabla .= "<td><div class='mensajes'>" . $lc_Mensaje . "</div></td></tr>";
    }
    $lc_String_Tabla .= "</table>\n";

    //$lo_Archivo = fopen ('../Planos/string_tabla.txt',"w+");
    //if ($lo_Archivo) { fwrite($lo_Archivo,$lc_String_Tabla); fclose($lo_Archivo); }

    return $lc_String_Tabla;
}

function Combinar_Documento($archivo, $lo_Registro, $lc_Accion = "")
{
    global $lc_Path_Funciones;

    // ADICIONAR LA RUTA RELATIVA
    $archivo = $lc_Path_Funciones . $archivo;

    $lc_Salida = '';
    if (file_exists($archivo)) {
        $la_File = file($archivo);
        if ($la_File) {
            $lc_Salida = implode("\n", $la_File);
            // SI SE OBTIENE UN REGISTRO MEDIANTE LA CONSULTA
            if (count(array_keys($lo_Registro)) > 0) {
                // INICIALIZAR LA VARIABLE PARA LINK ESPECFICO
                $lc_Link_Especifico = '';
                foreach ($lo_Registro as $lc_Clave => $lc_Valor_Clave) {

                    //echo "<br>".$lc_Clave;

                    // REEMPLAZAR EL CAMPO FECHA POR SU FORMATO
                    if (preg_match("/fecha/i", strtolower($lc_Clave), $la_Arreglo)) {
                        $lc_Valor_Clave = Formato_Fecha($lc_Valor_Clave);
                    }

                    // NO REEMPLAZAR LOS LINKS POR OBJETOS TIPO IMG
                    if (!preg_match("/link/i", strtolower($lc_Clave), $la_Arreglo)) {
                        // REEMPLAZAR LOS CAMPOS TIPO xxxx.jpg xxxxx.png  xxxxx.ico  xxxxx.svg
                        // if (ereg("(\.jpg|\.gif|\.png)$",strtolower($lc_Valor_Clave),$la_Arreglo)) { $lc_Valor_Clave = (ereg("editorial",$lc_Clave,$la_Array)) ? "<img class=imagen_editorial src='../Iconos_Articulo/".$lc_Valor_Clave."'>" : "<img class=imagen_articulo src='../Iconos_Articulo/".$lc_Valor_Clave."'>"; }
                    } else {
                        // PREGUNTAR SI EL CASO DE UNA URL
                        if (preg_match("/https:\/\/www/i", $lc_Valor_Clave) && !preg_match('/Abrir_Ventana/i', $lc_Valor_Clave)) {
                            $lc_Valor_Clave = "Abrir_Ventana('" . $lc_Valor_Clave . "');";
                        }
                        $lc_Link_Especifico = $lc_Valor_Clave;
                    }
                    // REEMPLAZAR LOS ATRIBUTOS POR SUS VALORES
                    $lc_Valor_Clave = $lc_Valor_Clave ?? '';
                    $lc_Salida = preg_replace(
                        "/\xAB" . $lc_Clave . "\xBB/",
                        preg_replace("/\n|\r/", "<br><br>", str_replace('"', "'", $lc_Valor_Clave)),
                        $lc_Salida
                    );
                }
                // ELIMINAR LAS REFERENCIAS DE ATRIBUTOS INEXISTENTES
                //$lc_Cadena_Archivo = ereg_replace("\xAB[a-z\_]{1,}\xBB"," <b>indefinido</b> ",$lc_Cadena_Archivo);

                // ADICIONAR EL EVENTO ONCLICK
                /*
                  if ($lc_Accion != "") { 
                      if ($lc_Link_Especifico != '') {
                          $lc_Salida = ereg_replace("id='Box'","id='Box' style='cursor:pointer;' onclick=\"".$lc_Accion.$lc_Link_Especifico.";\"",$lc_Salida);
                      } else {
                          $lc_Salida = ereg_replace("id='Box'","id='Box' style='cursor:pointer;' onclick=\"".$lc_Accion."\"",$lc_Salida); 
                      }
                  }
                  */
            }
        } else {
            $lc_Salida = "Error abriendo formato " . $archivo;
        }
    } else {
        $lc_Salida = "El archivo " . $archivo . " no existe";
    }
    //echo $lc_Salida;

    return $lc_Salida;
}

/*  DESCRIPCIN - Funcin que permite enviar un comunicado va email a un PROVEEDOR
  **  
  **  $la_Arreglo_Subasta   : Arreglo asociativo que contiene
  **      Correo    : direccin/direcciones email
  **      Origen    :
  **      Asunto    : 
  **      Titulo    :
  **      Mensaje   :
  **      Tabla     : Cdigo HTML
  **  
  **  Programador         - Carlos Alcaraz
  **  ltima Modificacin - 2007/12/13
  */

function Enviar_Plantilla_Correo($la_Arreglo_Subasta)
{
    global $lc_Cookie_Usuario;

    /********************* USO ***********************
          $la_Arreglo_Plantilla = array();
          $la_Arreglo_Plantilla['Correo']   = CORREO_SOPORTE;
          $la_Arreglo_Plantilla['Asunto']   = 'Revisin Documento - Geiico S.A.';
          $la_Arreglo_Plantilla['Titulo']   = 'Observaciones';

          $la_Arreglo_Plantilla['Mensaje']  = 'Se ha realizado una inspeccin con la siguiente informacin : <br>CT-'.$fc_Cotizacion.'.<br>OS-'.$fc_Orden_Servicio.'<br>Usuario : '.$lc_Cookie_Usuario.'.<br> Favor verificar.';
          $la_Arreglo_Plantilla['Origen']   = CORREO_SERVIDOR;
          
          Enviar_Plantilla_Correo ($la_Arreglo_Plantilla);
          
     *************************************************/

    $destinatario = $la_Arreglo_Subasta['Correo'];
    $asunto       = $la_Arreglo_Subasta['Asunto'];
    $cuerpo       = $la_Arreglo_Subasta['Html'];

    //PARA EL ENVO EN FORMATO HTML
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

    //DIRECCIN DE ORIGEN
    //$headers .= "From: Observaciones - ".NOMBRE_ENTIDAD." - <".$la_Arreglo_Subasta['Origen'].">\r\n";
    $headers .= "From: " . $asunto;
    //DIRECCIONES QUE RECIBIRN COPIA OCULTA
    $headers .= "Bcc: " . $la_Arreglo_Subasta['Origen'] . "\r\n";

    $lb_Envio = @mail($destinatario, $asunto, $cuerpo, $headers);

    if ($lb_Envio == false) {
        //error_log('Error Correo '.$destinatario.' '.date('Y/m/d')."\n",3,"../Log/email_aplicativo.log");
    } else {
        //error_log('Correo Subasta '.$destinatario.' '.date('Y/m/d')."\n",3,"../Log/email_aplicativo.log");
    }
    return $lb_Envio;
}


function Combinar_Registro($row, $lc_Html)
{
    $lb_Encontrado = false;

    if (preg_match_all("/\&lquo\;([a-z\_]{1,})\&rquo\;/i", $lc_Html, $la_Atributos)) {
        $lb_Encontrado = true;
        array_shift($la_Atributos);
    } else {
        if (preg_match_all("/\([a-z\_]{1,})\/i", $lc_Html, $la_Atributos)) {
            $lb_Encontrado = true;
            array_shift($la_Atributos);
        }
    }
    //print_r($la_Atributos);
    if ($lb_Encontrado == true) {
        $li_Total_Atributos = count($la_Atributos[0]);
        for ($li_Atributo = 0; $li_Atributo < $li_Total_Atributos; $li_Atributo++) {
            $lc_Atributo = $la_Atributos[0][$li_Atributo];
            //echo $lc_Atributo;
            if (isset($row[$lc_Atributo])) {
                $lc_Html = preg_replace("/\" . $lc_Atributo . "\/i", $row[$lc_Atributo], $lc_Html);
            }
            // echo "<br>Reemplazar ".$lc_Atributo." por ".$row[$lc_Atributo];
        }
    }
    return $lc_Html;
}


function Eliminar_Archivo_Remoto($fc_Url)
{
    global $lc_Path_Funciones;

    if (defined('DEBUG_PHP')) {
        $lc_Destino = $lc_Path_Funciones . 'Log/log_aplicativo_' . date('Y_m_d') . '.log';
        error_log("eliminar archivo " . $fc_Url . " \n", 3, $lc_Destino);
    }

    if (!is_null($fc_Url) && file_exists($fc_Url)) {
        $lb_Estado = @unlink($fc_Url);
        if ($lb_Estado) {
            echo "true";
            // BUSCAR SI EXISTE UN THUMBNAIL
            $lc_Thumbnail = preg_replace("/imagen\_/i", "thumbnail_", $fc_Url);
            if ($lc_Thumbnail !== null && file_exists($lc_Thumbnail)) {
                $lb_Estado = @unlink($lc_Thumbnail);
            }
        } else {
            echo "false";
        }
    } else {
        echo "true";
    }
}


function Eliminar_Archivo_Url($url, $dominio)
{
    global $lc_Path_Funciones;
    // ENVIAR LA PETICIN AL SERVIDOR REMOTO
    $lc_Url = $dominio . "?accion=Eliminar_Archivo_Remoto&url=" . $url;
    // OBTENER LA RESPUESTA DEL SERVIDOR REMOTO (true,false)
    $lc_Resultado = file_get_contents($lc_Url);
    //echo "url [".$lc_Url."] dominio [".$dominio."] url [".$url."] res [".$lc_Resultado."]";
    // RETORNAR LA RESPUESTA AL SERVIDOR PROPIO
    echo "<script type='text/javascript'>parent.Resultado_Eliminacion('" . $lc_Resultado . "')</script>";
}

function Recarga_Remota($fc_Url = "")
{
    global $lc_Path_Funciones;

    $fc_Url    = ($fc_Url != '') ? $fc_Url . "siev/Log/" . $_SERVER['REMOTE_ADDR'] . ".txt" : '';

    $lc_Destino = $lc_Path_Funciones . 'Log/log_aplicativo_' . date('Y_m_d') . '.log';
    //if ( defined('DEBUG_PHP') ) { error_log("validar recarga IP ".$fc_Url." \n",3, $lc_Destino); }

    // VALIDAR SI EXISTE EL ARCHIVO SWITCHE
    $lc_Contenido = @file_get_contents($fc_Url);

    // DETERMINAR SI SE DEBE REALIZAR LA RECARGA REMOTA
    $lc_Respuesta = ($lc_Contenido == false) ? 'false' : 'true';

    if ($lc_Respuesta == true) {
        if (defined('DEBUG_PHP')) {
            error_log("SI recarga IP " . $fc_Url . " \n", 3, $lc_Destino);
        }
    } else {
        if (defined('DEBUG_PHP')) {
            error_log("NO recarga IP " . $fc_Url . " \n", 3, $lc_Destino);
        }
    }
    echo $lc_Respuesta;
}

function Eliminar_Portafolio($lc_Id_Codigo = "")
{
    if ($lc_Id_Codigo != "") {
        $lc_Query     = "update productos set ruta_imagen='' where custom_idproducto = " . $lc_Id_Codigo;
        $la_Resultado = HacerConsultaQuery($lc_Query);

        if ($la_Resultado->DB_error != 'No') {
            $lb_Error = true;
        }
        echo "<script>parent.Recargar_Portafolio();</script>";
    } else {
        echo "<script>alert('El cdigo del producto no es vlido. Favor verificar');</script>";
    }
}

function Eliminar_Imagen_BaseDatos($lc_Id_Codigo = "", $lc_Categoria = "")
{
    if ($lc_Id_Codigo != "" && $lc_Categoria != "") {
        switch ($lc_Categoria) {
            case 'portafolio':
                $lc_Query    = "update productos set ruta_imagen='' where custom_idproducto = " . $lc_Id_Codigo;
                break;
            case 'galeria':
                $lc_Query    = "update galeriaimg set ruta_imagen='' where custom_idimg = " . $lc_Id_Codigo;
                break;
            case 'menu':
                $lc_Query    = "update tipo_portafolio set ruta_imagen='' where id = " . $lc_Id_Codigo;
                break;
            case 'cliente':
                $lc_Query    = "update clientes set ruta_imagen='' where custom_cliente = " . $lc_Id_Codigo;
                break;
        }
        $la_Resultado = HacerConsultaQuery($lc_Query);

        if ($la_Resultado->DB_error != 'No') {
            $lb_Error = true;
        }

        echo "<script>parent.Recargar_Pagina();</script>";
    } else {
        echo "<script>alert('El cdigo no es vlido. Favor verificar');</script>";
    }
}



//ASOCIACION DE PLANTILLA NUEVA
/*	
mysqli_select_db($conexion, $database_conexion);
$query_Objeto_plantilla = "SELECT plantillaje FROM clientes WHERE custom_cliente = '$lider'";
$Objeto_plantilla            = mysqli_query($query_Objeto_plantilla, $conexion) or die(mysqli_error($conexion));
$row_Objeto_plantilla         = mysqli_fetch_assoc($Objeto_plantilla);
echo $row_Objeto_plantilla['plantillaje'];
*/
function Plantilla()
{

    $row_Objeto_plantilla['plantillaje'] = 'plantillas/';

    $lc_Plantilla = "";
    if (isset($_POST['id'])) {
        switch ($_POST['id']) {
            case 'login':
                $lc_Plantilla = file_get_contents("../../" . $row_Objeto_plantilla['plantillaje'] . "/plantilla_login.html");
                break;
            case 'logueado':
                $lc_Plantilla = file_get_contents("../../" . $row_Objeto_plantilla['plantillaje'] . "/plantilla_logueado.html");
                break;
            case 'registro':
                $lc_Plantilla = file_get_contents("../../" . $row_Objeto_plantilla['plantillaje'] . "/plantilla_registro.html");
                break;
            case 'actualizar_datos': // COMBINAR LA PLANTILLA CON LOS DATOS DEL CLIENTE, QUE DEBEN ESTAR SESIONADOS
                $lc_Plantilla = Combinar_Registro_Plantilla($_SESSION['comprador'], file_get_contents("../../" . $row_Objeto_plantilla['plantillaje'] . "/comunicaciones/plantilla_registro_actualizacion.html"));
                ob_start();
                include_once "../../registro.php";
                $lc_Plantilla = ob_get_contents();
                ob_end_clean();
                break;
            default:
                $lc_Plantilla = "error " . $_POST['id'];
                break;
        }
        echo $lc_Plantilla;
    } else {
        echo "error sin plantilla";
    }
}

function Loguear()
{
    global $weblider;

    // error_log("========= INICIO REQUEST =========");
    // error_log("GET: " . print_r($_GET, true));
    // error_log("POST: " . print_r($_POST, true));
    // error_log("========= FIN REQUEST =========");

    validarFormularioSeguro(); // ? Aqu llamas la validacin de CSRF e intentos

    // Validar tipo de ingreso
    if (!empty($_POST['email']) && !empty($_POST['clave'])) {
        $tipo_ingreso = 1;
    } elseif (!empty($_POST['email'])) {
        $tipo_ingreso = 0;
    } else {
        echo "<script type='text/javascript'>top.location.replace('" . $weblider . "');</script>";
        exit();
    }

    // Consultar solo por el correo
    $email = Eliminar_Caracteres_No_Autorizados($_POST['email']);

    $lc_Query_Usuario = "SELECT *, us.first_name as first_name_comprador, 
                                us.last_name as last_name_comprador, 
                                us.email as email_comprador,
                                (SELECT c.ID as transportadora 
                                 FROM usuarios u 
                                 INNER JOIN ciudades c ON u.custom_codciudad = c.ID 
                                 WHERE c.trans_coordinadora = 1 AND u.custom_id = us.custom_id) as transportadora 
                         FROM usuarios us 
                         WHERE us.email = '$email'";

    $la_Resultado_Usuario = HacerConsultaQuery($lc_Query_Usuario);

    if (gettype($la_Resultado_Usuario) == 'object' && $la_Resultado_Usuario->DB_registros > 0) {
        $usuario = $la_Resultado_Usuario->DB_resultado[0];
        $claveIngresada = $_POST['clave'];
        $hashAlmacenado = $usuario['custom_password'];



        if ($tipo_ingreso == 0 || password_verify($claveIngresada, $hashAlmacenado)) {
            // Eliminar cesta anterior
            $lc_Query_Cesta = "DELETE FROM cesta 
                               WHERE (usuario = '" . session_id() . "' OR usuario = " . $usuario['custom_id'] . ") 
                               AND fecha_ingreso < '" . date('Y-m-d 00:00:00') . "'";
            HacerConsultaQuery($lc_Query_Cesta);

            // Actualizar cesta al usuario logueado
            $lc_Query_Cesta = "UPDATE cesta 
                               SET usuario = '" . $usuario['custom_id'] . "' 
                               WHERE usuario = '" . session_id() . "'";
            HacerConsultaQuery($lc_Query_Cesta);

            // Guardar sesin
            $_SESSION['comprador'] = $usuario;
            $_SESSION['tipo_logueo'] = $tipo_ingreso;

            echo "<script type='text/javascript'>top.location.replace('" . $weblider . "?cart=true');</script>";
        } else {
            echo "<script type='text/javascript'>_toastr.error('Contrasea incorrecta');</script>";
        }
    } else {
        echo "<script type='text/javascript'>_toastr.error('Correo no registrado, comunquese con el rea encargada.');</script>";
    }
}

$lc_Accion = '';
if (isset($_POST['accion']) || isset($_GET['accion'])) {
    $lc_Accion = (isset($_POST['accion'])) ? $_POST['accion'] : $_GET['accion'];
}

switch ($lc_Accion) {
    case 'Eliminar_Archivo_Remoto':
        Eliminar_Archivo_Remoto($_GET['url']);
        break;
    case 'Eliminar_Archivo_Url':
        Eliminar_Archivo_Url($url, $dominio);
        break;
    case 'Eliminar_Portafolio':
        Eliminar_Portafolio($_POST['codigo']);
        break;
    case 'Eliminar_Imagen_BaseDatos':
        Eliminar_Imagen_BaseDatos($_POST['codigo'], $_POST['categoria']);
        break;
    case 'Recarga_Remota':
        Recarga_Remota($_GET['url']);
        break;
    case 'Plantilla':
        Plantilla();
        break;
    case 'Loguear':
        Loguear();
        break;
    case 'Logout':
        foreach (array_keys($_SESSION) as $lc_Atributo) {
            unset($_SESSION[$lc_Atributo]);
        }
        session_destroy();
        echo "<script type='text/javascript'>top.location.replace('" . $weblider . "');</script>";
        break;
    case 'Cancelar_Popup':
        $_SESSION['popup'] = 'false';
        echo "<script type='text/javascript'>top.location.replace('" . $weblider . "');</script>";
        break;
    case 'Permitir_Popup':
        $_SESSION['popup'] = 'true';
        break;
    case 'Switche_Recarga_Remota':
        $lc_Archivo = "../Log/" . $_SERVER['REMOTE_ADDR'] . ".txt";
        $lc_Destino = '../Log/log_aplicativo_' . date('Y_m_d') . '.log';
        $lo_Switche = fopen($lc_Archivo, 'w+');
        if ($lo_Switche) {
            fwrite($lo_Switche, $_SERVER['REMOTE_ADDR'], strlen($_SERVER['REMOTE_ADDR']));
            fclose($lo_Switche);
            umask(0);
            @chmod($lc_Carpeta_Destino, 0777);
            //if ( defined('DEBUG_PHP') ) { error_log("crea switche recarga IP ".$fc_Url." \n",3, $lc_Destino); }
        } else {
            //if ( defined('DEBUG_PHP') ) { error_log("error crea switche recarga IP ".$fc_Url." \n",3, $lc_Destino); }
        }
        break;
}
//echo 1;	




// optimizar imgenes automticamente para carga diferida (lazy loading),
function aplicarLazySizes($contenidoHTML, $placeholder = 'images/imagen_no_disponible.webp')
{
    $contenidoHTML = preg_replace_callback(
        '/<img\s+([^>]*?)src=["\']([^"\']+)["\']([^>]*)>/i',
        function ($coincidencia) use ($placeholder) {
            $atributosAntes = $coincidencia[1];
            $srcOriginal = $coincidencia[2];
            $atributosDespues = $coincidencia[3];

            // Evitar modificar si ya tiene lazyload o data-src
            if (
                stripos($atributosAntes . $atributosDespues, 'data-src') !== false ||
                stripos($atributosAntes . $atributosDespues, 'lazyload') !== false
            ) {
                return $coincidencia[0];
            }

            // Asegurar clase lazyload
            if (preg_match('/class=["\']([^"\']*)["\']/i', $atributosAntes . $atributosDespues)) {
                $nuevoAtributo = preg_replace('/class=["\']([^"\']*)["\']/i', 'class="$1 lazyload"', $atributosAntes . $atributosDespues);
            } else {
                $nuevoAtributo = $atributosAntes . ' class="lazyload"' . $atributosDespues;
            }

            // Construir nuevo <img> con data-src y src placeholder
            return '<img ' . $nuevoAtributo . ' src="' . $placeholder . '" data-src="' . $srcOriginal . '">';
        },
        $contenidoHTML
    );

    return $contenidoHTML;
}
