<?php
if (session_id() == '') {
	session_start();
}

error_reporting(E_ALL);
ini_set('display_errors', 'On');

$lc_Ruta 		= "";
$lb_Root			= false;
$li_Iteracion	= 0;

function Obtener_o_Crear_Clave_IndexNow($host)
{
	$archivo_local = __DIR__ . "/" . $host . "_indexnow_key.txt"; // clave privada por dominio

	// Si ya existe clave local, usarla
	if (file_exists($archivo_local)) {
		$clave = trim(file_get_contents($archivo_local));
	} else {
		// Generar nueva clave aleatoria de 32 caracteres
		$clave = bin2hex(random_bytes(16)); // segura y única

		// Guardar la clave en archivo local para futuras ejecuciones
		file_put_contents($archivo_local, $clave);

		// Crear el archivo público en la raíz del dominio para verificación de Bing
		$archivo_publico = $_SERVER['DOCUMENT_ROOT'] . "/" . $clave . ".txt";
		file_put_contents($archivo_publico, $clave);
		@chmod($archivo_publico, 0644);
	}

	return $clave;
}

function Notificar_IndexNow($lista_urls)
{
	if (empty($lista_urls)) {
		return;
	}

	$host = parse_url($lista_urls[0], PHP_URL_HOST);
	$clave_indexnow = Obtener_o_Crear_Clave_IndexNow($host);

	$payload = [
		'host' => $host,
		'key' => $clave_indexnow,
		'keyLocation' => "https://{$host}/{$clave_indexnow}.txt",
		'urlList' => $lista_urls
	];

	$data = json_encode($payload, JSON_UNESCAPED_SLASHES);

	$ch = curl_init("https://www.bing.com/indexnow");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);

	$response = curl_exec($ch);
	$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	$curl_error = curl_error($ch);
	curl_close($ch);

	// Guardar log del resultado
	$log = "[" . $http_code . "]\n";
	$log .= "Respuesta: " . $response . "\n";
	if ($curl_error) {
		$log .= "CURL error: " . $curl_error . "\n";
	}
	$log .= "Payload enviado:\n" . $data . "\n";

	file_put_contents(__DIR__ . "/log_indexnow_lote.txt", $log);
}


// V A R I A B L  E   P A R A   D E T E R M I  N A R   S I   S E  P R E S E N T A  T O D A  L A  I N F O R M A C I Ó N,
// I N C L U Y E N D O   L O  S   P R O D U C T O S
$lb_Full_Info	= (isset($_GET['full'])) ? true : false;

// CARGAR EL ROOT	
do {
	if (file_exists($lc_Ruta . "Globales.php") != false) {
		$lb_Root = true;
	} else {
		$lc_Ruta .= "../";
	}
	$li_Iteracion++;
	if ($li_Iteracion > 6) {
		$lb_Root = true;
	}
} while ($lb_Root == false);

include $lc_Ruta . "Globales.php";
include $lc_Ruta . "php/Conexion_BD.php";
include $lc_Ruta . "php/Funciones_Generales.php";

function Caracteres_No_Validos_Url($lc_Cadena)
{
	// Asegurar que la cadena no sea null
	$lc_Cadena = $lc_Cadena ?? '';

	// Definir caracteres especiales y sus equivalentes
	$la_Valores    = ['O', 'U', 'E', 'A', 'I', 'N', 'a', 'e', 'i', 'o', 'u', 'n', '_', '_'];
	$la_Especiales = ['Ó', 'Ú', 'É', 'Á', 'Í', 'Ñ', 'á', 'é', 'í', 'ó', 'ú', 'ñ', ' ', '&'];

	// Normalizar reemplazo de caracteres especiales
	$lc_Cadena = str_replace($la_Especiales, $la_Valores, $lc_Cadena);

	// Convertir a minúsculas para URLs amigables
	$lc_Cadena = mb_strtolower($lc_Cadena, 'UTF-8');

	// Reemplazar caracteres no permitidos con "-"
	$lc_Cadena = preg_replace('/[^0-9a-z.]+/i', '-', $lc_Cadena);

	// Eliminar guiones al inicio y final
	$lc_Cadena = trim($lc_Cadena, '-');

	return $lc_Cadena;
}


// TOMAR EL DOMINIO
//$lc_Query		= "select CONCAT(custom_dominio2,'/',custom_cliente,'/') as dominio from clientes where usuario_hosting = '".$_GET['fc_Usuario']."'";
//$lc_Query		= " select CONCAT(custom_dominio2,'/',custom_cliente,'/') as dominio from clientes limit 1 ";	

if (isset($_GET['micro2'])) {
	// $lc_Query = "select CONCAT(custom_dominio2,'/',custom_cliente,'/') as dominio from clientes WHERE custom_cliente = '".$_GET['micro2']."'"; 
	$lc_Query = "select custom_dominio2,custom_cliente from clientes WHERE custom_cliente = '" . $_GET['micro2'] . "'";
} else {
	$lc_Query = "select custom_dominio2,custom_cliente from clientes limit 1 ";
}




$la_Resultado	= HacerConsultaQuery($lc_Query);

$lc_Dominio_Site	= "https://" . $la_Resultado->DB_resultado[0]['custom_dominio2'] . "/" . $la_Resultado->DB_resultado[0]['custom_cliente'] . "/";

$lc_Dominio_Site_images  = "https://" . $la_Resultado->DB_resultado[0]['custom_dominio2'] . "/";


//www.todoventas.com.co/nuestratienda/";

// ARREGLO MAPA DEL SITIO	
$la_Arreglo_Menu	= array();
//if ( !isset( $_SESSION['rastro_menu'] ) || !isset( $_SESSION['mapa_cliente'] ) || !in_array( DBUSER,array_keys( $_SESSION['mapa_cliente'] ) ) ) { 

// TOMAR LA CONDICIÓN
$lc_Condicion	= ($lb_Full_Info == true) ? "" : " where mostrar='si' ";

// TOMAR LAS DIFERENTES CATEGORÍAS PARA CREAR EL MENÚ DE SEGUIMIENTO
$lc_Query		= "select id, tipo, subcategoria, url, titulo, descripcion, palabras, ruta_imagen from tipo_portafolio " . $lc_Condicion . " order by subcategoria, id ";
$la_Resultado	= HacerConsultaQuery($lc_Query);

// DEFINIR EL CÓDIGO 0 COMO MENÚ DE INICIO PARA EL CASO DE OPCIONES SIN MENÚ
//$la_Arreglo_Menu[0]['url'] = 'https://'.$_SERVER['HTTP_HOST'];

if ($la_Resultado->DB_registros > 0) {
	foreach ($la_Resultado->DB_resultado as $lo_Registro) {
		// ADICIONAR EL CAMPO URL
		//$lo_Registro['url'] = '';
		$la_Arreglo_Menu[$lo_Registro['id']]  = $lo_Registro;
	}
}
$_SESSION['rastro_menu']		= $la_Arreglo_Menu;
$_SESSION['mapa_cliente'][]	= DBUSER;
/*
  } else {
      $la_Arreglo_Menu	= $_SESSION['rastro_menu'];
	}
  */


ob_start();


$la_Urls_Para_IndexNow = array(); // Aquí guardaremos las URLs



echo "<?xml version='1.0' encoding='UTF-8' " . chr(63) . ">
            \n<urlset xmlns='https://www.sitemaps.org/schemas/sitemap/0.9' 
            \n xmlns:image='https://www.google.com/schemas/sitemap-image/1.1'
            >";

//foreach ($_SESSION as $key => $value) { echo ("<br>".$key." = ".$value); }
$la_Ruta				= array();
$la_Root				= array();

$la_Root				= Tomar_Categoria('0');

//print_r( $la_Root );
echo Crear_Nivel($la_Root);

function Tomar_Categoria($lc_Id_Subcategoria)
{
	global $la_Arreglo_Menu;

	$la_Arreglo_Salida = array();

	foreach (array_keys($la_Arreglo_Menu) as $lc_Clave) {
		if ($la_Arreglo_Menu[$lc_Clave]['subcategoria'] == $lc_Id_Subcategoria) {
			$la_Arreglo_Salida[] = $la_Arreglo_Menu[$lc_Clave];
		}
	}
	return $la_Arreglo_Salida;
}

function Crear_Nivel($la_Datos)
{
	global $lc_Dominio_Site, $lb_Full_Info, $lc_Dominio_Site_images, $la_Urls_Para_IndexNow;

	$lc_Nivel = "\n";
	foreach (array_keys($la_Datos) as $lc_Clave) {
		$lc_URL_Amigable = ($la_Datos[$lc_Clave]['url'] != '') ? $la_Datos[$lc_Clave]['url'] . "#" : $la_Datos[$lc_Clave]['tipo'] . "#";

		$lc_URL = $lc_Dominio_Site . "pg" . $la_Datos[$lc_Clave]['id'] . "/sp/" . Caracteres_No_Validos_Url(strtolower(preg_replace("/[^0-9a-z\x2E]/i", "_", $lc_URL_Amigable)));

		// Guardar en el arreglo de URLs para IndexNow
		$la_Urls_Para_IndexNow[] = $lc_URL;

		$lc_Nivel .= "\n<url>
                          \n<loc>" . $lc_URL . "</loc>
                          \n<image:image><image:loc>" . $lc_Dominio_Site_images . "images/menu/" . $la_Datos[$lc_Clave]['ruta_imagen'] . "</image:loc></image:image>
                          \n<lastmod>" . date('Y-m-d') . "</lastmod>
                          \n<changefreq>weekly</changefreq>
                          \n<priority>0.5</priority>
                      \n</url>";

		$la_SubNivel = Tomar_Categoria($la_Datos[$lc_Clave]['id']);

		if (count($la_SubNivel) > 0) {
			$lc_Nivel .= Crear_Nivel($la_SubNivel);
		} else {
			if ($lb_Full_Info == true) {
				$lc_Query_Productos = "select url, custom_idproducto, custom_nombrepro as producto, p_clave, titu_busca, des_busca, mostrar, ruta_imagen from productos WHERE tipo = " . $la_Datos[$lc_Clave]['id'] . " AND mostrar='si' ";
				$lo_ObjetoConsulta = HacerConsultaQuery($lc_Query_Productos);

				if ($lo_ObjetoConsulta->DB_registros > 0) {
					foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Registro) {
						$lc_URL = $lc_Dominio_Site . "vp" . $lo_Registro['custom_idproducto'] . "/sp/" . Caracteres_No_Validos_Url($lo_Registro['url']);

						// Guardar en el arreglo de URLs para IndexNow
						$la_Urls_Para_IndexNow[] = $lc_URL;

						$lc_Nivel .= "\n<url>
                                          \n<image:image><image:loc>" . $lc_Dominio_Site_images . "images/portafolio/" . $lo_Registro['ruta_imagen'] . "</image:loc></image:image>                            		          
                                          \n<loc>" . $lc_URL . "</loc>
                                          \n<lastmod>" . date('Y-m-d') . "</lastmod>
                                          \n<changefreq>weekly</changefreq>
                                          \n<priority>0.5</priority>
                                      \n</url>";
					}
				}
			}
		}
	}
	return $lc_Nivel;
}

echo "\n</urlset>";


$lc_Xml = ob_get_contents();
ob_end_clean();

//error_log( $lc_Xml."\n",3,"./xml.log" );




// CREAR EL ARCHIVO XML
//$lo_Archivo = fopen( $lc_Ruta."Log/mapa_sitio.xml","w+" );
$lo_Archivo = fopen($lc_Ruta . "../sitemap.xml", "w+");
if ($lo_Archivo) {
	fwrite($lo_Archivo, $lc_Xml);
	fclose($lo_Archivo);
	umask(0);
	@chmod($lc_Ruta . "../sitemap.xml", 0777);
} else {
	echo "error";
}


// Enviar a IndexNow
Notificar_IndexNow($la_Urls_Para_IndexNow);




echo "Proceso finalizado.";
