<?php
    header('Content-Type: text/html; charset=iso-8859-1');
    
    $lc_Path = "./siev/"; $lb_Ruta = false; $li_Iteraciones = 0;
    // BUSCAR EL ROOT ./siev
    do { if ( file_exists( $lc_Path."Globales.php" ) ) { $lb_Ruta = true; } else { $lc_Path  = "../".preg_replace("/^\.\//","", $lc_Path); } $li_Iteraciones++;
    } while ( $lb_Ruta == false && $li_Iteraciones <= 6 );
    
    INCLUDE_ONCE $lc_Path."Globales.php";    
    INCLUDE_ONCE $lc_Path."php/Conexion_BD.php"; 
    REQUIRE $lc_Path."php/Modulo_Variables_Get.php";
    
    //DEBE VENIR EL CDIGO DE LA ENCUESTA QUE SE DESEA DIAGRAMAR
    if ( isset($encuesta) ) {
        // TOMAR LAS DIFERENTES PREGUNTAS Y RESPUESTAS POSIBLES
        $lc_Query           = "select encuesta_pregunta.encuesta as encuesta, encuesta_pregunta.codigo as codigo_pregunta, encuesta_pregunta.pregunta as nombre_pregunta, encuesta_respuesta.codigo as codigo_respuesta, encuesta_respuesta.respuesta as nombre_respuesta FROM encuesta_pregunta INNER JOIN encuesta_respuesta ON encuesta_pregunta.codigo = encuesta_respuesta.encuesta_pregunta WHERE encuesta_pregunta.estado_registro = 'A' AND encuesta_respuesta.estado_registro = 'A' AND encuesta_pregunta.encuesta = '".$encuesta."' ORDER BY encuesta_pregunta.orden ";
        $lo_ObjetoConsulta  = HacerConsultaQuery($lc_Query, $db );
    
        //echo "<br>".$lc_Query;
        
        $la_Respuesta_Pregunta  = array();
        if ( $lo_ObjetoConsulta->DB_registros > 0 ) {
            foreach ( $lo_ObjetoConsulta->DB_resultado as $lo_Registro ) {
                if ( !in_array($lo_Registro['codigo_respuesta'], array_keys($la_Respuesta_Pregunta)) ) {
                    $la_Respuesta_Pregunta[ $lo_Registro['encuesta'] ][ $lo_Registro['codigo_respuesta'] ] = array('respuesta'=>$lo_Registro['nombre_respuesta'],'pregunta'=>$lo_Registro['nombre_pregunta'],'respuestas'=>0,'codigo_pregunta'=>$lo_Registro['codigo_pregunta']); 
                } 
            }
        }
        
        // TOMAR LAS ENCUESTAS DILIGENCIADAS
        $lc_Query           = "select encuesta.nombre as nombre_encuenta, encuesta_diligenciada.encuesta, encuesta_diligenciada.usuario, encuesta_diligenciada.respuestas  FROM encuesta_diligenciada INNER JOIN encuesta ON encuesta_diligenciada.encuesta = encuesta.codigo AND encuesta_diligenciada.encuesta = '".$encuesta."' ";
        $lo_ObjetoConsulta  = HacerConsultaQuery($lc_Query, $db );
        
        // echo "<br><br>".$lc_Query;
        // echo "<br><br>".$lo_ObjetoConsulta->DB_registros;
         
        $la_Encuesta        = array();
        if ( $lo_ObjetoConsulta->DB_registros > 0 ) {
            foreach ( $lo_ObjetoConsulta->DB_resultado as $lo_Registro ) {
                
                //echo "<br>".$lo_Registro['encuesta'];
            
                if ( !in_array($lo_Registro['encuesta'], array_keys($la_Encuesta)) ) {
                    $la_Encuesta[ $lo_Registro['encuesta'] ] = array('nombre'=>$lo_Registro['nombre_encuenta']);
                }
                // DIVIDIR LAS RESPUESTAS Y BUSCAR SU CORRESPONDIENTE PREGUNTA
                $la_Respuesta       = explode( ',',$lo_Registro['respuestas'] );
                $li_Total_Respuesta = count($la_Respuesta); 
                for ($li_Respuesta=0; $li_Respuesta < $li_Total_Respuesta; $li_Respuesta++) {
                    $la_Respuesta_Pregunta[ $lo_Registro['encuesta'] ][ $la_Respuesta[$li_Respuesta] ]['respuestas'] = $la_Respuesta_Pregunta[ $lo_Registro['encuesta'] ][ $la_Respuesta[$li_Respuesta] ]['respuestas'] + 1;  
                }
            }
        }         
        //print_r( $la_Encuesta );
        //print_r( $la_Respuesta_Pregunta );
    } else {
        echo "No existe informacin de la encuesta[".$encuesta."] seleccionada. Favor verificar.";
        exit(0);
    }
    
    
?>
<!DOCTYPE html>
<html>
<head>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
    <link	  href="https://siev.com.co/siev13/aplicaciones/encuesta/css/encuesta.css" rel="stylesheet" type="text/css" />
        
    <style type='text/css'>
        * { 
            font-family : arial;
            font-size   : 12px; 
        }
        
        div.contenedor_pregunta {
            width: 650px;
            float: left;
        }
         
        div.contenedor_pregunta_grafico {
            width       : 320px;
            float       : left;
        } 
                
        .titulo_pregunta {
            height      : 30px;
            font-weight : bold;
        }
        
        div.respuesta_titulo_respuesta {
            min-height  : 17px;
        }
                
        .total_respuesta_pregunta {
            width       : 35px !important;
        }
        
        .color_respuesta_pregunta {
            width         : 15px !important;
            height        : 15px;
            border-radius : 2px;        
        }
    </style>
    
    <script type='text/javascript'>
        // DEFINIR LOS COLORES DE CADA UNO DE LOS SEGMENTOS
        var Arreglo_Color = ['#0079C2','#739841','#FDCF05','#9F388B','#B71F28','#D5B48B'];

        function Tomar_Numero (lc_Numero) {
            if ( String(lc_Numero) != 'undefined' ) {
              	var lc_Numero = String(lc_Numero).replace(/[^0-9]/g,'').replace(/^0/,'');
              	if (isNaN(parseInt(lc_Numero))) { return 0; } else { return parseInt(lc_Numero); }
            } else {
                return 0;
            }
        }
        
        function Graficar_Resultado( lc_Id_Contenedor ) {
            var canvas  = document.getElementById( lc_Id_Contenedor );
            var ctx     = canvas.getContext("2d");
            var lastend = 0;
            
            var lc_Id_Pregunta      = '#contenedor_pregunta_' + ( Tomar_Numero(lc_Id_Contenedor) ) + ' .respuesta_titulo_respuesta';
            // CREAR EL ARREGLO CON LOS TOTALES DE LAS RESPUESTAS
            var li_Total_Preguntas  = $(lc_Id_Pregunta).length;
            // CREAR EL ARREGLO DE DATOS
            var data              = new Array();
            // CREAR EL ARREGLO DE LABELS
            var labels            = new Array();
            
            // ALMACENAR EL TOTAL
            var li_Total_General  = 0;

            // RECORRER LAS DIFERENTES RESPUESTAS PARA TOMAR LOS TOTALES Y ASIGNARLOS
            // AL ARREGLO DE SE ENVA PARA LA CONSTRUCCIN DEL PIECHART
            $(lc_Id_Pregunta).each( function(index) {
                var lc_Label          = Tomar_Numero( $(this).find('label').eq(0).text() ); 
                var li_Total          = Tomar_Numero( $(this).find('label').eq(1).text() );
                data[ data.length ]   = li_Total;
                labels[labels.length] = lc_Label;
                li_Total_General      = li_Total_General + li_Total;
                
                // ADICIONAR EL COLOR DE LA RESPUESTA
                $(this).append("<label class='color_respuesta_pregunta' style='background:" + Arreglo_Color[index] + ";'>&nbsp;</label>");
            } );

            /*
            var data    = [200,60,15]; // If you add more data values make sure you add more colors
            var myTotal = 0; // Automatically calculated so don't touch
            
            for(var e = 0; e < data.length; e++) { myTotal += data[e]; }
            */
            for (var i = 0; i < data.length; i++) {
                ctx.fillStyle = Arreglo_Color[i];
                ctx.beginPath();
                ctx.moveTo(canvas.width/2,canvas.height/2);
                // Arc Parameters: x, y, radius, startingAngle (radians), endingAngle (radians), antiClockwise (boolean)
                ctx.arc(canvas.width/2,canvas.height/2,canvas.height/2,lastend,lastend+(Math.PI*2*(data[i]/li_Total_General)),false);
                ctx.lineTo(canvas.width/2,canvas.height/2);
                ctx.fill();
                lastend += Math.PI*2*(data[i]/li_Total_General);
            }
            
            // ADICIONAR LOS LABELS Y SUS COLORES
            
            // ASIGNAR TRANSPARENCIA
            //$('#' + lc_Id_Contenedor).fadeTo('slow', 0.5); 
        }
            
        $(document).ready(function () {
            //Graficar_Resultado( 'can' );
            
            $('#contenedor_graficos div').each( function(index) { 
                // TOMAR EL ID CONTENEDOR
                var lc_Id_Contenedor = $(this).find('canvas').attr('id');
                Graficar_Resultado( lc_Id_Contenedor );
            });  
        });
    
    </script>
</head>
<body>
    <?php
        echo "<div style='clear:both;display:block;'>";
        if ( count($la_Encuesta) > 0 ) {
            // IMPRIMIR LOS RESULTADOS
            foreach ( array_keys( $la_Encuesta ) as $lc_Id_Encuesta ) {
                  // IMPRIMIR EL TTULO DE LA ENCUESTA
                  echo "<div class='titulo_resultado_encuesta'>".$la_Encuesta[ $lc_Id_Encuesta ]['nombre']."</div>";
                  // IMPRIMIR LOS RESULTADOS DE LA ENCUESTA
                  $li_Total_Respuestas = count( $la_Respuesta_Pregunta[ $lo_Registro['encuesta'] ] );
                  // PRESENTAR LOS DIFERENTES ELEMENTOS DE LA ENCUESTA
                  //echo "<br>".$la_Total_Respuestas;
                  if ( $li_Total_Respuestas > 0 ) {
                      $la_Arreglo_Pregunta  = array();
                      $li_Total_Preguntas   = 0;
                      
                      // IMPRIMIR LA PREGUNTA
                      foreach ( $la_Respuesta_Pregunta[ $lc_Id_Encuesta ] as $lo_Registro_Respuesta ) {
                          if ( !in_array($lo_Registro_Respuesta['pregunta'],$la_Arreglo_Pregunta) ) {
                              if ( count($la_Arreglo_Pregunta) > 0) { echo "</div></div>"; }
                              echo "<div class='contenedor_pregunta' id='contenedor_pregunta_".$li_Total_Preguntas."'>
                                      <div class='contenedor_pregunta_grafico' id='contenedor_graficos' style='width:120px;' >
                                        <div align='center'>
                                          <canvas id='pregunta_".$li_Total_Preguntas."' width='100' height='100' /></canvas>
                                        </div>
                                      </div>
                                      <div class='contenedor_pregunta_grafico'>
                                          <div class='titulo_pregunta'>".$lo_Registro_Respuesta['pregunta']."</div>";
                              $la_Arreglo_Pregunta[] = $lo_Registro_Respuesta['pregunta'];
                              $li_Total_Preguntas++;
                              
                          }
                          echo "          <div class='respuesta_titulo_respuesta'>
                                            <label>".$lo_Registro_Respuesta['respuesta']."</label>
                                            <label class='total_respuesta_pregunta'>".$lo_Registro_Respuesta['respuestas']."</label>
                                          </div>";
                      }
                      echo "</div></div>";
                  } else {
                      echo "An no se han generado respuestas";
                  }
            }
            echo "  <div style='clear:both;display:block'></div>
                  </div>";

            /*
            echo "\n<div id='contenedor_graficos' style='display:block;margin-top:30px;'>";            

            // CREAR LAS DIFERENTES ZONAS CANVAS PARA ALMACENAR LOS GRFICOS
            $li_Total_Preguntas = ( isset($la_Arreglo_Pregunta) ) ? count($la_Arreglo_Pregunta) : 0;
            
            for ( $li_Pregunta=0; $li_Pregunta < $li_Total_Preguntas; $li_Pregunta++ ) {
                echo "\n<div style='float:left;width:300px;' align='center'>
                          <canvas id='pregunta_".$li_Pregunta."' width='150' height='150' /></canvas>
                        </div>";
            }
            echo "\n</div>";
            */
        }
    ?>

</body>
</html>
