// JavaScript Document

/* CONFIGURAR LOS MENSAJES */
var la_Mensaje_Cotizador  = new Array();
la_Mensaje_Cotizador['Seleccionar_Plan']          = 'Debe seleccionar un Plan. Favor verificar.';
la_Mensaje_Cotizador['Adultos_Incorrecto']        = 'El nmero de adultos es incorrecto. Favor verificar.';
la_Mensaje_Cotizador['Informacion_Solicitante']   = 'Debe digitar todos los campos del solicitante. Favor verificar.';
la_Mensaje_Cotizador['Adultos_Mayor_Cero']        = 'El nmero de adultos debe ser superior a cero. Favor verificar.';
la_Mensaje_Cotizador['Noches_Mayor_Cero']         = 'El nmero de noches debe ser superior a cero. Favor verificar.';
la_Mensaje_Cotizador['Fecha_No_Aplica']           = 'En esta fecha no aplica el plan.';
la_Mensaje_Cotizador['Costo_Obligatorio']         = 'Este valor es aproximado, obligatorio y sujeto a cambios, ser incluido en el valor total de la cotizacin, el asesor de su viaje lo confirmar con la reserva.';
la_Mensaje_Cotizador['Capacidad_Superada_Adulto'] = 'La capacidad de la habitacin elegida por usted no permite adicionar ms personas. Seleccione otra habitacion de mayor capacidad o contacta nuestros asesores.';
la_Mensaje_Cotizador['Capacidad_Superada_Menor']  = 'La capacidad de la habitacin elegida por usted no permite adicionar ms personas. Seleccione otra habitacion de mayor capacidad o contacta nuestros asesores.';
la_Mensaje_Cotizador['Autorizar_Envio_Mail']      = 'Para realizar el envo de la informacin, debe autorizar el recibo de la misma. Gracias.';
la_Mensaje_Cotizador['No_Permitir_Registro']      = 'Al desactivar la opcin de permitir registrar tus datos, no podrs realizar reservas, recibir boletines, promociones, descuentos.<br>';
la_Mensaje_Cotizador['Pie_Calendario']            = "<div style='text-align:justify;vertical-align:middle;'>Las fechas marcas con el smbolo <img src='" + gc_Ruta_Aplicativo + "Iconos/close.png'>, corresponden a das sin disponibilidad.</div>";

var la_Mes_Calendario = new Array('enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre');

/************************
 *PROCESO DE COTIZACIN 
 ***********************/ 
var li_Pasos_Cotizacion = 0;

var la_Mensaje_Pasos  = new Array();
la_Mensaje_Pasos[0]   = new Array('Seleccione la temporada en la cual desea viajar','');
la_Mensaje_Pasos[1]   = new Array('Elija las fechas y nmero de personas que desean viajar','');
la_Mensaje_Pasos[2]   = new Array('Escoja el tipo de habitacin o plan que desea','');
la_Mensaje_Pasos[3]   = new Array('Ingrese los datos personales, para recibir la cotizacin automtica e iniciar el proceso de reserva.','');


// ALMACENAR LAS CORRDENADAS DEL MOUSE
var lo_Mouse = new Object();
lo_Mouse.X   = 0;
lo_Mouse.Y   = 0;

// CREAR UN OBJETO PARA EL COTIZADOR
var go_Objeto_Cotizador = new Object();

// CREAR VARIABLE GLOBAL QUE ALMACENE LA HABITACIN SELECCIONADA
var gc_Habitacion_Seleccionada = null;
var gc_Habitacion_Cerrar       = null;

// CREAR UN OBJETO GLOBAL QUE ALMACENA LAS FECHAS DE LAS COTIZACIONES
var ga_Rango_Fechas_Cotizaciones  = new Array();
  
// CREAR UN OBJETO GLOBAL QUE ALMACENA LAS FECHAS CON SUS SOBRECOSTOS
var ga_Rango_Fechas_Sobrecostos   = new Array();
        
function Formato_Fecha_Y_M_D (ld_Fecha) {
    
    var lc_Reg_Exp_DMY  = /([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/;
    var la_Resultado    = lc_Reg_Exp_DMY.exec(ld_Fecha);
    var lc_Fecha        = false;
    if (la_Resultado == null) {
        var lc_Reg_Exp_YMD = /([0-9]{4})[\/|\-]([0-9]{2})[\/|\-]([0-9]{2})/;
        var la_Resultado = lc_Reg_Exp_YMD.exec(ld_Fecha);
        if (la_Resultado != null) { lc_Fecha = la_Resultado[1] + '-' + la_Resultado[2] + '-' + la_Resultado[3]; }
    } else {
        lc_Fecha = la_Resultado[3] + '-' + la_Resultado[2] + '-' + la_Resultado[1];
    }

    if (lc_Fecha == '') { alert('Fecha invlida '+ld_Fecha); }
    return lc_Fecha;
}

function Formato_Fecha(ld_Fecha) {
    // CAMBIAR EL FORMATO DE FECHA
    var lc_RegExp_DMY    = /([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/;
    var la_Resultado  = lc_RegExp_DMY.exec(ld_Fecha);
    if (la_Resultado != null) { var ld_Fecha = la_Resultado[3] + '-' + la_Resultado[2] + '-' + la_Resultado[1]; }
    return ld_Fecha;
}

function Objeto_Fecha (li_Dia,li_Mes,li_Year) {
    // LOS MESES VAN DEL 0 AL 11
    li_Mes = parseInt(li_Mes.replace(/^0/,'')) - 1;

    this.Fecha = new Date(li_Year,li_Mes,li_Dia);
    this.Dia   = li_Dia;
    this.Mes   = li_Mes;
    this.Year  = li_Year;
}

function Crear_Objeto_Fecha(ld_Fecha) {
    var lc_RegExp_DMY    = /([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/;
    var lc_RegExp_YMD    = /([0-9]{4})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{1,2})/;

    var la_Resultado  = lc_RegExp_DMY.exec(ld_Fecha);
    if (la_Resultado != null) {
        var lo_Objeto = new Objeto_Fecha(la_Resultado[1],la_Resultado[2],la_Resultado[3]);
    } else {
        var la_Resultado  = lc_RegExp_YMD.exec(ld_Fecha);
        if (la_Resultado != null) {
            var lo_Objeto = new Objeto_Fecha(la_Resultado[3],la_Resultado[2],la_Resultado[1]);
        } else {
            lo_Objeto = false;
        }
    }
    return lo_Objeto;
}

function Asignar_Fecha_Inhabil( lc_Id_Text, event, lo_Objeto ) {

    // SI NO SE HA SELECCIONADO UNA TEMPORADA
    if ( $('#fc_Temporada').attr('value') == "" ) {
        Mostrar_Mensaje('Por favor, seleccionar la temporada en la cual desea viajar.');
        // ESTABLECER EL MENSAJE DE INICIO
        Accion_Paso_Cotizador( 0 );
    } else {
        scwDisabledDates        = new Array();
        // DESHABILITAR LAS FECHAS ANTERIORES A LA FECHA ACTUAL
        var lo_Fecha            = Crear_Objeto_Fecha( $('#fc_Fecha_Actual')[0].value );
        scwDisabledDates[0]     = [new Date(1970,0,1), new Date(lo_Fecha.Year, lo_Fecha.Mes, lo_Fecha.Dia)];
        
        // SI POSEE FECHA LMITE, DESHABILITAR LAS FECHAS POSTERIORES
        if ( $('#fc_Fecha_Limite_Calendario')[0].value != '' ) {
            var lo_Fecha_Limite     = Crear_Objeto_Fecha( $('#fc_Fecha_Limite_Calendario')[0].value );
            scwDisabledDates[0]     = [ new Date(lo_Fecha_Limite.Year, lo_Fecha_Limite.Mes, lo_Fecha_Limite.Dia), new Date( (lo_Fecha_Limite.Year + scwDropDownYears), lo_Fecha_Limite.Mes, lo_Fecha_Limite.Dia) ];
        }
    
        var li_Total_Registros  = ga_Fecha_Inhabil.length;
        for (li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
            scwDisabledDates[scwDisabledDates.length] = Crear_Objeto_Fecha( ga_Fecha_Inhabil[li_Registro] ).Fecha;
        }
    
        // ADICIONAR LAS FECHAS DONDE NO SE POSEA DISPONIBILIDAD 
        Insertar_Texto_Calendario();
        
        // ABRIR EL CALENDARIO
        scwShow(document.getElementById( lc_Id_Text ), event);
    
        Seleccionar_Calendario( lo_Objeto );            
    
        // ADICIONAR MENSAJE EN EL PIE DE PGINA
        $('#scwFoot').append( la_Mensaje_Cotizador['Pie_Calendario'] );
        
        /****************************************************
        // ASIGNAR EVENTO UNA VEZ SE CIERRE EL CALENDARIO
        ****************************************************/
        scwNextAction = Validar_Fecha.runsAfterSCW(lo_Objeto);
        
        // DESPLAZAR EL ALMANAQUE AL LUGAR DEL CLICK
        Posicionar_Almanaque( event );
    }
}

function Posicionar_Almanaque( event ) {
    var li_Distancia = 10;
    //alert( lo_Mouse.X + ' ' + event.pageX + ' ' + event.screenX );
    $('#scw').css('top'   , ( lo_Mouse.Y + li_Distancia ) + 'px' );
    $('#scw').css('left'  , ( lo_Mouse.X + li_Distancia ) + 'px' );
    
    $('#scwIframe').css('top'   , ( event.pageY + li_Distancia ) + 'px' );
    $('#scwIframe').css('left'  , ( event.pageX + li_Distancia ) + 'px' );
    //alert( event.pageY + ' ' + event.pageX );
}

function Seleccionar_Calendario(lo_Objeto) {
    //var lo_Select = document.getElementById('scwMonths');
    //lo_Select.selectedIndex = <?php echo intval( date('n') ) - 1; ?>;

    $('#scw')[0].style.top  = lo_Objeto.offsetTop  + 'px';
    $('#scw')[0].style.left = ( parseInt( lo_Objeto.offsetLeft ) + 20 ) + 'px';
    
    $('#scwIframe')[0].style.top  = lo_Objeto.offsetTop  + 'px';
    $('#scwIframe')[0].style.left = ( parseInt( lo_Objeto.offsetLeft ) + 20 ) + 'px';
}          				

// OCULTAR LOS CALENDARIOS
function Ocultar_Boton_Calendario() {
    if ( arguments.length > 0 ) {
        $('#fc_Fecha_Inicio').parent().find('img').show();
        $('#fc_Fecha_Limite').parent().find('img').show();
    } else {
        $('#fc_Fecha_Inicio').parent().find('img').hide();
        $('#fc_Fecha_Limite').parent().find('img').hide();
    } 
}

function Inicializar_Totales() {
    Asignar_Valor('fc_Costo',0);
    Asignar_Valor('fc_Costo_Total',0);
}

function Cargar_Datos_Plan_Calendario_Transporte (lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'costo_plan_adulto_menor_calendario_transporte');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Id_Plan')[0].value + '|' + $('#fc_Temporada')[0].value );
    //la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Cargar_Fecha_Inhabil_Calendario();' );
    
    //alert( $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Id_Plan')[0].value + '|' + $('#fc_Temporada')[0].value );
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Validar_Fecha() {
    
    var lo_Fecha_Actual = document.getElementById('fc_Fecha_Actual');
    var lo_Fecha_Inicio = document.getElementById('fc_Fecha_Inicio');
    var lo_Fecha_Limite = document.getElementById('fc_Fecha_Limite');

    lo_Fecha_Inicio.value = Formato_Fecha(lo_Fecha_Inicio.value);
    lo_Fecha_Limite.value = Formato_Fecha(lo_Fecha_Limite.value);

    // VALIDAR QUE EXISTA PREVIAMENTE LA SELECCIN DE UN PLAN
    if ( document.getElementById('fc_Id_Plan').value == "" ) { 
        alert('Debe seleccionar un Plan. Favor verificar.');              
    } else {
				// VALIDAR QUE EXISTA UNA SELECCIN DE ADULTOS
        var li_Adultos  = Tomar_Numero(document.getElementById('fc_Adultos').value);

        // VALIDAR SIEMPRE Y CUANDO EL NMERO DE ADULTOS SEA MAYOR A CERO
        if ( li_Adultos > 0 && $('#fc_Tipo_Habitacion').attr('value') != '' ) {

            if ( lo_Fecha_Limite.value == '' ) { Asignar_Valor( 'fc_Fecha_Limite', lo_Fecha_Inicio.value ); }
  
            var li_Minimo_Dias = Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ); 
            var li_Maximo_Dias = Tomar_Numero( $('#fc_Maximo_Dias').attr('value') );

            // LA FECHA LMITE DEPENDER DEL NMERO MNIMO DE DAS
            if ( li_Minimo_Dias > 1 && li_Maximo_Dias > 1 ) {
                // OCULTAR EL CALENDARIO DE FECHA LMITE
                //$('#fc_Fecha_Limite').hide();

                if ( li_Minimo_Dias == li_Maximo_Dias ) {
                    var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                    lo_Objeto_Fecha_Inicial.Fecha.setDate( lo_Objeto_Fecha_Inicial.Fecha.getDate() + li_Minimo_Dias );
                    /******************************************************************************************
                    // IGUALAR LAS FECHAS PORQUE NO EXISTEN FECHAS DE SELECCIN, YA QUE SON TEMPRADAS FIJAS
                    ******************************************************************************************/
                    Asignar_Valor( 'fc_Fecha_Limite', String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                } else {
                    /******************************************************************************************************
                    // SI TIENE UN MXIMO DE DAS ASIGNADO .. ENTONCES SUMARLE A LA FECHA DE INICIO .. EL MXIMO DE DAS
                    ******************************************************************************************************/
                    if ( lo_Fecha_Inicio.value == lo_Fecha_Limite.value ) {
                        lo_Objeto_Fecha_Inicial.Fecha.setDate( lo_Objeto_Fecha_Inicial.Fecha.getDate() + li_Maximo_Dias );
                        Asignar_Valor( 'fc_Fecha_Limite', String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                    }
                    
                    /******************************************************************
                    // SI LA FECHA FINAL SUPERA EL MXIMO DE DAS .. NO PERMITIRLO
                    ******************************************************************/
                    var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                    var lo_Objeto_Fecha_Final   = Crear_Objeto_Fecha(lo_Fecha_Limite.value);
                    
                    if ( lo_Objeto_Fecha_Inicial.Fecha.setDate( lo_Objeto_Fecha_Inicial.Fecha.getDate() + li_Maximo_Dias ) < lo_Objeto_Fecha_Final.Fecha ) {
                        Asignar_Valor( 'fc_Fecha_Limite', String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                    }
                }
            } else {
                // PRESENTAR EL CALENDARIO DE FECHA LMITE
                //$('#fc_Fecha_Limite').show();
            }

            if (Es_Fecha_Menor(lo_Fecha_Inicio.value,lo_Fecha_Actual.value) == true) {
                 alert('La fecha inicial no puede ser menor a la fecha actual. Favor verificar.');
                 Asignar_Valor('fc_Fecha_Inicio',lo_Fecha_Actual.value);
            } else {
                if (Es_Fecha_Menor(lo_Fecha_Limite.value,lo_Fecha_Inicio.value) == true) {
                   //alert('La fecha lmite no puede ser menor a la fecha de inicio. Favor verificar.');
                   Asignar_Valor('fc_Fecha_Limite',lo_Fecha_Inicio.value);
                }
                
                // VALIDAR LA DISPONIBILIDAD NEGATIVA, SLO CUANDO SEA HOTELERA, PARA EL CASO DE PLAN NO APLICA
                if ( Tomar_Numero( $('#fc_Tipo_Cotizador').attr('value') ) == 2 ) {

                    // VALIDAR QUE EL RANGO SELECCIONADO, NO POSEA UNA DISPONIBILIDAD NEGATIVA
                    var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                    var lo_Objeto_Fecha_Final   = Crear_Objeto_Fecha(lo_Fecha_Limite.value);
                    var lb_Fecha_Disponibilidad = true;

                    var li_Total_Fecha_Inhabil = ga_Fecha_Inhabil.length;
                    for (li_Registro=0; li_Registro < li_Total_Fecha_Inhabil; li_Registro++) {
                        // CREAR EL OBJETO TIPO FECHA PARA LAS FECHAS INHABILES
                        lo_Objeto_Fecha_Inhabil = Crear_Objeto_Fecha( ga_Fecha_Inhabil[li_Registro] );
                        if ( lo_Objeto_Fecha_Inhabil.Fecha >= lo_Objeto_Fecha_Inicial.Fecha && lo_Objeto_Fecha_Inhabil.Fecha <= lo_Objeto_Fecha_Final.Fecha ) { lb_Fecha_Disponibilidad = false; break; } 
                    }
                    
                    lb_Fecha_Disponibilidad = true;
                    
                    if ( lb_Fecha_Disponibilidad == false ) {
                        var lc_Mensaje = 'Se ha includo la fecha ' + lo_Objeto_Fecha_Inhabil.Year + '-' + (lo_Objeto_Fecha_Inhabil.Mes + 1) + '-' + lo_Objeto_Fecha_Inhabil.Dia + ', la cual no tiene disponibilidad. Favor verificar.';
                        
                        try { parent.Mostrar_Mensaje( lc_Mensaje ); }
                        catch(exception) { alert( lc_Mensaje ); }
                        
                        //alert('limpiar fecha');
                        
                        Asignar_Valor('fc_Fecha_Inicio',lo_Fecha_Actual.value);
                        Asignar_Valor('fc_Fecha_Limite',lo_Fecha_Actual.value);
                    }
                }
                // REALIZAR EL PROCESO DE COTIZACIN
                Cotizar();
            }
//        }
        } else {
            // LA FECHA LMITE DEPENDER DEL NMERO MNIMO DE DAS
            var li_Minimo_Dias = Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ); 
            var li_Maximo_Dias = Tomar_Numero( $('#fc_Maximo_Dias').attr('value') );
            
            if ( li_Minimo_Dias > 1 && li_Maximo_Dias > 1 ) {
                if ( li_Minimo_Dias == li_Maximo_Dias ) {
                    var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                    lo_Objeto_Fecha_Inicial.Fecha.setDate( lo_Objeto_Fecha_Inicial.Fecha.getDate() + li_Minimo_Dias );
                    // ASIGNAR LA FECHA AL RANGO LMITE
                    Asignar_Valor( 'fc_Fecha_Limite', String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                }
            }
            // LA FECHA LMITE NO PUEDE SER MENOR QUE LA FECHA ACTUAL
            if (Es_Fecha_Menor(lo_Fecha_Limite.value,lo_Fecha_Inicio.value) == true) { Asignar_Valor('fc_Fecha_Limite',lo_Fecha_Inicio.value); }            
        }
        
        // ACTIVAR EL PASO 3
        Accion_Paso_Cotizador( 2 );
    }
}

function Icono_Desplegar_Ocultar(lo_Objeto,lc_Id_Contenedor) {
    lo_Objeto.src = (lo_Objeto.src.indexOf('btn_presentar') != -1) ? '../Iconos/btn_ocultar.gif' : '../Iconos/btn_presentar.gif';
    if (lo_Objeto.src.indexOf('btn_presentar') != -1) { Ocultar_Objeto(lc_Id_Contenedor); } else { Ocultar_Objeto(lc_Id_Contenedor,false); }
}	

function Enviar_Datos (lc_String_Select,lc_String_Texto) {
    if ( $('#recibir_email')[0].checked == false ) {

        var lc_Mensaje = la_Mensaje_Cotizador['Autorizar_Envio_Mail'];
        try { parent.Mostrar_Mensaje( lc_Mensaje ); }
        catch(exception) { alert( lc_Mensaje ); }
        
    } else {
    
        $('#fc_Plan').attr('value', $('#fc_Id_Plan').attr('value') ); 

        var lb_Enviar = true;
        if (lc_String_Select != '') { lb_Enviar = Validar_Objeto_Select (lc_String_Select,'#FFFFAA'); }
        if (lb_Enviar == true) { if (lc_String_Texto != '') { lb_Enviar = Validar_Objeto_Input(lc_String_Texto,'#FFFFAA'); } }
        if (lb_Enviar == false) {
            var lc_Mensaje = la_Mensaje_Cotizador['Informacion_Solicitante'];
            
            try { parent.Mostrar_Mensaje( lc_Mensaje ); }
            catch(exception) { alert( lc_Mensaje ); }
                       
        } else {
            var lb_enviar = false;
            
            // ELIMINAR LOS MENORES
            if (Tomar_Numero(document.getElementById('fc_Menores').value) == 0) { 
                $('#fc_Costos_Referencia_Usuario')[0].value = $('#fc_Costos_Referencia_Usuario')[0].value.replace( /\<\!--INICIO_ELIMINAR--\>[\x20-\xFA]{1,}\<\!--FIN_ELIMINAR--\>/i, "" );
                //alert($('#fc_Costos_Referencia_Usuario')[0].value);
            }
            
            // VALIDAR TOTAL DE NOCHES
            if (Tomar_Numero(document.getElementById('fc_Total_Dias').value) > 0) {                  
                // VALIDAR NMERO DE ADULTOS                  
                if (Tomar_Numero(document.getElementById('fc_Adultos').value) > 0) {
                    // ADICIONAR LA ZONA DE HABITACIONES
                    //if ( document.getElementById('zona_habitaciones_disponibles') != null ) { $('#zona_habitaciones_disponibles').css('display','none'); document.getElementById('Formulario_Cotizar').appendChild( document.getElementById('zona_habitaciones_disponibles') ); }
                    
                    Ocultar_Objeto('boton_enviar_cotizacion');
                    showLoading();
                    
                    $('#Formulario_Cotizar').submit();
                } else {
                    try { parent.top.Mostrar_Mensaje( la_Mensaje_Cotizador['Adultos_Mayor_Cero'] ); }
                    catch(exception) { alert( la_Mensaje_Cotizador['Adultos_Mayor_Cero'] ); }	
                }
            } else {
                // ADICIONAR LA ZONA DE HABITACIONES
                //if ( document.getElementById('zona_habitaciones_disponibles') != null ) { $('#zona_habitaciones_disponibles').css('display','none'); document.getElementById('Formulario_Cotizar').appendChild( document.getElementById('zona_habitaciones_disponibles') ); }

                Ocultar_Objeto('boton_enviar_cotizacion');
                showLoading();
            
                $('#Formulario_Cotizar').submit();
            }
        }
    }
}

/*
function Cargar_Datos_Plan (lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'costo_plan_adulto_menor');    
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', document.getElementById('fc_Id_Plan').value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Cotizar(); Cargar_Fecha_Inhabil_Calendario(); Cargar_Tipo_Calendario(); ');

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}
*/

function Cargar_Tipo_Calendario() {
    Cargar_Lista_Desplegable( 'fc_Temporada', 'tipo_calendario_portafolio' , document.getElementById('fc_Id_Portafolio').value );
}

function Cargar_Costos_Adicionales(lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion', 'Tomar_Costos_Adicionales' );    
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', lc_Id_Plan );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Existe_Estancia (li_Dias, li_Tipo_Usuario) { 
    var li_Total_Estancia = ga_Costo_Usuario_Estancia.length;
    var lb_Resultado      = false;

    if (li_Total_Estancia > 0) {
        for (var li_Estancia=0; li_Estancia < li_Total_Estancia; li_Estancia++) {
            //alert( ga_Costo_Usuario_Estancia[li_Estancia].Equivalencia  + ' ' + li_Dias + ' ' + ga_Costo_Usuario_Estancia[li_Estancia].Usuario + ' ' + li_Tipo_Usuario );
            if (ga_Costo_Usuario_Estancia[li_Estancia].Equivalencia == li_Dias && ga_Costo_Usuario_Estancia[li_Estancia].Usuario == li_Tipo_Usuario) {
                //alert('Dias ' + li_Dias + ' Tipo usuario ' + li_Tipo_Usuario + ' Costo ' + ga_Costo_Usuario_Estancia[li_Estancia].Costo + ' Capacidad ' + ga_Costo_Usuario_Estancia[li_Estancia].Capacidad );
                lb_Resultado = parseInt(ga_Costo_Usuario_Estancia[li_Estancia].Costo); break;
            }
        }
    }

    //alert( 'Estancia ' + li_Total_Estancia + ' Existe ? ' + lb_Resultado );
        
    return lb_Resultado;
}

function Existe_Sobrecosto ( lc_Fecha, li_Tipo_Usuario ) { 
    var li_Total_Registros  = ga_Rango_Fechas_Sobrecostos.length;
    // CUANDO LAS CONSULTAS SON COMPUESTAS, RECIBIR EL PARMETRO DE DAS
    var li_Comparar_Dias    = (arguments.length >= 3) ? arguments[2] : $('#fc_Total_Dias').attr('value');

    //alert(' Comparar ' + li_Comparar_Dias );
        
    var lb_Resultado        = false;
    if (li_Total_Registros > 0) {
        //alert( 'Buscar ' + lc_Fecha );
        for (var li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
            //alert( ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha + ' ' + lc_Fecha + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario + ' ' + li_Tipo_Usuario + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte + ' ' + $('#fc_Transporte').attr('value') + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Estancia + ' ' + $('#fc_Total_Dias').attr('value') );
            
            $('#objeto_validador').append("<div>" + ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha + ' ' + lc_Fecha + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario + ' ' + li_Tipo_Usuario + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte + ' ' + $('#fc_Transporte').attr('value') + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Estancia + ' ' + $('#fc_Total_Dias').attr('value') + "</div>" );
            
            if (ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha == lc_Fecha && ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario == li_Tipo_Usuario && ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte == $('#fc_Transporte').attr('value') && ga_Rango_Fechas_Sobrecostos[li_Registro].Estancia == li_Comparar_Dias ) {
                $('#objeto_validador').append("<div>Si existe " + ( 1 + parseFloat( ga_Rango_Fechas_Sobrecostos[li_Registro].Porcentaje / 100) ) + "</div>" );                
                lb_Resultado = 1 + parseFloat( ga_Rango_Fechas_Sobrecostos[li_Registro].Porcentaje / 100); break;
            }
        }
    }
    return lb_Resultado;
}

function Mostrar_Mensaje(lc_Mensaje) {
    if ( typeof jAlert == 'function' ) { jAlert(lc_Mensaje, 'Mensaje'); } else { alert(lc_Mensaje); }
}

function Validar_Cantidad_Adicionales( lo_Objeto ) {
    var li_Valor = Tomar_Numero( lo_Objeto.value );

    if ( li_Valor > 0 ) { lo_Objeto.value = li_Valor; } else { lo_Objeto.value = 1; }

    Calcular_Adicionales();
}

function Cargar_Plan_Ciudad_Salida (lc_Id_Ciudad) {
    //Cargar_Lista_Desplegable('fc_Id_Plan','lista_plan_ciudad_salida',lc_Id_Ciudad);
    Cargar_Lista_Desplegable('fc_Transporte','lista_transporte_ciudad_salida',lc_Id_Ciudad, 'Carga_Transporte()' );
}

function Validar_Fecha_Inhabil(lo_Picker) {

    var li_Total_Fechas = ga_Fecha_Inhabil.length;
    if (li_Total_Fechas > 0) {
        var lc_Year   = lo_Picker.document.getElementById('Year_Picker').value;
        var lc_Mes    = parseInt(lo_Picker.document.getElementById('Mes_Calendario').value) + 1;
        var li_Mes    = (lc_Mes < 10) ? '0' + lc_Mes : lc_Mes;

        // CADENA A BUSCAR
        var lc_Buscar = lc_Year + '-' + li_Mes;
        
        for (var li_Fecha=0; li_Fecha < li_Total_Fechas; li_Fecha++) {
            if (ga_Fecha_Inhabil[li_Fecha].indexOf(lc_Buscar) != -1) {
                // BUSCAR EL DA Y MARCARLO COMO INHBIL
                Marcar_Dia_Picker(lo_Picker,ga_Fecha_Inhabil[li_Fecha] );
            }
        }
    }
}

function Marcar_Dia_Picker (lo_Picker,lc_Dia) {

    var la_Fecha = lc_Dia.split('-');
    if (la_Fecha.length == 3) { var lc_Dia = (la_Fecha[0].length == 4) ? la_Fecha[2] : la_Fecha[0]; }            

    // MARCAR LOS DAS DE CALENDARIO
    var la_Dia        = document.getElementsByName( 'dia_'+lc_Dia.replace(/^0/,'') + '[]' );
    var li_Total_Dias = la_Dia.length;

    for ( var li_Dia=0; li_Dia < li_Total_Dias; li_Dia++ ) {
        var lo_Dia = la_Dia[li_Dia];              

        if (lo_Dia != null) {
            lo_Dia.innerHTML = '';
            //lo_Dia.style.backgroundImage    = 'url(<?php echo Path_Host."coti_planes/Iconos/"; ?>close.png)';
            lo_Dia.style.backgroundImage    = 'url(' + gc_Root + 'aplicaciones/iconos/close.png)';
            lo_Dia.style.backgroundPosition = 'center';
            lo_Dia.style.backgroundRepeat   = 'no-repeat';
            //lo_Dia.style.border             = '1px solid #000000';
            lo_Dia.style.height             = '18px';
            lo_Dia.onclick                  = function (e) { alert( la_Mensaje_Cotizador['Fecha_No_Aplica'] ); lo_Picker.focus(); }
        } else {
            //alert( 'dia_'+lc_Dia.replace(/^0/,'') );
        }              
    }              
}

function Cargar_Fecha_Inhabil () {

}

/*
function Cargar_Fecha_Inhabil_Calendario () {
    ga_Fecha_Inhabil = new Array();

    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion', 'Tomar_Fecha_Inhabil_Calendario' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo_calendario', document.getElementById('fc_Tipo_Calendario').value );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);    				
}
*/

function Inicializar_Formato() {
 		Asignar_Valor('fc_Nombre|fc_Apellido|fc_Cedula|fc_Telefono|fc_Email|fc_Temporada|fc_Transporte|fc_Ciudad_Salida','');
 		Asignar_Valor('fc_Adultos|fc_Menores|fc_Total_Dias','0');                
}

function Campo_Obligatorio(lo_Objeto) {
    if ( lo_Objeto.checked == false ) { 
        lo_Objeto.checked = true;

        var lc_Mensaje = la_Mensaje_Cotizador['Costo_Obligatorio'];
        try { parent.Mostrar_Mensaje( lc_Mensaje ); }
        catch(exception) { alert( lc_Mensaje ); }         
    }
}

/*  DESCRIPCIN - Funcin que obtener el texto de un objeto tipo SELECT
**  
**  lc_Id : Id del objeto sobre el cual se obtendr el valor.
*/	

function Tomar_Texto_Select (lc_Id) {
    var lo_Select = document.getElementById(lc_Id);
    var lc_Texto  = '';
    if (lo_Select != null) { lc_Texto = lo_Select.options[lo_Select.selectedIndex].text; }
    return lc_Texto;
}

function Presentar_Ocultar(lc_Id_Objeto) {
    // CAPTURAR EL OBJETO
    if (lc_Id_Objeto.nodeName) { var lo_Objeto = lc_Id_Objeto; } else { var lo_Objeto = document.getElementById(lc_Id_Objeto); }
    if (lo_Objeto != null) {
        // SWITCH PARA PRESENTAR/OCULTAR UN OBJETO
        if (lo_Objeto.style.display == 'none') { Ocultar_Objeto(lc_Id_Objeto,true); } else { Ocultar_Objeto(lc_Id_Objeto); }
    }
}

function Ver_Cotizador() { Presentar_Ocultar('modulo_cotizador'); document.getElementById('Div_Contenedor_Formulario').scrollIntoView(true); }

function Iniciar_Objeto_Cotizador() {
    go_Objeto_Cotizador.adultos                 = 0;
    go_Objeto_Cotizador.menores                 = 0;
    go_Objeto_Cotizador.dias                    = 0;
    go_Objeto_Cotizador.dias_proximos_adulto    = 0;
    go_Objeto_Cotizador.dias_adicionales_adulto = 0;
    go_Objeto_Cotizador.dias_proximos_menor     = 0;
    go_Objeto_Cotizador.dias_adicionales_menor  = 0;
    go_Objeto_Cotizador.fecha_inicio            = null;
    go_Objeto_Cotizador.fecha_final             = null;
    go_Objeto_Cotizador.costo_adulto_proximos   = 0;
    go_Objeto_Cotizador.costo_menor_proximos    = 0;
    go_Objeto_Cotizador.costo_adulto_adicional  = 0;
    go_Objeto_Cotizador.costo_menor_adicional   = 0;
    go_Objeto_Cotizador.costo_adulto            = 0;
    go_Objeto_Cotizador.costo_menor             = 0;
    go_Objeto_Cotizador.nuevo_costo_adulto      = 0;
    go_Objeto_Cotizador.nuevo_costo_menor       = 0;
    go_Objeto_Cotizador.costo_base              = 0;
    go_Objeto_Cotizador.adicionales             = 0;
    go_Objeto_Cotizador.iva                     = 0;
    go_Objeto_Cotizador.sobrecosto1             = 0;
    go_Objeto_Cotizador.sobrecosto2             = 0;
    
    /****************************************************************************************
    // BUSCAR LOS COSTOS DE LOS MENORES EN CASO DE SER CONFIGURADOS DIFERENTE AL CDIGO 2
    ****************************************************************************************/
    
    var li_Total_Costos = ga_Costo_Usuario_Estancia.length;
    var li_Costo_Menor  = null;
    var li_Indice_Menor = null;
    
    for ( li_Registro=0; li_Registro < li_Total_Costos; li_Registro++ ) {
        if ( ga_Costo_Usuario_Estancia[li_Registro].Usuario != 1 ) { li_Costo_Menor = ga_Costo_Usuario_Estancia[li_Registro].Usuario; li_Indice_Menor = li_Registro; break; } 
    }
    
    if ( li_Costo_Menor == null ) {
        $('#seccion_menores').hide();
    } else {
        if ( li_Costo_Menor != null && li_Costo_Menor != 2 ) { ga_Costo_Usuario_Estancia[li_Indice_Menor].Usuario = 2; }
        $('#seccion_menores').show();
    }
    
    /*******************************************************************************************
    // FIN BUSCAR LOS COSTOS DE LOS MENORES EN CASO DE SER CONFIGURADOS DIFERENTE AL CDIGO 2
    *******************************************************************************************/
}

function Cotizar() {
    //try { alert("caller is " + arguments.callee.caller.toString()); } catch(exception) {} 
   
    Iniciar_Objeto_Cotizador();
    
    // TOMAR LOS USUARIOS
    var li_Adultos      = parseInt( $('#fc_Adultos').attr('value') );
    var li_Menores      = parseInt( $('#fc_Menores').attr('value') );

    var lo_Fecha_Inferior = Crear_Objeto_Fecha( $('#fc_Fecha_Inicio').attr('value') );
    var lo_Fecha_Superior = Crear_Objeto_Fecha( $('#fc_Fecha_Limite').attr('value') );

    if (lo_Fecha_Inferior != false && lo_Fecha_Superior != false) { var li_Dias = ((lo_Fecha_Superior.Fecha - lo_Fecha_Inferior.Fecha) / (1000 * 60 * 60 * 24)); } else { li_Dias = 0; } 

    Asignar_Valor('fc_Total_Dias',li_Dias);
    $('.totalNoches').find('span').html( li_Dias );
    
    go_Objeto_Cotizador.costo_adulto_adicional  = Existe_Estancia (1, 1);
    go_Objeto_Cotizador.costo_menor_adicional   = Existe_Estancia (1, 2);
    
    if ( li_Dias == 0 ) { 
        var li_Costo_Adulto = 0;
        var li_Costo_Menor  = 0;
    } else {
        // CONOCER EL COSTO DE AULTO DA
        var li_Costo_Adulto_Dia = ( Existe_Estancia (1, 1) == false ) ? 0 : Existe_Estancia (1, 1);
        var li_Costo_Menor_Dia  = ( Existe_Estancia (1, 2) == false ) ? 0 : Existe_Estancia (1, 2);
         
        // A PARTIR DE LOS DAS, CONOCER PRECIOS POR ESTANCIA
        li_Costo_Adulto_Medida = Existe_Estancia (li_Dias, 1);

        if (li_Costo_Adulto_Medida != false) {
            // COSTO DE ADULTO POR DA 
            li_Costo_Adulto = ( li_Costo_Adulto_Medida / li_Dias ); 
        } else {
            // BUSCAR EL VALOR INFERIOR MS PRXIMO
            var li_Valor_Estancia = li_Costo_Adulto_Dia;
            var li_Dias_Proximos  = li_Dias;
            var li_Estancia       = false;
            
            for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
                // BUSCAR EL VALOR DE LA ESTANCIA
                var li_Estancia = Existe_Estancia( li_Valor_Inferior,1 );
                if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
            }
            
            if ( li_Dias_Proximos == li_Dias ) {
                li_Costo_Adulto = li_Costo_Adulto_Dia;
            } else {
                // EL COSTO DEL ADULTO SER EL DA PROXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
                li_Costo_Adulto = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * li_Costo_Adulto_Dia ) ) / li_Dias;
            }

            //alert( ' Das prximos ' + li_Dias_Proximos + ' Das ' + li_Dias + ' ' + ' Precio Adulto ' + li_Costo_Adulto );
            
            // ACTUALIZAR EL OBJETO
            go_Objeto_Cotizador.dias_proximos_adulto    = ( li_Estancia == false ) ? 1 : li_Dias_Proximos;
            go_Objeto_Cotizador.dias_adicionales_adulto = li_Dias - li_Dias_Proximos;
            go_Objeto_Cotizador.costo_adulto_proximos   = ( li_Estancia == false ) ? li_Valor_Estancia : (li_Valor_Estancia / li_Dias_Proximos);
            go_Objeto_Cotizador.costo_adulto_adicional  = li_Costo_Adulto_Dia;
        }

        // ACTUALIZAR EL OBJETO
        go_Objeto_Cotizador.costo_adulto  = li_Costo_Adulto;

        // TOMAR EL VALOR DEL MENOR
        li_Costo_Menor_Medida  = Existe_Estancia (li_Dias, 2);
        if (li_Costo_Menor_Medida != false) {
            // COSTO DE ADULTO POR DA 
            li_Costo_Menor = ( li_Costo_Menor_Medida / li_Dias ); 
        } else {
            // BUSCAR EL VALOR INFERIOR MS PRXIMO
            var li_Valor_Estancia = li_Costo_Menor_Dia;
            var li_Dias_Proximos  = li_Dias;
            var li_Estancia       = false;
            
            for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
                // BUSCAR EL VALOR DE LA ESTANCIA
                var li_Estancia = Existe_Estancia(li_Valor_Inferior,2);
                if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
            }

            // SI SLO SE TIENE UN VALOR POR REFERENCIA, ENTONCES UTILIZAR EL VALOR DE 1 DA
            if ( li_Dias_Proximos == li_Dias ) {
                li_Costo_Menor = li_Costo_Menor_Dia;
            } else {
                // EL COSTO DEL ADULTO SER EL DA PRXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
                li_Costo_Menor = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * li_Costo_Menor_Dia ) ) / li_Dias;
            }
            
            // ACTUALIZAR EL OBJETO
            go_Objeto_Cotizador.dias_proximos_menor     = ( li_Estancia == false ) ? 1 : li_Dias_Proximos;
            go_Objeto_Cotizador.dias_adicionales_menor  = li_Dias - li_Dias_Proximos;
            go_Objeto_Cotizador.costo_menor_proximos    = ( li_Estancia == false ) ? li_Valor_Estancia : (li_Valor_Estancia / li_Dias_Proximos);
            go_Objeto_Cotizador.costo_menor_adicional   = li_Costo_Menor_Dia;
        }

        // ACTUALIZAR EL OBJETO
        go_Objeto_Cotizador.costo_menor = li_Costo_Menor;

        if ( li_Costo_Adulto  == false ) { li_Costo_Adulto  = 0; }
        if ( li_Costo_Menor   == false ) { li_Costo_Menor   = 0; }

        // UNA VEZ QUE SE HA HALLADO EL COSTO DEL ADULTO Y DEL MENOR, BUSCAR QUE EL RANGO DE FECHAS NO POSEAN SOBRECOSTOS
        var ld_Fecha_Inicio       = Crear_Objeto_Fecha( $('#fc_Fecha_Inicio').attr('value') );

        // ACUMULADOR DE NUEVO COSTO POR PERODO
        var li_Nuevo_Costo_Adulto = 0;
        var li_Nuevo_Costo_Menor  = 0;

        //alert( li_Costo_Adulto + ' ' + ld_Fecha_Inicio.Fecha + ' ' + $('#fc_Fecha_Inicio').attr('value') );

        // EL CASO DE LOS SOBRE COSTOS ES ESPECIAL, DONDE SE APLICA UN SLO GRUPO DE SOBRECOSTOS SOBRE UN VALOR DEFINIDO EN LA CONFIGURACIN
        // O EN EL CASO DE HABER SOBRECOSTOS EN UN RANGO DE FECHAS QUE NO SE HA DEFINIDO, ENTONCES DIVIDIR LOS SOBRECOSTOS EN DOS BLOQUES
        
        if ( go_Objeto_Cotizador.dias_proximos_adulto == 0 ) {
            for (var li_Suma_Dia=0; li_Suma_Dia < li_Dias; li_Suma_Dia++ ) {
                // CREAR EL OBJETO FECHA
                var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
                // SUMAR UN DA
                ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
                // CREAR LA CADENA DE LA NUEVA FECHA
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1 );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
                }
                
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2 );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
                }
            }
        } else {
            // VALOR DEL ADULTO DEL PRIMER RANGO
            li_Costo_Adulto = go_Objeto_Cotizador.costo_adulto_proximos;
            li_Costo_Menor  = go_Objeto_Cotizador.costo_menor_proximos;
        
            // PARA EL CASO EN EL QUE LOS DAS NO ESTN CONFIGURADOS, APLICAR A CADA PLAZO, LO CORRESPONDIENTE
            for (var li_Suma_Dia=0; li_Suma_Dia < go_Objeto_Cotizador.dias_proximos_adulto; li_Suma_Dia++ ) {
                // CREAR EL OBJETO FECHA
                var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
                // SUMAR UN DA
                ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
                // CREAR LA CADENA DE LA NUEVA FECHA
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1, go_Objeto_Cotizador.dias_proximos_adulto );

                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
                }

                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + li_Nuevo_Costo_Adulto );
                
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2, go_Objeto_Cotizador.dias_proximos_menor );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
                    
                    //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + (li_Costo_Menor * lb_Resultado ) );
                } else {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
                    
                    //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + li_Costo_Menor );
                }
            }
            
            go_Objeto_Cotizador.sobrecosto1 = li_Nuevo_Costo_Adulto; 

            // VALOR DEL ADULTO DA ADICIONAL
            li_Costo_Adulto = go_Objeto_Cotizador.costo_adulto_adicional;
            li_Costo_Menor  = go_Objeto_Cotizador.costo_menor_adicional;
            
            for (var li_Suma_Dia=go_Objeto_Cotizador.dias_proximos_adulto; li_Suma_Dia < li_Dias; li_Suma_Dia++ ) {
                // CREAR EL OBJETO FECHA
                var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
                // SUMAR UN DA
                ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
                // CREAR LA CADENA DE LA NUEVA FECHA
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1, 1 );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
                }

                //alert( 'adicional ' + lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2, 1 );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
                    
                    //alert( 'adicional ' + lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + ( li_Costo_Menor * lb_Resultado ) );
                } else {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
                    
                    //alert( 'adicional ' + lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + li_Costo_Menor );
                }
                
            }
            
            go_Objeto_Cotizador.sobrecosto2 = li_Nuevo_Costo_Adulto;                         
        }
        
        // REASIGNAR EL NUEVO COSTO
        li_Costo_Adulto = li_Nuevo_Costo_Adulto / li_Dias;
        li_Costo_Menor  = li_Nuevo_Costo_Menor / li_Dias;
        
        // ACTUALIZAR EL OBJETO
        go_Objeto_Cotizador.nuevo_costo_adulto  = li_Costo_Adulto;
        go_Objeto_Cotizador.nuevo_costo_menor   = li_Costo_Menor;
    }

    // SI EL NMERO MXIMO DE DAS ES CERO, DE DECIR NO TIENE NOCHES
    if ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) { 
        var li_Costo_Adulto = ( Existe_Estancia (0, 1) == false ) ? 0 : Existe_Estancia (0, 1);
        var li_Costo_Menor  = ( Existe_Estancia (0, 2) == false ) ? 0 : Existe_Estancia (0, 2);
    }
    
    var li_Total_Costo_Adulto = ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos * li_Dias);
    var li_Total_Costo_Menor  = ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores * li_Dias); 

    //var li_Cotizacion   = (li_Costo_Adulto * li_Adultos) + (li_Costo_Menor * li_Menores);
    var li_Cotizacion   = (li_Total_Costo_Adulto + li_Total_Costo_Menor);
    
    //Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion * li_Dias));
    Asignar_Valor('fc_Costo',Formatear_Numero( Math.round( li_Cotizacion) ) );

    Calcular_Adicionales();
    
    // ACTUALIZAR EL OBJETO
    go_Objeto_Cotizador.adultos       = li_Adultos;
    go_Objeto_Cotizador.menores       = li_Menores;
    go_Objeto_Cotizador.dias          = li_Dias;
    go_Objeto_Cotizador.fecha_inicio  = $('#fc_Fecha_Inicio').attr('value');
    go_Objeto_Cotizador.fecha_final   = $('#fc_Fecha_Limite').attr('value');
    go_Objeto_Cotizador.costo_base    = li_Cotizacion;
    
    //Propiedades_Objeto(go_Objeto_Cotizador);
}

function Calcular_Adicionales() {
		var la_NombreObjeto     = document.getElementsByName('fc_Servicio[]');
		var la_Seleccion        = new Array();
		
    var li_Adultos      = Tomar_Numero(document.getElementById('fc_Adultos').value);
    var li_Menores      = Tomar_Numero(document.getElementById('fc_Menores').value);
    var li_Costo_Basico = Tomar_Numero(document.getElementById('fc_Costo').value);

		var li_Total_Adicional  = 0;
		for (var li_Ciclos=0; li_Ciclos < la_NombreObjeto.length; li_Ciclos++) {
				if (la_NombreObjeto[li_Ciclos].checked == true) { 
            // DIVIDIR EL VALUE
				    var la_Valor  = la_NombreObjeto[li_Ciclos].value.split("-");
            // EL VALUE POSEE 
            //    SERVICIO_GENERAL
            //    COSTO
            //    TIPO SERVICIO
            //    TIPO USUARIO
            if (la_Valor.length == 4) {
                var li_Costo_Adicional  = Tomar_Numero(la_Valor[1]);
                // 1-POR PERSONA
                if (la_Valor[2] == 1) {
                    // li_Costo_Adicional = (li_Adultos + li_Menores) * li_Costo_Adicional;
                    // 1 ADULTOS    2 - NIOS
                    switch (la_Valor[3]) {
                        case '1'  : li_Costo_Adicional = li_Adultos * li_Costo_Adicional; break;
                        case '2'  : li_Costo_Adicional = li_Menores * li_Costo_Adicional; break;
                    }
                }
            }
            
            // TOMAR LA CANTIDAD
            var li_Id_Cantidad  = la_NombreObjeto[li_Ciclos].id.replace('fc_Servicio_Adicional_','fc_Cantidad_Adicional_');
            var li_Cantidad     = Tomar_Numero( $('#' + li_Id_Cantidad ).attr('value') );

            li_Total_Adicional = (li_Cantidad > 0) ? (li_Total_Adicional + (li_Costo_Adicional * li_Cantidad)) : (li_Total_Adicional + li_Costo_Adicional);
            //li_Total_Adicional = li_Total_Adicional + li_Costo_Adicional;
        }
		}

		Asignar_Valor('fc_Costo_Adicional',Formatear_Numero(li_Total_Adicional));
		Asignar_Valor('fc_Costo_Total',Formatear_Numero(li_Total_Adicional + li_Costo_Basico));

    // ASIGNAR TOTALES AL BOOKING
    //$('.totalAdicionales').find('span').eq(0).html ( Formatear_Numero(li_Total_Adicional) );
    $('.parte-entera').html( Formatear_Numero(li_Total_Adicional + li_Costo_Basico) );

    $('.totalAdicionales').each(function(index) {
        $(this).find('span').eq(0).html ( Formatear_Numero(li_Total_Adicional) );        
    });
        
    // if ( li_Adultos > 0 && (li_Total_Adicional + li_Costo_Basico) == 0 && document.getElementById('fc_Total_Dias').value != '0') { parent.top.Mostrar_Mensaje('Para los das seleccionados, no se posee un valor predeterminado. Si desea mayor informacin, favor comunicarse con un asesor.'); Asignar_Valor('fc_Total_Dias',0); }      				
}

function Ver_Objeto_Cotizador() {
    $('#objeto_validador').remove();

    var la_Objeto = new Array();
    for ( atributo in go_Objeto_Cotizador ) {
        try { la_Objeto[la_Objeto.length] = "<div>" + atributo + " = " + go_Objeto_Cotizador[atributo] + '</div>'; }
        catch (exception) {}
    }
    
    $('body').append("<div id='objeto_validador' style='background:#fff;border:1px solid #000;position:absolute;top:" + lo_Mouse.Y + "px;left:0px;width:300px;'>" + la_Objeto.join("") + "</div><img id='cerrar_objeto_validador' style='float:right;' src='" + gc_Ruta_Aplicativo + "/aplicaciones/cotizador/Iconos/close_circle.png' >");
    $('#cerrar_objeto_validador').click(function(event) { event.preventDefault(); $('#cerrar_objeto_validador').remove(); return false; });
}

/*   CREAR UN STRING A PARTIR DE UN OBJETO FECHA */
function String_Fecha( ld_Fecha ) {
    lc_Mes = ( parseInt( ld_Fecha.getMonth() + 1 ) < 10 ) ? '0' + parseInt( ld_Fecha.getMonth() + 1 ) : parseInt( ld_Fecha.getMonth() + 1 );
    lc_Dia = ( parseInt( ld_Fecha.getDate() ) < 10 ) ? '0' + parseInt( ld_Fecha.getDate() ) : parseInt( ld_Fecha.getDate() );
    return ld_Fecha.getFullYear() + '-' + lc_Mes + '-' + lc_Dia;  
}

function Cargar_Costos_Adicionales(lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion','Tomar_Costos_Adicionales' );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo',lc_Id_Plan );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'tipo_cotizador', $('#fc_Tipo_Cotizador')[0].value );
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Cargar_Costos_Tipo_Calendario() {
    // LOS COSTOS DE LOS PLANES DEBEN SER CARGADOS SLO CUANDO LAS VARIABLES HAYAN SIDO DEFINIDAS O SELECCIONADAS
    
    if ( $('#fc_Id_Plan')[0].value != '' && $('#fc_Temporada')[0].value != '' && $('#fc_Transporte')[0].value != '' && $('#fc_Tipo_Habitacion')[0].value != '' ) {    
        //alert("caller is " + arguments.callee.caller.toString()); 

        //alert( $('#fc_Tipo_Cotizador')[0].value );
        
        var la_Arreglo = new Array();
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion'                 , 'Tomar_Costos_Plan_Calendario');
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo_plan_calendario' , $('#fc_Id_Plan')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Tipo_Habitacion')[0].value );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'tipo_cotizador'         , $('#fc_Tipo_Cotizador')[0].value );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'tipo_habitacion'        , $('#fc_Tipo_Habitacion')[0].value );

        Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
    } else {
        //alert('faltan ' + $('#fc_Id_Plan')[0].value + ' |' + $('#fc_Temporada')[0].value + ' |'+ $('#fc_Transporte')[0].value + ' |' + $('#fc_Tipo_Habitacion')[0].value );
    }
}

function Configurar_Adulto(li_Valor) {
    var li_Adultos              = parseInt(document.getElementById('fc_Adultos').value);
    var li_Menor                = 0; //parseInt(document.getElementById('fc_Menores').value);

    var li_Capacidad_Habitacion = Tomar_Numero( Tomar_Numero_Capacidad( $('#fc_Capacidad_Habitacion')[0].value) );

    // VALIDAR CAPACIDAD DE LA HABITACIN
    if ( li_Capacidad_Habitacion > 0 ) {
        if ( ( li_Adultos + li_Menor + li_Valor ) <= li_Capacidad_Habitacion ) {
            
            var li_Adultos = li_Adultos + li_Valor;
             
            Asignar_Valor('fc_Adultos',li_Adultos);
            // BUSCAR UNA HABITACIN QUE POSEA DISPONIBILIDAD
            // Cargar_Lista_Desplegable('fc_Tipo_Habitacion','tipo_habitacion_portafolio_capacidad',$('#fc_Id_Plan')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Adultos')[0].value );

            //if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Habitaciones_Disponibles(); }
            //Cargar_Habitaciones_Disponibles();

            Cotizar();
        } else {
            var lc_Mensaje = la_Mensaje_Cotizador['Capacidad_Superada_Adulto'];
            
            try { parent.Mostrar_Mensaje( lc_Mensaje ); }
            catch(exception) { alert( lc_Mensaje ); }
            
        } 
    } else {
        if ((li_Adultos + li_Valor) > 0) {
            
            var li_Adultos = li_Adultos + li_Valor;
             
            Asignar_Valor('fc_Adultos',li_Adultos); 

            //if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Habitaciones_Disponibles(); }
            //Cargar_Habitaciones_Disponibles();
            
            Cotizar(); 
        }
    }
    
    // OCULTAR LOS ELEMENTOS CUYA CAPACIDAD NO COINCIDA CON LOS ADULTOS SELECCIONADOS
    if ( li_Adultos > 0 ) {
        // OCULTAR TODAS LAS HABITACIONES
        $('#zona_habitaciones_disponibles ul li').hide();
        // ACTIVAR LAS QUE COINCIDAN CON LA CAPACIDAD DE ADULTOS
        $('.adultos_' + li_Adultos).show();
    }
    
    /*
    // CARGAR LOS REGISTROS PARA INGRESAR LOS VIAJEROS
    if ( $('#fc_Tipo_Reserva').attr('value') == 2 ) {
        var lo_Tabla_Adultos = document.getElementById('tabla_adultos');
        // CLONAR LA FILA 1
        var lo_Fila = document.getElementById('tabla_adultos').rows[1].cloneNode(true);
        // VACIAR LA TABLA
        for (var li_Registro=(lo_Tabla_Adultos.length - 1); li_Registro > 2; li_Registro--) {
            lo_Tabla_Adultos.deleteRow(li_Registro);
        }

        // ADICIONAR LOS REGISTROS ADICIONALES
        for (var li_Registro=0; li_Registro < li_Adultos; li_Registro++) {
            lo_Tabla_Adultos.appendChild(lo_Fila);
        }
        
        // CAMBIAR LAS PROPIEDADES DE LOS ELEMENTOS
        $('#tabla_adultos .captura_nacimiento').each(function(index) {
            $(this).attr('id','fc_Nacimiento_Adulto_' + index );
        });
        
        $('#tabla_adultos .captura_tipo_documento').each(function(index) {
            $(this).attr('id','fc_Tipo_Doc_Adulto_' + index );
        });        
    }*/
}

function Cargar_Habitaciones_Disponibles() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion'                 , 'Cargar_Habitacion_Temporada');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'plan'                   , $('#fc_Id_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'temporada'              , $('#fc_Temporada')[0].value );
    //la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'adultos'                , $('#fc_Adultos')[0].value );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

/*
function Tomar_Posicion_X( lo_Objeto ) {
    var la_Top = new Array();
    do {
        if ( lo_Objeto.offsetTop ) { la_Top[la_Top.length] = lo_Objeto.offsetTop; }
        lo_Objeto = lo_Objeto.parentNode;
    } while (lo_Objeto.tagName != 'BODY' );
    alert( la_Top );
}
*/

function Activar_Habitaciones_Cotizador( lc_Id_Habitacion ) {
    $('#contenedor_cotizador_' + lc_Id_Habitacion).hide();
    // ACTIVAR LAS HABITACIONES
    $('.contenedor_habitacion_disponible').show();
    //$('.contenedor_servicios_habitacion').css('display','none');
    $('.contenedor_servicios_habitacion').hide();
    // ELIMINAR HABITACIONES ACTIVAS
    $('.contenedor_habitacion_disponible').removeClass("habitacion_disponible_activa");
    //gc_Habitacion_Seleccionada = null;
    return false;
} 

function Configurar_Menor(li_Valor) {
    var li_Menor                = parseInt(document.getElementById('fc_Menores').value);
    var li_Capacidad_Habitacion = Tomar_Numero( $('#fc_Capacidad_Habitacion')[0].value );

    // VALIDAR CAPACIDAD DE LA HABITACIN
    if ( li_Capacidad_Habitacion > 0 ) {
        if ( (li_Menor + li_Valor) > 2 ) {
            var lc_Mensaje = la_Mensaje_Cotizador['Capacidad_Superada_Menor'];
            
            try { parent.Mostrar_Mensaje( lc_Mensaje ); }
            catch(exception) { alert( lc_Mensaje ); }
                    
        } else {
            if ((li_Menor + li_Valor) >= 0) { Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar(); }        
            //Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar();
        }
    } else {
        if ((li_Menor + li_Valor) >= 0) { Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar(); }
    }
    
    /*
    // CARGAR LOS REGISTROS PARA INGRESAR LOS VIAJEROS
    if ( $('#fc_Tipo_Reserva').attr('value') == 2 ) {
        var lo_Tabla_Menores = document.getElementById('tabla_menores');
        // CLONAR LA FILA 1
        var lo_Fila = document.getElementById('tabla_menores').rows[1].cloneNode(true);
        // VACIAR LA TABLA
        for (var li_Registro=(lo_Tabla_Menores.length - 1); li_Registro > 2; li_Registro--) {
            lo_Tabla_Menores.deleteRow(li_Registro);
        }

        // ADICIONAR LOS REGISTROS ADICIONALES
        for (var li_Registro=0; li_Registro < li_Menor; li_Registro++) {
            lo_Tabla_Menores.appendChild(lo_Fila);
        }
        
        // CAMBIAR LAS PROPIEDADES DE LOS ELEMENTOS
        $('#tabla_menores .captura_nacimiento').each(function(index) {
            $(this).attr('id','fc_Nacimiento_Menor_' + index );
        });
        
        $('#tabla_menores .captura_tipo_documento').each(function(index) {
            $(this).attr('id','fc_Tipo_Doc_Menor_' + index );
        });        
    } */   
} 
       
function Tomar_Capacidad_Habitacion() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','capacidad_habitacion' );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Tipo_Habitacion')[0].value );              

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function In_Array(la_Arreglo,lc_Valor) {
    var lb_Resultado = false;
    for (var li_Contador=0; li_Contador < la_Arreglo.length; li_Contador++) {
        if (la_Arreglo[li_Contador] == lc_Valor) { lb_Resultado = li_Contador; break; }
    }
    return lb_Resultado;
}

function Cargar_Datos_Plan_Portafolio() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_plan_portafolio' );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Id_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Datos_Carga_Portafolio()' );              

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Datos_Carga_Portafolio() {

    //alert( $('#fc_Tipo_Cotizador')[0].value );
    // SI EL TIPO DE COTIZADOR ES HOTEL
    if ( parseInt( $('#fc_Tipo_Cotizador')[0].value ) == 2 ) { 
        Ocultar_Objeto('habitacion_plan',false);
    } else {
        Ocultar_Objeto('habitacion_plan');
        // PRESENTAR EL SELECTOR DE FECHA
        Ocultar_Objeto('zona_calendario',false);
    }

    //alert( parseInt( $('#fc_Maximo_Dias')[0].value ) );

    // SI EL MXIMO DE DAS DE CERO, ENTONCES OCULTAR EL SEGUNDO RANGO
    if ( parseInt( $('#fc_Maximo_Dias')[0].value ) == 0 ) {
        Ocultar_Objeto('zona_calendario_limite')
    } else {
        Ocultar_Objeto('zona_calendario_limite',false);              
    }
}

// FUNCIN QUE SE EJECUTA UNA VEZ SE HAN TOMADO LOS DATOS DEL SERVIDOR
function Carga_Ciudad_Salida() {
    // SI NO SE OBTIENEN DATOS DE CIUDAD DE SALIDA, ENTONCES OCULTAR    
    if ( $('#fc_Ciudad_Salida')[0].length == 1 ) { Ocultar_Objeto('ciudad_salida'); } else { Ocultar_Objeto('ciudad_salida',false); }
}

function Tomar_Datos_Disponibilidad() {
    // INICIALIZAR EL ARREGLO DE DISPONIBILIDAD
    ga_Rango_Fechas_Cotizaciones  = new Array();
    
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('accion','Construir_Calendario');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('contenedor','contenedor_disponibilidad_plan_portafolio_hotel');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('plan_portafolio', $('#fc_Id_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('tipo_habitacion', $('#fc_Tipo_Habitacion')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('rango_fecha', $('#fc_Fecha_Inicio')[0].value.substr(0,7) );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('ejecutar','');
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Insertar_Texto_Calendario() {
    var li_Total_Cotizacion = ga_Rango_Fechas_Cotizaciones.length;

    var la_Fecha            = $('#fc_Fecha_Inicio')[0].value.split('-'); 
    var li_Year             = la_Fecha[0];
    // DISMINUIR UN DA AL MES 0-11
    var li_Mes              = Tomar_Numero(la_Fecha[1]) - 1;
    var li_Dia_Calendario   = Tomar_Numero(la_Fecha[2]);
    
    if ( li_Total_Cotizacion > 0 ) {
        for (li_Dia=li_Dia_Calendario; li_Dia < 31; li_Dia++) {
            // TOMAR LA FECHA, SI CORRESPONDE AL MISMO MES, PINTAR
            var lo_Nueva_Fecha    = new Date( li_Year,li_Mes,li_Dia );
            var lo_Existe_Reserva = Buscar_Fecha_Rango( lo_Nueva_Fecha );
            
            // ADICIONAR EL TEXTO DE RESERVAS
            //$('#zona_prueba').append( li_Dia + ' - ' + lo_Existe_Reserva.reservas );
            
            if ( lo_Existe_Reserva.registros > 0 ) {
                if ( ga_Costo_Usuario_Estancia.length > 0 ) {
                    if ( ga_Costo_Usuario_Estancia[0].Disponibilidad <= lo_Existe_Reserva.registros ) {
                        var lc_Fecha_Verificacion = li_Year + '-' + la_Fecha[1] + '-' + li_Dia;

                        if ( In_Array( ga_Fecha_Inhabil, lc_Fecha_Verificacion ) == false ) { ga_Fecha_Inhabil[ga_Fecha_Inhabil.length] = lc_Fecha_Verificacion; }
                        scwDisabledDates[scwDisabledDates.length] = lo_Nueva_Fecha;
                    }
                }
            }            
        }
    }
}

function Buscar_Fecha_Rango( lo_Fecha ) {
    // BUSCAR LA FECHA EN EL ARREGLO DE FECHA COTIZADAS
    var li_Total_Registros    = ga_Rango_Fechas_Cotizaciones.length;
    var li_Total_Cotizaciones = 0;
    var la_Cotizacion         = new Array();
    var lo_Objeto_Salida      = new Object();
    
    for (var li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
        // CONVERTIR LAS FECHAS
        lo_Fecha_Inicio = Crear_Objeto_Fecha( ga_Rango_Fechas_Cotizaciones[ li_Registro ].fecha_inicio );
        lo_Fecha_Final  = Crear_Objeto_Fecha( ga_Rango_Fechas_Cotizaciones[ li_Registro ].fecha_final );
        
        // ADICIONAR EL TEXTO DE RESERVAS
        //$('#zona_prueba').append( "<div>" + lo_Fecha + ' ' + lo_Fecha_Inicio.Fecha + ' ' + lo_Fecha_Final.Fecha + "</div>" );        

        if ( lo_Fecha >= lo_Fecha_Inicio.Fecha && lo_Fecha <= lo_Fecha_Final.Fecha ) {
            li_Total_Cotizaciones = li_Total_Cotizaciones + 1;
            // ADICIONAR EL NMERO DE LA COTIZACIN
            la_Cotizacion[ la_Cotizacion.length ] = "<div class='cotizacion'>" + ga_Rango_Fechas_Cotizaciones[ li_Registro ].cotizacion + "</div>"; 
        }
    }
    lo_Objeto_Salida.registros  = li_Total_Cotizaciones;
    lo_Objeto_Salida.reservas   = la_Cotizacion.join('');
    
    return lo_Objeto_Salida; 
}

/*
function Traer_Datos_Habitacion() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_habitacion' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Tipo_Habitacion')[0].value );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}
*/

function Traer_Datos_Habitacion() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_habitacion' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Tipo_Habitacion')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Validar_Menores()' );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}


function Tomar_Numero_Capacidad() {
    var la_Capacidad        = $('#fc_Capacidad_Habitacion').attr('value').split(',');
    var li_Total_Elementos  = la_Capacidad.length;
       
    return la_Capacidad[ (li_Total_Elementos - 1) ];
}

function Validar_Menores() {
    $('#zona_mensaje_usuario').hide();

    if ( $('#fc_Menores_Habitacion').attr('value') != '' ) {
        $('#zona_mensaje_usuario').show();
        if ( Tomar_Numero( $('#fc_Menores_Habitacion').attr('value') ) == 0 ) {
            // CONFIGURAR LOS MENORES EN 0
            $('#fc_Menores').attr('value',0);

            $('#seccion_menores').hide();

            if ( Tomar_Numero( $('#fc_Capacidad_Habitacion').attr('value') ) > 0 ) {
                $('#zona_mensaje_usuario').html('Capacidad adultos : ' + Tomar_Numero_Capacidad() + '<br>No aplica para menores.');
            } else {
                $('#zona_mensaje_usuario').html('No aplica para menores.');
            }
        } else {
            if ( Tomar_Numero( $('#fc_Capacidad_Habitacion').attr('value') ) > 0 ) {
                $('#zona_mensaje_usuario').html('Capacidad adultos : ' + Tomar_Numero_Capacidad() + '<br>Capacidad nios&nbsp;&nbsp;&nbsp; : ' + $('#fc_Menores_Habitacion').attr('value') );
            } else {
                $('#zona_mensaje_usuario').html('Capacidad nios&nbsp; : ' + $('#fc_Menores_Habitacion').attr('value') );
            }            
        }
    }
}

function Activar_Eventos_Campos_Chequeo() {
    $('#recibir_email').click(function() {
        if ( this.checked == false ) {
            if ( $('#contenedor_mensaje')[0].style.display == 'none' ) { Asignar_Valor('mensaje_checkeo', la_Mensaje_Cotizador['Autorizar_Envio_Mail']); $('#contenedor_mensaje').slideToggle('slow'); }                  
        } else {
            Ocultar_Objeto('contenedor_mensaje');
        }
    });
    $('#registrar_datos').click(function() {
        if ( this.checked == false ) {
            if ( $('#contenedor_mensaje')[0].style.display == 'none' ) { 
                Asignar_Valor('fc_No_Registrar_Datos','');    
                Asignar_Valor('mensaje_checkeo', la_Mensaje_Cotizador['No_Permitir_Registro']); 
                $('#contenedor_mensaje').slideToggle('slow'); 
            }
        } else {
            Asignar_Valor('fc_No_Registrar_Datos','true');
            Ocultar_Objeto('contenedor_mensaje');
        }
    });          
}

function showLoading() {
    $('#loading').empty().append( 'Cargando informacin ... ' );
    $('#loading')[0].style.backgroundImage  = "url('http://www.siev.com.co/siev/aplicaciones/importar/images/loading.gif')";
    $("#loading").show();
}

function hideLoading() {
    $("#loading").hide();
}

function Cerrar_Loading() {
    hideLoading();
}

function Cargar_Lista_Desplegable(lc_Objeto_Destino,lc_Detalle_Lista,lc_Parametro,lc_Funcion){
    /*********** PRESENTAR EL LOADING *************/
    showLoading();
    /*********** PRESENTAR EL LOADING *************/            

    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('id',  lc_Detalle_Lista);
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('objeto',  lc_Objeto_Destino);              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('codigo',  ( String(lc_Parametro) != 'undefined' ) ? lc_Parametro : '' );
    if ( String(lc_Funcion) != 'undefined' ) { la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('ejecutar' , lc_Funcion ); }
        
    Enviar_Objeto_Servidor( gc_Root + 'php/Cargar_Select.php',la_Arreglo ); 			 
}

function Tomar_Numero (lc_Numero) {
  if ( String(lc_Numero) != 'undefined' ) {
    	var lc_Numero = lc_Numero.replace(/[^0-9]/gi,'').replace(/^0/,'');
    	if (isNaN(parseInt(lc_Numero))) { return 0; } else { return parseInt(lc_Numero); }
  } else {
      return 0;
  }
}

function Ver_Descripcion_Servicio( lc_Id_Servicio ) {
    Tomar_Datos_Servicio_General( lc_Id_Servicio );
}

function Tomar_Datos_Servicio_General( lc_Id_Servicio ) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_servicio_general' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', lc_Id_Servicio );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Ver_Seccion_Servicio_General()' );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Ver_Seccion_Servicio_General() {
    li_Distancia = 10;
    
    $('#modulo_detalle_disponibilidad').show();
    $('#modulo_detalle_disponibilidad').css('top'   , ( lo_Mouse.Y + li_Distancia ) + 'px' );
    $('#modulo_detalle_disponibilidad').css('left'  , ( lo_Mouse.X + li_Distancia ) + 'px' );
}

function Cargar_Servicios_Habitacion() {

    if ( $('#fc_Tipo_Habitacion').attr('value') != '' && $('#fc_Transporte').attr('value') != '' ) {
        var la_Arreglo = new Array();
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('accion'          , 'Cargar_Servicio_Habitacion');
        // la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('contenedor'      , 'contenedor_servicios_habitacion_' + $('#fc_Tipo_Habitacion').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('contenedor'      , 'contenedor_servicios_habitacion_' + $('#fc_Tipo_Habitacion_Adulto').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('tipo_habitacion' , $('#fc_Tipo_Habitacion').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('tipo_transporte' , $('#fc_Transporte').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('plan'            , $('#fc_Id_Plan').attr('value') );

        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('ejecutar','');

        //alert( $('#fc_Tipo_Habitacion').attr('value') + ' ' + $('#fc_Transporte').attr('value') );
        
        Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);    
    }
}

function Validar_Contenido_Servicios_Incluidos( lc_Id_Contenedor ) {
    // SI NO SE OBTUVIERON DATOS DE SERVICIOS INCLUIDOS
    if ( $('#' + lc_Id_Contenedor).html() == '' ) {
        $('#' + lc_Id_Contenedor).html(  $('#editor_portafolio').html() ); 
    }
}

// FUNCIN QUE ES LLAMADA UNA VEZ SE CARGA EL FORMULARIO
function Cargar_Temporadas_Plan() {

    Datos_Carga_Portafolio();
    
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion'   , 'Cargar_Temporadas_Plan');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'plan'     , $('#fc_Id_Plan')[0].value );

    gc_Ruta_Aplicativo = 'http://www.otroviaje.com/siev/aplicaciones/cotizador/';
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Seleccion_Temporada_Plan( li_Registros ) {

    switch ( li_Registros ) {

        case 1  : // OCULTAR LA ZONA DE TEMPORADAS
                  $('#promotionslist .cabeceraContenedor').hide();
                  $('#zona_contenido_temporadas').hide();
        
                  // ESTABLECER EL MENSAJE DE INICIO
                  Accion_Paso_Cotizador( 1 );
                  // PRESENTAR EL MENSAJE DE LA LISTA DE HABITACIONES
                  $('.zona_mensaje_habitacion').show();

                  // CAPTURAR EL ID DE LA TEMPORADA
                  var lc_Id_Temporada = $('.item_right').eq(0).attr('id'); 
                  $('#fc_Temporada').attr('value', lc_Id_Temporada );

                  Cargar_Habitaciones_Disponibles();

                  // CARGAR LOS TIPOS DE TRANSPORTE PARA LOS DIFERENTES TIPOS DE HABITACIN
                  Cargar_Lista_Desplegable('fc_Transporte','lista_transporte_calendario', lc_Id_Temporada ,'Carga_Transporte()');
          
                  // CARGAR LAS FECHA INHBILES Y LAS DE INICIO Y LMITE
                  Cargar_Fechas_Temporada();
        
                  break; 
        default : // ESTABLECER EL MENSAJE DE INICIO
                  Accion_Paso_Cotizador( 0 );
                  $('.item_right').click(function(event) {
                      event.preventDefault() ;

                      // ESTABLECER EL MENSAJE DE PASO 2
                      Accion_Paso_Cotizador( 1 );
                      
                      // PRESENTAR EL MENSAJE DE LA LISTA DE HABITACIONES
                      $('.zona_mensaje_habitacion').show();
                      
                      $('#fc_Temporada').attr('value', $(this).attr('id') );
                      
                      Cargar_Habitaciones_Disponibles();
                      
                      // CARGAR LOS TIPOS DE TRANSPORTE PARA LOS DIFERENTES TIPOS DE HABITACIN
                      Cargar_Lista_Desplegable('fc_Transporte','lista_transporte_calendario', $(this).attr('id') ,'Carga_Transporte()');

                      // INICIALIZAR LOS TOTAL
                      Inicializar_Totales();

                      // INICIALIZAR LAS FECHAS DEL CALENDARIO
                      $('#fc_Fecha_Inicio').attr('value', $('#fc_Fecha_Actual').attr('value') );  
                      $('#fc_Fecha_Limite').attr('value', $('#fc_Fecha_Actual').attr('value') );
                      
                      // CARGAR LAS FECHA INHBILES Y LAS DE INICIO Y LMITE
                      Cargar_Fechas_Temporada();
                      
                      return false;
                  });
                  break;
    }
    // CARGAR LAS FECHAS DE LA TEMPORADA
    
}

function Cargar_Servicios_Adicionales( lc_Contenedor ) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion'                 , 'Cargar_Servicios_Adicionales');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'plan'                   , $('#fc_Id_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'contenedor'             , lc_Contenedor );
    
    gc_Ruta_Aplicativo = 'http://www.otroviaje.com/siev/aplicaciones/cotizador/';
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Carga_Transporte() {

    //Iniciar_Fechas_Cotizador();
    // OCULTAR LA DESCRIPCIN DE LA HABITACIN
    //$('#modulo_detalle_disponibilidad').hide();
    
    //if ( $('#zona_usuarios')[0].style.display == 'none' ) { $('#zona_usuarios').slideToggle('slow'); }
    //Ocultar_Objeto('transporte_temporada',false);

    if ( $('#fc_Transporte')[0].length > 1 ) { 
        // SI SE OBTIENE EL CASO DE NO APLICA, OCULTAR    
        if ( $('#fc_Transporte')[0].length == 2 ) {
            // CARGAR LOS DATOS DEL SEGUNDO ITEM
            Asignar_Valor( 'fc_Transporte',$('#fc_Transporte')[0].options[1].value );
            // OCULTAR LA ZONA DE TRANSPORTE
            $('#transporte_temporada').hide();
            
            //**************************************************************
            // CARGAR LOS INCLUIDOS Y NO INCLUDOS
            //if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Servicios_Habitacion(); }
            //**************************************************************
            //Cargar_Servicios_Habitacion();
            
        } else {
            // VISUALIZAR EL TIPO DE TRANSPORTE
            $('#transporte_temporada').show();
        }
        Tomar_Proceso_Transporte();       
    } else {
        $('#transporte_temporada').hide();
    }
}

function Tomar_Proceso_Transporte() {

    //Asignar_Valor('posicion_referencia|zona_mensaje_usuario','');

    // CARGAR LOS COSTOS POR PLAN, CALENDARIO Y MEDIO DE TRANSPORTE                  
    Cargar_Datos_Plan_Calendario_Transporte();

    // TOMAR LOS DATOS DE LOS PRECIOS SEGN CALENDARIO
    Cargar_Costos_Tipo_Calendario();

    // PRESENTAR LOS DATOS DE LOS SERVICIOS ADICIONAL
    //if ( $('#modulo_servicios_adicionales')[0].style.display == 'none' ) { $('#modulo_servicios_adicionales').slideToggle('slow'); }
}


function Cargar_Fechas_Temporada() {
    // INICIALIZAR EL ARREGLO DE FECHAS INHBILES
    ga_Fecha_Inhabil = new Array();

    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario' , 'cotizador_fecha_inhabil');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo'     , document.getElementById('fc_Temporada').value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar'   , 'Convertir_Fecha_Inhabil()' );
                  
    Enviar_Objeto_Servidor( gc_Root + 'php/Traer_Detalle.php',la_Arreglo);              
}
    
function Convertir_Fecha_Inhabil() {
    ga_Fecha_Inhabil = document.getElementById('fc_Fecha_Inhabil').value.split(',');
    
    Iniciar_Fechas_Cotizador();
}

function Seleccion_Habitacion_Disponible() {
    $('label.ver_mas').click(function(event){
        event.preventDefault();
        
        var lc_Id_Habitacion  = $(this).attr('id');
        // ASIGNAR EL TIPO DE MONEDA
        $('.total span.moneda').html( '&nbsp;' + gc_Tipo_Moneda );
        
        // ASIGNAR AL NMERO DE ADULTOS, AQUELLOS QUE HAYAN SIDO CONFIGURADOS EN LA DISPONIBILIDAD DE HABITACIONES
        var li_Adultos_Habitacion_Seleccionada = parseInt( lc_Id_Habitacion.replace(/[0-9]{1,}\_/,'') );
        
        $('#fc_Adultos').attr('value',li_Adultos_Habitacion_Seleccionada);  
         
        // DESPLEGAR LOS DATOS DE LA HABITACIN SELECCIONADA
        if ( $(this).parent().parent().find('.contenedor_habitacion_disponible').css('display') == 'none' ) {

            // PRESENTAR LA ZONA DE USUARIO
            $('#zona_usuario').show();
        
            // ASIGNAR A LA VARIABLE, EL TIPO DE HABITACIN SELECCIONADA, ELIMINANDO EL SEGUNDO VALOR, QUE CORRESPONDE A 
            // EL NMERO DE ADULTOS. SOLUCIN DADA PARA AQUELLAS HABITACIONES DE MLTIPLES ADULTOS. Ej. 2,3,4
            $('#fc_Tipo_Habitacion').attr('value', lc_Id_Habitacion.replace(/\_[0-9]{1,}/,'') );

            $('#fc_Tipo_Habitacion_Adulto').attr('value', lc_Id_Habitacion );            
            
            $(this).find('span').empty().html('Ocultar');
            //$(this).parent().find('label span').empty().html('Ocultar');
            
            // ASIGNAR EL NMERO DE ADULTOS
            $('#fc_Adultos').attr('value', $(this).find('input').attr('value') );
            // CARGAR LA INFORMACIN DE LOS CALENDARIOS
            Iniciar_Fechas_Cotizador();
            
            // OCULTAR TODAS LAS HABITACIONES
            $('.lista_titulo_habitacion ul li').hide();
            // PRESENTAR EL TIPO DE HABITACIN ACTUAL
            $('#tipo_habitacion_' + lc_Id_Habitacion ).show();
            // ASIGNAR EVENTO PARA CARGAR LOS SERVICIOS INCLUIDOS
            if ( String( $('#servicios_habitacion_' + lc_Id_Habitacion ).data('events') ) == 'undefined' ) {
                $('#servicios_habitacion_' + lc_Id_Habitacion ).click(function(event) { 
                    // SI NO SE HAN CARGADO LOS SERVICIOS INCLUIDOS
                    if ( $('#contenedor_servicios_habitacion_' + lc_Id_Habitacion ).html() == '' ) {
                        Cargar_Servicios_Habitacion(); 
                    } else {
                        $('#contenedor_servicios_habitacion_' + lc_Id_Habitacion ).empty();
                    }
                });            
            }

            // ASIGNAR EVENTO PARA CARGAR LOS SERVICIOS ADICIONALES
            if ( String( $('#servicios_adicionales_' + lc_Id_Habitacion ).data('events') ) == 'undefined' ) {
                $('#servicios_adicionales_' + lc_Id_Habitacion ).click(function(event) { 
                    // SI NO SE HAN CARGADO LOS SERVICIOS ADICIONALES
                    if ( $('#contenedor_servicios_adicionales_' + lc_Id_Habitacion ).html() == '' ) {
                        // LIMPIAR LOS CONTENEDORES
                        $('.contenedor_servicios_adicionales').empty();
                        // CARGAR LOS SERVICIOS ADICIONALES
                        Cargar_Servicios_Adicionales( 'contenedor_servicios_adicionales_' + lc_Id_Habitacion );
                    } else {
                        // ACTIVAR ACORDEON
                        $('#contenedor_servicios_adicionales_' + lc_Id_Habitacion ).slideToggle('slow');
                    }
                });            
            }
            
            // DESPLEGAR AUTOMATICAMENTE LOS SERVICIOS
            $('#servicios_habitacion_' + lc_Id_Habitacion ).trigger('click'); 
            $('#servicios_adicionales_' + lc_Id_Habitacion ).trigger('click');
            
            // MOVER EL OBJETO DE TRANSPORTE
            document.getElementById('zona_transporte_' + lc_Id_Habitacion ).appendChild( document.getElementById('transporte_temporada') );
            //$('#transporte_temporada').show();

            /*****************************************************
            // CARGAR LOS COSTOS A PARTIR DEL TIPO DE HABITACIN
            *****************************************************/
            Cargar_Costos_Tipo_Calendario();
            
            // ESTABLECER EL MENSAJE DEL PASO 3
            Accion_Paso_Cotizador( 3 );
            
        } else {
            // OCULTAR LA ZONA DE USUARIO
            $('#zona_usuario').hide();

            // DEVOLVER EL OBJETO TRANSPORTE
            document.getElementById('contenedor_totales' ).appendChild( document.getElementById('transporte_temporada') );
            //$('#transporte_temporada').hide();
            
            $(this).find('span').empty().html('Ver tarifas y servicios');
            //$(this).parent().find('label span').empty().html('Ver Detalle');
            
            // NO HAY HABITACIN SELECCIONADA
            $('#fc_Tipo_Habitacion').attr('value', '' );
            // INICIALIZR EL NMERO DE ADULTOS
            //$('#fc_Adultos').attr('value', 0);
            // PRESENTAR TODAS LAS HABITACIONES
            //$('.lista_titulo_habitacion ul li').show();
            
            // ACTIVAR LAS QUE COINCIDAN CON LA CAPACIDAD DE ADULTOS
            $('.adultos_' + $('#fc_Adultos').attr('value') ).show();

            // PONER EN 0 LOS TOTALES
            $('.parte-entera').html( '0' );
        }
        
        $(this).parent().parent().find('.contenedor_habitacion_disponible').slideToggle('slow');

        // ACTIVAR EL EVENTO DE CARGA DE LOS SERVICIOS
                
        return false;
    });
}

// DEFINIR LOS EVENTOS EN LOS OBJETOS DEL COTIZADOR
$(document).ready(function() {
    
    // LISTAR LOS TIPOS DE CALENDARIO/TEMPORADAS A PARTIR DEL PLAN SELECCIONADO
    Cargar_Temporadas_Plan();
    
    // PRESENTAR LA ZONA DE LOS VIAJEROS
    //if ( $('#fc_Tipo_Reserva').attr('value') == 2 ) { $('#zona_viajeros').show(); }    

    /*
        $('#boton_recibir_email').click( function () {
            if ( this.checked == true ) { if ( $('#informacion_solicitante')[0].style.display == 'none' ) { $('#informacion_solicitante').slideToggle('slow'); } } else { $('#informacion_solicitante').slideToggle('slow'); }
        });
    */

    // LIMPIAR LOS CAMPOS DEL FORMULARIO
    //Inicializar_Formato();
    // ACTIVAR LOS CAMPOS DE CHEQUEO DE EMAIL Y REGISTRO DE INFORMACIN
    //Activar_Eventos_Campos_Chequeo();

    // SI NO EXISTEN PLANES, ENTONCES INHABILITAR LA OPCIN DE COTIZAR
    //var lo_Plan = document.getElementById('fc_Id_Plan');
    //if (lo_Plan.length < 1) { Ocultar_Objeto( $('.btn_cotizar')[0] ); } 

    // TRAER LOS DATOS DEL CLIENTE                             
    if ( $('#fc_Custom_Comprador')[0].value != '' ) {
        //var la_Arreglo = new Array();
        //la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'datos_cliente_conectado' );              
        //la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Custom_Comprador')[0].value );
        //Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);                                
    }

    // CARGAR LOS DATOS CUANDO VENGA DIRECTAMENTE DE UN PORTAFOLIO
    if ( $('#fc_Id_Plan')[0].value != '' ) { 
        //Cargar_Datos_Plan_Portafolio(); 
        //Cargar_Costos_Adicionales($('#fc_Id_Plan')[0].value);
        //Cargar_Lista_Desplegable('fc_Temporada','tipo_calendario_portafolio',$('#fc_Id_Plan')[0].value);
    }

    $('body').mousemove(function(e){
        //var pageCoords = "( " + e.pageX + ", " + e.pageY + " )";
        //$("#mouse:first").text("( e.pageX, e.pageY ) : " + pageCoords);
        //lo_Mouse.X = ( String(self.location.href).indexOf('Cotizar_Iframe') != -1 ) ? parseInt(e.pageX) : parseInt(e.pageX) - 280;
        //lo_Mouse.Y = ( String(self.location.href).indexOf('Cotizar_Iframe') != -1 ) ? parseInt(e.pageY) : parseInt(e.pageY) - 270;

        lo_Mouse.X = ( String(self.location.href).indexOf('booking') != -1 ) ? parseInt(e.pageX) : parseInt(e.pageX) - 280;
        lo_Mouse.Y = ( String(self.location.href).indexOf('booking') != -1 ) ? parseInt(e.pageY) : parseInt(e.pageY) - 270;
    });    

});   

function Iniciar_Fechas_Cotizador() {

    if ( $('#fc_Fecha_Inicio_Calendario')[0].value != '' || $('#fc_Fecha_Inicio_Calendario')[0].value != '0000-00-00' ) {
        // SI LA FECHA ES MAYOR A LA FECHA ACTUAL, ENTONCES ACTUALIZAR 
        if ( Crear_Objeto_Fecha( $('#fc_Fecha_Inicio_Calendario')[0].value ).Fecha >  Crear_Objeto_Fecha( $('#fc_Fecha_Inicio')[0].value ).Fecha ) {
            $('#fc_Fecha_Inicio')[0].value = $('#fc_Fecha_Inicio_Calendario')[0].value;
            //alert(6 +  ' ' + $('#fc_Fecha_Inicio_Calendario')[0].value + ' ' + $('#fc_Fecha_Actual')[0].value );
            $('#fc_Fecha_Limite')[0].value = $('#fc_Fecha_Inicio_Calendario')[0].value;
            // POR FAVOR VERIFICAR QUE LA FECHA DE INICIO SEA POSTERIOR A LA FECHA DE INICIO DEL CALENDARIO
            //parent.Mostrar_Mensaje('Favor verificar que la fecha de viaje sea posterior a la fecha en que inicia la temporada seleccionada.');
        } else {
            //alert(' limpiar 2');
            //$('#fc_Fecha_Inicio')[0].value = $('#fc_Fecha_Actual')[0].value;
            //$('#fc_Fecha_Limite')[0].value = $('#fc_Fecha_Actual')[0].value;
        }

        // SI EL NMERO MNIMO DE NOCHES ES IGUAL AL NMERO MXIMO DE NOCHES
        var li_Minimo_Dias = Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ); 
        var li_Maximo_Dias = Tomar_Numero( $('#fc_Maximo_Dias').attr('value') );

        //alert( li_Minimo_Dias + ' ' + li_Maximo_Dias);
        // ojo if ( li_Minimo_Dias == li_Maximo_Dias ) { Validar_Fecha(); if ( li_Maximo_Dias > 0 ) { Ocultar_Boton_Calendario(); } } else { Ocultar_Boton_Calendario(false); }
        //if ( li_Minimo_Dias == li_Maximo_Dias ) { Validar_Fecha(); Ocultar_Boton_Calendario(); } else { Ocultar_Boton_Calendario(false); }
        
        // SI EL MXIMO DE DAS ES 0, ENTONCES OCULTAR LOS ALMANAQUES
        // if ( li_Maximo_Dias == 0 && li_Minimo_Dias == 0 ) { Ocultar_Boton_Calendario(); } else { Ocultar_Boton_Calendario(true); }

        Ocultar_Boton_Calendario(true);
        
        if ( li_Minimo_Dias == li_Maximo_Dias ) { Validar_Fecha(); if ( li_Maximo_Dias > 0 ) { $('.calendario_fecha_salida').hide(); } else { $('.calendario_fecha_salida').show(); } }

    } else {
        //alert('limpiar fechas');
        $('#fc_Fecha_Inicio')[0].value = $('#fc_Fecha_Actual')[0].value;
        $('#fc_Fecha_Limite')[0].value = $('#fc_Fecha_Actual')[0].value;
        
    }
}

function Accion_Paso_Cotizador( li_Paso ) {
    // ESTABLECER EL MENSAJE DE INICIO
    $('#mensaje_pasos_cotizacion').html( la_Mensaje_Pasos[li_Paso][0] );
    $('#menu_sup_steps ul').removeClass();
    $('#menu_sup_steps ul').addClass('step' + (li_Paso + 1) );
    //$('#menu_sup_steps ul li').removeClass().addClass('step_todo');
    $('#menu_sup_steps ul li').eq(li_Paso).addClass('stephome_current');
    
    switch (li_Paso) {
        case 0  : $('#promotionslist .cabeceraContenedor').css({ background:'#B72E72',color:'#fff' });
                  // retornar EL CASO 1 - Fechas
                  $('#calendarnew').css({ background:'#5F5F5F',color:'#fff' });
                  // RETORNAR EL CASO 3 - Habitacin
                  $('.zona_mensaje_habitacion').css({ background:'#F6F6F6',color:'#676565' });
                  // ADICIONAR EL NMERO DEL PASO
                  $('#promotionslist .cabeceraContenedor .numero_paso_cotizacion').html( '- Paso 01 - ' ); 
                  break;
        case 1  : $('#calendarnew').css({ background:'#B72E72',color:'#fff' });
                  // RETORNAR EL CASO 0 - Temporada
                  $('#promotionslist .cabeceraContenedor').css({ background:'#F6F6F6',color:'#676565' });
                  // RETORNAR EL CASO 3 - Habitacin
                  $('.zona_mensaje_habitacion').css({ background:'#F6F6F6',color:'#676565' });
                  // ADICIONAR EL NMERO DEL PASO
                  $('#calendarnew .numero_paso_cotizacion').html( '- Paso 02 - ' );
                  break;
        case 2  : $('.zona_mensaje_habitacion').css({ background:'#B72E72',color:'#fff' }); 
                  // RETORNAR EL CASO 0 - Temporada
                  $('#promotionslist .cabeceraContenedor').css({ background:'#F6F6F6',color:'#676565' });
                  // retornar EL CASO 1 - Fechas
                  $('#calendarnew').css({ background:'#5F5F5F',color:'#fff' });
                  // ADICIONAR EL NMERO DEL PASO
                  $('.zona_mensaje_habitacion .numero_paso_cotizacion').html( '- Paso 03 - ' );
                  break;
        case 3  : $('#zona_usuario').css({ background:'#B72E72',color:'#fff' }); 
                  $('#zona_usuario .cabeceraContenedor').css({ background:'#B72E72',color:'#fff' });

                  // RETORNAR EL CASO 0 - Temporada
                  $('#promotionslist .cabeceraContenedor').css({ background:'#F6F6F6',color:'#676565' });
                  // retornar EL CASO 1 - Fechas
                  $('#calendarnew').css({ background:'#5F5F5F',color:'#fff' });
                  // RETORNAR EL CASO 3 - Habitacin
                  $('.zona_mensaje_habitacion').css({ background:'#F6F6F6',color:'#676565' });
                  // ADICIONAR EL NMERO DEL PASO
                  $('#zona_usuario .numero_paso_cotizacion').html( '- Paso 04 - ' );
                  // CAMBIAR EL BOTN
                  $('.button').css({ background:'#fff',color:'#B72E72' }); 
                  break;
    }
}

