<?php
require_once('./Connections/conexion.php');

// INICIA RECUPERACION DE PROMEDIO DE CALIFICACION
$sql_puntuacion = "SELECT count(*) as cantidad, SUM(custom_calificacion) as total, SUM(custom_calificacion)/count(*) as votacion FROM productos_calificacion WHERE custom_id_producto = " . $row_actuprod['custom_idproducto'] . "";

$puntuacion = mysqli_query($conexion, $sql_puntuacion) or die(mysqli_error($conexion));

$row_calificacion = mysqli_fetch_assoc($puntuacion);

if ($row_calificacion['votacion'] < 3) {
	$row_calificacion['votacion'] = 4.5;
}


$calificacion_actual = ceil($row_calificacion['votacion']);

?>


<style>
	.rating-productos-container {
		display: flex;
		align-items: center;
		gap: 10px;
		justify-content: left;
	}

	.rating-productos {
		display: flex;
		flex-direction: row-reverse;
		align-items: center;
		gap: 5px;
	}

	.rating-productos input {
		display: none;
	}

	.rating-productos label {
		width: 30px;
		height: 30px;
		clip-path: polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%);
		background-color: #ddd;
		cursor: pointer;
		transition: background-color 0.3s ease, transform 0.2s ease;
	}

	/* Efecto de sombreado progresivo al pasar el cursor */
	.rating-productos label:hover,
	.rating-productos label:hover~label {
		background-color: #ffc107;
	}

	/* Estrellas seleccionadas y anteriores */
	.rating-productos input:checked+label,
	.rating-productos input:checked+label~label {
		background-color: #ffc107;
	}

	.submit-icon {
		display: flex;
		align-items: center;
		justify-content: center;
		width: 35px;
		height: 35px;
		background-color: #007bff;
		color: white;
		border-radius: 50%;
		cursor: pointer;
		transition: background-color 0.3s ease, transform 0.2s ease;
		border: none;
		outline: none;
	}

	/* Efecto hover en el botn de envo */
	.submit-icon:hover {
		background-color: #0056b3;
	}

	/* Ajustar el icono dentro del botn */
	.submit-icon i {
		font-size: 16px;
	}
</style>

<!-- Formulario -->
<form id="rating-productosForm">
	<div class="rating-productos-container">
		<div class="rating-productos">
			<!-- Invertir el orden de las estrellas de 5 a 1 -->
			<input type="radio" id="star5" name="calificacion" value="5" <?php if ($calificacion_actual == 5) echo 'checked'; ?>>
			<label for="star5" title="5 estrellas"></label>

			<input type="radio" id="star4" name="calificacion" value="4" <?php if ($calificacion_actual == 4) echo 'checked'; ?>>
			<label for="star4" title="4 estrellas"></label>

			<input type="radio" id="star3" name="calificacion" value="3" <?php if ($calificacion_actual == 3) echo 'checked'; ?>>
			<label for="star3" title="3 estrellas"></label>

			<input type="radio" id="star2" name="calificacion" value="2" <?php if ($calificacion_actual == 2) echo 'checked'; ?>>
			<label for="star2" title="2 estrellas"></label>

			<input type="radio" id="star1" name="calificacion" value="1" <?php if ($calificacion_actual == 1) echo 'checked'; ?>>
			<label for="star1" title="1 estrella"></label>
		</div>
		<!-- Botn de envo -->
		<button type="button" id="submitrating-productos" class="submit-icon" title="Calificar">
			<i class="fas fa-paper-plane"></i>
		</button>
	</div>

	<!-- Campo oculto -->
	<input type="hidden" name="producto_votacion" value="<?php echo $row_actuprod['custom_idproducto']; ?>">
</form>

<!-- Contenedor para el toast -->
<div id="toast" style="
    display: none;
    position: fixed;
    bottom: 20px;
    right: 20px;
    background-color: #28a745;
    color: white;
    padding: 15px;
    border-radius: 5px;
    z-index: 1000;">
</div>

<script>
	document.getElementById('submitrating-productos').addEventListener('click', function() {
		const formData = new FormData(document.getElementById('rating-productosForm'));
		const xhr = new XMLHttpRequest();

		xhr.open('POST', './siev/aplicaciones/calificacion/votacion_producto_procesa.php', true);
		xhr.onload = function() {
			if (xhr.status === 200) {
				const response = JSON.parse(xhr.responseText);
				showToast(`Gracias por calificar. Le diste ${response.calificacion} estrellas.`);
			} else {
				showToast('Ocurri un error al enviar la calificacin.', true);
			}
		};
		xhr.send(formData);
	});

	function showToast(message, error = false) {
		const toast = document.getElementById('toast');
		toast.textContent = message;
		toast.style.backgroundColor = error ? '#dc3545' : '#28a745'; // Rojo para errores, verde para xito
		toast.style.display = 'block';

		setTimeout(() => {
			toast.style.display = 'none';
		}, 3000);
	}
</script>