<?php
require_once('Connections/conexion.php');

// INICIA RECUPERACIN DE PROMEDIO DE CALIFICACIN
$sql_puntuacion = "SELECT count(*) as cantidad, SUM(custom_calificacion) as total, SUM(custom_calificacion)/count(*) as votacion FROM productos_calificacion WHERE custom_id_producto = 0";

$puntuacion = mysqli_query($conexion, $sql_puntuacion) or die(mysqli_error($conexion));

$row_calificacion = mysqli_fetch_assoc($puntuacion);

if ($row_calificacion['votacion'] < 3.5) {
	$row_calificacion['votacion'] = 4.5;
}

$calificacion_actual = ceil($row_calificacion['votacion']);

?>


<!-- Estilos CSS -->
<style>
	.rating-container {
		display: flex;
		align-items: center;
		gap: 10px;
		justify-content: left;
	}

	.rating {
		display: flex;
		flex-direction: row-reverse;
		align-items: center;
		gap: 5px;
	}

	.rating input {
		display: none;
	}

	.rating label {
		width: 30px;
		height: 30px;
		clip-path: polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%);
		background-color: #ddd;
		cursor: pointer;
		transition: background-color 0.3s ease, transform 0.2s ease;
	}

	.rating label:hover,
	.rating label:hover~label {
		background-color: #ffc107;
	}

	.rating input:checked+label,
	.rating input:checked+label~label {
		background-color: #ffc107;
	}

	.submit-icon {
		display: flex;
		align-items: center;
		justify-content: center;
		width: 35px;
		height: 35px;
		background-color: #007bff;
		color: white;
		border-radius: 50%;
		cursor: pointer;
		transition: background-color 0.3s ease, transform 0.2s ease;
		border: none;
		outline: none;
	}

	.submit-icon:hover {
		background-color: #0056b3;
	}

	.submit-icon i {
		font-size: 16px;
	}
</style>

<!-- Formulario del Home -->
<form id="home_ratingForm">
	<div class="rating-container">
		<div class="rating">
			<!-- Invertir el orden de las estrellas de 5 a 1 -->
			<input type="radio" id="home_star5" name="calificacion" value="5" <?php if ($calificacion_actual == 5) echo 'checked'; ?>>
			<label for="home_star5" title="5 estrellas"></label>

			<input type="radio" id="home_star4" name="calificacion" value="4" <?php if ($calificacion_actual == 4) echo 'checked'; ?>>
			<label for="home_star4" title="4 estrellas"></label>

			<input type="radio" id="home_star3" name="calificacion" value="3" <?php if ($calificacion_actual == 3) echo 'checked'; ?>>
			<label for="home_star3" title="3 estrellas"></label>

			<input type="radio" id="home_star2" name="calificacion" value="2" <?php if ($calificacion_actual == 2) echo 'checked'; ?>>
			<label for="home_star2" title="2 estrellas"></label>

			<input type="radio" id="home_star1" name="calificacion" value="1" <?php if ($calificacion_actual == 1) echo 'checked'; ?>>
			<label for="home_star1" title="1 estrella"></label>
		</div>
		<!-- Botn de envo -->
		<button type="button" id="home_submitRating" class="submit-icon" title="Calificar">
			<i class="fas fa-paper-plane"></i>
		</button>
	</div>

	<!-- Campo oculto -->
	<input type="hidden" name="producto_votacion" value="0">
</form>

<!-- Contenedor para el toast del home -->
<div id="home_toast" style="
    display: none;
    position: fixed;
    bottom: 20px;
    right: 20px;
    background-color: #28a745;
    color: white;
    padding: 15px;
    border-radius: 5px;
    z-index: 1000;">
</div>


<script>
	document.getElementById('home_submitRating').addEventListener('click', function() {
		const formData = new FormData(document.getElementById('home_ratingForm'));
		const xhr = new XMLHttpRequest();

		xhr.open('POST', './siev/aplicaciones/calificacion/votacion_producto_procesa.php', true);
		xhr.onload = function() {
			if (xhr.status === 200) {
				try {
					const response = JSON.parse(xhr.responseText);
					home_showToast(`Gracias por calificar. Le diste ${response.calificacion} estrellas.`);
				} catch (e) {
					home_showToast('Ocurri un error al enviar la calificacin.', true);
				}
			} else {
				home_showToast('Ocurri un error al enviar la calificacin.', true);
			}
		};
		xhr.send(formData);
	});

	function home_showToast(message, error = false) {
		const toast = document.getElementById('home_toast');
		toast.textContent = message;
		toast.style.backgroundColor = error ? '#dc3545' : '#28a745'; // Rojo para errores, verde para xito
		toast.style.display = 'block';

		setTimeout(() => {
			toast.style.display = 'none';
		}, 3000);
	}
</script>