<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Tripgo_Elementor_My_Account_Button extends Widget_Base {

	public function get_name() {
		return 'tripgo_elementor_my_account_button';
	}

	public function get_title() {
		return esc_html__( 'My Account Button', 'tripgo' );
	}

	public function get_icon() {
		return 'eicon-dual-button';
	}

	public function get_categories() {
		return [ 'tripgo' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'tripgo' ),
			]
		);	
			
			// Add Class control
			$this->add_control(
				'text_my_account_button',
				[
					'label' => esc_html__( 'Text My Account Button', 'tripgo' ),
					'type' 	=> \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
					'default' => esc_html__( 'My account', 'tripgo' ),
				]
			);

			$this->add_control(
				'text_login_button',
				[
					'label' => esc_html__( 'Text Login Button', 'tripgo' ),
					'type' 	=> \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
					'default' => esc_html__( 'Login', 'tripgo' ),
				]
			);

			$this->add_control(
				'text_signup_button',
				[
					'label' => esc_html__( 'Text Sign Up Button', 'tripgo' ),
					'type' 	=> \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
					'default' => esc_html__( 'Sign Up', 'tripgo' ),
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();

		$text_my_account_button = $settings['text_my_account_button'];
		$text_login_button 		= $settings['text_login_button'];
		$text_signup_button 	= $settings['text_signup_button'];

		$my_account_page_url 	= get_permalink( get_option('woocommerce_myaccount_page_id') );

		?>

		<?php if ( is_user_logged_in() ) { 
			$current_user = wp_get_current_user();
		?>
			<div class="ova-my-account-button logged-in">
				<?php if ( ($current_user instanceof WP_User) ) {
			        echo get_avatar( $current_user->ID, 30 );
			    } ?>
				<a href="<?php echo esc_url($my_account_page_url); ?>">
					<?php echo esc_html($text_my_account_button);?>
				</a>
			</div>
		<?php } else { ?>
			<div class="ova-my-account-button logged-out">
				<a class="ma-button login-button" href="<?php echo esc_url($my_account_page_url); ?>">
					<?php echo esc_html($text_login_button);?>
				</a>
				<a class="ma-button singup-button" href="<?php echo esc_url($my_account_page_url); ?>">
					<?php echo esc_html($text_signup_button);?>
				</a>
			</div>
		<?php }
	}
	
}
$widgets_manager->register( new Tripgo_Elementor_My_Account_Button() );