<?php
require_once "Connections/conexion.php";

//Instanciar la variable conexion para evitar error de variable indefinida
$conn               = new ConexionMySql();
$conexion           = $conn->DB_conexion;
$database_conexion  = $conn->bd;

if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
        $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
        $theValue = function_exists("mysqli_real_escape_string") ? mysqli_real_escape_string($theValue) : mysqli_real_escape_string($theValue);

        switch ($theType) {
            case "text"   : $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;    
            case "long"   : case "int": $theValue = ($theValue != "") ? intval($theValue) : "NULL"; break;
            case "double" : $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "NULL"; break;
            case "date"   : $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
            case "defined": $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue; break;
        }
        return $theValue;
    }
}

$colname_compradores = "-1";
if (isset($_SESSION['comprador'])) { $colname_compradores = $_SESSION['comprador']; }
mysqli_select_db($conexion,$database_conexion);
$query_compradores      = sprintf("SELECT * FROM usuarios WHERE custom_id = %s and usuario = '$row_micros[custom_cliente]'", GetSQLValueString($colname_compradores, "text"));
$compradores            = mysqli_query($conexion,$query_compradores) or die(mysqli_error($conexion));
$row_compradores        = mysqli_fetch_assoc($compradores);
$totalRows_compradores  = mysqli_num_rows($compradores);

?>

<?php

$maxRows_cesta = 10;
$pageNum_cesta = 0;

if (isset($_GET['pageNum_cesta'])) { $pageNum_cesta = $_GET['pageNum_cesta']; }

$startRow_cesta = $pageNum_cesta * $maxRows_cesta;
mysqli_select_db($conexion,$database_conexion);

// SI NO EXISTE UN COMPRADO LOGUEADO, ENTONCES PRESENTAR LOS DATOS DEL USUARIO ANNIMO
/********************* COMPRADOR ANNIMO ***************************/
// UTILIZAR UN COMPRADOR ANNIMO 
if ($_SESSION['comprador'] == '') {
    // SI NO TIENE COMPRADOR, ASIGNAR LA SESIN
    $_SESSION['comprador_anonimo']  = session_id();
    // INGRESAR LOS REGISTROS COMO COMPRADOR ANNIMO
    $lc_Usuario_Tienda              = session_id();
} else {
    $lc_Usuario_Tienda = $row_compradores['custom_id'];
}
/********************* COMPRADOR ANNIMO ***************************/

$query_cesta        = "SELECT cesta.id, cesta.cantidad, cesta.cliente, cesta.usuario, cesta.idproducto, cesta.atributos, productos.custom_idproducto, productos.ruta_imagen, productos.custom_nombrepro, productos.custom_referencia, productos.producto_codigo, productos.custom_valor, productos.custom_subtotal, productos.custom_bruto, productos.custom_iva, productos.custom_viva, productos.custom_pocedes, productos.custom_descuento, productos.tipo as prodTipo, tipo_portafolio.id as tipoPortaId, tipo_portafolio.tipo as tipoPorNombre FROM cesta, productos, tipo_portafolio WHERE cesta.usuario = '".$lc_Usuario_Tienda."' and cesta.cliente = '$row_micros[custom_cliente]' and cesta.idproducto = productos.custom_idproducto and tipo_portafolio.id=productos.tipo";
$query_limit_cesta  = sprintf("%s LIMIT %d, %d", $query_cesta, $startRow_cesta, $maxRows_cesta);

//echo $query_cesta;

$cesta      = mysqli_query($conexion,$query_limit_cesta) or die(mysqli_error($conexion));
$row_cesta  = mysqli_fetch_assoc($cesta);

$_SESSION['cesta_usuario'] = $row_cesta;

if (isset($_GET['totalRows_cesta'])) {
    $totalRows_cesta = $_GET['totalRows_cesta'];
} else {
    $all_cesta = mysqli_query($conexion,$query_cesta);
    $totalRows_cesta = mysqli_num_rows($all_cesta);
}

$totalPages_cesta = ceil($totalRows_cesta/$maxRows_cesta)-1;
mysqli_select_db($conexion,$database_conexion);

$query_pedido = "SELECT * FROM cesta, productos WHERE cesta.usuario = '".$lc_Usuario_Tienda."' and cesta.cliente = '$row_micros[custom_cliente]' and cesta.idproducto = productos.custom_idproducto";
$pedido       = mysqli_query($conexion,$query_pedido) or die(mysqli_error($conexion));

$row_pedido       = mysqli_fetch_assoc($pedido);
$totalRows_pedido = mysqli_num_rows($pedido);

//echo $query_pedido." ".$totalRows_pedido;

/*SQL:: Detalle del PEDIDO*/

$maxRows_det_pedido = 10;
$pageNum_det_pedido = 0;

if (isset($_GET['pageNum_det_pedido'])) {
  $pageNum_det_pedido = $_GET['pageNum_det_pedido'];
}
$startRow_det_pedido = $pageNum_det_pedido * $maxRows_det_pedido;
mysqli_select_db($conexion,$database_conexion);

$query_det_pedido       = "SELECT * FROM pedidos, productos, pedido_detalle WHERE pedido_detalle.id='$_GET[idpedido]' and pedido_detalle.usuario = '$row_compradores[custom_id]' and pedido_detalle.cliente = '$row_micros[custom_cliente]' and pedidos.idpedido=pedido_detalle.id and productos.custom_idproducto= pedidos.idproducto";
$query_limit_det_pedido = sprintf("%s LIMIT %d, %d", $query_det_pedido, $startRow_det_pedido, $maxRows_det_pedido);

$det_pedido             = mysqli_query($conexion,$query_limit_det_pedido) or die(mysqli_error($conexion));
$row_det_pedido         = mysqli_fetch_assoc($det_pedido);


/*SQL:: PEDIDOS x USUARIO*/
$maxRows_total_pedidos = 10;
$pageNum_total_pedidos = 0;
if (isset($_GET['pageNum_total_pedidos'])) { $pageNum_total_pedidos = $_GET['pageNum_total_pedidos']; }

$startRow_total_pedidos = $pageNum_total_pedidos * $maxRows_total_pedidos;
mysqli_select_db($conexion,$database_conexion);
$query_total_pedidos      = "SELECT * FROM pedido_detalle WHERE pedido_detalle.usuario = '". $row_compradores['custom_id']."' and pedido_detalle.cliente = '".$row_micros['custom_cliente']."' ORDER BY fecha DESC"; 
$query_limit_total_pedidos = sprintf("%s LIMIT %d, %d", $query_total_pedidos, $startRow_total_pedidos, $maxRows_total_pedidos);
$total_pedidos            = mysqli_query($conexion,$query_limit_total_pedidos) or die(mysqli_error($conexion));
$totalRows_total_pedidos  = mysqli_num_rows($total_pedidos);
$row_total_pedidos        = mysqli_fetch_assoc($total_pedidos);

/*SQL:: PEDIDOS x USUARIO - X PAGAR*/


/*mysqli_select_db($conexion, $database_conexion);
$query_total_xpagar = "SELECT * FROM pedido_detalle WHERE estado_pago= '0' AND pedido_detalle.usuario = '$row_compradores[custom_id]' and pedido_detalle.cliente = '$row_micros[custom_cliente]'"; 
$total_xpagar = mysqli_query($conexion,$query_total_xpagar) or die(mysqli_error($conexion));
$totalRows_total_xpagar = mysqli_num_rows($total_xpagar);
$row_total_xpagar = mysqli_fetch_assoc($total_xpagar);*/


//require "pedidos/conversor.php";
 
//if( isset($_SESSION['comprador']) and $totalRows_pedido > 0 ){
if( $totalRows_pedido > 0 ){
    $total_prod_cesta= 0;
    do {
        $p_subtotal   = $row_pedido['custom_subtotal'];
        $p_iva        = $row_pedido['custom_viva'];
        $p_total      = $row_pedido['custom_valor'];
        $p_descuento  = $row_pedido['custom_descuento'];

        if ($row_pedido['atributos'] >0) {
            $colname_atribValues = $row_pedido['atributos'];
            mysqli_select_db($conexion,$database_conexion);
            $query_atribValues = sprintf("SELECT productos_atrib_values.id as idAtribVal, productos_atrib_values.id_atrr as idAtrib, productos_atrib_values.nombre as nombreAtribVal, productos_atrib_values.custom_valor, productos_atrib.id, productos_atrib.id_producto, productos_atrib.nombre as nombreAtrib, productos_atrib_values.custom_subtotal FROM productos_atrib_values,productos_atrib WHERE productos_atrib_values.id IN(%s) and productos_atrib.id = productos_atrib_values.id_atrr", $colname_atribValues);
            $atribValues = mysqli_query($conexion,$query_atribValues) or die(mysqli_error($conexion));
            $row_atribValues = mysqli_fetch_assoc($atribValues);
            $totalRows_atribValues = mysqli_num_rows($atribValues);
						//echo $query_atribValues;
						do {  
                /* Precio total de ATRIBUTO   */				  
                $p_iva=  $p_iva + $row_atribValues['custom_viva'];
                $p_subtotal= $p_subtotal + $row_atribValues['custom_subtotal'];
                $p_total= $p_total + $row_atribValues['custom_valor'];
                $p_descuento= $p_descuento + $row_atribValues['custom_descuento'];
    				} while ($row_atribValues = mysqli_fetch_assoc($atribValues));

        }

        $p_iva            =  $p_iva * $row_pedido['cantidad'];
        $p_subtotal       = $p_subtotal * $row_pedido['cantidad'];
        $p_total          = $p_total * $row_pedido['cantidad'];
        $p_descuento      = $p_descuento * $row_pedido['cantidad'];
        $t_subtotal       = $t_subtotal + $p_subtotal ;
        $t_iva            = $t_iva + $p_iva ;
        $t_total          = $t_total + $p_total ;
        $t_descuento      = $t_descuento + $p_descuento ;
        $total_prod_cesta = $total_prod_cesta + $row_pedido['cantidad'];
    } while ($row_pedido = mysqli_fetch_assoc($pedido));
}
 ?>
