📌 README.md - Notificaciones Push con Service Workers y Web Push API

📢 Sistema de Notificaciones Push
Este proyecto permite el envío de notificaciones push en tiempo real mediante la API Web Push, Service Workers y la librería Minishlink/WebPush en PHP. Es compatible con Chrome, Mozilla y Edge en PC y dispositivos móviles.

📖 Descripción del Proyecto
El sistema permite a los usuarios registrarse para recibir notificaciones push en su navegador. Funciona mediante un Service Worker que intercepta las notificaciones enviadas desde el servidor y las muestra en el cliente.

✅ Características principales:

Registro de usuarios para recibir notificaciones push.
Envío de notificaciones con imágenes, iconos y acciones personalizadas.
Integración con Minishlink/WebPush en PHP.
Compatibilidad con Chrome, Mozilla y Edge.
Service Worker para manejar notificaciones en segundo plano.
Persistencia de suscripciones en base de datos.
🛠 Instalación y Configuración
1️⃣ Requisitos Previos
Antes de instalar, asegúrate de tener:

Servidor con PHP 7.4+
Composer instalado
MySQL o MariaDB como base de datos
Certificado SSL (HTTPS obligatorio)
2️⃣ Instalación
📥 Clonar el repositorio
bash
Copiar
Editar
git clone https://github.com/tuusuario/notificaciones-push.git
cd notificaciones-push
📦 Instalar dependencias con Composer
bash
Copiar
Editar
composer install
🗃 Crear la base de datos y tabla
Ejecuta en MySQL:

sql
Copiar
Editar
CREATE DATABASE notificaciones;
USE notificaciones;

CREATE TABLE suscripciones_push (
    id INT AUTO_INCREMENT PRIMARY KEY,
    endpoint TEXT NOT NULL,
    p256dh TEXT NOT NULL,
    auth TEXT NOT NULL,
    fecha TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
🔑 Generar claves VAPID
Ejecuta en terminal:

bash
Copiar
Editar
php js/pwa/generar_vapid.php
Esto generará dos claves:

Clave Pública: BNJHutigtT4tkPAyKuELi1GF1hDdIuHm8648LoC5tUvkrMQaPHZute_-N-CLuXk7Q6yI_wbyZmiYsSsDfJ0dw6g
Clave Privada: sRrEsZ3H5h0IyuO22eeUJ-TrxYZh0wc9coHmIq83nkA
Guárdalas en notificaciones_push.php y main.js.

🚀 Arquitectura del Proyecto
El sistema tiene 3 componentes principales:

1️⃣ 📡 Cliente (Front-end)

main.js: Maneja el registro de usuarios para recibir notificaciones.
service-worker.js: Captura y muestra las notificaciones.
2️⃣ 🖥 Servidor (Back-end en PHP)

guardar_subscripcion.php: Guarda las suscripciones en la base de datos.
notificaciones_push.php: Envía las notificaciones a los suscriptores.
3️⃣ 📂 Base de datos (MySQL)

Almacena los usuarios suscritos a las notificaciones.
📜 Explicación del Funcionamiento
1️⃣ Usuario se suscribe a las notificaciones
Cuando el usuario hace clic en el botón de "Activar Notificaciones", main.js:

Solicita permiso al navegador.
Registra el Service Worker (service-worker.js).
Obtiene la suscripción del usuario y la envía a guardar_subscripcion.php.
2️⃣ Servidor guarda la suscripción en la base de datos
guardar_subscripcion.php:

Recibe la suscripción en formato JSON.
Verifica si ya existe en la base de datos.
Si es nueva, la inserta; si no, la actualiza.
3️⃣ Servidor envía una notificación
Cuando se ejecuta notificaciones_push.php, el servidor:

Recupera todas las suscripciones almacenadas.
Usa Minishlink/WebPush para enviar la notificación con las claves VAPID.
Chrome, Mozilla y Edge reciben y muestran la notificación.
4️⃣ Service Worker maneja la notificación
Cuando el navegador recibe la notificación:

service-worker.js la intercepta y la muestra con imágenes y botones de acción.
Si el usuario hace clic, lo redirige a la web.
📂 Estructura del Proyecto
bash
Copiar
Editar
notificaciones-push/
│── public_html/
│   ├── js/
│   │   ├── pwa/
│   │   │   ├── service-worker.js  # Service Worker que maneja las notificaciones
│   │   │   ├── main.js            # Manejo del registro de suscripciones
│   │   │   ├── guardar_subscripcion.php # Guarda suscripciones en la BD
│   │   │   ├── notificaciones_push.php  # Envía notificaciones a los usuarios
│   │   │   ├── generar_vapid.php  # Genera las claves VAPID
│   ├── images/
│   │   ├── progressive/
│   │   │   ├── icon-maskable.png # Ícono de la notificación
│── vendor/ # Dependencias instaladas por Composer
│── composer.json # Dependencias PHP
│── README.md # Documentación
⚡ Ejemplo de Notificación Push
Así se ve la notificación que recibe el usuario:

📌 Ejemplo en notificaciones_push.php:

php
Copiar
Editar
$webPush->queueNotification(
  $sub,
  json_encode([
      "title" => "🚀 Notificación Importante",
      "body" => "Tu mensaje personalizado aquí con más detalles.",
      "icon" => "https://www.siev.mobi/images/progressive/icon-maskable.png",
      "image" => "https://www.siev.mobi/images/progressive/icon-maskable.png",
      "badge" => "https://www.siev.mobi/images/progressive/icon-maskable.png",
      "vibrate" => [200, 100, 200],
      "actions" => [
          [
              "action" => "ver",
              "title" => "🔍 Ver Detalles"
          ],
          [
              "action" => "cerrar",
              "title" => "❌ Cerrar"
          ]
      ],
      "data" => ["url" => "https://www.siev.mobi"]
  ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)
);
📌 Ejemplo de service-worker.js mostrando la notificación:

javascript
Copiar
Editar
self.addEventListener("push", function (event) {
    console.log("📩 Notificación push recibida", event);

    if (event.data) {
        let data = event.data.json();

        const options = {
            body: data.body,
            icon: data.icon,
            image: data.image,
            badge: data.badge,
            vibrate: data.vibrate,
            actions: data.actions,
            data: { url: data.data?.url || "https://www.siev.mobi" }
        };

        event.waitUntil(
            self.registration.showNotification(data.title, options)
        );
    }
});

// Abre la web al hacer clic en la notificación
self.addEventListener("notificationclick", (event) => {
    event.notification.close();
    event.waitUntil(clients.openWindow(event.notification.data.url));
});
📌 Conclusión
Este sistema de Notificaciones Push permite enviar mensajes en tiempo real a los usuarios de la web. Se ha optimizado para Chrome, Edge y Mozilla, asegurando compatibilidad total en PC y dispositivos móviles.

🚀 ¡Listo para usar en producción! ✅

📞 Soporte
Si tienes dudas o mejoras, contáctanos en tuemail@dominio.com o abre un issue en el repositorio.

🔹 Con esto, tu sistema queda documentado profesionalmente. ¡Listo para compartir! 🚀