<style>
    /* ======== 1?? CONTROL PARA MOSTRAR / OCULTAR FLECHA (DROPDOWN TOGGLE) ======== */
    .hide-dropdown-toggle {
        display: none !important;
    }

    .show-dropdown-toggle {
        display: inline-block !important;
    }

    @media (max-width: 991px) {
        .hide-dropdown-toggle {
            display: inline-block !important;
        }
    }

    /* ======== 2?? ESTILO GENERAL DEL MEN PRINCIPAL (NAVBAR) ======== */
    .navbar {
        background-color: white !important;
        /* Fondo blanco */
        border-bottom: 1px solid #fff;
        /* Lnea inferior naranja */
    }

    /* Enlaces principales del men */
    .navbar-nav .nav-link {
        color: black !important;
        /* Texto negro */
        font-weight: 600;
        padding: 10px 15px;
    }

    /* Color al pasar el mouse sobre los enlaces */
    .navbar-nav .nav-link:hover {
        background-color: lightgray !important;
        /* Fondo gris en hover */
        color: black !important;
    }

    /* ======== 3?? ESTILOS PARA EL MEN DESPLEGABLE (DROPDOWN) ======== */
    /* Fondo del men desplegable */
    .dropdown-menu {
        background-color: white !important;
        /* Fondo blanco */
        border: 1px solid #fff !important;
        /* Borde naranja */
    }

    /* Color del texto en el men desplegable */
    .dropdown-menu .dropdown-item {
        color: black !important;
        /* Texto negro */
        font-size: 16px;
        padding: 10px 15px;
    }

    /* Al pasar el mouse sobre un tem del dropdown */
    .dropdown-menu .dropdown-item:hover,
    .dropdown-menu .dropdown-item:focus {
        background-color: lightgray !important;
        /* Fondo gris en hover */
        color: black !important;
    }

    /* Elementos inactivos */
    .dropdown-menu .dropdown-item.disabled,
    .dropdown-menu .dropdown-item:disabled {
        color: rgba(0, 0, 0, 0.5) !important;
        /* Texto negro tenue */
    }

    /* ======== 4?? ESTILOS PARA SEPARAR TEXTO Y FLECHA ======== */
    .nav-item.dropdown .d-flex {
        gap: 10px;
    }

    .nav-item.dropdown .dropdown-toggle {
        color: black !important;
        /* Color de la flecha negro */
    }

    /* ======== 5?? ESTILOS PARA EL MEN EN MVILES ======== */
    @media (max-width: 991px) {
        .dropdown-menu {
            background-color: white !important;
            /* Fondo blanco */
            border: 0px solid orange !important;
            /* Borde naranja */
        }

        /* Agrandar espacio entre elementos */
        .dropdown-menu .dropdown-item {
            font-size: 18px;
            padding: 12px 18px;
        }

        /* Asegurar que el texto sea siempre visible */
        .navbar-nav .nav-link {
            font-size: 18px;
        }
    }
</style>
<?php
if (!function_exists('Convertir_Url_Amigable')) {
    function Convertir_Url_Amigable($cadena)
    {
        $valores    = array('O', 'U', 'E', 'A', 'I', 'N', 'a', 'e', 'i', 'o', 'u', 'n', '-');
        $especiales = array('', '', '', '', '', '', '', '', '', '', '', '', ' ');
        return preg_replace("/[^\w]/", "-", strtolower(str_replace($especiales, $valores, trim($cadena))));
    }
}

if (isset($lc_Query)) {
    $objetoConsulta = HacerConsultaQuery($lc_Query);

    // Inicializar arreglos para construir el rbol de categoras
    $la_Categoria        = array(); // Registro completo, clave = id_categoria
    $la_Nombre_Categoria = array(); // Mapea id => nombre_categoria
    $la_Nivel_Menu       = array(); // Lista de ids para categoras de nivel 0

    if (is_object($objetoConsulta) && $objetoConsulta->DB_registros > 0) {
        foreach ($objetoConsulta->DB_resultado as $registro) {
            $id_cat    = $registro['id_categoria'];
            $id_padre  = $registro['id_subcategoria'];
            $posicion  = isset($registro['posicion']) ? (int)$registro['posicion'] : 9999;
            $solousuarios = isset($registro['solousuarios']) ? (int)$registro['solousuarios'] : 0;
            $megamenu     = isset($registro['megamenu']) ? (int)$registro['megamenu'] : 0;
            // Opcional: si en el query se incluye tipopre, se guarda; de lo contrario se deja vaco.
            $tipopre   = isset($registro['tipopre']) ? $registro['tipopre'] : '';

            // Si ya existe (placeholder) se actualiza la propiedad desplegar
            if (isset($la_Categoria[$id_cat])) {
                if (empty($la_Categoria[$id_cat]['desplegar'])) {
                    $la_Categoria[$id_cat]['desplegar'] = $registro['desplegar'];
                }
            } else {
                $la_Categoria[$id_cat] = array(
                    "id"           => $id_cat,
                    "desplegar"    => $registro['desplegar'], // "si" o "no"
                    "nombre"       => $registro['nombre_categoria'],
                    "url"          => $registro['url_tipo_portafolio'],
                    "posicion"     => $posicion,
                    "productos"    => array(),
                    "children"     => array(),
                    "solousuarios" => $solousuarios,
                    "megamenu"     => $megamenu,
                    "tipopre"      => $tipopre
                );
            }

            // Guardar el nombre de la categora para uso posterior
            if (!isset($la_Nombre_Categoria[$id_cat])) {
                $la_Nombre_Categoria[$id_cat] = $registro['nombre_categoria'];
            }

            // Procesar la relacin padrehijo
            if ($id_padre == '0') {
                if (!in_array($id_cat, $la_Nivel_Menu)) {
                    $la_Nivel_Menu[] = $id_cat;
                }
            } else {
                $padre = $id_padre;
                if (!isset($la_Categoria[$padre])) {
                    $la_Categoria[$padre] = array(
                        "id"           => $padre,
                        "desplegar"    => "",
                        "nombre"       => "",
                        "url"          => "",
                        "posicion"     => 9999,
                        "productos"    => array(),
                        "children"     => array(),
                        "solousuarios" => 0,
                        "megamenu"     => 0,
                        "tipopre"      => ''
                    );
                }
                if (!in_array($id_cat, $la_Categoria[$padre]['children'])) {
                    $la_Categoria[$padre]['children'][] = $id_cat;
                }
            }

            // Si existe un producto asociado, lo agregamos (evitando duplicados)
            if (!empty($registro['id_producto'])) {
                $prodPos = isset($registro['posicion_producto']) ? (int)$registro['posicion_producto'] : 9999;
                $prod = array(
                    "id"       => $registro['id_producto'],
                    "nombre"   => $registro['nombre_producto'],
                    "url"      => $registro['url_producto'],
                    "posicion" => $prodPos
                );
                $existingProdIds = array_column($la_Categoria[$id_cat]['productos'], 'id');
                if (!in_array($prod['id'], $existingProdIds)) {
                    $la_Categoria[$id_cat]['productos'][] = $prod;
                }
            }
        }
    }

    /**
     * Funcin recursiva para mostrar el men.
     * Incorpora:
     * - solousuarios: se oculta si la categora es solo para usuarios y no hay sesin.
     * - megamenu y tipopre: si la categora tiene megamenu activo y su nombre coincide con el valor de tipo (consulta a tipo_portafolio), se despliega en layout grid.
     */
    function mostrar_menu($catId)
    {
        global $la_Categoria, $la_Nombre_Categoria, $weblider, $lider, $idio, $sesion_usuarios_contenidos;
        $cat = $la_Categoria[$catId];
        $nombre = isset($la_Nombre_Categoria[$catId]) ? $la_Nombre_Categoria[$catId] : $cat['nombre'];

        // Verificar solousuarios: si es 1 y el usuario no est autenticado, no se muestra
        if ($cat['solousuarios'] == 1 && (!isset($sesion_usuarios_contenidos) || $sesion_usuarios_contenidos !== 'Y')) {
            return;
        }

        $urlAmigable = (!empty(trim($cat['url']))) ? $cat['url'] : Convertir_Url_Amigable($nombre);
        $linkCategoria = $weblider . $lider . '/pg' . $catId . '/' . $idio . '/' . $urlAmigable;
        $hasChildren = !empty($cat['children']);
        $hasProductos = !empty($cat['productos']);

        // Si la categora tiene megamenu activado, verificamos la presentacin (tipopre)
        if ($cat['megamenu'] == 1) {
            // Se consulta la tabla tipo_portafolio para obtener el valor "tipo" y la imagen (si corresponde)
            $lc_Query_Posicion = "SELECT tipo, ruta_imagen FROM tipo_portafolio WHERE id = '" . $catId . "' ";
            $lo_ObjetoConsulta = HacerConsultaQuery($lc_Query_Posicion);
            $tipo = '';
            $img = '';
            if (is_object($lo_ObjetoConsulta) && $lo_ObjetoConsulta->DB_registros > 0) {
                foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Posicion) {
                    if ($lo_Posicion['megamenu'] == 1) {
                        $tipo = $lo_Posicion['tipo'];
                        $img = $lo_Posicion['ruta_imagen'];
                    }
                }
            }
            // Si el nombre de la categora coincide con el valor obtenido (tipopre), usamos el layout especial
            if ($nombre == $tipo) {
                echo "<li id='li-{$catId}' class='nav-item dropdown mega-menu nav-animate-fadeIn nav-hover-animate hover-animate-bounceIn'>";
                echo "<a class='nav-link' href='{$linkCategoria}'>{$nombre}</a>";
                echo "<ul class='dropdown-menu dropdown-menu-clean has-topBar'>";
                echo "<div class='row'>";
                // Columna para subcategoras
                if ($hasChildren) {
                    $childrenSorted = $cat['children'];
                    usort($childrenSorted, function ($a, $b) {
                        global $la_Categoria;
                        return ($la_Categoria[$a]['posicion'] ?? 9999) - ($la_Categoria[$b]['posicion'] ?? 9999);
                    });
                    // Se agrupan en bloques (por ejemplo, de 6 en 6)
                    $childrenChunks = array_chunk($childrenSorted, 6, false);
                    foreach ($childrenChunks as $chunk) {
                        echo "<div class='col-md-5th'>";
                        foreach ($chunk as $childId) {
                            mostrar_menu($childId);
                        }
                        echo "</div>";
                    }
                }
                // Columna para productos (si existen)
                if ($hasProductos) {
                    echo "<div class='col-md-5th'>";
                    $productosSorted = $cat['productos'];
                    usort($productosSorted, function ($pA, $pB) {
                        $posA = $pA['posicion'] ?? 9999;
                        $posB = $pB['posicion'] ?? 9999;
                        if ($posA != $posB) {
                            return $posA - $posB;
                        }
                        return $pA['id'] - $pB['id'];
                    });
                    foreach ($productosSorted as $prod) {
                        $prodUrl = (!empty(trim($prod['url']))) ? $prod['url'] : Convertir_Url_Amigable($prod['nombre']);
                        $prodLink = $weblider . $lider . '/vp' . $prod['id'] . '/' . $idio . '/' . $prodUrl;
                        echo "<li class='dropdown'><a class='dropdown-item' href='{$prodLink}'>{$prod['nombre']}</a></li>";
                    }
                    echo "</div>";
                }
                echo "</div>"; // fin row
                echo "</ul>";
                echo "</li>";
                return; // Finaliza la funcin para este caso
            }
        }

        // Renderizado normal (para categoras que no usan el layout especial tipopre)
        $liClass = ($hasChildren || $hasProductos) ? "nav-item dropdown" : "nav-item";
        echo "<li id='li-{$catId}' class='{$liClass}'>";
        if ($hasChildren || $hasProductos) {
            echo "<div class='d-flex align-items-center'>";
            echo "<a class='nav-link category-toggle' href='{$linkCategoria}' data-toggle='dropdown'>{$nombre}</a>";
            echo "<a class='nav-link dropdown-toggle dropdown-toggle-split hide-dropdown-toggle' href='#' role='button' data-bs-toggle='dropdown' aria-expanded='false'><span class='visually-hidden'>Toggle Dropdown</span></a>";
            echo "</div>";
            echo "<ul class='dropdown-menu'>";
            if ($hasChildren) {
                $childrenSorted = $cat['children'];
                usort($childrenSorted, function ($a, $b) {
                    global $la_Categoria;
                    return ($la_Categoria[$a]['posicion'] ?? 9999) - ($la_Categoria[$b]['posicion'] ?? 9999);
                });
                foreach ($childrenSorted as $childId) {
                    mostrar_menu($childId);
                }
            }
            if ($hasProductos) {
                $productosSorted = $cat['productos'];
                usort($productosSorted, function ($pA, $pB) {
                    $posA = $pA['posicion'] ?? 9999;
                    $posB = $pB['posicion'] ?? 9999;
                    if ($posA != $posB) {
                        return $posA - $posB;
                    }
                    return $pA['id'] - $pB['id'];
                });
                foreach ($productosSorted as $prod) {
                    $prodUrl = (!empty(trim($prod['url'] ?? ''))) ? $prod['url'] : Convertir_Url_Amigable($prod['nombre']);

                    $prodLink = $weblider . $lider . '/vp' . $prod['id'] . '/' . $idio . '/' . $prodUrl;
                    echo "<li class='dropdown'><a class='dropdown-item' href='{$prodLink}'>{$prod['nombre']}</a></li>";
                }
            }
            echo "</ul>";
        } else {
            echo "<a class='nav-link' href='{$linkCategoria}'>{$nombre}</a>";
        }
        echo "</li>";
    }

    // Ordenar las categoras de nivel 0 por posicin
    usort($la_Nivel_Menu, function ($a, $b) use ($la_Categoria) {
        return ($la_Categoria[$a]['posicion'] ?? 9999) - ($la_Categoria[$b]['posicion'] ?? 9999);
    });

    // Mostrar el men principal (por ejemplo, <ul class="navbar-nav">)
    echo $atributos_ul;
    foreach ($la_Nivel_Menu as $catId) {
        mostrar_menu($catId);
    }
    echo "\n</ul>";
}
?>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Detectar si es mvil (segn ancho de pantalla)
        const isMobile = window.matchMedia("(max-width: 991px)").matches;
        const categoriaLinks = document.querySelectorAll(".category-toggle");
        categoriaLinks.forEach(link => {
            link.addEventListener("click", function(event) {
                if (isMobile) {
                    const parent = this.closest(".nav-item.dropdown");
                    if (!parent.classList.contains("show")) {
                        event.preventDefault(); // Evita la navegacin en el primer toque
                        parent.classList.add("show");
                        const submenu = parent.querySelector(".dropdown-menu");
                        if (submenu) {
                            submenu.classList.add("show");
                        }
                    } else {
                        window.location.href = this.href;
                    }
                }
            });
        });
    });
</script>