<style>
    /* ======== ESTILOS GENERALES PARA EL MEN ======== */
    ul.navbar-nav {
        background-color: #ffffff;
        padding-left: 0;
        margin-bottom: 0;
    }

    ul.navbar-nav li {
        margin-bottom: 0 !important;
    }

    .nav-item {
        position: relative;
    }

    /* ======== GRID PARA SUBCATEGORAS ======== */
    ul.mega-grid {
        list-style: none;
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
        gap: 10px 20px;
        padding: 20px;
        margin: 0;
        width: 100%;
        box-sizing: border-box;
    }

    ul.mega-grid li {
        padding: 8px 0;
    }

    /* ======== ENLACES DEL MEN PRINCIPAL ======== */
    .nav-link {
        color: #333 !important;
        font-weight: 500;
        padding: 12px 18px;
        display: block;
        text-decoration: none;
        transition: background-color 0.2s ease, color 0.2s ease, box-shadow 0.2s ease, transform 0.2s ease;
        border-radius: 6px;
    }

    .nav-link.dropdown-toggle {
        font-size: 1.05rem;
        font-weight: bold;
        padding: 10px 15px;
    }

    /* Efecto de volumen en hover */
    .nav-item:hover>.nav-link,
    .nav-link:hover {
        background-color: #f0f0f0;
        color: #000 !important;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.08);
        /* volumen sutil */
        transform: scale(1.03);
        /* efecto de "salto suave" */
    }

    /* ======== MEN DESPLEGABLE ======== */
    .dropdown-menu {
        background-color: #fff;
        border: 1px solid #e0e0e0;
        margin-top: 0;
        display: none;
        position: absolute;
        top: 100%;
        left: 0;
        z-index: 1000;
        min-width: max-content;
        /* Se adapta al contenido */
        width: auto;
        border-radius: 6px;
        white-space: nowrap;
        /* Evita que los tems hagan salto de lnea */
    }

    .dropdown-menu.dropdown-menu-clean {
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
        box-sizing: border-box;
    }

    .dropdown-menu a {
        color: #333;
        font-size: 15px;
        padding: 10px 16px;
        display: block;
        text-decoration: none;
        transition: background-color 0.2s ease, color 0.2s ease;
    }

    .dropdown-menu li:hover {
        background-color: #f5f5f5;
    }

    .dropdown-menu li:hover>a {
        color: #000 !important;
    }

    .dropdown-menu .dropdown-item.disabled {
        color: #aaa !important;
    }

    /* ======== MEGAMEN ======== */
    .mega-menu {
        position: static;
    }

    .mega-menu .dropdown-menu {
        width: 100%;
        left: 0;
        right: 0;
        padding: 20px;
        display: none;
        position: absolute;
        border: none;
        border-radius: 0;
    }

    .mega-menu:hover .dropdown-menu {
        display: block;
    }

    .mega-menu .row {
        display: flex;
        flex-wrap: wrap;
        gap: 30px;
    }

    .col-md-5th {
        width: 33.33%;
        padding: 10px 15px;
    }

    .mega-menu li {
        padding-bottom: 12px;
    }

    .mega-menu a {
        font-weight: 500;
    }

    /* ======== RESPONSIVE (MVIL) ======== */
    @media (max-width: 991px) {
        .nav-link {
            font-size: 16px;
            padding: 14px 18px;
        }

        .dropdown-menu {
            position: static !important;
            width: 100% !important;
            border: none;
            border-radius: 0;
        }

        .mega-menu .dropdown-menu {
            padding: 10px;
        }

        .col-md-5th {
            width: 100% !important;
        }

        .mega-menu .row {
            flex-direction: column;
        }

        .dropdown-menu {
            background-color: #fff !important;
        }

        .dropdown-menu li a {
            color: #333 !important;
        }

        .navbar-nav .nav-item.active>.nav-link {
            background-color: #f0f0f0 !important;
            color: #000 !important;
        }
    }

    /* ======== UTILITARIOS ======== */
    .noList {
        list-style: none;
        padding-left: 0;
    }

    .hide {
        display: none !important;
    }

    .nav-link::after,
    .nav-item.dropdown.has-children>.nav-link::after {
        content: none !important;
    }

    .nav-item .dropdown-menu,
    .nav-item .dropdown-menu>div {
        background-color: #ccc !important;
    }
</style>



<?php
if (!function_exists('Convertir_Url_Amigable')) {
    function Convertir_Url_Amigable($lc_Cadena)
    {
        $la_Valores     = array('O', 'U', 'E', 'A', 'I', 'N', 'a', 'e', 'i', 'o', 'u', 'n', '-');
        $la_Especiales  = array('', '', '', '', '', '', '', '', '', '', '', '', ' ');
        $lc_Cadena = preg_replace("/[^\w]/", "-", strtolower(str_replace($la_Especiales, $la_Valores, trim($lc_Cadena ?? ''))));
        return $lc_Cadena;
    }
}

if (!function_exists('Diagramar_Menu')) {
    function Diagramar_Menu($lc_Id_Categoria)
    {
        global $la_Nombre_Categoria, $la_Categoria, $atributos_ul, $atributos_li, $weblider, $lider, $idio, $sesion_comprador, $sesion_usuarios_contenidos;


        $la_Categorias            = $la_Categoria[$lc_Id_Categoria];
        $la_Categorias['nombre']  = $la_Nombre_Categoria[$lc_Id_Categoria];
        $la_Categorias['solousuarios'] = 0;
        // VALIDAR QUE NO HAYA SIDO DIAGRAMADO EL ELEMENTO
        if ($la_Categorias['diagramado'] == false) {
            // ACTUALIZAR LA ACCIN DE DIAGRAMACIN
            $la_Categoria[$lc_Id_Categoria]['diagramado'] = true;


            // CREAR LA URL AMIGABLE
            $url = $la_Categorias['url'] ?? '';
            $lc_Url_Amigable_Categoria = trim($url) !== '' ? $url : Convertir_Url_Amigable($la_Categorias['nombre']);

            $la_Registro_Item = array("solousuarios" => $la_Categorias['solousuarios'], "nombre" => $la_Categorias['nombre'], 'url' => $weblider . $lider . '/pg' . $lc_Id_Categoria . '/' . $idio . '/' . $lc_Url_Amigable_Categoria, 'posicion' => $la_Categorias['posicion'], 'posicion_producto' => $la_Categorias['posicion_producto'],);


            // GENERAR LOS LI

            if ($la_Categorias['desplegar'] == 'si') {
                if (count($la_Categorias['subcategorias']) == 0) {
                    if (count($la_Categorias['productos']) == 0) {
                        // GENERAR LOS LI CERRADO
                        echo "<li id='li-1' class='dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, "<a id='a-1' class='nav-link dropdown-toggle' href='url' >nombre posicion_X</a>") . "</li>";
                    } else {
                        echo "<li id='li-2' class='dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, $atributos_li);
                        echo "\n<ul id='ul-1' class='dropdown-menu' >";
                        // ALMACENAR LOS PRODUCTOS QUE SERN LISTADOS Y EVITAR DUPLICIDAD
                        $la_Producto_Menu = array();

                        //print_r($la_Categorias['productos']);
                        foreach ($la_Categorias['productos'] as $lo_Registro) {
                            //echo "\n<li>".$lo_Registro['id'].' '.$lo_Registro['nombre']."</li>";
                            //echo "\n<li>".$lo_Registro['nombre']."</li>";

                            // EVITAR DUPLICADAD DE PRODUCTO EN LA MISMA CATEGORA    
                            if (!in_array($lo_Registro['id'], $la_Producto_Menu)) {

                                $la_Producto_Menu[] = $lo_Registro['id'];

                                // CREAR LA URL AMIGABLE
                                $url = isset($lo_Registro['url']) ? $lo_Registro['url'] : '';
                                $lc_Url_Amigable = (trim($url) !== '') ? $url : Convertir_Url_Amigable($lo_Registro['nombre']);

                                // GENERAR LOS LI
                                $la_Registro_Item = array("nombre" => $lo_Registro['nombre'], "url" => $weblider . $lider . '/vp' . $lo_Registro['id'] . '/' . $idio . '/' . $lc_Url_Amigable, 'posicion' => $lo_Registro['posicion'], 'posicion_producto' => $lo_Registro['posicion_producto']);
                                echo "<li id='li-3' class='nav-item dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, "<a id='a-3' class='nav-link ' href='url' >nombre posicion_X</a>") . "</li>";
                            }
                        }
                        echo "\n</ul></li>";
                        //echo "<br>tiene productos";
                    }
                } else {
                    $tipo = null;

                    // CONSULTAR POSICION EN BASE DE DATOS
                    $lc_Query_Posicion  = "SELECT id, tipo, ruta_imagen, subcategoria, megamenu FROM tipo_portafolio WHERE id = '" . $lc_Id_Categoria . "' ";
                    $lo_ObjetoConsulta  = HacerConsultaQuery($lc_Query_Posicion);

                    foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Posicion) {
                        if ($lo_Posicion['megamenu']  == 1) {
                            $tipo = $lo_Posicion['tipo'];
                            $img = $lo_Posicion['ruta_imagen'];
                            //echo $tipo;                      
                        }
                    }

                    //echo "Categoria: " . $la_Categorias['nombre']; 

                    //AQUI VA LAS SESIONES PARA QUE SE PUEDA IDENTIFICAR EL DEPLEGABLE Y NO DESPLEGAR CUANDO NO HAY SESION COMO ESTA EN            
                    if ($la_Registro_Item['solousuarios'] == 1 and $sesion_usuarios_contenidos != 'Y') {
                        echo "<li id='li-4' class='dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, "<a id='a-4' href='#' data-toggle='modal' data-target='#mylogueo'>nombre posicion_X</a>");
                        echo "<ul id='ul-2' class='dropdown-menu hide ' >";
                    } elseif ($la_Categorias['nombre'] == $tipo) {

                        echo "<li id='li-5' class='dropdown mega-menu nav-animate-fadeIn nav-hover-animate hover-animate-bounceIn' >" . Combinar_Registro_Plantilla($la_Registro_Item, $atributos_li);
                        echo "<ul id='ul-3' id='ancla2' class='dropdown-menu dropdown-menu-clean has-topBar ' >";
                        //echo "<li>";
                        echo "<div class='row'>";
                        //echo "<div class='col-md-5th'>";

                        echo "<ul class='mega-grid'>";
                        foreach ($la_Categorias['subcategorias'] as $d_menu) {

                            Diagramar_Menu($d_menu);
                        }
                        echo "</ul>";




                        //echo "</div>"; // col-md-5th'
                        //echo "<div class='row'>";       
                        // PRESENTAR LOS PRODUCTOS QUE SE DESPRENDEN DE LA CATEGORA
                        if (count($la_Categorias['productos']) > 0) {
                            echo "<div class='col-md-5th'>";
                            foreach ($la_Categorias['productos'] as $lo_Registro) {
                                // CREAR LA URL AMIGABLE
                                $lc_Url_Amigable  = (trim($lo_Registro['url']) != '') ? $lo_Registro['url'] : Convertir_Url_Amigable($lo_Registro['nombre']);
                                // GENERAR LOS LI
                                $la_Registro_Item = array("nombre" => $lo_Registro['nombre'], "url" => $weblider . $lider . '/vp' . $lo_Registro['id'] . '/' . $idio . '/' . $lc_Url_Amigable, 'posicion' => $lo_Registro['posicion'], 'posicion_producto' => $lo_Registro['posicion_producto']);
                                echo "<li id='li-6' class='dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, "<a id='a-6' class='nav-link' href='url' >nombre posicion_X</a>") . "</li>";
                            }
                            echo "</div>"; // col-md-5th'     
                            /*
                            echo "<div class='col-md-6th'>";
                                //echo $lo_Posicion['ruta_imagen'];
                                echo "<img style='width: 90%; margin: 0 auto; display: block; padding-bottom: 5px;' src=".$weblider."images/menu/$img >";                          
                            echo "</div>";// col-md-5th'
                            */
                        }
                        echo "</div>"; //row
                        //echo "</li>";
                    } else {
                        echo "<li id='li-7' class='nav-item dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, $atributos_li);
                        echo "<ul id='ul-4' id='base-2' class='dropdown-menu'>";

                        foreach (array_values($la_Categorias['subcategorias']) as $lc_Id_Categoria) {
                            echo Diagramar_Menu($lc_Id_Categoria);
                            //echo "<li>Pintar ".$lc_Id_Categoria."</li>";
                        }

                        // PRESENTAR LOS PRODUCTOS QUE SE DESPRENDEN DE LA CATEGORA
                        if (isset($la_Categorias['productos']) && count($la_Categorias['productos']) > 0) {
                            foreach ($la_Categorias['productos'] as $lo_Registro) {
                                // CREAR LA URL AMIGABLE
                                $lc_Url_Amigable = ($lo_Registro['url'] !== null && trim($lo_Registro['url']) != '') ? $lo_Registro['url'] : Convertir_Url_Amigable($lo_Registro['nombre']);
                                $la_Registro_Item = array(
                                    "nombre" => $lo_Registro['nombre'],
                                    "url" => $weblider . $lider . '/vp' . $lo_Registro['id'] . '/' . $idio . '/' . $lc_Url_Amigable,
                                    'posicion' => $lo_Registro['posicion'],
                                    'posicion_producto' => $lo_Registro['posicion_producto']
                                );
                                echo "<li id='li-8' class='dropdown' >" . Combinar_Registro_Plantilla($la_Registro_Item, "<a id='a-8' class='nav-link' href='url' >nombre posicion_X</a>") . "</li>";
                            }
                        }
                    }
                    //HASTA AQUI SE VALIDA LA SESIOIN DEL USUARIO Y LA VALIDACION DEL MENU SOLO PARA USUARIOS




                    //echo "</div>";
                    // FIN PRESENTAR LOS PRODUCTOS QUE SE DESPRENDEN DE LA CATEGORA
                    echo "</ul></li>";
                }
            } else {


                if ($la_Registro_Item['solousuarios'] == 1 and $sesion_usuarios_contenidos != 'Y') {
                    echo "<li id='li-9'>" . Combinar_Registro_Plantilla($la_Registro_Item, "
				 <a id='a-9' class='dropdown' href='url'>nombre posicion_X</a>") . $sesion_comprador . "\n</li>";
                } else {
                    echo "<li id='li-10' class='dropdown'>" . Combinar_Registro_Plantilla($la_Registro_Item, "<a id='a-10' class='nav-link dropdown-toggle' href='url'>nombre posicion_X</a>") . "\n</li>";
                }
                //FINALIZA LOS MENU POR SESION.
            }
        }
    }
}

if (!function_exists('Adicionar_Registro')) {
    function Adicionar_Registro($la_Arreglo, $lo_Registro)
    {

        $li_Posicion          = $lo_Registro['posicion'];
        $lc_Id_Categoria      = $lo_Registro['id_categoria'];
        $li_Posicion_Producto = $lo_Registro['posicion_producto'];

        $li_Total_Registros = count($la_Arreglo);

        //echo "<br>Adicionar [".$li_Total_Registros."] ".$lc_Id_Categoria." ".$li_Posicion."<br>";

        $la_Nuevo_Arreglo   = array();
        $lb_Ingresado       = false;

        if ($li_Total_Registros == 0) {
            $la_Nuevo_Arreglo[] = array('categoria' => $lc_Id_Categoria, 'posicion' => $li_Posicion, 'posicion_producto' => $li_Posicion_Producto, "url" => $lo_Registro['url_tipo_portafolio']);
            $lb_Ingresado       = true;
        } else {
            for ($li_Registro = 0; $li_Registro < $li_Total_Registros; $li_Registro++) {
                if ($la_Arreglo[$li_Registro]['posicion'] > $li_Posicion && $lb_Ingresado == false) {
                    $la_Nuevo_Arreglo[] = array('categoria' => $lc_Id_Categoria, 'posicion' => $li_Posicion, 'posicion_producto' => $li_Posicion_Producto, "url" => $lo_Registro['url_tipo_portafolio']);
                    $lb_Ingresado       = true;
                }
                $la_Nuevo_Arreglo[] = $la_Arreglo[$li_Registro];
            }
        }
        if ($lb_Ingresado == false) {
            $la_Nuevo_Arreglo[] = array('categoria' => $lc_Id_Categoria, 'posicion' => $li_Posicion, 'posicion_producto' => $li_Posicion_Producto, "url" => $lo_Registro['url_tipo_portafolio']);
        }

        //print_r( $la_Nuevo_Arreglo );
        //echo "<br>----------------";
        return $la_Nuevo_Arreglo;
    }

    function Adicionar_Subcategoria($la_Subcategorias, $lo_Registro, $la_Categoria)
    {
        $li_Total_Registros = count($la_Subcategorias);
        $la_Nuevo_Arreglo   = array();
        $lb_Ingresado       = false;

        if ($li_Total_Registros > 0) {

            for ($li_Registro = 0; $li_Registro < $li_Total_Registros; $li_Registro++) {
                $li_Indice_Categoria = $la_Subcategorias[$li_Registro];

                if ($la_Categoria[$li_Indice_Categoria]['posicion'] > $lo_Registro['posicion'] && $lb_Ingresado == false) {
                    $la_Nuevo_Arreglo[] = $lo_Registro['id_categoria'];
                    $lb_Ingresado       = true;
                }
                $la_Nuevo_Arreglo[] = $li_Indice_Categoria;
            }
        }
        if ($lb_Ingresado == false) {
            $la_Nuevo_Arreglo[] = $lo_Registro['id_categoria'];
        }

        return $la_Nuevo_Arreglo;
    }

    function Adicionar_Producto($la_Productos, $lo_Registro, $la_Categoria)
    {
        $li_Total_Registros = count($la_Productos);
        $la_Nuevo_Arreglo   = array();
        $lb_Ingresado       = false;

        if ($li_Total_Registros > 0) {
            for ($li_Registro = 0; $li_Registro < $li_Total_Registros; $li_Registro++) {
                if ($la_Productos[$li_Registro]['posicion_producto'] > $lo_Registro['posicion_producto'] && $lb_Ingresado == false) {
                    $la_Nuevo_Arreglo[] = array("id" => $lo_Registro['id_producto'], "nombre" => $lo_Registro['nombre_producto'], "posicion" => $lo_Registro['posicion'], "posicion_producto" => $lo_Registro['posicion_producto'], "url" => $lo_Registro['url_producto']);
                    $lb_Ingresado       = true;
                }
                $la_Nuevo_Arreglo[] = $la_Productos[$li_Registro];
            }
        }
        if ($lb_Ingresado == false) {
            $la_Nuevo_Arreglo[] = array("id" => $lo_Registro['id_producto'], "nombre" => $lo_Registro['nombre_producto'], "posicion" => $lo_Registro['posicion'], "posicion_producto" => $lo_Registro['posicion_producto'], "url" => $lo_Registro['url_producto']);
        }

        return $la_Nuevo_Arreglo;
    }
}

//if ( isset($lc_Query) && !isset($_SESSION[ $lc_Menu_Sesion ]) ) {    
if (isset($lc_Query)) {
    $lo_ObjetoConsulta  = HacerConsultaQuery($lc_Query);

    //echo $lc_Query;

    $la_Menu                = array();
    $la_Categoria           = array();
    $la_Nombre_Categoria    = array();

    $la_Productos_Categoria = array();

    $la_Opciones  = array();
    if (gettype($lo_ObjetoConsulta) == 'object' && $lo_ObjetoConsulta->DB_registros > 0) {

        // ALMACENAR LOS REGISTRO DEL NIVEL 0
        $la_Nivel_Menu = array();

        foreach ($lo_ObjetoConsulta->DB_resultado as $lo_Registro) {
            // ALMACENAR EL NOMBRE DE LA TODAS LAS CATEGORAS
            if (!in_array($lo_Registro['id_categoria'], array_keys($la_Nombre_Categoria))) {
                $la_Nombre_Categoria[$lo_Registro['id_categoria']] = $lo_Registro['nombre_categoria'];
            }

            // CREAR LA CATEGORA 
            if (!in_array($lo_Registro['id_categoria'], array_keys($la_Categoria))) {
                // CONOCER EL NIVEL
                $lc_Nivel = ($lo_Registro['id_subcategoria'] == '0') ? 0 : '';

                // ALMACENAR LOS REGISTROS CON SU ORDEN
                if ($lo_Registro['id_subcategoria'] == '0') {
                    $la_Nivel_Menu = Adicionar_Registro($la_Nivel_Menu, $lo_Registro);
                }

                //echo "<br>".$lo_Registro['nombre_categoria']." nivel ".$lc_Nivel;
                $la_Categoria[$lo_Registro['id_categoria']] = array("solousuarios" => $lo_Registro['solousuarios'], "desplegar" => $lo_Registro['desplegar'], "nivel" => $lc_Nivel, "diagramado" => false, "nombre" => $lo_Registro['nombre_categoria'], "productos" => array(), "subcategorias" => array(), "posicion" => $lo_Registro['posicion'], "posicion_producto" => $lo_Registro['posicion_producto'], "url" => $lo_Registro['url_tipo_portafolio']);
            }
            // CREAR LA SUBCATEGORA COMO UNA CATEGORA
            if ($lo_Registro['id_subcategoria'] != '0' && !in_array($lo_Registro['id_subcategoria'], array_keys($la_Categoria))) {
                $la_Categoria[$lo_Registro['id_subcategoria']]  = array("desplegar" => $lo_Registro['desplegar'], "nivel" => "", "diagramado" => false, "nombre" => $lo_Registro['nombre_categoria'], "productos" => array(), "subcategorias" => array(), "posicion" => $lo_Registro['posicion'], "posicion_producto" => $lo_Registro['posicion_producto'], "url" => $lo_Registro['url_tipo_portafolio']);
            }

            // PREGUNTAR SI POSEE PRODUCTOS ASOCIADOS, TENIENDO EN CUENTA QUE LOS PRODUCTOS PERTENECEN A LA SUBCATEGORA
            // EN CASO DE SER DIFERENTE DE 0
            if ($lo_Registro['id_subcategoria'] == '0') {
                if ($lo_Registro['id_producto'] != '') {
                    //echo "<br>adicionar producto ".$lo_Registro['nombre_producto']." a la categoria ".$lo_Registro['id_categoria'];
                    $lb_Insertar = false;
                    if (!isset($la_Productos_Categoria[$lo_Registro['id_categoria']])) {
                        $lb_Insertar = true;
                    } else {
                        if (!in_array($lo_Registro['id_producto'], $la_Productos_Categoria[$lo_Registro['id_categoria']])) {
                            $lb_Insertar = true;
                        }
                    }
                    if ($lb_Insertar == true) {
                        $la_Productos_Categoria[$lo_Registro['id_categoria']][] = $lo_Registro['id_producto'];
                        $la_Categoria[$lo_Registro['id_categoria']]['productos'][] = array("id" => $lo_Registro['id_producto'], "nombre" => $lo_Registro['nombre_producto'], "posicion" => $lo_Registro['posicion'], "posicion_producto" => $lo_Registro['posicion_producto'], "url" => $lo_Registro['url_producto']);
                    }
                }
            } else {
                // ADICIONAR LA SUBCATEGORA AL ARREGLO ASOCIATIVO DE LAS CATEGORAS
                if (!in_array($lo_Registro['id_categoria'], array_values($la_Categoria[$lo_Registro['id_subcategoria']]['subcategorias']))) {
                    // ADICIONAR LA SUBCATEGORA DE FORMA ORGANIZADA
                    $la_Categoria[$lo_Registro['id_subcategoria']]['subcategorias'] = Adicionar_Subcategoria($la_Categoria[$lo_Registro['id_subcategoria']]['subcategorias'], $lo_Registro, $la_Categoria);
                }

                //if ( $lo_Registro['id_producto_categoria'] != '' ) {                                                                
                if ($lo_Registro['id_producto'] != '') {
                    $lb_Insertar = false;
                    if (!isset($la_Productos_Categoria[$lo_Registro['id_categoria']])) {
                        $lb_Insertar = true;
                    } else {
                        if (!in_array($lo_Registro['id_producto'], $la_Productos_Categoria[$lo_Registro['id_categoria']])) {
                            $lb_Insertar = true;
                        }
                    }
                    if ($lb_Insertar == true) {
                        $la_Productos_Categoria[$lo_Registro['id_categoria']][] = $lo_Registro['id_producto'];
                        //echo "<br>adicionar producto ".$lo_Registro['nombre_producto']." a la categoria ".$lo_Registro['id_categoria'];
                        // ADICIONAR PRODUCTO
                        $la_Categoria[$lo_Registro['id_categoria']]['productos'] = Adicionar_Producto($la_Categoria[$lo_Registro['id_categoria']]['productos'], $lo_Registro, $la_Categoria);
                    }
                }
            }
        }
    }

    /*print_r( array_keys($la_Categoria) );*/
    //print_r( $la_Categoria['90'] );


    /************************************
        // INICIO: CREACIN DE MEN
     ************************************/
    //ob_start();
    $lc_Categoria_Menu = (isset($lc_Categoria_Menu)) ? $lc_Categoria_Menu : 0;

    //echo $lc_Categoria_Menu;
    //print_r( $la_Categoria['1427'] );

    if ($lc_Categoria_Menu > 0) {
        echo $atributos_ul;
        foreach ($la_Categoria[$lc_Categoria_Menu]['subcategorias'] as $lc_Id_Categoria) {
            echo Diagramar_Menu($lc_Id_Categoria);
        }

        // ADICIONAR EL ATRIBUTO U OBJETO FINAL DEL MEN
        if (isset($atributos_final_ul)) {
            echo $atributos_final_ul;
            unset($atributos_final_ul);
        }

        echo "\n</ul>";
    } else {
        echo $atributos_ul;

        if (isset($la_Nivel_Menu)) {
            //foreach ( array_keys($la_Categoria) as $lc_Id_Categoria ) {
            foreach ($la_Nivel_Menu as $lo_Registro) {
                $lc_Id_Categoria = $lo_Registro['categoria'];
                //echo "<br>[ ".$lc_Id_Categoria." ] [ ".$la_Categoria[$lc_Id_Categoria]['nivel']." ] ";

                if (is_numeric($la_Categoria[$lc_Id_Categoria]['nivel'])) {
                    echo Diagramar_Menu($lc_Id_Categoria);
                } else {
                    //echo "<br>No Diagramar [ ".$lc_Id_Categoria." ] [ ".$la_Categoria[$lc_Id_Categoria]['nivel']." ] ";
                }
            }
        }

        // ADICIONAR EL ATRIBUTO U OBJETO FINAL DEL MEN
        if (isset($atributos_final_ul)) {
            echo $atributos_final_ul;
            unset($atributos_final_ul);
        }

        echo "\n</ul>";
    }


    //print_r( $la_Nivel_Menu );

    //array_multisort($la_Categoria, SORT_ASC, SORT_STRING, $la_Nivel_Menu);
    //print_r( array_keys($la_Categoria) );
    //print_r( array_multisort($la_Nivel_Menu, SORT_ASC, SORT_STRING, $la_Nivel_Menu);

    //$lc_Menu = ob_get_contents();
    //ob_end_clean();

    //echo "<br>Cachear";
    // CACHEAR EL MEN        
    //$_SESSION[ $lc_Menu_Sesion ] = $lc_Menu;
    /************************************
        // FIN: CREACIN DE MEN
     ************************************/

    /*************************************************
        // SI NO EXISTEN DATOS DE MEN, OCULTAR LA ZONA
     *************************************************/
    if (!isset($la_Nivel_Menu)) {
        echo "<script type='text/javascript'>Ocultar_Objeto('contenedor_menu_ppal');</script>";
    }
} else {
    //echo "<br>Cacheada";
}
// PRESENTAR EL MEN CACHEADO
//echo $_SESSION[ $lc_Menu_Sesion ];

//print_r( $la_Categoria[ '421' ] );

?>