<?php

// Buscar el archivo Globales.php de forma recursiva
$lc_Path = "./siev/";
$lb_Ruta = false;
$li_Iteraciones = 0;

do {
    if (file_exists($lc_Path . "Globales.php")) {
        $lb_Ruta = true;
    } else {
        $lc_Path  = "../" . preg_replace("/^\.\//", "", $lc_Path);
    }
    $li_Iteraciones++;
} while ($lb_Ruta == false && $li_Iteraciones <= 6);

include_once $lc_Path . "Globales.php";
include_once $lc_Path . "php/Conexion_BD.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['activar']) && $_POST['activar'] == 1) {

    // Conexión
    $conn               = new ConexionMySql();
    $conexion           = $conn->DB_conexion;
    $database_conexion  = $conn->bd;

    $conversion = isset($_POST['conversion']) ? intval($_POST['conversion']) : 0;
    $tipo = "Cookie";

    $ip  = $_SERVER['REMOTE_ADDR'] ?? 'Desconocida';
    $url = $_SERVER['HTTP_REFERER'] ?? 'Desconocida';

    $latitud = $longitud = $ciudad = $region = $pais = 'Desconocido';

    $geo_url = 'http://www.geoplugin.net/php.gp?ip=' . urlencode($ip);
    $response = @file_get_contents($geo_url);

    if ($response !== false) {
        $meta = @unserialize($response);
        if (is_array($meta) && isset($meta['geoplugin_countryName'])) {
            $latitud  = $meta['geoplugin_latitude'] ?? '0.0';
            $longitud = $meta['geoplugin_longitude'] ?? '0.0';
            $ciudad   = $meta['geoplugin_city'] ?? 'Desconocida';
            $region   = $meta['geoplugin_region'] ?? 'Desconocida';
            $pais     = $meta['geoplugin_countryName'] ?? 'Desconocido';
        }
    }

    // Evitar duplicados por IP en el mismo día (opcional)
    $existe = $conexion->prepare("SELECT 1 FROM cookie_boton WHERE ip = ? AND DATE(fecha) = CURDATE()");
    $existe->bind_param("s", $ip);
    $existe->execute();
    $existe->store_result();

    if ($existe->num_rows == 0) {
        $stmt = $conexion->prepare("
            INSERT INTO cookie_boton 
            (conversion, tipo, url, ip, fecha, latitud, longitud, ciudad, region, pais) 
            VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP, ?, ?, ?, ?, ?)
        ");

        if ($stmt) {
            $stmt->bind_param(
                "issssssss",
                $conversion,
                $tipo,
                $url,
                $ip,
                $latitud,
                $longitud,
                $ciudad,
                $region,
                $pais
            );
            $stmt->execute();
            $stmt->close();
        }
    }

    $existe->close();

    http_response_code(200);
}
