<?php
require_once('../Connections/conexion.php');
require_once('../siev/php/Conexion_BD.php');

//Instanciar la variable conexion para evitar error de variable indefinida
$conn               = new ConexionMySql();
$conexion           = $conn->DB_conexion;
$database_conexion  = $conn->bd;

include('../php/escalafotos.php');

if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($conexion, $theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
  {
    $theValue = stripslashes($theValue);
    $theValue = function_exists("mysqli_real_escape_string") ? mysqli_real_escape_string($conexion, $theValue) : mysqli_escape_string($theValue);

    switch ($theType) {
      case "text":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "long":
      case "int":
        $theValue = ($theValue != "") ? intval($theValue) : "NULL";
        break;
      case "double":
        $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "NULL";
        break;
      case "date":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "defined":
        $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
        break;
    }
    return $theValue;
  }
}

$colname_clientes = "-1";

if (isset($_GET['idcliente'])) {
  $colname_clientes = $_GET['idcliente'];
}

mysqli_select_db($conexion, $database_conexion);
$query_clientes     = sprintf("SELECT * FROM clientes WHERE custom_cliente = %s", GetSQLValueString($conexion, $colname_clientes, "text"));
$clientes           = mysqli_query($conexion, $query_clientes) or die(mysqli_error($conexion));
$row_clientes       = mysqli_fetch_assoc($clientes);
$totalRows_clientes = mysqli_num_rows($clientes);

/******************************************************************
 *  REDEFINIR EL CUSTOM_DOMINIO2 CUANDO LA URL SEA 174.133.42.130
 *****************************************************************/
if (isset($row_clientes['custom_dominio2']) && preg_match("/174\.133/", $row_clientes['custom_dominio2'])) {
  $row_clientes['custom_dominio2'] = "www.todoventa.com/demo/demo/?micro=" . $row_clientes['custom_cliente'];
}


$colname_mensajes = "-1";
if (isset($_GET['idmensaje'])) {
  $colname_mensajes = $_GET['idmensaje'];
}

mysqli_select_db($conexion, $database_conexion);
$query_mensajes     = sprintf("SELECT * FROM contactenos WHERE custom_id = %s", GetSQLValueString($conexion, $colname_mensajes, "int"));
$mensajes           = mysqli_query($conexion, $query_mensajes) or die(mysqli_error($conexion));
$row_mensajes       = mysqli_fetch_assoc($mensajes);
$totalRows_mensajes = mysqli_num_rows($mensajes);

$maxRows_promocion = 3;
$pageNum_promocion = 0;

if (isset($_GET['pageNum_promocion'])) {
  $pageNum_promocion = $_GET['pageNum_promocion'];
}

$startRow_promocion = $pageNum_promocion * $maxRows_promocion;

mysqli_select_db($conexion, $database_conexion);
$query_promocion        = "SELECT * FROM productos WHERE usuario = '$row_clientes[custom_cliente]' and custom_descuento > 0 order by rand()";
$query_limit_promocion  = sprintf("%s LIMIT %d, %d", $query_promocion, $startRow_promocion, $maxRows_promocion);
$promocion              = mysqli_query($conexion, $query_limit_promocion) or die(mysqli_error($conexion));
$row_promocion          = mysqli_fetch_assoc($promocion);

if (isset($_GET['totalRows_promocion'])) {
  $totalRows_promocion = $_GET['totalRows_promocion'];
} else {
  $all_promocion = mysqli_query($conexion, $query_promocion);
  $totalRows_promocion = mysqli_num_rows($all_promocion);
}

$totalPages_promocion = ceil($totalRows_promocion / $maxRows_promocion) - 1;

?>
<html>

<head>
  <title>Mensaje de WhatsApp</title>
</head>

<body style="margin: 0; padding: 20px 0; background-color: #f0f0f0; font-family: Arial, sans-serif;">

  <table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#f0f0f0">
    <tr>
      <td align="center">
        <table width="650" border="0" cellspacing="0" cellpadding="20" style="background-color: #ffffff; border-radius: 10px; max-width: 650px;">

          <!-- Encabezado -->
          <tr>
            <td align="center" style="background-color: #EF7908; color: #000000; font-size: 20px; font-weight: bold; padding: 20px; border-top-left-radius: 10px; border-top-right-radius: 10px;">
              Alerta de WhatsApp - SIEV
            </td>
          </tr>

          <!-- Enlaces superiores -->
          <tr>
            <td align="right" style="font-size: 14px; color: #000000;">
              <a href="https://www.todoventa.com/?f_rec=1&amp;ver=1&amp;micro2=e-manage" style="color: #000000; text-decoration: none;">Recomienda nuestra pgina</a> /
              <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color: #000000; text-decoration: none;">Contctenos</a>
            </td>
          </tr>

          <!-- Logo -->
          <tr>
            <td>
              <table width="100%" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td width="50%" align="left" valign="baseline">
                    <img src="https://www.siev.co/siev13/images/logo.png" alt="SIEV" style="max-height: 60px;" />
                  </td>
                  <td width="50%">&nbsp;</td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Link alternativo -->
          <tr>
            <td style="font-size: 14px; color: #000000;">
              <a href="https://www.todoventa.com/correo/mensajes_alerta.php?idmensaje=<?php echo $row_mensajes['custom_id']; ?>&amp;idcliente=e-manage" style="color: #000000; text-decoration: none;">
                Si no visualizas bien este correo o necesitas imprimirlo, haz clic aqu
              </a>
            </td>
          </tr>

          <!-- Cuerpo del mensaje -->
          <tr>
            <td style="font-size: 14px; color: #000000; text-align: justify;">
              <p>Hola <?php echo $row_clientes['first_name']; ?> <?php echo $row_clientes['last_name']; ?>, has recibido un mensaje de WhatsApp por medio de tu sitio Web <strong><?php echo $row_clientes['custom_dominio2']; ?></strong>. Te recordamos ingresar al
                <a href="https://www.todoventa.com" style="color: #000000;">SIEV</a> e ir al rea de Mensajes para responder al usuario lo antes posible. Recuerda que es importante ser oportuno con las respuestas.
              </p>
            </td>
          </tr>

          <!-- Detalles del mensaje -->
          <tr>
            <td style="font-size: 14px; color: #000000; text-align: justify;">
              <p><strong>El mensaje depositado es el siguiente:</strong></p>
              <p>
                <strong>Asunto:</strong> <?php echo $row_mensajes['custom_asunto']; ?><br />
                <strong>Mensaje:</strong> <?php echo $row_mensajes['custom_mensaje']; ?>
              </p>
              <p>
                <strong>Nombre del Contacto:</strong> <?php echo $row_mensajes['custom_nombre']; ?><br />
                <strong>E-Mail:</strong> <?php echo $row_mensajes['custom_email']; ?><br />
                <strong>Telfono:</strong> <?php echo $row_mensajes['custom_tel']; ?>
              </p>
            </td>
          </tr>

          <!-- Promociones -->
          <?php if ($totalRows_promocion > 0) { ?>
            <?php do { ?>
              <!-- Aqu se pueden insertar promociones si es necesario -->
            <?php } while ($row_promocion = mysqli_fetch_assoc($promocion)); ?>
          <?php } ?>

          <!-- Despedida -->
          <tr>
            <td style="font-size: 14px; color: #000000;">
              Atentamente,<br /><br />
              rea de Servicio al Cliente<br />
              Web: <a href="https://www.todoventa.com" style="color: #000000;">https://www.todoventa.com</a><br />
              Email: <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color: #000000;">servicioalcliente@todoventa.com</a>
            </td>
          </tr>

          <!-- Enlaces inferiores -->
          <tr>
            <td align="right" style="font-size: 14px; color: #000000;">
              <a href="https://www.todoventa.com/?f_rec=1&amp;ver=1&amp;micro2=e-manage" style="color: #000000; text-decoration: none;">Recomienda nuestra pgina</a> /
              <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color: #000000; text-decoration: none;">Contctanos</a>
            </td>
          </tr>

        </table>
      </td>
    </tr>
  </table>

</body>

</html>


<?php
mysqli_free_result($clientes);
mysqli_free_result($mensajes);
mysqli_free_result($promocion);
?>