<?php
require_once('../Connections/conexion.php');
require_once('../siev/php/Conexion_BD.php');
//Instanciar la variable conexion para evitar error de variable indefinida
$conn               = new ConexionMySql();
$conexion           = $conn->DB_conexion;
$database_conexion  = $conn->bd;

include('../php/escalafotos.php');

if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($conexion, $theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
  {
    $theValue = stripslashes($theValue);
    $theValue = function_exists("mysqli_real_escape_string") ? mysqli_real_escape_string($conexion, $theValue) : mysqli_escape_string($theValue);

    switch ($theType) {
      case "text":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "long":
      case "int":
        $theValue = ($theValue != "") ? intval($theValue) : "NULL";
        break;
      case "double":
        $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "NULL";
        break;
      case "date":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "defined":
        $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
        break;
    }
    return $theValue;
  }
}

$colname_clientes = "-1";

if (isset($_GET['idcliente'])) {
  $colname_clientes = $_GET['idcliente'];
}

mysqli_select_db($conexion, $database_conexion);
$query_clientes     = sprintf("SELECT * FROM clientes WHERE custom_cliente = %s", GetSQLValueString($conexion, $colname_clientes, "text"));
$clientes           = mysqli_query($conexion, $query_clientes) or die(mysqli_error($conexion));
$row_clientes       = mysqli_fetch_assoc($clientes);
$totalRows_clientes = mysqli_num_rows($clientes);

/******************************************************************
 *  REDEFINIR EL CUSTOM_DOMINIO2 CUANDO LA URL SEA 174.133.42.130
 *****************************************************************/
//if ( isset( $row_clientes['custom_dominio2'] ) && preg_match("/174\.133/",$row_clientes['custom_dominio2']) ) { $row_clientes['custom_dominio2'] = "www.todoventa.com/demo/demo/?micro=".$row_clientes['custom_cliente']; }


$colname_mensajes = "-1";
if (isset($_GET['idmensaje'])) {
  $colname_mensajes = $_GET['idmensaje'];
}

mysqli_select_db($conexion, $database_conexion);
$query_mensajes     = sprintf("SELECT * FROM sugerencias WHERE custom_id = %s", GetSQLValueString($conexion, $colname_mensajes, "int"));
$mensajes           = mysqli_query($conexion, $query_mensajes) or die(mysqli_error($conexion));
$row_mensajes       = mysqli_fetch_assoc($mensajes);
$totalRows_mensajes = mysqli_num_rows($mensajes);

$maxRows_promocion = 3;
$pageNum_promocion = 0;

if (isset($_GET['pageNum_promocion'])) {
  $pageNum_promocion = $_GET['pageNum_promocion'];
}

$startRow_promocion = $pageNum_promocion * $maxRows_promocion;

mysqli_select_db($conexion, $database_conexion);
$query_promocion        = "SELECT * FROM productos WHERE usuario = '$row_clientes[custom_cliente]' and custom_descuento > 0 order by rand()";
$query_limit_promocion  = sprintf("%s LIMIT %d, %d", $query_promocion, $startRow_promocion, $maxRows_promocion);
$promocion              = mysqli_query($conexion, $query_limit_promocion) or die(mysqli_error($conexion));
$row_promocion          = mysqli_fetch_assoc($promocion);

if (isset($_GET['totalRows_promocion'])) {
  $totalRows_promocion = $_GET['totalRows_promocion'];
} else {
  $all_promocion = mysqli_query($conexion, $query_promocion);
  $totalRows_promocion = mysqli_num_rows($all_promocion);
}

$totalPages_promocion = ceil($totalRows_promocion / $maxRows_promocion) - 1;

?>

<html>

<head>
  <title>Mensaje de Alerta</title>
</head>

<body style="margin: 0; padding: 20px 0; background-color: #f0f0f0; font-family: Arial, sans-serif;">

  <table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#f0f0f0">
    <tr>
      <td align="center">
        <table width="650" border="0" cellspacing="0" cellpadding="20" style="background-color: #ffffff; border-radius: 10px;">

          <!-- Encabezado -->
          <tr>
            <td align="center" style="background-color: #EF7908; color: #000000; font-size: 18px; font-weight: bold; padding: 20px; border-radius: 10px 10px 0 0;">
              Has recibido una sugerencia - SIEV
            </td>
          </tr>

          <!-- Enlaces ocultos superiores -->
          <tr style="display: none;">
            <td align="right" style="font-size: 14px;">
              <a href="https://www.todoventa.com/?f_rec=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Recomienda nuestra pgina</a> /
              <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Contctenos</a>
            </td>
          </tr>

          <!-- Logo -->
          <tr>
            <td>
              <table width="100%" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td width="50%" align="left" valign="baseline">
                    <img src="https://www.siev.co/siev13/images/logo.png" alt="SIEV" style="max-height: 60px;" />
                  </td>
                  <td width="50%">&nbsp;</td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Mensaje principal -->
          <tr>
            <td style="font-size: 14px; color: #000000; text-align: justify;">
              <p>
                Hola <?php echo $row_clientes['first_name']; ?> <?php echo $row_clientes['last_name']; ?>, has recibido una sugerencia por medio de tu sitio Web
                <a href="https://<?php echo $row_clientes['custom_dominio2']; ?>" style="color:#007BFF;">
                  <?php echo $row_clientes['custom_dominio2']; ?>
                </a>.
                Te recordamos ingresar al <a href="https://www.siev.com" style="color:#007BFF;">SIEV</a>, ir al rea de sugerencias y responder al usuario lo antes posible. Recuerda que es importante ser oportuno con las respuestas.
              </p>
            </td>
          </tr>

          <!-- Contenido de la sugerencia -->
          <tr>
            <td style="font-size: 14px; color: #000000; text-align: justify;">
              <p><strong>Sugerencia depositada:</strong></p>
              <p>
                <strong>Asunto:</strong> <?php echo $row_mensajes['custom_asunto']; ?><br />
                <strong>Sugerencia:</strong> <?php echo $row_mensajes['custom_mensaje']; ?>
              </p>
              <p>
                <strong>Los datos de la sugerencia son los siguientes:</strong><br /><br />
                <strong>Nombre del Contacto:</strong> <?php echo $row_mensajes['custom_nombre']; ?><br />
                <strong>E-Mail:</strong> <?php echo $row_mensajes['custom_email']; ?><br />
                <strong>Telfono:</strong> <?php echo $row_mensajes['custom_tel']; ?><br />
                <strong>Pas:</strong> <?php echo $row_mensajes['custom_pais']; ?><br />
                <strong>Ciudad:</strong> <?php echo $row_mensajes['custom_ciudad']; ?>
              </p>
            </td>
          </tr>

          <!-- Promociones -->
          <?php if ($totalRows_promocion > 0) { ?>
            <?php do { ?>
              <!-- Aqu podras mostrar contenido promocional si lo deseas -->
            <?php } while ($row_promocion = mysqli_fetch_assoc($promocion)); ?>
          <?php } ?>

          <!-- Enlaces ocultos inferiores -->
          <tr style="display: none;">
            <td align="right" style="font-size: 14px;">
              <a href="https://www.todoventa.com/?f_rec=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Recomienda nuestra pgina</a> /
              <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Contctanos</a>
            </td>
          </tr>

          <!-- Descargo de responsabilidad -->
          <tr>
            <td style="font-size: 12px; color: #666666; text-align: justify;">
              El presente mensaje, as como sus anexos, son propiedad de SIEV y pueden contener informacin privilegiada y confidencial.
              El destinatario podr usar el mensaje y la informacin en l contenida exclusivamente para el fin para el cual le fue remitido;
              el uso, copia, distribucin o divulgacin con cualquier otro propsito est prohibido. La informacin de tipo personal no relacionada
              con la actividad y gestin de SIEV no compromete su responsabilidad. Si por error recibe este mensaje, por favor destruya su contenido y avise a su remitente.
            </td>
          </tr>

          <!-- Espaciado final -->
          <tr>
            <td style="padding: 10px;"></td>
          </tr>

        </table>
      </td>
    </tr>
  </table>

</body>

</html>


<?php
mysqli_free_result($clientes);
mysqli_free_result($mensajes);
mysqli_free_result($promocion);
?>