<?php

require_once('../Connections/conexion.php');
require_once('../siev/php/Conexion_BD.php');
//Instanciar la variable conexion para evitar error de variable indefinida
$conn               = new ConexionMySql();
$conexion           = $conn->DB_conexion;
$database_conexion  = $conn->bd;

if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($conexion, $theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
  {
    $theValue = stripslashes($theValue);

    $theValue = function_exists("mysqli_real_escape_string") ? mysqli_real_escape_string($conexion, $theValue) : mysqli_escape_string($theValue);

    switch ($theType) {
      case "text":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "long":
      case "int":
        $theValue = ($theValue != "") ? intval($theValue) : "NULL";
        break;
      case "double":
        $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "NULL";
        break;
      case "date":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "defined":
        $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
        break;
    }
    return $theValue;
  }
}

$colname_clientes = "-1";
if (isset($_GET['idcliente'])) {
  $colname_clientes = $_GET['idcliente'];
}

mysqli_select_db($conexion, $database_conexion);
$query_clientes     = sprintf("SELECT * FROM clientes WHERE custom_cliente = %s", GetSQLValueString($conexion, $colname_clientes, "text"));
$clientes           = mysqli_query($conexion, $query_clientes) or die(mysqli_error($conexion));
$row_clientes       = mysqli_fetch_assoc($clientes);
$totalRows_clientes = mysqli_num_rows($clientes);

$colname_productos = "-1";
if (isset($_GET['producto'])) {
  $colname_productos = $_GET['producto'];
}

mysqli_select_db($conexion, $database_conexion);
$query_productos      = sprintf("SELECT * FROM productos WHERE custom_idproducto = %s", GetSQLValueString($conexion, $colname_productos, "int"));
$productos            = mysqli_query($conexion, $query_productos) or die(mysqli_error($conexion));
$row_productos        = mysqli_fetch_assoc($productos);
$totalRows_productos  = mysqli_num_rows($productos);

$colname_preguntas = "-1";
if (isset($_GET['idpregunta'])) {
  $colname_preguntas = $_GET['idpregunta'];
}

mysqli_select_db($conexion, $database_conexion);
$query_preguntas      = sprintf("SELECT * FROM preguntasprod WHERE custom_idpregunta = %s", GetSQLValueString($conexion, $colname_preguntas, "int"));
$preguntas            = mysqli_query($conexion, $query_preguntas) or die(mysqli_error($conexion));
$row_preguntas        = mysqli_fetch_assoc($preguntas);
$totalRows_preguntas  = mysqli_num_rows($preguntas);

$maxRows_promocion = 3;
$pageNum_promocion = 0;
if (isset($_GET['pageNum_promocion'])) {
  $pageNum_promocion = $_GET['pageNum_promocion'];
}
$startRow_promocion = $pageNum_promocion * $maxRows_promocion;

mysqli_select_db($conexion, $database_conexion);
$query_promocion        = "SELECT * FROM productos WHERE usuario = '$row_clientes[custom_cliente]' and custom_descuento > 0 order by rand()";
$query_limit_promocion  = sprintf("%s LIMIT %d, %d", $query_promocion, $startRow_promocion, $maxRows_promocion);
$promocion              = mysqli_query($conexion, $query_limit_promocion) or die(mysqli_error($conexion));
$row_promocion          = mysqli_fetch_assoc($promocion);

if (isset($_GET['totalRows_promocion'])) {
  $totalRows_promocion  = $_GET['totalRows_promocion'];
} else {
  $all_promocion        = mysqli_query($conexion, $query_promocion);
  $totalRows_promocion  = mysqli_num_rows($all_promocion);
}
$totalPages_promocion = ceil($totalRows_promocion / $maxRows_promocion) - 1;
?>
<!DOCTYPE html>
<html lang="es">

<head>
  <meta charset="UTF-8">
  <title>Mensaje de Alerta - Pregunta Recibida</title>
</head>

<body style="margin: 0; padding: 20px 0; background-color: #f0f0f0; font-family: Arial, sans-serif;">

  <!-- Contenedor externo gris -->
  <table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#f0f0f0">
    <tr>
      <td align="center">

        <!-- Contenedor blanco central -->
        <table width="650" border="0" cellspacing="0" cellpadding="20"
          style="background-color: #ffffff; border-radius: 10px; max-width: 650px;">

          <!-- Encabezado naranja -->
          <tr>
            <td align="center" style="background-color: #EF7908; color: #000000; font-size: 20px; font-weight: bold; padding: 20px; border-top-left-radius: 10px; border-top-right-radius: 10px;">
              Pregunta Recibida - SIEV
            </td>
          </tr>

          <!-- Enlaces superiores ocultos -->
          <tr style="display: none;">
            <td align="right" style="font-size: 14px;">
              <a href="https://www.todoventa.com/?f_rec=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Recomienda nuestra pgina</a> /
              <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Contctenos</a>
            </td>
          </tr>

          <!-- Fecha y logo -->
          <tr>
            <td>
              <table width="100%" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td width="50%" align="left" valign="baseline">
                    <img src="https://www.siev.co/siev13/images/logo.png" alt="SIEV" style="max-height: 60px;" />
                  </td>
                  <td width="50%">&nbsp;</td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Mensaje principal -->
          <tr>
            <td style="font-size: 14px; color: #000000; text-align: justify;">
              <p>
                Hola <?php echo $row_clientes['first_name']; ?> <?php echo $row_clientes['last_name']; ?>,
              </p>
              <p>
                Se ha recibido una pregunta sobre <strong><?php echo $row_productos['custom_nombrepro']; ?></strong>
                a travs de tu sitio web
                <a href="https://<?php echo $row_clientes['custom_dominio2']; ?>" style="color:#007BFF;"><?php echo $row_clientes['custom_dominio2']; ?></a>.
              </p>
              <p>
                Te recordamos ingresar al <a href="https://www.siev.com" style="color:#007BFF;">SIEV</a> e ir al rea de Preguntas para responder lo antes posible.
                Recuerda que es importante ser oportuno con las respuestas.
              </p>
            </td>
          </tr>

          <!-- Detalles de la pregunta -->
          <tr>
            <td style="font-size: 14px; color: #000000; text-align: justify;">
              <p><strong>La pregunta realizada es la siguiente:</strong></p>

              <p>
                <strong>Nombre de quien pregunta:</strong> <?php echo $row_preguntas['custom_nombre']; ?><br>
                <strong>Email:</strong> <?php echo $row_preguntas['email']; ?><br>
                <strong>Elemento de inters:</strong> <?php echo $row_productos['custom_nombrepro']; ?><br>
                <strong>Pregunta realizada:</strong><br>
                <?php echo $row_preguntas['custom_pregunta']; ?>
              </p>
            </td>
          </tr>

          <!-- Promociones si existen -->
          <?php if ($totalRows_promocion > 0) { ?>
            <?php do { ?>
              <!-- Aqu podras incluir la promocin -->
            <?php } while ($row_promocion = mysqli_fetch_assoc($promocion)); ?>
          <?php } ?>

          <!-- Enlaces inferiores ocultos -->
          <tr style="display: none;">
            <td align="right" style="font-size: 14px;">
              <a href="https://www.todoventa.com/?f_rec=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Recomienda nuestra pgina</a> /
              <a href="https://www.todoventa.com/?f_contacto=1&amp;ver=1&amp;micro2=e-manage" style="color:#000000;">Contctanos</a>
            </td>
          </tr>

          <!-- Aviso legal -->
          <tr>
            <td style="font-size: 12px; color: #666666; text-align: justify; padding-top: 20px;">
              El presente mensaje, as como sus anexos, son propiedad de SIEV y pueden contener informacin privilegiada y confidencial.
              El destinatario podr usar el mensaje y la informacin en l contenida exclusivamente para el fin para el cual le fue remitido;
              el uso, copia, distribucin o divulgacin con cualquier otro propsito est prohibido.
              La informacin de tipo personal no relacionada con la actividad y gestin de SIEV no compromete su responsabilidad.
              Si por error recibe este mensaje, por favor destruya su contenido y avise a su remitente.
            </td>
          </tr>

        </table>
      </td>
    </tr>
  </table>

</body>

</html>


<?php
mysqli_free_result($clientes);
mysqli_free_result($productos);
mysqli_free_result($preguntas);
mysqli_free_result($promocion);
?>