<?php 
    require_once('../Connections/conexion.php');
require_once('../siev/php/Conexion_BD.php');
    //Instanciar la variable conexion para evitar error de variable indefinida
    $conn               = new ConexionMySql();
    $conexion           = $conn->DB_conexion;
    $database_conexion  = $conn->bd;

    //include('../php/escalafotos.php');

    error_reporting(0);
    ini_set('display_errors','On');

    /********************************************************************************
    // FUNCIN QUE PERMITE COMBINAR UNA PLANTILLA HTML CON UN ARREGLO ASOCIATIVO
    ********************************************************************************/
    function Combinar_Registro_Plantilla ($row,$lc_Html) {
        $lb_Encontrado = false;
        
        // REEMPLAZAR LOS CARACTERES DE APERTURA Y CIERRE POR LOS TAGS   
        $lc_Html = str_replace("&raquo;","", str_replace("&laquo;","",$lc_Html) );
        
        if (preg_match_all("/\([0-9a-z\_]{1,})\/i",$lc_Html,$la_Atributos)) { $lb_Encontrado = true; array_shift($la_Atributos);	}
        	
        if ($lb_Encontrado == true) {
        		$li_Total_Atributos = count($la_Atributos[0]);
        		for ($li_Atributo=0; $li_Atributo < $li_Total_Atributos; $li_Atributo++) {
          			$lc_Atributo = $la_Atributos[0][$li_Atributo];
          			if ( in_array( $lc_Atributo, array_keys($row) ) ) {
                    $lc_Html = preg_replace("/\".$lc_Atributo."\/i",$row[$lc_Atributo],$lc_Html);
                } else {
                    //print_r( array_keys($row) ); 
                }
        		}
            // LIMPIAR LAS REFERENCIAS NULAS
            $lc_Html = preg_replace("/\[A-z]{1,}\/i","",$lc_Html);
        }
        return $lc_Html;
    }
    

     if (!function_exists("GetSQLValueString")) {
        function GetSQLValueString($conexion, $theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
          $theValue = stripslashes($theValue);
        
          $theValue = function_exists("mysqli_real_escape_string") ? mysqli_real_escape_string($conexion,$theValue) : mysqli_escape_string($theValue);
        
          switch ($theType) {
              case "text"   : $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;    
              case "long"   : 
              case "int"    : $theValue = ($theValue != "") ? intval($theValue) : "NULL"; break;
              case "double" : $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "NULL"; break;
              case "date"   : $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
              case "defined": $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue; break;
          }
          return $theValue;
        }
    }

    $colname_clientes = "-1";
    if (isset($_GET['micro2'])) { $colname_clientes = $_GET['micro2']; }

    mysqli_select_db($conexion,$database_conexion);

    $query_clientes     = sprintf("SELECT *, custom_empresa as custom_nombre_empresa, ruta_imagen as ruta_cliente, first_name as first_name_empresa, last_name as last_name_empresa, custom_telemp as custom_telemp_empresa, custom_diremp as custom_diremp_empresa, email as email_empresa, custom_celemp as custom_celemp_empresa FROM clientes WHERE custom_cliente = %s", GetSQLValueString($conexion,$colname_clientes, "text"));
    $clientes           = mysqli_query($conexion,$query_clientes) or die(mysqli_error($conexion));
    $row_clientes       = mysqli_fetch_assoc($clientes);
    $totalRows_clientes = mysqli_num_rows($clientes);

    $maxRows_promocion = 3;
    $pageNum_promocion = 0;

    if (isset($_GET['pageNum_promocion'])) { $pageNum_promocion = $_GET['pageNum_promocion']; }

    $startRow_promocion = $pageNum_promocion * $maxRows_promocion;

    mysqli_select_db($conexion,$database_conexion);
    $query_promocion        = "SELECT * FROM productos WHERE usuario = '".$row_clientes['custom_cliente']."' and custom_descuento > 0 order by rand()";
    $query_limit_promocion  = sprintf("%s LIMIT %d, %d", $query_promocion, $startRow_promocion, $maxRows_promocion);
    $promocion              = mysqli_query($conexion,$query_limit_promocion) or die(mysqli_error($conexion));
    $row_promocion          = mysqli_fetch_assoc($promocion);

    if (isset($_GET['totalRows_promocion'])) {
        $totalRows_promocion = $_GET['totalRows_promocion'];
    } else {
        $all_promocion = mysqli_query($conexion,$query_promocion);
        $totalRows_promocion = mysqli_num_rows($all_promocion);
    }
    $totalPages_promocion = ceil($totalRows_promocion/$maxRows_promocion)-1;

    // ALMACENAR LAS DIFERENTES PROMOCIONES
    $la_Item_Promocion      = array();
    
    if ($totalRows_promocion > 0) {
        $lc_Plantilla_Item_Promocion = file_get_contents($weblider."/".$row_clientes['plantillaje']."/"."comunicaciones/plantilla_boletin.html");        
        $la_Registro_Promocion  = array();
        do {
            $la_Registro_Promocion = $row_promocion;
            $la_Registro_Promocion['custom_dominio2'] = $row_clientes['custom_dominio2'];
            
            $la_Item_Promocion[] = Combinar_Registro_Plantilla( $la_Registro_Promocion,$lc_Plantilla_Item_Promocion );
              
        } while ($row_promocion = mysqli_fetch_assoc($promocion));
    }

    mysqli_select_db($conexion,$database_conexion);
    $query_usuarios     = "SELECT *, email as email_usuario FROM usuarios WHERE custom_id = $_GET[usuario]";
    $usuarios           = mysqli_query($conexion,$query_usuarios) or die(mysqli_error($conexion));
    $row_usuarios       = mysqli_fetch_assoc($usuarios);
    $totalRows_usuarios = mysqli_num_rows($usuarios);

    mysqli_select_db($conexion,$database_conexion);
    $query_contenidos     = "SELECT custom_idproducto, FCKeditor1 FROM productos WHERE custom_idproducto = '$_GET[contenido]'";
    $contenidos           = mysqli_query($conexion,$query_contenidos) or die(mysqli_error($conexion));
    $row_contenidos       = mysqli_fetch_assoc($contenidos);
    $totalRows_contenidos = mysqli_num_rows($contenidos);

    // COMBINAR LOS ARREGLOS DE CLIENTES Y USUARIOS
    $la_Registro        = array_merge($row_clientes,$row_usuarios,$row_contenidos);
    // SI EL CLIENTE NO POSEE LOGO
    if ( $row_clientes['ruta_cliente'] == "") { $row_clientes['ver_logo'] = "display:none;"; }
    // SI EXISTEN PROMOCIONES
    $la_Registro['lista_promociones'] = implode("",$la_Item_Promocion);
    // FECHA ACTUAL
    $la_Registro['custom_fecha']      = date('Y-m-d H:i:s');
    
    $lc_Plantilla_Boletin = file_get_contents( $weblider."/plantillas/comunicaciones/plantilla_boletin.html");

    $la_Registro['dominio_imagen']    = $la_Registro['custom_dominio2'];
    $la_Registro['custom_dominio2']   = ( preg_match("/www\./i",$la_Registro['custom_dominio2']) ) ? $la_Registro['custom_dominio2'] : "www.todoventa.com";
    // ALMACENAR EL CDIGO DEL CONTENIDO
    $la_Registro['custom_idproducto'] = $row_contenidos['custom_idproducto'];
    // ALMACENAR EL CDIGO DEL BOLETIN
    $la_Registro['boletin']           = ( isset($_GET['boletin']) ) ? $_GET['boletin'] : '';

    echo Combinar_Registro_Plantilla( $la_Registro,$lc_Plantilla_Boletin );    

    mysqli_free_result($clientes);
    mysqli_free_result($promocion);
    mysqli_free_result($usuarios);
    mysqli_free_result($contenidos);
?>
