<?php

class MultiContacto
{
  private $numerosPorCiudad;
  private $archivoIndices;

  public function __construct($numerosPorCiudad, $archivoIndices = 'indices_ciudades')
  {
    $this->numerosPorCiudad = $numerosPorCiudad;

    // Normalizar las claves para el nombre del archivo
    $clavesNormalizadas = $this->normalizarClaves($numerosPorCiudad);
    $this->archivoIndices = $archivoIndices . '_' . md5(json_encode(array_keys($clavesNormalizadas))) . '.txt';

    // Reemplazar numerosPorCiudad con las claves normalizadas
    $this->numerosPorCiudad = $clavesNormalizadas;

    if (!isset($_SESSION)) {
      session_start();
    }

    if (!isset($_SESSION['telefonos_multicontacto']) || !is_array($_SESSION['telefonos_multicontacto'])) {
      $_SESSION['telefonos_multicontacto'] = [];
    }
  }


  private function normalizarClaves($array)
  {
    $clavesNormalizadas = array_map(function ($clave) {
      // Asegurarse de que la cadena est en UTF-8
      if (mb_detect_encoding($clave, 'UTF-8', true) !== 'UTF-8') {
        $clave = mb_convert_encoding($clave, 'UTF-8');
      }
      // Convertir a ASCII eliminando tildes y caracteres especiales
      $claveNormalizada = @iconv('UTF-8', 'ASCII//TRANSLIT', $clave);
      // Si iconv falla, usar una alternativa simple
      if ($claveNormalizada === false) {
        $claveNormalizada = preg_replace('/[^A-Za-z0-9]/', '_', $clave);
      } else {
        // Reemplazar espacios y caracteres no alfanumricos con guiones bajos
        $claveNormalizada = preg_replace('/[^A-Za-z0-9]/', '_', $claveNormalizada);
      }
      return $claveNormalizada;
    }, array_keys($array));

    return array_combine($clavesNormalizadas, array_values($array));
  }



  private function leerIndices()
  {
    if (!file_exists($this->archivoIndices)) {
      $indices = array_fill_keys(array_keys($this->numerosPorCiudad), 0);
      $this->guardarIndices($indices);
    } else {
      $contenido = file_get_contents($this->archivoIndices);
      $indices = json_decode($contenido, true);

      if (!is_array($indices)) {
        $indices = array_fill_keys(array_keys($this->numerosPorCiudad), 0);
        $this->guardarIndices($indices);
      }
    }

    // Asegurar que todas las ciudades tengan un ndice inicializado
    foreach ($this->numerosPorCiudad as $ciudad => $numeros) {
      if (!isset($indices[$ciudad])) {
        $indices[$ciudad] = 0;
      }
    }

    return $indices;
  }

  private function guardarIndices($indices)
  {
    file_put_contents($this->archivoIndices, json_encode($indices));
  }

  private function asignarNumero($ciudad, &$indices)
  {
    if (!isset($this->numerosPorCiudad[$ciudad])) {
      throw new Exception("Ciudad no vlida: $ciudad");
    }

    $numerosDeCiudad = $this->numerosPorCiudad[$ciudad];

    if (!is_array($numerosDeCiudad)) {
      throw new Exception("Error: Los nmeros para la ciudad $ciudad no son un array vlido.");
    }

    $indiceActual = (int)$indices[$ciudad];

    if (!array_key_exists($indiceActual, $numerosDeCiudad)) {
      throw new Exception("Error: ndice fuera de rango para la ciudad $ciudad.");
    }

    $numeroAsignado = $numerosDeCiudad[$indiceActual];

    // Actualizar ndice para la prxima solicitud
    $indices[$ciudad] = ($indiceActual + 1) % count($numerosDeCiudad);

    return $numeroAsignado;
  }

  public function generarNumeros()
  {
    $indices = $this->leerIndices();
    $resultados = [];

    foreach ($this->numerosPorCiudad as $ciudad => $numeros) {
      try {
        $numeroAsignado = $this->asignarNumero($ciudad, $indices);
        $_SESSION['telefonos_multicontacto'][$ciudad] = $numeroAsignado;
        $resultados[$ciudad] = $numeroAsignado;
      } catch (Exception $e) {
        $resultados[$ciudad] = "Error: " . $e->getMessage();
      }
    }

    $this->guardarIndices($indices);

    return $resultados;
  }
}




// Ejemplo de uso
$numerosPorCiudad = [
  'bogota' => [
    '+573111111110',
    '+573111111111',
    '+573111111112',
    '+573111111113',
    '+573111111114',
    '+573111111115',
    '+573111111116',
    '+573111111117',
    '+573111111118',
    '+573111111119'
  ],
  'medellin' => [
    '+573222222200',
    '+573222222201',
    '+573222222202',
    '+573222222203',
    '+573222222204',
    '+573222222205',
    '+573222222206',
    '+573222222207',
    '+573222222208'
  ],
  'cali' => [
    '+573333333300',
    '+573333333301',
    '+573333333302',
    '+573333333303',
    '+573333333304',
    '+573333333305',
    '+573333333306',
    '+573333333307'
  ],
  'barranquilla' => [
    '+573444444400',
    '+573444444401',
    '+573444444402',
    '+573444444403',
    '+573444444404',
    '+573444444405',
    '+573444444406'
  ],
  'cartagena' => [
    '+573555555500',
    '+573555555501',
    '+573555555502',
    '+573555555503',
    '+573555555504',
    '+573555555505'
  ],
  'bucaramanga' => [
    '+573666666600',
    '+573666666601',
    '+573666666602',
    '+573666666603',
    '+573666666604'
  ]
];



// $numerosPorCiudad = [
//   'Solicitar visita' => [
//     '573175555555', // Diego Trujillo
//   ],
// ];

$multiContacto = new MultiContacto($numerosPorCiudad);
$resultados = $multiContacto->generarNumeros();



// ENVIO DIRECTO A WHATSAPP POR MEDIO DE MODAL Y TOMA DE DATOS

// Generar el cdigo HTML con los enlaces de las ciudades y los nmeros asignados

$la_Registro['whatsapp_multicontacto'] = '<div id="ciudades-container" class="ciudades-container">';
foreach ($resultados as $ciudad => $numero) {
  // Si hubo un error al asignar el nmero, no agregar el enlace
  if (strpos($numero, 'Error') === 0) {
    continue;
  }
  $ciudadNombre = ucfirst($ciudad);
  $la_Registro['whatsapp_multicontacto'] .= "<a id=\"whatsapp\" href=\"#whatsapp_modal\" data-city=\"$ciudad\" data-phone=\"$numero\" data-bs-toggle=\"modal\" data-view=\"#modal-signin-view\">";
  $la_Registro['whatsapp_multicontacto'] .= "$ciudadNombre <i class=\"fab fa-whatsapp icon-whatsapp\"></i>";
  $la_Registro['whatsapp_multicontacto'] .= "</a>";
}
$la_Registro['whatsapp_multicontacto'] .= '</div>';


$row_micros['whatsapp_multicontacto'] = $la_Registro['whatsapp_multicontacto'];
// echo $row_micros['whatsapp_multicontacto'];





// ENVIO DIRECTO LLAMADA TELEFONICA

// Generar el cdigo HTML con los enlaces de las ciudades y los nmeros asignados para llamadas directas

$la_Registro['call_multicontacto'] = '<div id="ciudades-container" class="ciudades-container">';

foreach ($resultados as $ciudad => $numero) {
  // Si hubo un error al asignar el nmero, no agregar el enlace
  if (strpos($numero, 'Error') === 0) {
    continue;
  }

  $ciudadNombre = ucfirst($ciudad);
  $la_Registro['call_multicontacto'] .= "<a id=\"movil\" href=\"tel:$numero\" class=\"call-link\">";
  $la_Registro['call_multicontacto'] .= "$ciudadNombre - $numero <i class=\"fas fa-phone icon-call\"></i>";
  $la_Registro['call_multicontacto'] .= "</a>";
}

$la_Registro['call_multicontacto'] .= '</div>';

// Asignar el HTML al array de resultados y mostrarlo
$row_micros['call_multicontacto'] = $la_Registro['call_multicontacto'];
// echo $row_micros['call_multicontacto'];







// ENVIO DIRECTO A WHATSAPP

// Generar el cdigo HTML con los enlaces de las ciudades y los nmeros asignados para WhatsApp

$la_Registro['whatsapp_multicontacto_directo'] = '<div id="ciudades-container" class="ciudades-container">';

foreach ($resultados as $ciudad => $numero) {
  // Si hubo un error al asignar el nmero, no agregar el enlace
  if (strpos($numero, 'Error') === 0) {
    continue;
  }

  $ciudadNombre = ucfirst($ciudad);

  // Formato del enlace de WhatsApp
  $mensaje = rawurlencode("Hola. Estoy interesado en conocer acerca de sus servicios.");
  $la_Registro['whatsapp_multicontacto_directo'] .= "<a href=\"https://wa.me/$numero?text=$mensaje\" target=\"_blank\" class=\"whatsapp-link\">";
  $la_Registro['whatsapp_multicontacto_directo'] .= "$ciudadNombre <i class=\"fab fa-whatsapp icon-whatsapp\"></i>";
  $la_Registro['whatsapp_multicontacto_directo'] .= "</a>";
}

$la_Registro['whatsapp_multicontacto_directo'] .= '</div>';

// Asignar el HTML al array de resultados y mostrarlo
$row_micros['whatsapp_multicontacto_directo'] = $la_Registro['whatsapp_multicontacto_directo'];
// echo $row_micros['whatsapp_multicontacto'];








// ENVO DIRECTO A TELEGRAM

// Generar el cdigo HTML con los enlaces de las ciudades y los nmeros asignados para Telegram

$la_Registro['telegram_multicontacto'] = '<div id="ciudades-container" class="ciudades-container">';

foreach ($resultados as $ciudad => $usuario) {
  // Saltar si hubo error al asignar el usuario
  if (strpos($usuario, 'Error') === 0) continue;

  $ciudadNombre = ucfirst($ciudad);

  // Enlace directo al usuario de Telegram
  $url = "https://t.me/$usuario";

  $la_Registro['telegram_multicontacto'] .= "<a href=\"$url\" target=\"_blank\" class=\"telegram-link\">";
  $la_Registro['telegram_multicontacto'] .= "$ciudadNombre <i class=\"fab fa-telegram icon-telegram\"></i>";
  $la_Registro['telegram_multicontacto'] .= "</a>";
}

$la_Registro['telegram_multicontacto'] .= '</div>';
$row_micros['telegram_multicontacto'] = $la_Registro['telegram_multicontacto'];


// echo $row_micros['telegram_multicontacto'];


//**********************************************************************
/////////////////WHATSAPP MULTICIUDAD /////////////////////////////////////////
// *********************************************************************








//**********************************************************************
/////////////////WAZE MULTICIUDAD /////////////////////////////////////////
// *********************************************************************

$ubicacionesPorCiudad = [
  'Sede Bogot Cll 72' => [
    'https://www.waze.com/es/live-map/directions?ll=4.6633161%2C-74.0671806', // Ubicacin 1
  ],
  'Sede Bogot Cll 13' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.4.6106534%2C-74.0887514', // Ubicacin 1
  ],
  'Sede Medelln' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.6.2293635%2C-75.5699572', // Ubicacin 1
  ],
  'Sede Cali' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.3.4793799%2C-76.5276745', // Ubicacin 1
  ],
  'Sede Barranquilla' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.10.9886749%2C-74.8017821', // Ubicacin 1
  ],
  'Servicio Tcnico Norte' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.4.6633021%2C-74.06706', // Ubicacin 1
  ],
  'Servicio Tcnico Bogot Ricaute' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.4.6102173%2C-74.0881885', // Ubicacin 1
  ],
  'Repuestos' => [
    'https://www.waze.com/live-map/directions?navigate=yes&to=ll.4.6102117%2C-74.0894918', // Ubicacin 1
  ],
];


// $ubicacionesPorCiudad = [
//   'Sede Bogot Cll 72' => [
//     'https://www.waze.com/es/live-map/directions?ll=4.6633161%2C-74.0671806', // Ubicacin 1
//   ]
// ];


$multiContacto = new MultiContacto($ubicacionesPorCiudad);
$resultados = $multiContacto->generarNumeros();

// print_r($resultados);


// Visualizar los resultados
$la_Registro['waze_multicontacto'] = '<div id="ciudades-container" class="ciudades-container">';

foreach ($resultados as $ciudad => $url) {
  // Si hubo un error al asignar la URL, no agregar el enlace
  if (strpos($url, 'Error') === 0) {
    continue;
  }

  $ciudadNombre = ucfirst($ciudad);

  // Formato del enlace de Waze
  $la_Registro['waze_multicontacto'] .= "<a href=\"$url\" target=\"_blank\" class=\"waze-link\">";
  $la_Registro['waze_multicontacto'] .= "$ciudadNombre <i class=\"fab fa-waze icon-waze\"></i>";
  $la_Registro['waze_multicontacto'] .= "</a>";
}

$la_Registro['waze_multicontacto'] .= '</div>';

// Asignar el HTML al array de resultados y mostrarlo
$row_micros['waze_multicontacto'] = $la_Registro['waze_multicontacto'];

//**********************************************************************
/////////////////WAZE MULTICIUDAD /////////////////////////////////////////
// *********************************************************************




echo Combinar_Registro_Plantilla($la_Registro, file_get_contents($row_micros['plantillaje'] . "/comunicaciones/plantilla_multicanal.html"));
