<?php
session_start();

error_reporting(E_ALL);
ini_set('display_errors', 'On');

if (!isset($lc_Path)) {
  $lc_Path = "./siev/";
  $lb_Ruta = false;
  $li_Iteraciones = 0;
  // BUSCAR EL ROOT ./siev
  do {
    if (file_exists($lc_Path . "Globales.php")) {
      $lb_Ruta = true;
    } else {
      $lc_Path  = "../" . preg_replace("/^\.\//", "", $lc_Path);
    }
    $li_Iteraciones++;
  } while ($lb_Ruta == false && $li_Iteraciones <= 6);
}

include_once $lc_Path . "Globales.php";
include_once $lc_Path . "php/Conexion_BD.php";

//ACTIVA FUNCION DE SEGURIDAD DE FORMULARIOS
validarFormularioSeguro();


// Validar y limpiar entradas globales
$tuemail      = isset($_POST['tuemail']) ? limitarTexto(trim($_POST['tuemail'])) : '';
$tunombre     = isset($_POST['tunombre']) ? limitarTexto(trim(urldecode($_POST['tunombre']))) : '';
$mensaje      = isset($_POST['mensaje']) ? mb_substr(trim(strip_tags(urldecode($_POST['mensaje']))), 0, 500) : '';
$usuariorec   = isset($_POST['usuariorec']) ? limitarTexto(trim($_POST['usuariorec'])) : '';
$idioma       = isset($_POST['idioma']) ? limitarTexto(trim($_POST['idioma'])) : '';
$boletin      = isset($_POST['boletin']) ? '1' : '0';
$lider        = isset($_POST['usuariorec']) ? limitarTexto(trim($_POST['usuariorec'])) : '';

// Validacin de arrays recibidos
$nombreamigo = isset($_POST['nombreamigo']) && is_array($_POST['nombreamigo']) ? array_map('limitarTexto', $_POST['nombreamigo']) : [];
$emailamigo  = isset($_POST['emailamigo']) && is_array($_POST['emailamigo']) ? array_map('limitarTexto', $_POST['emailamigo']) : [];


//require '../PHPMailer20/vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../PHPMailer20/vendor/PHPMailer/src/PHPMailer.php';
require '../PHPMailer20/vendor/PHPMailer/src/SMTP.php';
require '../PHPMailer20/vendor/PHPMailer/src/Exception.php';

if ($_SESSION['lenguaje'] == 'sp') {
  include($lc_Path . '../idiomas/espanol.php');
}
if ($_SESSION['lenguaje'] == 'por') {
  include($lc_Path . '../idiomas/portugues.php');
}
if ($_SESSION['lenguaje'] == 'ing') {
  include($lc_Path . '../idiomas/ingles.php');
}



//ACTIVA FUNCION DE SEGURIDAD DE FORMULARIOS
validarFormularioSeguro();

// SWITCH PARA CONTROLAR MAIL SMTP
if (defined('SMTP')) {
  $usar_smtp = true;
}

function array_envia($array)
{
  $tmp = serialize($array);
  $tmp = urlencode($tmp);
  return $tmp;
}

if (isset($_POST['codigo_robot']) && $_POST['codigo_robot'] != '') {

  $query_empresa = "SELECT * FROM clientes WHERE custom_cliente = 'todoventa' ";
  $lo_Objeto_Empresa = HacerConsultaQuery($query_empresa);
  $row_empresa = $lo_Objeto_Empresa->DB_resultado[0];

  $query_clientes = "SELECT * FROM clientes WHERE custom_cliente = '" . $lider . "' ";
  $lo_Objeto_Cliente = HacerConsultaQuery($query_clientes);
  $row_clientes = $lo_Objeto_Cliente->DB_resultado[0];


  $array_rec = array();


  //
  for ($r = 0; $r < count($emailamigo); $r++) {  // Inicia cilco para multiples recomendaciones          
    if ($nombreamigo[$r] <> '' and $emailamigo[$r] <> '') { // Valida campos

      $recomiendanos = "INSERT INTO recomendados (custom_fecha, custom_de, custom_emailde, custom_para, custom_emailpara, mensaje, usuario, idioma, tipo) VALUES (
        '" . date('Y-m-d H:i:s') . "',
        '$tunombre',
        '$tuemail',
        '$nombreamigo[$r]',
        '$emailamigo[$r]',
        '" . addslashes($mensaje) . "',
        '$lider',
        '$idioma',
        'web'
      )";

      $lo_Objeto_Contacto = HacerConsultaQuery($recomiendanos);
      $idrec = $lo_Objeto_Contacto->DB_Id;
      $array_rec[$r] = $idrec;


      // error_log("Consulta  ".$recomiendanos.'   '.$idrec.'  '.date('Y/m/d H:i:s')."\n",3,"./logerror.txt");


    } // Finaliza validacion de campos

    // Inscribirlo como Usuario
    //Se inscribe el que recomienda
    $query_usuarios = "SELECT * FROM usuarios WHERE email = '$tuemail' and usuario = '$usuariorec'";

    // error_log("?? QUERY_USUARIOS: {$query_usuarios}");

    $lo_Objeto_Usuarios = HacerConsultaQuery($query_usuarios);

    //SI NO EXISTE LO INSERTA
    if ($lo_Objeto_Usuarios->DB_registros == 0) {
      $c_activado = ($boletin === '1') ? 'Y' : 'N';

      $inserta_usuarios = "INSERT INTO usuarios (
        usuario, custom_estado, custom_password, custom_nivelacceso,
        custom_fecingreso, first_name, email, custom_telefono,
        tipoing, idioma, carnet, custom_empresa, custom_cargo, c_activado
      ) VALUES (
        '$usuariorec', 'Inscrito', '', 'Activado',
        '" . date('Y-m-d H:i:s') . "', '$tunombre', '$tuemail', '',
        'Y', '$idioma', '', '', '', '$c_activado'
      )";

      $lo_Objeto_Insertar = HacerConsultaQuery($inserta_usuarios);
      $idu = $lo_Objeto_Insertar->DB_Id;

      //asigna el usuario a la lista de correo asiganda por el cliente
      $sqllista  = "INSERT INTO listas(cliente, usuario, lista ) VALUES ('$row_clientes[custom_cliente]', '$idu', '$row_clientes[lista_recomendadores]')";
      $lo_Objeto_listas = HacerConsultaQuery($sqllista);
      $idListas = $lo_Objeto_listas->DB_Id;
      //Asignar a la lista general
      $sqllista_general  = "INSERT INTO listas(cliente, usuario, lista ) VALUES ('$row_clientes[custom_cliente]', '$idu', '$row_clientes[lista_general]')";
      $lo_Objeto_listasGnral = HacerConsultaQuery($sqllista_general);
      $idLG = $lo_Objeto_listasGnral->DB_Id;
    } else {


      if ($_POST['boletin'] == '') {
        $baja_correo = "UPDATE usuarios SET c_activado = 'N' WHERE email = '" . $row_usuarios['email'] . "'";
        $baja_listas = "DELETE FROM listas WHERE usuario = " . $row_usuarios['custom_id'];
        $lo_Objeto_listasGnral = HacerConsultaQuery($baja_correo);
        $lo_Objeto_listasGnral = HacerConsultaQuery($baja_listas);
      }
    }

    // Se inscribe al que se recomienda

    $query_usuarios2 = "SELECT * FROM usuarios WHERE email = '" . $emailamigo[$r] . "' and usuario = '$usuariorec'";

    $lo_Objeto_Usuarios = HacerConsultaQuery($query_usuarios2);

    //Si no existe lo inserta
    if ($lo_Objeto_Usuarios->DB_registros == 0 and $emailamigo[$r] <> '') {
      $inserta_usuarios2 = "INSERT INTO usuarios (usuario, custom_estado, custom_password, custom_nivelacceso, custom_fecingreso, custom_pais, custom_ciudad, first_name, last_name, email, custom_telefono, tipoing, idioma, carnet, custom_empresa, custom_cargo) VALUES ('$usuariorec', 'Inscrito', '', 'Activado', '', '', '', '$nombreamigo[$r]', '', '$emailamigo[$r]', '', 'Y', '$idioma', '', '', '')";

      $lo_Objeto_Insertar = HacerConsultaQuery($inserta_usuarios2);
      $idu2 = $lo_Objeto_Insertar->DB_Id;

      //asigna el usuario a la lista de correo asiganda por el cliente
      $sqllista  = "INSERT INTO listas(cliente, usuario, lista ) VALUES ('$row_clientes[custom_cliente]', '$idu', '$row_clientes[lista_recomendados]')";
      $lo_Objeto_listas = HacerConsultaQuery($sqllista);
      $idListas = $lo_Objeto_listas->DB_Id;
      //Asignar a la lista general
      $sqllista_general  = "INSERT INTO listas(cliente, usuario, lista ) VALUES ('$row_clientes[custom_cliente]', '$idu', '$row_clientes[lista_general]')";
      $lo_Objeto_listasGnral = HacerConsultaQuery($sqllista_general);
      $idLG = $lo_Objeto_listasGnral->DB_Id;
    }



    $SITEurlrecoenvio       = "https://$row_clientes[subdominio]/correo/recomendacion.php?micro2=" . $row_clientes['custom_cliente'] . "&idrecomienda=$idrec&idcliente=" . $row_clientes['custom_cliente'] . "";

    $SITEurlrecomienda      = "https://$row_clientes[subdominio]/correo/recomendados.php?micro2=" . $row_clientes['custom_cliente'] . "&idrecomienda=$idrec&idcliente=" . $row_clientes['custom_cliente'] . "";


    //  error_log("Consulta  ".$SITEurlrecoenvio.'   '.$SITEurlrecomienda.'  '.date('Y/m/d H:i:s')."\n",3,"./logerror.txt");


    $SITEasuntorecomienda   = "Gracias por recomendarnos " . $row_clientes['custom_empresa'];
    $SITEasuntorecprod      = (isset($row_producto)) ? $nombreamigo[$r] . " conoce " . $row_producto['custom_nombrepro'] : $nombreamigo[$r] . " conoce " . $row_clientes['custom_empresa'];
    $SITEasuntorecenvio     = $nombreamigo[$r] . " conoce " . $row_clientes['custom_empresa'];

    // Sanitizar entradas

    $email_amigo    = isset($emailamigo[$r]) ? trim((string)$emailamigo[$r]) : '';
    $nombre_amigo   = isset($nombreamigo[$r]) ? trim((string)urldecode($nombreamigo[$r])) : '';
    $email_cliente  = isset($row_clientes['email']) ? trim((string)$row_clientes['email']) : '';
    $nombre_cliente = isset($row_clientes['custom_empresa']) ? trim((string)$row_clientes['custom_empresa']) : '';

    // ENVO al recomendado
    $body = file_get_contents($SITEurlrecoenvio);
    $mail = new PHPMailer();
    $mail->IsHTML(true);
    $mail->CharSet = 'UTF-8';


    if (isset($usar_smtp)) {
      $mail->SMTPDebug = 2;
      $mail->SMTPAuth = true;
      $mail->SMTPSecure = 'ssl';
      $mail->Host     = trim($row_clientes['host']);
      $mail->Port     = (int) $row_clientes['puerto'];
      $mail->Username = filter_var(trim($row_clientes['email_boletines']), FILTER_SANITIZE_EMAIL);
      $mail->Password = trim($row_clientes['clave']);
    }

    $mail->From     = $tuemail;
    $mail->FromName = $tunombre;
    $mail->Subject  = $SITEasuntorecprod;
    $mail->Body     = $body;

    if ($email_amigo !== '' && filter_var($email_amigo, FILTER_VALIDATE_EMAIL)) {
      $mail->AddAddress($email_amigo, $nombre_amigo);
    }
    $mail->AddAddress('pedidos@todoventa.com', $nombre_cliente);
    $mail->Send();
  } // Finaliza el ciclo de mltiples recomendaciones

  $array_rec = array_envia($array_rec);

  // ENVO de agradecimiento al remitente
  $body = file_get_contents($SITEurlrecomienda);
  $mail = new PHPMailer();
  $mail->IsHTML(true);
  $mail->CharSet = 'UTF-8';


  if (isset($usar_smtp)) {
    $mail->SMTPDebug = 2;
    $mail->SMTPAuth = true;
    $mail->SMTPSecure = 'ssl';
    $mail->Port = $row_clientes['puerto'];
    $mail->Host = $row_clientes['host'];
    $mail->Username = $row_clientes['email_boletines'];
    $mail->Password = $row_clientes['clave'];
  }

  $mail->From     = $email_cliente;
  $mail->FromName = $nombre_cliente;
  $mail->Subject  = $SITEasuntorecomienda;
  $mail->Body     = $body;

  if ($tuemail !== '' && filter_var($tuemail, FILTER_VALIDATE_EMAIL)) {
    $mail->AddAddress($tuemail, $tunombre);
  }
  $mail->Send();

  // ENVO de alerta
  $urlalerta = "https://" . $row_clientes['subdominio'] . "/correo/recomendados_alerta.php?idrecomienda=" . $idrec . "&idcliente=" . $row_clientes['custom_cliente'];

  $body = file_get_contents($urlalerta);
  $mail = new PHPMailer();
  $mail->IsHTML(true);
  $mail->CharSet = 'UTF-8';


  if (isset($usar_smtp)) {
    $mail->SMTPDebug = 2;
    $mail->SMTPAuth = true;
    $mail->SMTPSecure = 'ssl';
    $mail->Host     = trim($row_clientes['host']);
    $mail->Port     = (int) $row_clientes['puerto'];
    $mail->Username = filter_var(trim($row_clientes['email_boletines']), FILTER_SANITIZE_EMAIL);
    $mail->Password = trim($row_clientes['clave']);
  }

  $mail->From     = $row_empresa['email'];
  $mail->FromName = $row_empresa['custom_empresa'];
  $mail->Subject  = "Alerta - Recomendacin recibida SIEV - $idioma";
  $mail->Body     = $body;
  $mail->IsHTML(true);
  $mail->setFrom($row_empresa['email'], $row_empresa['custom_empresa']);

  if ($email_cliente !== '' && filter_var($email_cliente, FILTER_VALIDATE_EMAIL)) {
    $mail->AddAddress($email_cliente, $nombre_cliente);
  }
  $mail->AddAddress('pedidos@todoventa.com', $nombre_cliente);
  $mail->Send();
} else {
  // Se llama el script de respuesta en caso de fallar en el cdigo de la imagen
  echo $SITEfallovalidacion;
}
