<?php

$fecha_visita = date("Y-m-d H:i:s");
$url          = $_SERVER['REQUEST_URI'];
$referer      = $_SERVER['HTTP_REFERER'] ?? 'url directo';
$ip           = $_SERVER['REMOTE_ADDR'];
$user_agent   = $_SERVER['HTTP_USER_AGENT'] ?? 'desconocido';
$is_bot       = preg_match('/bot|crawl|slurp|spider/i', $user_agent) ? 1 : 0;

// Navegador simple
$navegador = 'Desconocido';
if (stripos($user_agent, 'Chrome') !== false) $navegador = 'Chrome';
elseif (stripos($user_agent, 'Firefox') !== false) $navegador = 'Firefox';
elseif (stripos($user_agent, 'Safari') !== false) $navegador = 'Safari';
elseif (stripos($user_agent, 'Edge') !== false) $navegador = 'Edge';
elseif (stripos($user_agent, 'MSIE') !== false || stripos($user_agent, 'Trident') !== false) $navegador = 'IE';

// Dispositivo
$dispositivo = (preg_match('/mobile/i', $user_agent)) ? 'Móvil' : 'Escritorio';

// Geo
if (!isset($_SESSION['pais']) || !isset($_SESSION['ciudad'])) {
  $pais = 'Desconocido';
  $ciudad = 'Desconocido';
  $json = @file_get_contents("http://ip-api.com/json/$ip?fields=country,city,status");

  if ($json) {
    $data = json_decode($json, true);
    if ($data['status'] === 'success') {
      $pais = $data['country'] ?? 'Desconocido';
      $ciudad = $data['city'] ?? 'Desconocido';
    }
  }

  $_SESSION['pais'] = $pais;
  $_SESSION['ciudad'] = $ciudad;
} else {
  $pais = $_SESSION['pais'];
  $ciudad = $_SESSION['ciudad'];
}

// Sesión personalizada
if (!isset($_SESSION['sesion_visita_id'])) {
  $_SESSION['sesion_visita_id'] = session_id() . '_' . uniqid();
  $_SESSION['sesion_inicio'] = time();
}
$session_id = $_SESSION['sesion_visita_id'];
$duracion   = time() - ($_SESSION['sesion_inicio'] ?? time());

// Usuario logueado (si aplica)
$id_usuario = $_SESSION['id_usuario'] ?? 'NULL';

// UTM
$utm_source   = $_GET['utm_source'] ?? '';
$utm_medium   = $_GET['utm_medium'] ?? '';
$utm_campaign = $_GET['utm_campaign'] ?? '';

// 1. Marcar página anterior como salida si aplica
if (isset($_SESSION['ultima_url']) && $_SESSION['ultima_url'] !== $url) {
  $sql_salida = "
        UPDATE visitas_site
        SET es_salida = 1
        WHERE session_id = '{$session_id}'
        AND url = '" . addslashes($_SESSION['ultima_url']) . "'
        ORDER BY fecha_visita DESC
        LIMIT 1
    ";
  HacerConsultaQuery($sql_salida, $database_conexion);
}
$_SESSION['ultima_url'] = $url;

// 2. Registrar visita actual
$sql_insert = "
INSERT INTO visitas_site
(fecha_visita, url, referer, ip, user_agent, navegador, dispositivo, pais, ciudad, is_bot, session_id, duracion, id_usuario, utm_source, utm_medium, utm_campaign)
VALUES
('$fecha_visita', '" . addslashes($url) . "', '" . addslashes($referer) . "', '$ip', '" . addslashes($user_agent) . "', '$navegador', '$dispositivo', '$pais', '$ciudad', $is_bot,
'$session_id', $duracion, " . ($id_usuario !== 'NULL' ? intval($id_usuario) : 'NULL') . ", '$utm_source', '$utm_medium', '$utm_campaign')
";
HacerConsultaQuery($sql_insert, $database_conexion);
