<?php

if (!defined('DBNAME')) {
    if (!isset($lc_Path)) {
        $lc_Path = "./siev/";
        $lb_Ruta = false;
        $li_Iteraciones = 0;
        // BUSCAR EL ROOT ./siev
        do {
            if (file_exists($lc_Path . "Globales.php")) {
                $lb_Ruta = true;
            } else {
                $lc_Path = "../" . preg_replace("/^\.\//", "", $lc_Path);
            }
            $li_Iteraciones++;
        } while ($lb_Ruta == false && $li_Iteraciones <= 6);
    }
    include_once $lc_Path . "Globales.php";
}

if (!function_exists('HacerConsultaQuery')) {
    class ConexionMySql
    {
        var $bd;
        var $DB_error;
        var $DB_registros;
        var $DB_campos;
        var $DB_atributos;
        var $DB_registrosafectados;
        var $DB_resultado;
        var $DB_resultado_conexion;
        var $DB_conexion;
        var $DB_Id;

        function __construct($dbname = "")
        {

            global $conexion;

            $this->DB_error = 'No';
            $this->bd = (trim($dbname != "")) ? $dbname : DBNAME;

            //if ( isset($_SESSION['host_conexion']) && $_SESSION['host_conexion'] != "" ) {
            //$this->DB_conexion = ( isset($conexion) ) ? $conexion : @mysql_connect ( $_SESSION['host_conexion'], DBUSER, DBPASS);
            //    $this->DB_conexion = ( isset($conexion) ) ? $conexion : @mysql_connect ( $_SESSION['host_conexion'], 'root', $_SESSION['pws_conexion'] );
            //} else {
            //$this->DB_conexion = ( isset($conexion) ) ? $conexion : @mysql_connect ( DBHOST, DBUSER, DBPASS);
            //}

            $this->DB_conexion = mysqli_connect(DBHOST, DBUSER, DBPASS);

            //if ( isset($conexion) || isset( $_SESSION['conexion'] ) ) { $this->Error_Log("conectando con SIEV ".DBHOST.' '.$this->bd.' '.DBUSER.' '.DBPASS ); }

            if ($this->DB_conexion) {
                if (!mysqli_select_db($this->DB_conexion, $this->bd)) {
                    $this->Error_Log("Error conectando la Base de Datos " . DBHOST . ' ' . $this->bd . ' ' . DBUSER . ' ' . DBPASS);
                    $this->DB_error = 'Error conectando la Base de Datos';
                }
            } else {
                $this->Error_Log("Conexion Fallida con " . $this->bd . " " . DBUSER . " " . DBPASS . " [" . DBHOST . "]");
                $this->DB_error = 'Error conectando el Servidor MySql';
            }
            return $this;
        }

        function Error_Log($lc_Mensaje)
        {
            global $lc_Path;

            if (defined('DEBUG_PHP') && DEBUG_PHP == "true") {
                $lc_Destino = $lc_Path . 'Log/log_aplicativo_' . date('Y_m_d') . '.log';
                $lb_Existe = true;
                if (!file_exists($lc_Destino)) {
                    //ACTIVAR ESTA LINEAS PARA CREAR EL ARCHIVO DEL LOG
                    /*
                    if (($lo_Archivo = fopen($lc_Destino, 'w')) === FALSE) {
                        $lb_Existe = false;
                    } else {
                        fclose($lo_Archivo);
                        @chmod($lc_Destino, 0777);
                    }*/
                }

                if ($lb_Existe == true) {
                    //ACTIVAR ESTA LINEA PARA IMPRIMIR LAS CONSULTAS DEL SITIO EN EL LOG
                    //error_log($lc_Mensaje . ' ' . date('Y/m/d H:i:s') . "\n", 3, $lc_Destino);
                }
            }
        }

        function EjecutarQuery($query)
        {
            global $ga_Error_BD;

            if ($this->DB_conexion == true) {
                // TOMAR EL TIEMPO DE EJECUCIN
                $start_time = explode(' ', microtime());
                $start_time = $start_time[1] + $start_time[0];

                $lc_Resultado = mysqli_query($this->DB_conexion, stripslashes($query));
                $this->DB_resultado_conexion = $lc_Resultado;

                // TOMAR EL TIEMPO FINAL DE EJECUCIN
                $end_time = explode(' ', microtime());
                $lc_Tiempo_Resultado = number_format(($end_time[0] + $end_time[1] - $start_time), 4);

                $la_Resultado = array();

                if (!$lc_Resultado) {
                    $lc_Error = (string)mysqli_error($this->DB_conexion);
                    $this->Error_Log($lc_Error . ' ' . $query);

                    // Capturar errores personalizados
                    //foreach ($ga_Error_BD as $gc_Error => $lc_Valor) {
                    //    if (ereg($gc_Error,strtoupper($lc_Error),$la_Resultado)) { $lc_Error = $lc_Valor; }
                    //}

                    /*
                    foreach ( array_keys($ga_Error_BD) as $lc_Atributo ) {
                        $lc_Buscar = preg_replace("/\x20/","\x20",$lc_Atributo);
                        if ( preg_match("/".$lc_Buscar."/i",$lc_Error,$la_Error) ) { $lc_Error = $ga_Error_BD[$lc_Atributo]; }
                    }
                    */

                    $this->DB_error = $lc_Error . ' ' . $query;
                    $this->DB_registros = 0;
                } else {
                    $this->DB_Id = mysqli_insert_id($this->DB_conexion);
                    $this->DB_error = 'No';
                    // En caso de actualizar, borrar o insertar
                    if (preg_match("/^select|show|describe|truncate|alter/i", trim($query), $la_Resultado) && gettype($lc_Resultado) != "boolean") {
                        $this->DB_registros = mysqli_num_rows($lc_Resultado);
                        $this->DB_campos = mysqli_num_fields($lc_Resultado);
                        $this->DB_registrosafectados = mysqli_num_rows($lc_Resultado);
                        $this->Error_Log("Select [" . $this->DB_registros . "] / (" . $query . ") - " . DBHOST . ' ' . $this->bd . ' ' . DBUSER . ' ' . DBPASS);
                        //$this->Error_Log("DB - ".DBNAME." Select (".$this->DB_registros." - ".$lc_Tiempo_Resultado." segs. ) / (".$query.")");
                    } else {
                        if (gettype($lc_Resultado) == "boolean" && $lc_Resultado == true) {
                            $this->DB_registrosafectados = mysqli_affected_rows($this->DB_conexion);
                            $this->Error_Log("Update / Insert (" . $this->DB_registrosafectados . ") " . $query . " - " . DBHOST . ' ' . $this->bd . ' ' . DBUSER . ' ' . DBPASS);
                        } else {
                            $this->DB_error = "Error en la sentencia. Favor verificar.";
                        }
                    }
                    // En caso de no obtenerse un resultado satisfactorio de una sentencia
                    // select, update o delete, reportar el caso de error
                    if ($this->DB_registrosafectados == 0) {
                        //if (!ereg("[BEGIN|COMMIT]",$query,$la_Transaccion)) { $this->Error_Log("Reg. afectados ".$query); }
                        $this->Error_Log("Reg. afectados " . $query);
                    }
                    // Almacena el nombre de los atributos
                    $la_Atributo = array();
                    // Almacena el resultado de la consulta en forma de arreglo
                    $la_Resultado = array();
                    // Si existen registros
                    if ($this->DB_registros > 0) {
                        // Tomar los nombres de los atributos
                        for ($li_Columna = 0; $li_Columna < $this->DB_campos; $li_Columna++) {
                            $la_Atributo[] = mysqli_field_name($lc_Resultado, $li_Columna);
                        }
                        $this->DB_atributos = $la_Atributo;
                        // Crear el arreglo bidimensional con el resultado de la sentencia sql
                        for ($li_Fila = 0; $li_Fila < $this->DB_registros; $li_Fila++) {
                            for ($li_Columna = 0; $li_Columna < $this->DB_campos; $li_Columna++) {
                                $tempResult = mysqli_result($lc_Resultado, $li_Fila, $li_Columna);
                                $la_Resultado[$li_Fila][$la_Atributo[$li_Columna]] = ($tempResult !== null) ? html_entity_decode($tempResult, ENT_COMPAT, 'ISO-8859-1') : null;
                            }
                        }
                    }
                }
            } else {
                $la_Resultado = array();
                $this->Error_Log("Conexin fallida con el servidor de Base de Datos ");
                $this->DB_error = 'Conexin fallida con el servidor de Base de Datos';
                $this->DB_registros = 0;
            }
            $this->DB_resultado = $la_Resultado;

            return $this;
        }


        function EjecutarPreparedQuery($sql, $params = [], $types = "")
        {
            $stmt = mysqli_prepare($this->DB_conexion, $sql);
        
            if ($stmt === false) {
                $this->Error_Log("Error preparando consulta: " . mysqli_error($this->DB_conexion));
                $this->DB_error = mysqli_error($this->DB_conexion);
                return false;
            }
        
            if (!empty($params)) {
                mysqli_stmt_bind_param($stmt, $types, ...$params);
            }
        
            if (!mysqli_stmt_execute($stmt)) {
                $this->Error_Log("Error ejecutando consulta: " . mysqli_stmt_error($stmt));
                $this->DB_error = mysqli_stmt_error($stmt);
                return false;
            }
        
            $result = mysqli_stmt_get_result($stmt);
        
            if ($result !== false) {
                $this->DB_resultado = $result->fetch_all(MYSQLI_ASSOC);
                $this->DB_registros = count($this->DB_resultado);
                $this->DB_error = 'No';
                return $this->DB_resultado;
            } else {
                $this->DB_registrosafectados = mysqli_stmt_affected_rows($stmt);
                $this->DB_Id = mysqli_insert_id($this->DB_conexion); // ?? Capturamos el ID insertado
                $this->DB_error = 'No';
                return true;
            }
        }
        
    }

    /* Descripcin    : Funcion que permite ejecutar sentencias Sql en el servidor de BD
    // Resultado      : Devuelve un objeto con los siguientes atributos
    //                  DB_error      - Mensaje de error
    //                  DB_registros  - Nmero de registros
    //                  DB_campos     - Nmero de atributos
    //                  DB_registrosafectados - Nmero de registros afectados por la sentencia sql
    //                  DB_resultado  - Arreglo de dos dimensiones con los datos obtenidos de la consulta
    //                  DB_conexion   - Estado de la conexin al servidor de la BD
    */
    /**
     * La funcion  mysqli_field_name no tiene un equivalente directo en la version 7 de php por lo que  se crea esta funciona para porder seguir usando la misma logica
     **/

    function mysqli_field_name($result, $field_offset)
    {
        $properties = mysqli_fetch_field_direct($result, $field_offset);
        return is_object($properties) ? $properties->name : null;
    }
    /**
     * La funcion  mysqli_result no tiene un equivalente directo en la version 7 de php por lo que
     * se crea esta funciona para porder seguir usando la misma logica sin alterar mas codigo
     * SOlo debe llamarse la funcion
     **/
    function mysqli_result($res, $row, $field = 0)
    {
        $res->data_seek($row);
        $datarow = $res->fetch_array();
        return $datarow[$field];
    }

    function HacerConsultaQuery($lc_Query, $dbname = "")
    {

        global $lc_Path;

        if (!defined('DBNAME') || DBNAME == '' || $dbname == "") {
            error_reporting(E_ALL);
            ini_set('display_errors', 'On');

            $lc_Destino = $lc_Path . 'Log/log_aplicativo_' . date('Y_m_d') . '.log';
            $lb_Existe = true;
            //if (!file_exists($lc_Destino)) { if(($lo_Archivo = fopen($lc_Destino,'w')) === FALSE) { $lb_Existe = false; } else { fclose($lo_Archivo); @chmod($lc_Destino,0777); } }

            //if ($lb_Existe == true) { error_log("Sin BD ".$lc_Query.' '.date('Y/m/d H:i:s')."\n",3,$lc_Destino); }

            include_once $lc_Path . "Globales.php";
            $dbname = DBNAME;

            //if ($lb_Existe == true) { error_log("Despues Sin BD ".$lc_Query.' ['.DBNAME.'][ '.$dbname.' ] '.date('Y/m/d H:i:s')."\n",3,$lc_Destino); }
        }

        //if ( $dbname == "" && ) { $dbname = $_SESSION['cliente_base_datos']; }
        //$lc_Destino = $lc_Path.'Log/log_aplicativo_'.date('Y_m_d').'.log';
        //$lb_Existe  = true;
        //if (!file_exists($lc_Destino)) { if(($lo_Archivo = fopen($lc_Destino,'w')) === FALSE) { $lb_Existe = false; } else { fclose($lo_Archivo); @chmod($lc_Destino,0777); } }
        //if ($lb_Existe == true) { error_log("Llamado SQL ".$lc_Query.' ['.$dbname.' '.DBNAME.'] '.date('Y/m/d H:i:s')."\n",3,$lc_Destino); }

        // Establecer la conexin con la BD
        $conn_ = new ConexionMySql($dbname);
        //TomarConexionBD ();
        if ($conn_->DB_error == 'No') {
            // Ejecutar la accin sobre la BD
            $la_Resultado = $conn_->EjecutarQuery($lc_Query);
            return $la_Resultado;
        } else {
            return array();
        }
    }

    function HacerConsultaPreparada($sql, $params = [], $types = "", $dbname = "")
    {
        global $lc_Path;

        if (!defined('DBNAME') || DBNAME == '' || $dbname == "") {
            include_once $lc_Path . "Globales.php";
            $dbname = DBNAME;
        }

        $conn_ = new ConexionMySql($dbname);

        if ($conn_->DB_error == 'No') {
            $resultado = $conn_->EjecutarPreparedQuery($sql, $params, $types);

            if ($resultado !== false) {
                return $conn_; // ? Devuelve el objeto que contiene DB_Id, DB_error, DB_resultado, etc.
            } else {
                return false; // ? Si el ejecutado falla, devuelves false
            }
        } else {
            return false;
        }
    }
}

if (!function_exists('Iniciar_Transaccion')) {
    function Iniciar_Transaccion()
    {
        $lc_Query = "BEGIN";
        $la_Resultado = HacerConsultaQuery($lc_Query);
    }
}

if (!function_exists('Finalizar_Transaccion')) {
    function Finalizar_Transaccion($lb_Error = false)
    {
        $lc_Query = ($lb_Error == false) ? "COMMIT;" : "ROLLBACK;";
        $la_Resultado = HacerConsultaQuery($lc_Query);
    }
}
