<?php
    header("Cache-Control: no-store, no-cache, must-revalidate");
    
    if (session_id() == "") { session_start(); } // INICIAR LA SESIN
    
    error_reporting(E_ALL);
    ini_set('display_errors','On');
    
    $lc_Path = "siev/"; $lb_Ruta = false; $li_Iteraciones = 0;
    // BUSCAR EL ROOT ./siev
    do { if ( file_exists( $lc_Path."Globales.php" ) ) { $lb_Ruta = true; } else { $lc_Path  = "../".$lc_Path; } $li_Iteraciones++;
    } while ( $lb_Ruta == false && $li_Iteraciones <= 6 );

    INCLUDE $lc_Path."Globales.php";

    DEFINE( "RUTA", "http://www.todoventa.com/siev/aplicaciones/informe_gerencial/" );

   	if ( !function_exists('HacerConsultaQuery') ) { INCLUDE_ONCE $lc_Path."php/Conexion_BD.php"; }

    if ( !function_exists('Eliminar_Caracteres_No_Numericos') ) {
        function Eliminar_Caracteres_No_Numericos($lc_Cadena) {
            $lc_Cadena      = preg_replace("/[^0-9]/","",$lc_Cadena);
            return $lc_Cadena;
        }
    }    
        
    if ( !function_exists('Combinar_Registro') ) {
        function Combinar_Registro ($row,$lc_Html) {
            $lb_Encontrado = false;
    
            if (preg_match_all("/\&lquo\;([a-z\_]{1,})\&rquo\;/i",$lc_Html,$la_Atributos)) {
    		        $lb_Encontrado = true;
    		        array_shift($la_Atributos);
            } else {
                if (preg_match_all("/\([a-z\_]{1,})\/i",$lc_Html,$la_Atributos)) {
                    $lb_Encontrado = true;
                    array_shift($la_Atributos);
                }	
            }
            //print_r($la_Atributos);
            if ($lb_Encontrado == true) {
                $li_Total_Atributos = count($la_Atributos[0]);
                for ($li_Atributo=0; $li_Atributo < $li_Total_Atributos; $li_Atributo++) {
                    $lc_Atributo = $la_Atributos[0][$li_Atributo];
                    //echo $lc_Atributo;
                    if ( isset( $row[$lc_Atributo] ) ) { $lc_Html = preg_replace("/\".$lc_Atributo."\/i",$row[$lc_Atributo],$lc_Html); }
                    // echo "<br>Reemplazar ".$lc_Atributo." por ".$row[$lc_Atributo];
                } 
            }
            return $lc_Html;
        }
    }

    $lc_Plantilla_Informe = file_get_contents( RUTA."plantilla.html");
    $lc_Plantilla_Menu    = file_get_contents( RUTA."template_menu.html");
     
    /********************************************************************************
    // FUNCIN QUE PERMITE COMBINAR UNA PLANTILLA HTML CON UN ARREGLO ASOCIATIVO
    ********************************************************************************/
    if (!function_exists('Combinar_Registro_Plantilla')) {
        function Combinar_Registro_Plantilla ($row,$lc_Html) {
            $lb_Encontrado = false;
    
            if ( is_array($row) ) {
                // REEMPLAZAR LOS CARACTERES DE APERTURA Y CIERRE POR LOS TAGS   
                $lc_Html = str_replace("&raquo;","", str_replace("&laquo;","",$lc_Html) );
        
                if (preg_match_all("/\([0-9a-z\_]{1,})\/i",$lc_Html,$la_Atributos)) { $lb_Encontrado = true; array_shift($la_Atributos);	}
                
                if ($lb_Encontrado == true) {
                		$li_Total_Atributos = count($la_Atributos[0]);
                		for ($li_Atributo=0; $li_Atributo < $li_Total_Atributos; $li_Atributo++) {
                  			$lc_Atributo = $la_Atributos[0][$li_Atributo];
                  			if ( in_array( $lc_Atributo, array_keys($row) ) ) {
                            $lc_Html = preg_replace("/\".$lc_Atributo."\/i",$row[$lc_Atributo],$lc_Html);
                        } else {
                            //print_r( array_keys($row) ); 
                        }
                		}
                    // LIMPIAR LAS REFERENCIAS NULAS
                    $lc_Html = preg_replace("/\[A-z]{1,}\/i","",$lc_Html);
                }
            } else {
                $lc_Html = "Arreglo no definido";
            }
            return $lc_Html;
        }
    }
    

    $bd         = $_SESSION['cliente_base_datos'];
    $usuario    = $lider;
    $year       = ( isset($_GET['year']) )        ? $_GET['year']       : date('Y');
    $mes        = ( isset($_GET['mes']) )         ? $_GET['mes']        : 0;
    $resultados = ( isset($_GET['resultados']) )  ? $_GET['resultados'] : 0;
   
    /*****************************************
    // ALMACENAR LOS TOTALES POR CADA MES
    *****************************************/
    $la_Registro_Totales      = array();
    
    /*********************************************
    //  ALMACENAR LOS TOTALES POR CADA INFORME
    *********************************************/
    $la_Total_Titulo_Informe  = array();

    // GENERAR LOS INFORMES POR DEFECTO
/*    ob_start();
        $informe = 'preguntas';
        INCLUDE "./grafico.php";
        $lc_Contenido_Preguntas = ob_get_contents();            
    ob_end_clean();
*/
 
    /*********************************************
    *   TOMAR LA INFORMACIN DE LA FACTURACIN
    *********************************************/
    $lc_Query_Facturacion   = "SELECT sum(valor) as total, DATE_FORMAT(fecha_inicial,'%c') as mes FROM factura WHERE DATE_FORMAT(fecha_inicial,'%Y') = '".$year."' AND estado_registro = 'A' GROUP BY DATE_FORMAT(fecha_inicial,'%c') ";
    $lo_Objeto_Facturacion  = HacerConsultaQuery($lc_Query_Facturacion, $bd);
    
    $lc_Factura_Pagada    = "<img src='./images/factura_ok.png' style='width:20px;margin:0px auto;' >";
    $lc_Factura_Pendiente = "<img src='./images/factura_pendiente.png' style='width:20px;margin:0px auto;' >";
    
    /*************************************
    *       CARGAR LA FACTURACIN
    *************************************/         
    $la_Facturacion = array();
    if ( $lo_Objeto_Facturacion->DB_registros > 0 ) {
        foreach ( $lo_Objeto_Facturacion->DB_resultado as $lo_Registro_Factura ) {
            $la_Facturacion[ $lo_Registro_Factura['mes'] ] = $lo_Registro_Factura['total'];
        }
    }         

    if ( $_SERVER['REMOTE_ADDR'] == '190.0.44.238' || $_SERVER['REMOTE_ADDR'] == '190.157.86.29' ) {
        ob_start();
            $informe  = 'analytics';
            INCLUDE "./grafico.php";
            //$la_Registro['grafico_preguntas'] = ob_get_contents();
            $lc_Grafico_Analytics = ob_get_contents();
        ob_end_clean();
    } 
     
    ob_start();
        $informe  = 'preguntas';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_preguntas'] = ob_get_contents();
        $lc_Grafico_Preguntas = ob_get_contents();
    ob_end_clean();        


    ob_start();
        $informe  = 'mensajes';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_mensajes'] = ob_get_contents();
        $lc_Grafico_Mensajes  = ob_get_contents();
    ob_end_clean();

    ob_start();
        $informe  = 'recomendados';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_recomendados'] = ob_get_contents();
        $lc_Grafico_Recomendados = ob_get_contents(); 
    ob_end_clean(); 

    ob_start();
        $informe  = 'compartidos';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_compartidos'] = ob_get_contents();
        $lc_Grafico_Compartidos = ob_get_contents(); 
    ob_end_clean(); 

    ob_start();
        $informe  = 'sugerencias';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_sugerencias'] = ob_get_contents();
        $lc_Grafico_Sugerencias = ob_get_contents();
    ob_end_clean(); 

    ob_start();
        $informe  = 'quejas';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_quejas'] = ob_get_contents();
        $lc_Grafico_Quejas = ob_get_contents();
    ob_end_clean(); 

    ob_start();
        $informe  = 'testimonios';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_testimonios'] = ob_get_contents();
        $lc_Grafico_Testimonios = ob_get_contents();
    ob_end_clean(); 
    
    ob_start();
        $informe  = 'usuarios';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_usuarios'] = ob_get_contents();
        $lc_Grafico_Usuarios  = ob_get_contents();
    ob_end_clean(); 
    
    ob_start();
        $informe  = 'pedidos';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_pedidos'] = ob_get_contents();
        $lc_Grafico_Pedidos = ob_get_contents();
    ob_end_clean(); 
    
    ob_start();
        $informe  = 'boletines';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_boletines'] = ob_get_contents();
        $lc_Grafico_Boletines = ob_get_contents();
    ob_end_clean(); 

    ob_start();
        $informe  = 'categorias';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_boletines'] = ob_get_contents();
        $lc_Grafico_Categorias = ob_get_contents();
    ob_end_clean();

    ob_start();
        $informe  = 'portafolios';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_boletines'] = ob_get_contents();
        $lc_Grafico_Portafolios = ob_get_contents();
    ob_end_clean();
        
    ob_start();
        $informe  = 'visitas';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_tickets'] = ob_get_contents();
        $lc_Registro_Visitas = ob_get_contents();
    ob_end_clean(); 
    
    /***********************************************************************
         DEJAR DE LTIMO YA QUE LOS TICKETS SE TOMAN DESDE HFACHINO_SIEV
    ***********************************************************************/
    ob_start();
        $informe  = 'tickets';
        INCLUDE "./grafico.php";
        //$la_Registro['grafico_tickets'] = ob_get_contents();
        $lc_Registro_Tickets = ob_get_contents();
    ob_end_clean(); 
    
    $la_Registro = array();
    $la_Registro['basedatos']       = $_SESSION['cliente_base_datos'];
    $la_Registro['custom_cliente']  = $_SESSION['cliente_micro'];
    $la_Registro['weblider']        = $weblider;    

    if ( isset($lc_Grafico_Analytics) )   { $la_Registro['grafico_preguntas'] = $lc_Grafico_Analytics; }
    
    $la_Registro['grafico_preguntas']     = $lc_Grafico_Preguntas;
    $la_Registro['grafico_mensajes']      = $lc_Grafico_Mensajes;
    $la_Registro['grafico_recomendados']  = $lc_Grafico_Recomendados;
    $la_Registro['grafico_compartidos']   = $lc_Grafico_Compartidos;
    $la_Registro['grafico_sugerencias']   = $lc_Grafico_Sugerencias;
    $la_Registro['grafico_quejas']        = $lc_Grafico_Quejas;
    $la_Registro['grafico_testimonios']   = $lc_Grafico_Testimonios;
    $la_Registro['grafico_usuarios']      = $lc_Grafico_Usuarios;
    $la_Registro['grafico_pedidos']       = $lc_Grafico_Pedidos;
    $la_Registro['grafico_boletines']     = $lc_Grafico_Boletines;
    $la_Registro['grafico_tickets']       = $lc_Registro_Tickets;
    $la_Registro['grafico_visitas']       = $lc_Registro_Visitas;
    $la_Registro['grafico_portafolios']   = $lc_Grafico_Portafolios;
    $la_Registro['grafico_categorias']    = $lc_Grafico_Categorias;
    
    $la_Meses = array('enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre');
    
    // OCULTAR LOS MESES NO SOLICITADOS
    if ( $mes > 0 ) {
        for ( $li_Mes=1; $li_Mes <= 12; $li_Mes++ ) {
            // CREAR EL ATRIBUTO DE VISUALIZACIN
            $lc_Atributo = 'ver_'.$la_Meses[ $li_Mes - 1 ];
            // OCULTAR LOS ELEMENTOS QUE NO DEBEN SER PRESENTADOS
            if ( $li_Mes != $mes ) { $la_Registro[ $lc_Atributo ] = 'visibility:hidden;'; } // display:none; 
        }
    } else {
        for ( $li_Mes=1; $li_Mes <= 12; $li_Mes++ ) {
            // CREAR EL ATRIBUTO DE VISUALIZACIN
            $lc_Atributo = 'ver_'.$la_Meses[ $li_Mes - 1 ];
            // OCULTAR LOS ELEMENTOS QUE NO DEBEN SER PRESENTADOS
            $la_Registro[ $lc_Atributo ] = 'visibility:visible;';// display:none; 
        }
    }
                                               
    //$la_Registro['grafico_preguntas']     = file_get_contents( RUTA.'grafico.php?informe=preguntas&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_mensajes']      = file_get_contents( RUTA.'grafico.php?informe=mensajes&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados ); 
    //$la_Registro['grafico_recomendados']  = file_get_contents( RUTA.'grafico.php?informe=recomendados&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_compartidos']   = file_get_contents( RUTA.'grafico.php?informe=compartidos&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );   
    //$la_Registro['grafico_sugerencias']   = file_get_contents( RUTA.'grafico.php?informe=sugerencias&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_quejas']        = file_get_contents( RUTA.'grafico.php?informe=quejas&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_testimonios']   = file_get_contents( RUTA.'grafico.php?informe=testimonios&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_usuarios']      = file_get_contents( RUTA.'grafico.php?informe=usuarios&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_pedidos']       = file_get_contents( RUTA.'grafico.php?informe=pedidos&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_boletines']     = file_get_contents( RUTA.'grafico.php?informe=boletines&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );    
    //$la_Registro['grafico_tickets']       = file_get_contents( RUTA.'grafico.php?informe=tickets&bd=hfachino_siev&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );

    //$la_Registro['grafico_lista_tickets'] = file_get_contents( RUTA.'grafico.php?informe=lista_tickets&bd=hfachino_siev&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );    
    //$la_Registro['grafico_seguimiento']   = file_get_contents( RUTA.'grafico.php?informe=seguimiento&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_callback']      = file_get_contents( RUTA.'grafico.php?informe=callback&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );
    //$la_Registro['grafico_llamadas']      = file_get_contents( RUTA.'grafico.php?informe=llamadas&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );    
    //$la_Registro['grafico_noleidos']      = file_get_contents( RUTA.'grafico.php?informe=noleidos&bd='.$bd.'&usuario='.$usuario.'&year='.$year.'&mes='.$mes.'&resultados='.$resultados );            

    // BUSCAR LAS LLAMADAS IP
    /*$lc_Query           = "select cuentaip, pinip FROM clientes WHERE custom_cliente = '".$_SESSION['cliente_micro']."' ";
    $lo_ObjetoConsulta  = HacerConsultaQuery( $lc_Query );
    if ( $lo_ObjetoConsulta->DB_registros > 0 && trim($lo_ObjetoConsulta->DB_resultado[0]['cuentaip'] != "" ) {
        ob_start();
            
            error_reporting('');
            ini_set('display_errors',0);
            
            $usr  = $lo_ObjetoConsulta->DB_resultado[0]['cuentaip']; // "38112957";
            $pwd  = $lo_ObjetoConsulta->DB_resultado[0]['pinip']; // "p5UxjjsH";
                    
            INCLUDE "./tari_pag.php";
            $lc_Contenido_Llamadas = ob_get_contents();
        ob_end_clean();
    }
    */

    // BUSCAR LOS CALLBACK
/*
    $lc_Query               = "select fecha, telefono_usuario FROM callback WHERE fecha like '%".$year."%' ORDER BY fecha DESC";
    $lo_Objeto_Callback     = HacerConsultaQuery( $lc_Query, $la_Registro['basedatos'] );
    $lc_Contenido_Callback  = "";
    
    echo $lc_Query;
     
    if ( $lo_Objeto_Callback->DB_registros > 0 ) {
        ob_start();
            
            echo "<table>
                    <tr><th>Fecha</th><th>Telfono</th></tr>";
            foreach ( $lo_Objeto_Callback->DB_resultado as $lo_Registro ) { 
                echo "<tr><td valign='top'>".$lo_Registro['fecha']."</td><td valign='top' style='padding-left:20px;'>".$lo_Registro['telefono_usuario']."</td></tr>";
            }
            echo "</table>";
            
            $lc_Contenido_Callback = ob_get_contents();
        ob_end_clean();
    }
    
    $la_Registro['lista_callback'] = $lc_Contenido_Callback;
*/
    
    ob_start();
        // TOMAR EL AO ACTUAL
        $li_Year_Actual = date('Y');
        if ( isset($_GET['correo']) ) {
            echo "<option value='".$year."'>".$year."</option>"; 
        } else {
            for ($li_Year_Select=$li_Year_Actual; $li_Year_Select >= 2008; $li_Year_Select--) {
                echo "<option value='".$li_Year_Select."'>".$li_Year_Select."</option>";
            }
        }
        $lc_Contenido_Year = ob_get_contents();
    ob_end_clean();     


    //$la_Registro['llamadas_ip']           = $lc_Contenido_Llamadas;    
    $la_Registro['year_informe']          = $lc_Contenido_Year;
    $la_Registro['year']                  = $year;//$li_Year_Actual;
         
    if ( !isset($_GET['menu']) ) {
        $la_Registro_Menu = array('year_informe'=>$lc_Contenido_Year,'weblider'=>$la_Registro['weblider']);    
        $la_Registro['menu'] = Combinar_Registro_Plantilla( $la_Registro_Menu,$lc_Plantilla_Menu );      
    } else {
    
    }
    
    $la_Registro['ver_menu'] = (isset($_GET['menu'])) ? 'display:none;' : 'display:block;';
    
    // *******************************************************************
    // TOMAR LOS DATOS DE ANALYTICS, ALMACENADOS EN hfachino_siev
    // *******************************************************************
    ob_start();    
        $lc_Query             = ( $mes > 0 ) ? "select * FROM analytics WHERE custom_cliente = '".$_SESSION['cliente_micro']."' AND YEAR(fecha_inicio) = ".$year." AND MONTH(fecha_inicio) = ".$mes." ORDER BY fecha_inicio DESC " : "select * FROM analytics WHERE custom_cliente = '".$_SESSION['cliente_micro']."' AND YEAR(fecha_inicio) = ".$year." AND YEAR(fecha_final) = ".$year." ORDER BY fecha_inicio DESC ";
        $lo_Objeto_Analytics  = HacerConsultaQuery( $lc_Query, 'hfachino_siev' );
        
        if ( $lo_Objeto_Analytics->DB_registros > 0 ) {
            echo "<table id='tabla_analytics' style='width:800px;margin:0px auto;margin-bottom:30px;' >
                    <tr>
                        <td style='text-align:center;font-weight:bold;'>Perodo</td>
                        <td style='text-align:center;font-weight:bold;'>Sesiones</td>
                        <td style='text-align:center;font-weight:bold;'>Usuarios</td>
                        <td style='text-align:center;font-weight:bold;'>Pginas vistas</td>
                        <td style='text-align:center;font-weight:bold;'>Pginas/Sesin</td>
                        <td style='text-align:center;font-weight:bold;'>Duracin sesin</td>
                        <td style='text-align:center;font-weight:bold;'>Rebote</td>
                        <td style='text-align:center;font-weight:bold;'>Nuevas sesiones</td>
                    </tr>";        
            foreach ( $lo_Objeto_Analytics->DB_resultado as $lo_Registro_Analytics ) {
                echo "<tr>
                          <td style='text-align:center;' >".$lo_Registro_Analytics['fecha_inicio'].'&nbsp;&nbsp;-&nbsp;&nbsp;'.$lo_Registro_Analytics['fecha_final']."</td>
                          <td style='text-align:center;' >".number_format($lo_Registro_Analytics['sesiones'])."</td>
                          <td style='text-align:center;' >".number_format($lo_Registro_Analytics['usuarios'])."</td>
                          <td style='text-align:center;' >".number_format($lo_Registro_Analytics['paginas_vistas'])."</td>
                          <td style='text-align:center;' >".number_format( ($lo_Registro_Analytics['paginas_vistas'] / $lo_Registro_Analytics['sesiones']),2)."</td>
                          <td style='text-align:center;' >".number_format( ($lo_Registro_Analytics['duracion_sesion'] / 60),2 )."</td>
                          <td style='text-align:center;' >".$lo_Registro_Analytics['porcentaje_rebote']."%</td>
                          <td style='text-align:center;' >".$lo_Registro_Analytics['porcentaje_nuevas_sesiones']."%</td>
                      </tr>";
            }
            echo "</table>";    
        }
        $lc_Contenido_Analytics = ob_get_contents();
    ob_end_clean();
    
    if ( $lo_Objeto_Analytics->DB_registros > 0 ) {
        $la_Registro['analytics'] = $lc_Contenido_Analytics; 
    } else {
        $la_Registro['ver_seccion_analytics'] = 'display:none;';    
    }

    // *******************************************************************
    // TOMAR LOS DATOS DE ANALYTICS, ALMACENADOS EN hfachino_siev
    // *******************************************************************
        
    //print_r( $GLOBALS );
    
    /*
    // BUSCAR LOS TICKETS
    $lc_Query             = "select custom_mensaje as label_mensaje, custom_estado as estado, custom_fecha as label_fecha_ingreso, fechares as fecha_respuesta, custom_respuesta FROM contactenos WHERE cliente='".$_SESSION['cliente_micro']."' AND custom_fecha like '%".$year."%' ORDER BY custom_fecha DESC";
    $lo_Objeto_Tickets    = HacerConsultaQuery( $lc_Query, 'hfachino_siev' );
    $lc_Contenido_Tickets = "";
    
    //echo $lc_Query;
     
    if ( $lo_Objeto_Tickets->DB_registros > 0 ) {
        ob_start();
            
            echo "<table>
                    <tr><th>Mensaje</th><th>Estado</th><th>Fecha</th><th>Respuesta</th></tr>";
            foreach ( $lo_Objeto_Tickets->DB_resultado as $lo_Registro ) { 
                echo "<tr><td valign='top'>".utf8_decode($lo_Registro['label_mensaje'])."<br><br><b>R./</b>".utf8_decode($lo_Registro['custom_respuesta'])."</td><td valign='top'>".$lo_Registro['estado']."</td><td style='width:120px;' valign='top'>".$lo_Registro['label_fecha_ingreso']."</td><td style='width:120px;' valign='top' >".$lo_Registro['fecha_respuesta']."</td></tr>";
            }
            echo "</table>";
            
            $lc_Contenido_Tickets = ob_get_contents();
        ob_end_clean();
    }
    
    $la_Registro['lista_tickets'] = $lc_Contenido_Tickets;
    */
    
    $la_Imagen_Resultados = array();
    $li_Mayor_Valor       = 1;
    
    // INICIALIZAR ARREGLOS
    foreach ( array_values($la_Meses) as $lc_Mes ) {
        // REGISTRAR LOS TOTALES
        $la_Registro[ 'total_'.ucfirst($lc_Mes) ]           = 0;
        // REGISTRAR LOS PORCENTAJES
        $la_Registro[ 'porcentaje_'.ucfirst($lc_Mes) ]      = 0;
        // PRESENTAR IMGENES DE ESTADO
        $la_Imagen_Resultados['imagen_'.ucfirst($lc_Mes) ]  = "";
        // PERMITIR EL PAGO DE LA FACTURA
        $la_Pagar_Factura['pagar_'.ucfirst($lc_Mes) ]       = "";
    }

    // PRODUCTO TIPO PAGO POR RESULTADOS MES 12
    //$lc_Id_Pago_Mensual = 12;    
    // BUSCAR LOS PAGOS REALIZADOS POR EL CLIENTE
    //$lc_Query_Facturas  = "select pedido.total, MONTH(facturacion.fecha_factura) as mes FROM facturacion INNER JOIN pedido_detalle ON facturacion.pedido_detalle = pedido_detalle.id INNER JOIN pedidos ON pedido_detalle.id = pedidos.idpedido WHERE DATE_FORMAT(facturacion.fecha_factura,'%Y') = ".$year." AND pedidos.idproducto = ".$lc_Id_Pago_Mensual;
    //$lo_ObjetoConsulta  = HacerConsultaQuery( $lc_Query_Facturas, "hfachino_demofina" );

    /*    
    $la_Registro['total_Enero']     = 0;
    $la_Registro['total_Febrero']   = 0;
    $la_Registro['total_Marzo']     = 0;
    $la_Registro['total_Abril']     = 0;
    $la_Registro['total_Mayo']      = 0;
    $la_Registro['total_Junio']     = 0;
    $la_Registro['total_Julio']     = 0;
    $la_Registro['total_Agosto']    = 0;
    $la_Registro['total_Septiembre']= 0;
    $la_Registro['total_Octubre']   = 0;
    $la_Registro['total_Noviembre'] = 0;
    $la_Registro['total_Diciembre'] = 0;
    */
    
    foreach ( array_keys($la_Registro_Totales) as $li_Indice ) {
        
        $li_Mayor_Valor = ( $la_Registro_Totales[ $li_Indice ] > $li_Mayor_Valor ) ? $la_Registro_Totales[ $li_Indice ] : $li_Mayor_Valor; 
        // CONTROLAS LA CONDICIN DE PAGO
        $lb_Pagar       = true;
        
        switch ( $li_Indice ) {
            case 1  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Enero']     = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Enero']       = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Enero']      = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 2  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Febrero']   = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Febrero']     = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Febrero']    = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 3  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Marzo']     = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Marzo']       = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Marzo']      = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 4  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Abril']     = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Abril']       = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Abril']      = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 5  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Mayo']      = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Mayo']        = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Mayo']       = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 6  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Junio']     = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Junio']       = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Junio']      = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 7  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Julio']     = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Julio']       = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Julio']      = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 8  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Agosto']    = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Agosto']      = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Agosto']     = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 9  : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Septiembre']= number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Septiembre']  = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Septiembre'] = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 10 : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Octubre']   = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Octubre']     = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Octubre']    = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 11 : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Noviembre'] = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Noviembre']   = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Noviembre']  = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
            case 12 : if ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) { $lb_Pagar = false; } $lc_Imagen_Factura = ( isset($la_Facturacion[ $li_Indice ]) && $la_Facturacion[ $li_Indice ] >= $la_Registro_Totales[ $li_Indice ] ) ? $lc_Factura_Pagada : $lc_Factura_Pendiente; $la_Registro['total_Diciembre'] = number_format($la_Registro_Totales[ $li_Indice ]); $la_Pagar_Factura['pagar_Diciembre']   = ( $la_Registro_Totales[ $li_Indice ] > 0 && $lb_Pagar == true ) ? "onclick=\"Pagar_Factura(".round($la_Registro_Totales[ $li_Indice ]).','.$year.','.$li_Indice.")\"": ""; $la_Imagen_Resultados['imagen_Diciembre']  = ( $la_Registro_Totales[ $li_Indice ] > 0 ) ? $lc_Imagen_Factura : "" ; break;
        }
    }
    
    $li_Alto_Grafico    = 100;
    
    /*
    $la_Registro['porcentaje_Enero']     = 0;
    $la_Registro['porcentaje_Febrero']   = 0;
    $la_Registro['porcentaje_Marzo']     = 0;
    $la_Registro['porcentaje_Abril']     = 0;
    $la_Registro['porcentaje_Mayo']      = 0;
    $la_Registro['porcentaje_Junio']     = 0;
    $la_Registro['porcentaje_Julio']     = 0;
    $la_Registro['porcentaje_Agosto']    = 0;
    $la_Registro['porcentaje_Septiembre']= 0;
    $la_Registro['porcentaje_Octubre']   = 0;
    $la_Registro['porcentaje_Noviembre'] = 0;
    $la_Registro['porcentaje_Diciembre'] = 0;
    */

    // RECORRER NUEVAMENTE PARA GENERAR EL GRFICO
    foreach ( array_keys($la_Registro_Totales) as $li_Indice ) {
    
        $li_Alto_Caso = number_format( ( ( $la_Registro_Totales[ $li_Indice ] * $li_Alto_Grafico) / $li_Mayor_Valor ), 1);
            
        switch ( $li_Indice ) {
            case 1  : $la_Registro['porcentaje_Enero']     = number_format($li_Alto_Caso,1); break;
            case 2  : $la_Registro['porcentaje_Febrero']   = number_format($li_Alto_Caso,1); break;
            case 3  : $la_Registro['porcentaje_Marzo']     = number_format($li_Alto_Caso,1); break;
            case 4  : $la_Registro['porcentaje_Abril']     = number_format($li_Alto_Caso,1); break;
            case 5  : $la_Registro['porcentaje_Mayo']      = number_format($li_Alto_Caso,1); break;
            case 6  : $la_Registro['porcentaje_Junio']     = number_format($li_Alto_Caso,1); break;
            case 7  : $la_Registro['porcentaje_Julio']     = number_format($li_Alto_Caso,1); break;
            case 8  : $la_Registro['porcentaje_Agosto']    = number_format($li_Alto_Caso,1); break;
            case 9  : $la_Registro['porcentaje_Septiembre']= number_format($li_Alto_Caso,1); break;
            case 10 : $la_Registro['porcentaje_Octubre']   = number_format($li_Alto_Caso,1); break;
            case 11 : $la_Registro['porcentaje_Noviembre'] = number_format($li_Alto_Caso,1); break;
            case 12 : $la_Registro['porcentaje_Diciembre'] = number_format($li_Alto_Caso,1); break;
        }    
    }
    
    // OCULTAR O PRESENTAR LA OPCIN DE PAGO POR RESULTADOS
    $la_Registro['ver_resultados'] = ( !isset($_GET['resultados']) ) ? 'display:none;' : '';                    

    if ( $la_Registro['ver_resultados'] == '' ) {
        /******************************
        // ASIGNAR EL TOTAL GENERAL 
        ******************************/
        
        $la_Registro[ 'totales_pagos_resultados' ] = "  <div style='padding-bottom:7px;' class='contenedor_totales' >
                                                      <!-- PAGO POR RESULTADOS -->
                                                      <h2 style='text-align:center;' id='titulo_grafico_seguimiento'>Pago por resultados ".$year."</h2>
                                                      <div style='text-align:left;padding-left:10px;' id='resultado_grafico_pago_resultados'>
                                                      
                                                          <table align='center' cellpadding='0' cellspacing='0' border='0' style='margin-top:20px;'>
                                                            <tbody align='center'>
                                                              <tr>
                                                              	  <td valign='bottom' style='".$la_Registro['ver_enero'].";padding:0px 4px;'      ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Enero']."</div><div ".$la_Pagar_Factura['pagar_Enero']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Enero']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_febrero'].";padding:0px 4px;'    ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Febrero']."</div><div ".$la_Pagar_Factura['pagar_Febrero']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Febrero']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_marzo'].";padding:0px 4px;'      ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Marzo']."</div><div ".$la_Pagar_Factura['pagar_Marzo']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Marzo']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_abril'].";padding:0px 4px;'      ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Abril']."</div><div ".$la_Pagar_Factura['pagar_Abril']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Abril']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_mayo'].";padding:0px 4px;'       ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Mayo']."</div><div ".$la_Pagar_Factura['pagar_Mayo']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Mayo']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_junio'].";padding:0px 4px;'      ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Junio']."</div><div ".$la_Pagar_Factura['pagar_Junio']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Junio']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_julio'].";padding:0px 4px;'      ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Julio']."</div><div ".$la_Pagar_Factura['pagar_Julio']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Julio']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_agosto'].";padding:0px 4px;'     ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Agosto']."</div><div ".$la_Pagar_Factura['pagar_Agosto']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Agosto']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_septiembre'].";padding:0px 4px;' ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Septiembre']."</div><div ".$la_Pagar_Factura['pagar_Septiembre']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Septiembre']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_octubre'].";padding:0px 4px;'    ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Octubre']."</div><div ".$la_Pagar_Factura['pagar_Octubre']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Octubre']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_noviembre'].";padding:0px 4px;'  ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Noviembre']."</div><div ".$la_Pagar_Factura['pagar_Noviembre']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Noviembre']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                                  <td valign='bottom' style='".$la_Registro['ver_diciembre'].";padding:0px 4px;'  ><div class='valor_barra_vertical' style='vertical-align:text-top'>".$la_Imagen_Resultados['imagen_Diciembre']."</div><div ".$la_Pagar_Factura['pagar_Diciembre']." class='barra_vertical' style='height:".$la_Registro['porcentaje_Diciembre']."px; background-color:#e46713;width:5.5em;text-shadow:#CCCCCC 0.1em 0.1em 0.1em;border-radius: 5px 5px 0px 0px;-webkit-border-radius: 5px 5px 0px 0px;box-shadow: 1px 1px 1px black;-webkit-box-shadow: 1px 1px 1px black;-moz-box-shadow: 1px 1px 1px black;margin-bottom:1px;' >&nbsp;</div></td>
                                                              </tr>
                                                              <tr id='etiq'>
                                                                  <td style='".$la_Registro['ver_enero'].";padding:0px 4px;'      > <div class='valor_resultados Total_Enero'      style='display: block;'>$ ".$la_Registro['total_Enero']."</div>     <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Enero</div></td>
                                                                  <td style='".$la_Registro['ver_febrero'].";padding:0px 4px;'    > <div class='valor_resultados Total_Febrero'    style='display: block;'>$ ".$la_Registro['total_Febrero']."</div>   <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Febrero</div></td>
                                                                  <td style='".$la_Registro['ver_marzo'].";padding:0px 4px;'      > <div class='valor_resultados Total_Marzo'      style='display: block;'>$ ".$la_Registro['total_Marzo']."</div>     <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Marzo</div></td>
                                                                  <td style='".$la_Registro['ver_abril'].";padding:0px 4px;'      > <div class='valor_resultados Total_Abril'      style='display: block;'>$ ".$la_Registro['total_Abril']."</div>     <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Abril</div></td>
                                                                  <td style='".$la_Registro['ver_mayo'].";padding:0px 4px;'       > <div class='valor_resultados Total_Mayo'       style='display: block;'>$ ".$la_Registro['total_Mayo']."</div>      <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Mayo</div></td>
                                                                  <td style='".$la_Registro['ver_junio'].";padding:0px 4px;'      > <div class='valor_resultados Total_Junio'      style='display: block;'>$ ".$la_Registro['total_Junio']."</div>     <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Junio</div></td>
                                                                  <td style='".$la_Registro['ver_julio'].";padding:0px 4px;'      > <div class='valor_resultados Total_Julio'      style='display: block;'>$ ".$la_Registro['total_Julio']."</div>     <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Julio</div></td>
                                                                  <td style='".$la_Registro['ver_agosto'].";padding:0px 4px;'     > <div class='valor_resultados Total_Agosto'     style='display: block;'>$ ".$la_Registro['total_Agosto']."</div>    <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Agosto</div></td>
                                                                  <td style='".$la_Registro['ver_septiembre'].";padding:0px 4px;' > <div class='valor_resultados Total_Septiembre' style='display: block;'>$ ".$la_Registro['total_Septiembre']."</div><div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Septiembre</div></td>
                                                                  <td style='".$la_Registro['ver_octubre'].";padding:0px 4px;'    > <div class='valor_resultados Total_Octubre'    style='display: block;'>$ ".$la_Registro['total_Octubre']."</div>   <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Octubre</div></td>
                                                                  <td style='".$la_Registro['ver_noviembre'].";padding:0px 4px;'  > <div class='valor_resultados Total_Noviembre'  style='display: block;'>$ ".$la_Registro['total_Noviembre']."</div> <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Noviembre</div></td>
                                                                  <td style='".$la_Registro['ver_diciembre'].";padding:0px 4px;'  > <div class='valor_resultados Total_Diciembre'  style='display: block;'>$ ".$la_Registro['total_Diciembre']."</div> <div style='clear:both;display:block;'></div><div class='verticalmente' style='position: relative;transform: rotate(-90deg);-o-transform: rotate(-90deg);-webkit-transform: rotate(-90deg);-moz-transform: rotate(-90deg);-ms-filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);writing-mode: tb-rl;filter: flipv fliph;margin: 0 -1em;width: 4.5em;height: 20px;padding-right: 20px;'>Diciembre</div></td>
                                                              </tr>
                                                            </tbody>
                                                          </table>                
                                                      </div>
                                                      <!-- PAGO POR RESULTADOS -->
                                                  </div>";

                                                  
    }

    
    /***********************************************
    // ASIGNAR EL TOTAL GENERAL POR CADA INFORME
    ***********************************************/ 
    foreach ( array_keys($la_Total_Titulo_Informe) as $lc_Informe ) {
        if ( $la_Total_Titulo_Informe[ $lc_Informe ] == 0 ) {
            // OCULTAR TODA LA SECCIN
            //$la_Registro[ 'ver_seccion_'.$lc_Informe ] = ";visibility:hidden;height:1px;border:none;overflow:hidden;max-height:1px;width:1px;";
            $la_Registro[ 'ver_seccion_'.$lc_Informe ] = ""; 
        } else {
            if ( $la_Registro['ver_resultados'] == '' ) {
                $la_Registro[ 'total_'.$lc_Informe ] = "<div class='informe_resultados' style='text-align:center;' >Total pago por resultados $ <b>".number_format($la_Total_Titulo_Informe[ $lc_Informe ])."</b> </div> ";
            }
        }
    }
    
    echo Combinar_Registro_Plantilla( $la_Registro,$lc_Plantilla_Informe );

    //echo $la_Registro['grafico_preguntas'];
    //print_r( array_keys($la_Registro) );
    //print_r( $la_Registro_Totales );
     
?>    
    