// JavaScript Document

/* CONFIGURAR LOS MENSAJES */
var la_Mensaje_Cotizador  = new Array();
la_Mensaje_Cotizador['Seleccionar_Plan']          = 'Debe seleccionar un Plan. Favor verificar.';
la_Mensaje_Cotizador['Adultos_Incorrecto']        = 'El nmero de adultos es incorrecto. Favor verificar.';
la_Mensaje_Cotizador['Informacion_Solicitante']   = 'Debe digitar todos los campos del solicitante. Favor verificar.';
la_Mensaje_Cotizador['Adultos_Mayor_Cero']        = 'El nmero de adultos debe ser superior a cero. Favor verificar.';
la_Mensaje_Cotizador['Noches_Mayor_Cero']         = 'El nmero de noches debe ser superior a cero. Favor verificar.';
la_Mensaje_Cotizador['Fecha_No_Aplica']           = 'En esta fecha no aplica el plan.';
la_Mensaje_Cotizador['Costo_Obligatorio']         = 'Este valor es aproximado, obligatorio y sujeto a cambios, ser incluido en el valor total de la cotizacin, el asesor de su viaje lo confirmar con la reserva.';
la_Mensaje_Cotizador['Capacidad_Superada_Adulto'] = 'La capacidad de la habitacin elegida por usted no permite adicionar ms personas. Seleccione otra habitacion de mayor capacidad o contacta nuestros asesores.';
la_Mensaje_Cotizador['Capacidad_Superada_Menor']  = 'La capacidad de la habitacin elegida por usted no permite adicionar ms personas. Seleccione otra habitacion de mayor capacidad o contacta nuestros asesores.';
la_Mensaje_Cotizador['Autorizar_Envio_Mail']      = 'Para realizar el envo de la informacin, debe autorizar el recibo de la misma. Gracias.';
la_Mensaje_Cotizador['No_Permitir_Registro']      = 'Al desactivar la opcin de permitir registrar tus datos, no podrs realizar reservas, recibir boletines, promociones, descuentos.<br>';
la_Mensaje_Cotizador['Pie_Calendario']            = "<div style='text-align:justify;vertical-align:middle;'>Las fechas marcas con el smbolo <img src='" + gc_Ruta_Aplicativo + "Iconos/close.png'>, corresponden a das sin disponibilidad.</div>";

var la_Mes_Calendario = new Array('enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre');

// ALMACENAR LAS CORRDENADAS DEL MOUSE
var lo_Mouse = new Object();
lo_Mouse.X   = 0;
lo_Mouse.Y   = 0;

// CREAR UN OBJETO PARA EL COTIZADOR
var go_Objeto_Cotizador = new Object();

// CREAR VARIABLE GLOBAL QUE ALMACENE LA HABITACIN SELECCIONADA
var gc_Habitacion_Seleccionada = null;
var gc_Habitacion_Cerrar       = null;

// CREAR UN OBJETO GLOBAL QUE ALMACENA LAS FECHAS DE LAS COTIZACIONES
var ga_Rango_Fechas_Cotizaciones  = new Array();
  
// CREAR UN OBJETO GLOBAL QUE ALMACENA LAS FECHAS CON SUS SOBRECOSTOS
var ga_Rango_Fechas_Sobrecostos   = new Array();
        
function Formato_Fecha_Y_M_D (ld_Fecha) {
    
    var lc_Reg_Exp_DMY  = /([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/;
    var la_Resultado    = lc_Reg_Exp_DMY.exec(ld_Fecha);
    var lc_Fecha        = false;
    if (la_Resultado == null) {
        var lc_Reg_Exp_YMD = /([0-9]{4})[\/|\-]([0-9]{2})[\/|\-]([0-9]{2})/;
        var la_Resultado = lc_Reg_Exp_YMD.exec(ld_Fecha);
        if (la_Resultado != null) { lc_Fecha = la_Resultado[1] + '-' + la_Resultado[2] + '-' + la_Resultado[3]; }
    } else {
        lc_Fecha = la_Resultado[3] + '-' + la_Resultado[2] + '-' + la_Resultado[1];
    }

    if (lc_Fecha == '') { alert('Fecha invlida '+ld_Fecha); }
    return lc_Fecha;
}

function Formato_Fecha(ld_Fecha) {
    // CAMBIAR EL FORMATO DE FECHA
    var lc_RegExp_DMY    = /([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/;
    var la_Resultado  = lc_RegExp_DMY.exec(ld_Fecha);
    if (la_Resultado != null) { var ld_Fecha = la_Resultado[3] + '-' + la_Resultado[2] + '-' + la_Resultado[1]; }
    return ld_Fecha;
}

function Objeto_Fecha (li_Dia,li_Mes,li_Year) {
    // LOS MESES VAN DEL 0 AL 11
    li_Mes = parseInt(li_Mes.replace(/^0/,'')) - 1;

    this.Fecha = new Date(li_Year,li_Mes,li_Dia);
    this.Dia   = li_Dia;
    this.Mes   = li_Mes;
    this.Year  = li_Year;
}

function Crear_Objeto_Fecha(ld_Fecha) {
    var lc_RegExp_DMY    = /([0-9]{1,2})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{4})/;
    var lc_RegExp_YMD    = /([0-9]{4})[\/|\-]([0-9]{1,2})[\/|\-]([0-9]{1,2})/;

    var la_Resultado  = lc_RegExp_DMY.exec(ld_Fecha);
    if (la_Resultado != null) {
        var lo_Objeto = new Objeto_Fecha(la_Resultado[1],la_Resultado[2],la_Resultado[3]);
    } else {
        var la_Resultado  = lc_RegExp_YMD.exec(ld_Fecha);
        if (la_Resultado != null) {
            var lo_Objeto = new Objeto_Fecha(la_Resultado[3],la_Resultado[2],la_Resultado[1]);
        } else {
            lo_Objeto = false;
        }
    }
    return lo_Objeto;
}

function Asignar_Fecha_Inhabil( lc_Id_Text, event, lo_Objeto ) {
    scwDisabledDates        = new Array();
    // DESHABILITAR LAS FECHAS ANTERIORES A LA FECHA ACTUAL
    var lo_Fecha            = Crear_Objeto_Fecha( $('#fc_Fecha_Actual')[0].value );
    scwDisabledDates[0]     = [new Date(1970,0,1), new Date(lo_Fecha.Year, lo_Fecha.Mes, lo_Fecha.Dia)];
    
    // SI POSEE FECHA LMITE, DESHABILITAR LAS FECHAS POSTERIORES
    if ( $('#fc_Fecha_Limite_Calendario')[0].value != '' ) {
        var lo_Fecha_Limite     = Crear_Objeto_Fecha( $('#fc_Fecha_Limite_Calendario')[0].value );
        scwDisabledDates[0]     = [ new Date(lo_Fecha_Limite.Year, lo_Fecha_Limite.Mes, lo_Fecha_Limite.Dia), new Date( (lo_Fecha_Limite.Year + scwDropDownYears), lo_Fecha_Limite.Mes, lo_Fecha_Limite.Dia) ];
    }

    var li_Total_Registros  = ga_Fecha_Inhabil.length;
    for (li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
        scwDisabledDates[scwDisabledDates.length] = Crear_Objeto_Fecha( ga_Fecha_Inhabil[li_Registro] ).Fecha;
    }

    // ADICIONAR LAS FECHAS DONDE NO SE POSEA DISPONIBILIDAD 
    Insertar_Texto_Calendario();
    
    // ABRIR EL CALENDARIO
    scwShow(document.getElementById( lc_Id_Text ), event);

    Seleccionar_Calendario( lo_Objeto );            

    // ADICIONAR MENSAJE EN EL PIE DE PGINA
    $('#scwFoot').append( la_Mensaje_Cotizador['Pie_Calendario'] );
    
    // ASIGNAR EVENTO UNA VEZ SE CIERRE EL CALENDARIO
    scwNextAction = Validar_Fecha.runsAfterSCW(lo_Objeto);
    
    // DESPLAZAR EL ALMANAQUE AL LUGAR DEL CLICK
    Posicionar_Almanaque( event );
}

function Posicionar_Almanaque( event ) {
    var li_Distancia = 10;
    //alert( lo_Mouse.X + ' ' + event.pageX + ' ' + event.screenX );
    $('#scw').css('top'   , ( lo_Mouse.Y + li_Distancia ) + 'px' );
    $('#scw').css('left'  , ( lo_Mouse.X + li_Distancia ) + 'px' );
    
    $('#scwIframe').css('top'   , ( event.pageY + li_Distancia ) + 'px' );
    $('#scwIframe').css('left'  , ( event.pageX + li_Distancia ) + 'px' );
    //alert( event.pageY + ' ' + event.pageX );
}

function Seleccionar_Calendario(lo_Objeto) {
    //var lo_Select = document.getElementById('scwMonths');
    //lo_Select.selectedIndex = <?php echo intval( date('n') ) - 1; ?>;

    $('#scw')[0].style.top  = lo_Objeto.offsetTop  + 'px';
    $('#scw')[0].style.left = ( parseInt( lo_Objeto.offsetLeft ) + 20 ) + 'px';
    
    $('#scwIframe')[0].style.top  = lo_Objeto.offsetTop  + 'px';
    $('#scwIframe')[0].style.left = ( parseInt( lo_Objeto.offsetLeft ) + 20 ) + 'px';
}          				

function Ocultar_Boton_Calendario() {
    $('#fc_Fecha_Inicio').parent().find('img').hide();
    $('#fc_Fecha_Limite').parent().find('img').hide();
}

function Iniciar_Fechas_Cotizador() {
    if ( $('#fc_Fecha_Inicio_Calendario')[0].value != '' || $('#fc_Fecha_Inicio_Calendario')[0].value != '0000-00-00' ) {
        // SI LA FECHA ES MAYOR A LA FECHA ACTUAL, ENTONCES ACTUALIZAR 
        if ( Crear_Objeto_Fecha( $('#fc_Fecha_Inicio_Calendario')[0].value ).Fecha >  Crear_Objeto_Fecha( $('#fc_Fecha_Actual')[0].value ).Fecha ) {
            $('#fc_Fecha_Inicio')[0].value = $('#fc_Fecha_Inicio_Calendario')[0].value;
            $('#fc_Fecha_Limite')[0].value = $('#fc_Fecha_Inicio_Calendario')[0].value;
        } else {
            $('#fc_Fecha_Inicio')[0].value = $('#fc_Fecha_Actual')[0].value;
            $('#fc_Fecha_Limite')[0].value = $('#fc_Fecha_Actual')[0].value;
        }

        // SI EL NMERO MNIMO DE NOCHES ES IGUAL AL NMERO MXIMO DE NOCHES
        var li_Minimo_Dias = Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ); 
        var li_Maximo_Dias = Tomar_Numero( $('#fc_Maximo_Dias').attr('value') );

        if ( li_Minimo_Dias == li_Maximo_Dias ) { Validar_Fecha(); Ocultar_Boton_Calendario(); }

    } else {    
        $('#fc_Fecha_Inicio')[0].value = $('#fc_Fecha_Actual')[0].value;
        $('#fc_Fecha_Limite')[0].value = $('#fc_Fecha_Actual')[0].value;
    }
}

function Inicializar_Totales() {
    Asignar_Valor('fc_Costo',0);
    Asignar_Valor('fc_Costo_Total',0);
}

function Cargar_Fechas_Temporada() {
    // INICIALIZAR EL ARREGLO DE FECHAS INHBILES
    ga_Fecha_Inhabil = new Array();

    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'cotizador_fecha_inhabil');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', document.getElementById('fc_Temporada').value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Convertir_Fecha_Inhabil()' );
                  
    Enviar_Objeto_Servidor( gc_Root + 'php/Traer_Detalle.php',la_Arreglo);              
}
    
function Convertir_Fecha_Inhabil() {
    ga_Fecha_Inhabil = document.getElementById('fc_Fecha_Inhabil').value.split(',');

    Iniciar_Fechas_Cotizador();
}

function Cargar_Datos_Plan_Calendario_Transporte (lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'costo_plan_adulto_menor_calendario_transporte');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Plan')[0].value + '|' + $('#fc_Temporada')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Cotizar();Cargar_Fecha_Inhabil_Calendario();' );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Validar_Fecha() {
    // VALIDAR QUE EXISTA PREVIAMENTE LA SELECCIN DE UN PLAN
    if ( document.getElementById('fc_Plan').value == "" ) { 
        alert('Debe seleccionar un Plan. Favor verificar.');              
    } else {
				// VALIDAR QUE EXISTA UNA SELECCIN DE ADULTOS
        var li_Adultos  = Tomar_Numero(document.getElementById('fc_Adultos').value);
/*                  				
				if ( li_Adultos == 0 ) {
				    try { parent.top.Mostrar_Mensaje('El nmero de adultos es incorrecto. Favor verificar.'); }
				    catch (exception) { alert('El nmero de adultos es incorrecto. Favor verificar.'); }
        } else {
*/
            var lo_Fecha_Actual = document.getElementById('fc_Fecha_Actual');
            var lo_Fecha_Inicio = document.getElementById('fc_Fecha_Inicio');
            var lo_Fecha_Limite = document.getElementById('fc_Fecha_Limite');

            if ( lo_Fecha_Limite.value == '' ) { Asignar_Valor( 'fc_Fecha_Limite', lo_Fecha_Inicio.value ); }
  
            var li_Minimo_Dias = Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ); 
            var li_Maximo_Dias = Tomar_Numero( $('#fc_Maximo_Dias').attr('value') );

            // LA FECHA LMITE DEPENDER DEL NMERO MNIMO DE DAS
            if ( li_Minimo_Dias > 1 && li_Maximo_Dias > 1 ) {
                if ( li_Minimo_Dias == li_Maximo_Dias ) {
                    var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                    lo_Objeto_Fecha_Inicial.Fecha.setDate( lo_Objeto_Fecha_Inicial.Fecha.getDate() + li_Minimo_Dias );
                    // ASIGNAR LA FECHA AL RANGO LMITE
                    Asignar_Valor( 'fc_Fecha_Limite', String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                    //alert( String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                }
            }
            
/*                                    
            // LA FECHA LMITE DEPENDER DEL NMERO MNIMO DE DAS
            if ( Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ) > 1 && Tomar_Numero( $('#fc_Maximo_Dias').attr('value') )     ) { 
                var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                lo_Objeto_Fecha_Inicial.Fecha.setDate( lo_Objeto_Fecha_Inicial.Fecha.getDate() + Tomar_Numero( $('#fc_Minimo_Dias').attr('value') ) );
                // ASIGNAR LA FECHA AL RANGO LMITE
                Asignar_Valor( 'fc_Fecha_Limite', String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
                //alert( String_Fecha(lo_Objeto_Fecha_Inicial.Fecha) );
            }
*/
            lo_Fecha_Inicio.value = Formato_Fecha(lo_Fecha_Inicio.value);
            lo_Fecha_Limite.value = Formato_Fecha(lo_Fecha_Limite.value);
            
            if (Es_Fecha_Menor(lo_Fecha_Inicio.value,lo_Fecha_Actual.value) == true) {
                 alert('La fecha inicial no puede ser menor a la fecha actual. Favor verificar.');
                 Asignar_Valor('fc_Fecha_Inicio',lo_Fecha_Actual.value);
            } else {
                if (Es_Fecha_Menor(lo_Fecha_Limite.value,lo_Fecha_Inicio.value) == true) {
                   //alert('La fecha lmite no puede ser menor a la fecha de inicio. Favor verificar.');
                   Asignar_Valor('fc_Fecha_Limite',lo_Fecha_Inicio.value);
                }
                
                // VALIDAR LA DISPONIBILIDAD NEGATIVA, SLO CUANDO SEA HOTELERA, PARA EL CASO DE PLAN NO APLICA
                if ( Tomar_Numero( $('#fc_Tipo_Cotizador').attr('value') ) == 2 ) {

                    // VALIDAR QUE EL RANGO SELECCIONADO, NO POSEA UNA DISPONIBILIDAD NEGATIVA
                    var lo_Objeto_Fecha_Inicial = Crear_Objeto_Fecha(lo_Fecha_Inicio.value);
                    var lo_Objeto_Fecha_Final   = Crear_Objeto_Fecha(lo_Fecha_Limite.value);
                    var lb_Fecha_Disponibilidad = true;
                                    
                    var li_Total_Fecha_Inhabil = ga_Fecha_Inhabil.length;
                    for (li_Registro=0; li_Registro < li_Total_Fecha_Inhabil; li_Registro++) {
                        // CREAR EL OBJETO TIPO FECHA PARA LAS FECHAS INHABILES
                        lo_Objeto_Fecha_Inhabil = Crear_Objeto_Fecha( ga_Fecha_Inhabil[li_Registro] );
                        if ( lo_Objeto_Fecha_Inhabil.Fecha >= lo_Objeto_Fecha_Inicial.Fecha && lo_Objeto_Fecha_Inhabil.Fecha <= lo_Objeto_Fecha_Final.Fecha ) { lb_Fecha_Disponibilidad = false; break; } 
                    }
                    
                    if ( lb_Fecha_Disponibilidad == false ) {
                        var lc_Mensaje = 'Se ha includo la fecha ' + lo_Objeto_Fecha_Inhabil.Year + '-' + (lo_Objeto_Fecha_Inhabil.Mes + 1) + '-' + lo_Objeto_Fecha_Inhabil.Dia + ', la cual no tiene disponibilidad. Favor verificar.';
                        
                        try { parent.Mostrar_Mensaje( lc_Mensaje ); }
                        catch(exception) { alert( lc_Mensaje ); }
                        
                        Asignar_Valor('fc_Fecha_Inicio',lo_Fecha_Actual.value);
                        Asignar_Valor('fc_Fecha_Limite',lo_Fecha_Actual.value);
                    }
                }
                // REALIZAR EL PROCESO DE COTIZACIN
                Cotizar();
            }
//        }
    }
}

function Icono_Desplegar_Ocultar(lo_Objeto,lc_Id_Contenedor) {
    lo_Objeto.src = (lo_Objeto.src.indexOf('btn_presentar') != -1) ? '../Iconos/btn_ocultar.gif' : '../Iconos/btn_presentar.gif';
    if (lo_Objeto.src.indexOf('btn_presentar') != -1) { Ocultar_Objeto(lc_Id_Contenedor); } else { Ocultar_Objeto(lc_Id_Contenedor,false); }
}	

function Enviar_Datos (lc_String_Select,lc_String_Texto) {
    if ( $('#recibir_email')[0].checked == false ) {

        var lc_Mensaje = la_Mensaje_Cotizador['Autorizar_Envio_Mail'];
        try { parent.Mostrar_Mensaje( lc_Mensaje ); }
        catch(exception) { alert( lc_Mensaje ); }
        
    } else {
        var lb_Enviar = true;
        if (lc_String_Select != '') { lb_Enviar = Validar_Objeto_Select (lc_String_Select); }
        if (lb_Enviar == true) { if (lc_String_Texto != '') { lb_Enviar = Validar_Objeto_Input(lc_String_Texto); } }
        if (lb_Enviar == false) {
            var lc_Mensaje = la_Mensaje_Cotizador['Informacion_Solicitante'];
            
            try { parent.Mostrar_Mensaje( lc_Mensaje ); }
            catch(exception) { alert( lc_Mensaje ); }
                       
        } else {
            var lb_enviar = false;
            
            // ELIMINAR LOS MENORES
            if (Tomar_Numero(document.getElementById('fc_Menores').value) == 0) { 
                $('#fc_Costos_Referencia_Usuario')[0].value = $('#fc_Costos_Referencia_Usuario')[0].value.replace( /\<\!--INICIO_ELIMINAR--\>[\x20-\xFA]{1,}\<\!--FIN_ELIMINAR--\>/i, "" );
                //alert($('#fc_Costos_Referencia_Usuario')[0].value);
            }
            
            // VALIDAR TOTAL DE NOCHES
            if (Tomar_Numero(document.getElementById('fc_Total_Dias').value) > 0) {                  
                // VALIDAR NMERO DE ADULTOS                  
                if (Tomar_Numero(document.getElementById('fc_Adultos').value) > 0) {
                    // ADICIONAR LA ZONA DE HABITACIONES
                    if ( document.getElementById('zona_habitaciones_disponibles') != null ) { $('#zona_habitaciones_disponibles').css('display','none'); document.getElementById('Formulario_Cotizar').appendChild( document.getElementById('zona_habitaciones_disponibles') ); }
                    
                    $('#Formulario_Cotizar').submit();
/*                                  
              			try { document.forms['Formulario_Datos'].submit(); lb_enviar = true; }
              			catch (exception) { }
              			if (lb_enviar==false) { 
                  			try { document.Formulario_Datos.submit(); lb_enviar = true; } 
                  			catch (exception) { }
                  			if (lb_enviar==false) {	document.getElementById('Formulario_Cotizar').submit();	}
              			}
*/
                } else {
                    try { parent.top.Mostrar_Mensaje( la_Mensaje_Cotizador['Adultos_Mayor_Cero'] ); }
                    catch(exception) { alert( la_Mensaje_Cotizador['Adultos_Mayor_Cero'] ); }	
                }
            } else {
                // ADICIONAR LA ZONA DE HABITACIONES
                if ( document.getElementById('zona_habitaciones_disponibles') != null ) { $('#zona_habitaciones_disponibles').css('display','none'); document.getElementById('Formulario_Cotizar').appendChild( document.getElementById('zona_habitaciones_disponibles') ); }
            
                $('#Formulario_Cotizar').submit();
/*            
          			try { document.forms['Formulario_Datos'].submit(); lb_enviar = true; }
          			catch (exception) { }
          			if (lb_enviar==false) { 
              			try { document.Formulario_Datos.submit(); lb_enviar = true; } 
              			catch (exception) { }
              			if (lb_enviar==false) {	document.getElementById('Formulario_Cotizar').submit(); }
          			} */
          			
                //parent.top.Mostrar_Mensaje( la_Mensaje_Cotizador['Noches_Mayor_Cero'] );	
            }
        }
    }
}

/*
function Configurar_Adulto(li_Valor) {
    var li_Adultos = parseInt(document.getElementById('fc_Adultos').value);
    if ((li_Adultos + li_Valor) > 0) { Asignar_Valor('fc_Adultos',li_Adultos + li_Valor); Cotizar(); }
}

function Configurar_Menor(li_Valor) {
    var li_Menor = parseInt(document.getElementById('fc_Menores').value);
    if ((li_Menor + li_Valor) >= 0) { Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar(); }
}
*/
function Cargar_Datos_Plan (lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'costo_plan_adulto_menor');    
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', document.getElementById('fc_Plan').value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Cotizar(); Cargar_Fecha_Inhabil_Calendario(); Cargar_Tipo_Calendario(); ');

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Cargar_Tipo_Calendario() {
    Cargar_Lista_Desplegable( 'fc_Temporada', 'tipo_calendario_portafolio' , document.getElementById('fc_Id_Portafolio').value );
}

function Cargar_Costos_Adicionales(lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion', 'Tomar_Costos_Adicionales' );    
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', lc_Id_Plan );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

/*
function Cotizar() {
    var li_Costo_Adulto = parseInt(document.getElementById('fc_Costo_Adulto_Dia').value);
    var li_Costo_Menor  = parseInt(document.getElementById('fc_Costo_Menor_Dia').value);
    
    var li_Adultos      = parseInt(document.getElementById('fc_Adultos').value);
    var li_Menores      = parseInt(document.getElementById('fc_Menores').value);
    
    var lo_Fecha_Inferior = Crear_Objeto_Fecha(document.getElementById('fc_Fecha_Inicio').value);
    var lo_Fecha_Superior = Crear_Objeto_Fecha(document.getElementById('fc_Fecha_Limite').value);

    if (lo_Fecha_Inferior != false && lo_Fecha_Superior != false) { var li_Dias = ((lo_Fecha_Superior.Fecha - lo_Fecha_Inferior.Fecha) / (1000 * 60 * 60 * 24)); } else { li_Dias = 0; } 

    // A PARTIR DE LOS DAS CONOCER PRECIOS POR ESTANCIA
    li_Costo_Adulto_Medida = Existe_Estancia (li_Dias, 1);
    li_Costo_Menor_Medida  = Existe_Estancia (li_Dias, 2);

    if (li_Costo_Adulto_Medida != false) { li_Costo_Adulto = li_Costo_Adulto_Medida; }
    if (li_Costo_Menor_Medida  != false) { li_Costo_Menor  = li_Costo_Menor_Medida;  }

    if ( li_Dias > 0 ) {    
        var li_Total_Costo_Adulto = (li_Costo_Adulto_Medida != false) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos * li_Dias);
        var li_Total_Costo_Menor  = (li_Costo_Menor_Medida  != false) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores * li_Dias); 
    } else {
        var li_Total_Costo_Adulto = (li_Costo_Adulto_Medida != false) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos);
        var li_Total_Costo_Menor  = (li_Costo_Menor_Medida  != false) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores); 
    }    
    
    //var li_Cotizacion   = (li_Costo_Adulto * li_Adultos) + (li_Costo_Menor * li_Menores);
    var li_Cotizacion   = (li_Total_Costo_Adulto + li_Total_Costo_Menor);
    
    //Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion * li_Dias));
    Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion));
    Asignar_Valor('fc_Total_Dias',li_Dias);
    Calcular_Adicionales();
}
*/

/*
function Existe_Estancia (li_Dias, li_Tipo_Usuario) { 
    var li_Total_Estancia = ga_Costo_Usuario_Estancia.length;
    var lb_Resultado      = false;
    if (li_Total_Estancia > 0) {
        for (var li_Estancia=0; li_Estancia < li_Total_Estancia; li_Estancia++) {
            if (ga_Costo_Usuario_Estancia[li_Estancia].Equivalencia == li_Dias && ga_Costo_Usuario_Estancia[li_Estancia].Usuario == li_Tipo_Usuario) {
                lb_Resultado = parseInt(ga_Costo_Usuario_Estancia[li_Estancia].Costo); break;
            }
        }
    }
    return lb_Resultado;
}
*/

function Existe_Estancia (li_Dias, li_Tipo_Usuario) { 
    var li_Total_Estancia = ga_Costo_Usuario_Estancia.length;
    var lb_Resultado      = false;
    if (li_Total_Estancia > 0) {
        for (var li_Estancia=0; li_Estancia < li_Total_Estancia; li_Estancia++) {
            if (ga_Costo_Usuario_Estancia[li_Estancia].Equivalencia == li_Dias && ga_Costo_Usuario_Estancia[li_Estancia].Usuario == li_Tipo_Usuario) {
                lb_Resultado = parseInt(ga_Costo_Usuario_Estancia[li_Estancia].Costo); break;
            }
        }
    }
    return lb_Resultado;
}

/*
function Existe_Sobrecosto ( lc_Fecha, li_Tipo_Usuario ) { 
    var li_Total_Registros  = ga_Rango_Fechas_Sobrecostos.length;
    var lb_Resultado        = false;
    if (li_Total_Registros > 0) {
        //alert( 'Buscar ' + lc_Fecha );
        for (var li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
            if (ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha == lc_Fecha && ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario == li_Tipo_Usuario && ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte == $('#fc_Transporte').attr('value') ) {            
                lb_Resultado = 1 + parseFloat( ga_Rango_Fechas_Sobrecostos[li_Registro].Porcentaje / 100); break;
            }
        }
    }
    return lb_Resultado;
}
*/

function Existe_Sobrecosto ( lc_Fecha, li_Tipo_Usuario ) { 
    var li_Total_Registros  = ga_Rango_Fechas_Sobrecostos.length;
    // CUANDO LAS CONSULTAS SON COMPUESTAS, RECIBIR EL PARMETRO DE DAS
    var li_Comparar_Dias    = (arguments.length >= 3) ? arguments[2] : $('#fc_Total_Dias').attr('value');
    
    var lb_Resultado        = false;
    if (li_Total_Registros > 0) {
        //alert( 'Buscar ' + lc_Fecha );
        for (var li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
            //alert( ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha + ' ' + lc_Fecha + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario + ' ' + li_Tipo_Usuario + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte + ' ' + $('#fc_Transporte').attr('value') + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Estancia + ' ' + $('#fc_Total_Dias').attr('value') );
            
            $('#objeto_validador').append("<div>" + ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha + ' ' + lc_Fecha + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario + ' ' + li_Tipo_Usuario + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte + ' ' + $('#fc_Transporte').attr('value') + ' ' + ga_Rango_Fechas_Sobrecostos[li_Registro].Estancia + ' ' + $('#fc_Total_Dias').attr('value') + "</div>" );
            
            if (ga_Rango_Fechas_Sobrecostos[li_Registro].Fecha == lc_Fecha && ga_Rango_Fechas_Sobrecostos[li_Registro].Usuario == li_Tipo_Usuario && ga_Rango_Fechas_Sobrecostos[li_Registro].Transporte == $('#fc_Transporte').attr('value') && ga_Rango_Fechas_Sobrecostos[li_Registro].Estancia == li_Comparar_Dias ) {
                $('#objeto_validador').append("<div>Si existe " + ( 1 + parseFloat( ga_Rango_Fechas_Sobrecostos[li_Registro].Porcentaje / 100) ) + "</div>" );                
                lb_Resultado = 1 + parseFloat( ga_Rango_Fechas_Sobrecostos[li_Registro].Porcentaje / 100); break;
            }
        }
    }
    return lb_Resultado;
}

function Mostrar_Mensaje(lc_Mensaje) {
    jAlert(lc_Mensaje, 'Mensaje');
}

function Validar_Cantidad_Adicionales( lo_Objeto ) {
    var li_Valor = Tomar_Numero( lo_Objeto.value );

    if ( li_Valor > 0 ) { lo_Objeto.value = li_Valor; } else { lo_Objeto.value = 1; }

    Calcular_Adicionales();
}

function Calcular_Adicionales() {
		var la_NombreObjeto     = document.getElementsByName('fc_Servicio[]');
		var la_Seleccion        = new Array();
		
    var li_Adultos      = Tomar_Numero(document.getElementById('fc_Adultos').value);
    var li_Menores      = Tomar_Numero(document.getElementById('fc_Menores').value);
    var li_Costo_Basico = Tomar_Numero(document.getElementById('fc_Costo').value);

		var li_Total_Adicional  = 0;
		for (var li_Ciclos=0; li_Ciclos < la_NombreObjeto.length; li_Ciclos++) {
				if (la_NombreObjeto[li_Ciclos].checked == true) { 
            // DIVIDIR EL VALUE
				    var la_Valor  = la_NombreObjeto[li_Ciclos].value.split("|");
            // EL VALUE POSEE 
            //    SERVICIO_GENERAL
            //    COSTO
            //    TIPO SERVICIO
            //    TIPO USUARIO
            if (la_Valor.length == 4) {
                var li_Costo_Adicional  = Tomar_Numero(la_Valor[1]);
                // 1-POR PERSONA
                if (la_Valor[2] == 1) {
                    // li_Costo_Adicional = (li_Adultos + li_Menores) * li_Costo_Adicional;
                    // 1 ADULTOS    2 - NIOS
                    switch (la_Valor[3]) {
                        case '1'  : li_Costo_Adicional = li_Adultos * li_Costo_Adicional; break;
                        case '2'  : li_Costo_Adicional = li_Menores * li_Costo_Adicional; break;
                    }
                }
            }
            
            // TOMAR LA CANTIDAD
            var li_Id_Cantidad  = la_NombreObjeto[li_Ciclos].id.replace('fc_Servicio_Adicional_','fc_Cantidad_Adicional_');
            var li_Cantidad     = Tomar_Numero( $('#' + li_Id_Cantidad ).attr('value') );

            li_Total_Adicional = (li_Cantidad > 0) ? (li_Total_Adicional + (li_Costo_Adicional * li_Cantidad)) : (li_Total_Adicional + li_Costo_Adicional);
            //li_Total_Adicional = li_Total_Adicional + li_Costo_Adicional;
        }
		}

		Asignar_Valor('fc_Costo_Adicional',Formatear_Numero(li_Total_Adicional));
		Asignar_Valor('fc_Costo_Total',Formatear_Numero(li_Total_Adicional + li_Costo_Basico));

    // if ( li_Adultos > 0 && (li_Total_Adicional + li_Costo_Basico) == 0 && document.getElementById('fc_Total_Dias').value != '0') { parent.top.Mostrar_Mensaje('Para los das seleccionados, no se posee un valor predeterminado. Si desea mayor informacin, favor comunicarse con un asesor.'); Asignar_Valor('fc_Total_Dias',0); }      				
}

function Cargar_Plan_Ciudad_Salida (lc_Id_Ciudad) {
    //Cargar_Lista_Desplegable('fc_Plan','lista_plan_ciudad_salida',lc_Id_Ciudad);
    Cargar_Lista_Desplegable('fc_Transporte','lista_transporte_ciudad_salida',lc_Id_Ciudad);
}

function Cargar_Lista_Desplegable(lc_Objeto_Destino,lc_Detalle_Lista,lc_Parametro){
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'id', lc_Detalle_Lista );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'objeto', lc_Objeto_Destino );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', lc_Parametro );

    Enviar_Objeto_Servidor( gc_Root + 'php/Cargar_Select.php',la_Arreglo ); 			 
}

function Validar_Fecha_Inhabil(lo_Picker) {

    var li_Total_Fechas = ga_Fecha_Inhabil.length;
    if (li_Total_Fechas > 0) {
        var lc_Year   = lo_Picker.document.getElementById('Year_Picker').value;
        var lc_Mes    = parseInt(lo_Picker.document.getElementById('Mes_Calendario').value) + 1;
        var li_Mes    = (lc_Mes < 10) ? '0' + lc_Mes : lc_Mes;

        // CADENA A BUSCAR
        var lc_Buscar = lc_Year + '-' + li_Mes;
        
        for (var li_Fecha=0; li_Fecha < li_Total_Fechas; li_Fecha++) {
            if (ga_Fecha_Inhabil[li_Fecha].indexOf(lc_Buscar) != -1) {
                // BUSCAR EL DA Y MARCARLO COMO INHBIL
                Marcar_Dia_Picker(lo_Picker,ga_Fecha_Inhabil[li_Fecha] );
            }
        }
    }
}
/*              
function Marcar_Dia_Picker (lo_Picker,lc_Dia) {
    var lo_Dia = lo_Picker.document.getElementById('dia_'+lc_Dia.replace(/^0/,''));
    lo_Dia.innerHTML = '';
    lo_Dia.style.backgroundImage    = 'url(' + gc_Root + 'aplicaciones/Iconos/close.png)';
    lo_Dia.style.backgroundPosition = 'center';
    lo_Dia.style.backgroundRepeat   = 'no-repeat';
    lo_Dia.style.border             = '1px solid #000000';
    lo_Dia.style.height             = '18px';
    lo_Dia.onclick                  = function (e) { alert('En esta fecha no aplica el plan.'); }
}
*/

function Marcar_Dia_Picker (lo_Picker,lc_Dia) {

    var la_Fecha = lc_Dia.split('-');
    if (la_Fecha.length == 3) { var lc_Dia = (la_Fecha[0].length == 4) ? la_Fecha[2] : la_Fecha[0]; }            

    // MARCAR LOS DAS DE CALENDARIO
    var la_Dia        = document.getElementsByName( 'dia_'+lc_Dia.replace(/^0/,'') + '[]' );
    var li_Total_Dias = la_Dia.length;

    for ( var li_Dia=0; li_Dia < li_Total_Dias; li_Dia++ ) {
        var lo_Dia = la_Dia[li_Dia];              

        if (lo_Dia != null) {
            lo_Dia.innerHTML = '';
            //lo_Dia.style.backgroundImage    = 'url(<?php echo Path_Host."coti_planes/Iconos/"; ?>close.png)';
            lo_Dia.style.backgroundImage    = 'url(' + gc_Root + 'aplicaciones/iconos/close.png)';
            lo_Dia.style.backgroundPosition = 'center';
            lo_Dia.style.backgroundRepeat   = 'no-repeat';
            //lo_Dia.style.border             = '1px solid #000000';
            lo_Dia.style.height             = '18px';
            lo_Dia.onclick                  = function (e) { alert( la_Mensaje_Cotizador['Fecha_No_Aplica'] ); lo_Picker.focus(); }
        } else {
            //alert( 'dia_'+lc_Dia.replace(/^0/,'') );
        }              
    }              
}

function Cargar_Fecha_Inhabil () {

}

function Cargar_Fecha_Inhabil_Calendario () {
    ga_Fecha_Inhabil = new Array();

    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion', 'Tomar_Fecha_Inhabil_Calendario' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo_calendario', document.getElementById('fc_Tipo_Calendario').value );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);    				
}

function Inicializar_Formato() {
 		Asignar_Valor('fc_Nombre|fc_Apellido|fc_Cedula|fc_Telefono|fc_Email|fc_Temporada|fc_Transporte|fc_Ciudad_Salida','');
 		Asignar_Valor('fc_Adultos|fc_Menores|fc_Total_Dias','0');                
}

function Campo_Obligatorio(lo_Objeto) {
    if ( lo_Objeto.checked == false ) { 
        lo_Objeto.checked = true;

        var lc_Mensaje = la_Mensaje_Cotizador['Costo_Obligatorio'];
        try { parent.Mostrar_Mensaje( lc_Mensaje ); }
        catch(exception) { alert( lc_Mensaje ); }         
    }
}

/*  DESCRIPCIN - Funcin que obtener el texto de un objeto tipo SELECT
**  
**  lc_Id : Id del objeto sobre el cual se obtendr el valor.
*/	

function Tomar_Texto_Select (lc_Id) {
    var lo_Select = document.getElementById(lc_Id);
    var lc_Texto  = '';
    if (lo_Select != null) { lc_Texto = lo_Select.options[lo_Select.selectedIndex].text; }
    return lc_Texto;
}

function Presentar_Ocultar(lc_Id_Objeto) {
    // CAPTURAR EL OBJETO
    if (lc_Id_Objeto.nodeName) { var lo_Objeto = lc_Id_Objeto; } else { var lo_Objeto = document.getElementById(lc_Id_Objeto); }
    if (lo_Objeto != null) {
        // SWITCH PARA PRESENTAR/OCULTAR UN OBJETO
        if (lo_Objeto.style.display == 'none') { Ocultar_Objeto(lc_Id_Objeto,true); } else { Ocultar_Objeto(lc_Id_Objeto); }
    }
}

function Ver_Cotizador() { Presentar_Ocultar('modulo_cotizador'); document.getElementById('Div_Contenedor_Formulario').scrollIntoView(true); }

/*
function Cotizar() {
    var li_Dias         = 0;
    var li_Costo_Adulto = ( Existe_Estancia (li_Dias, 1) == false ) ? Existe_Estancia (1, 1) : Existe_Estancia (li_Dias, 1);
    var li_Costo_Menor  = ( Existe_Estancia (li_Dias, 2) == false ) ? Existe_Estancia (1, 2) : Existe_Estancia (li_Dias, 2);

    var li_Adultos      = parseInt(document.getElementById('fc_Adultos').value);
    var li_Menores      = parseInt(document.getElementById('fc_Menores').value);
    
    var lo_Fecha_Inferior = Crear_Objeto_Fecha(document.getElementById('fc_Fecha_Inicio').value);
    var lo_Fecha_Superior = Crear_Objeto_Fecha(document.getElementById('fc_Fecha_Limite').value);

    if (lo_Fecha_Inferior != false && lo_Fecha_Superior != false) { var li_Dias = ((lo_Fecha_Superior.Fecha - lo_Fecha_Inferior.Fecha) / (1000 * 60 * 60 * 24)); } else { li_Dias = 0; } 

    // A PARTIR DE LOS DAS CONOCER PRECIOS POR ESTANCIA
    li_Costo_Adulto_Medida = Existe_Estancia (li_Dias, 1);
    li_Costo_Menor_Medida  = Existe_Estancia (li_Dias, 2);

    if (li_Costo_Adulto_Medida != false) { 
        li_Costo_Adulto = li_Costo_Adulto_Medida; 
    } else {
        // BUSCAR EL VALOR INFERIOR MS PRXIMO
        var li_Valor_Estancia = Existe_Estancia (1, 1);
        var li_Dias_Proximos  = li_Dias;
        for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
            // BUSCAR EL VALOR DE LA ESTANCIA
            var li_Estancia = Existe_Estancia(li_Valor_Inferior,1);
            if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
        }
        // SI SLO SE TIENE UN VALOR POR REFERENCIA, ENTONCES UTILIZAR EL VALOR DE 1 DA
        if ( li_Dias_Proximos == li_Dias ) {
            li_Costo_Adulto = Existe_Estancia (1, 1);
        } else {
            // EL COSTO DEL ADULTO SER EL DA PROXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
            li_Costo_Adulto = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * Existe_Estancia (1, 1) ) ) / li_Dias;
        }
    }
    
    if (li_Costo_Menor_Medida  != false) { 
        li_Costo_Menor  = li_Costo_Menor_Medida;  
    } else { 
        li_Costo_Menor  = Existe_Estancia (1, 2); 
    }

    if (isNaN(li_Costo_Adulto)) { li_Costo_Adulto = 0; }

    if ( li_Dias == 0 ) {
        var li_Total_Costo_Adulto = (li_Costo_Adulto_Medida != false) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos);
        var li_Total_Costo_Menor  = (li_Costo_Menor_Medida  != false) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores);
    } else {
        var li_Total_Costo_Adulto = (li_Costo_Adulto_Medida != false) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos * li_Dias);
        var li_Total_Costo_Menor  = (li_Costo_Menor_Medida  != false) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores * li_Dias);
    }

    //var li_Cotizacion   = (li_Costo_Adulto * li_Adultos) + (li_Costo_Menor * li_Menores);
    var li_Cotizacion   = (li_Total_Costo_Adulto + li_Total_Costo_Menor);
    
    //Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion * li_Dias));
    Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion));
    Asignar_Valor('fc_Total_Dias',li_Dias);
    Calcular_Adicionales();
}
*/


function Iniciar_Objeto_Cotizador() {
    go_Objeto_Cotizador.adultos                 = 0;
    go_Objeto_Cotizador.menores                 = 0;
    go_Objeto_Cotizador.dias                    = 0;
    go_Objeto_Cotizador.dias_proximos_adulto    = 0;
    go_Objeto_Cotizador.dias_adicionales_adulto = 0;
    go_Objeto_Cotizador.dias_proximos_menor     = 0;
    go_Objeto_Cotizador.dias_adicionales_menor  = 0;
    go_Objeto_Cotizador.fecha_inicio            = null;
    go_Objeto_Cotizador.fecha_final             = null;
    go_Objeto_Cotizador.costo_adulto_proximos   = 0;
    go_Objeto_Cotizador.costo_menor_proximos    = 0;
    go_Objeto_Cotizador.costo_adulto_adicional  = 0;
    go_Objeto_Cotizador.costo_menor_adicional   = 0;
    go_Objeto_Cotizador.costo_adulto            = 0;
    go_Objeto_Cotizador.costo_menor             = 0;
    go_Objeto_Cotizador.nuevo_costo_adulto      = 0;
    go_Objeto_Cotizador.nuevo_costo_menor       = 0;
    go_Objeto_Cotizador.costo_base              = 0;
    go_Objeto_Cotizador.adicionales             = 0;
    go_Objeto_Cotizador.iva                     = 0;
    go_Objeto_Cotizador.sobrecosto1             = 0;
    go_Objeto_Cotizador.sobrecosto2             = 0;
}

/*
function Cotizar() {
    // TOMAR LOS USUARIOS
    var li_Adultos      = parseInt( $('#fc_Adultos').attr('value') );
    var li_Menores      = parseInt( $('#fc_Menores').attr('value') );

    var lo_Fecha_Inferior = Crear_Objeto_Fecha( $('#fc_Fecha_Inicio').attr('value') );
    var lo_Fecha_Superior = Crear_Objeto_Fecha( $('#fc_Fecha_Limite').attr('value') );

    if (lo_Fecha_Inferior != false && lo_Fecha_Superior != false) { var li_Dias = ((lo_Fecha_Superior.Fecha - lo_Fecha_Inferior.Fecha) / (1000 * 60 * 60 * 24)); } else { li_Dias = 0; } 

    if ( li_Dias == 0 ) { 
        var li_Costo_Adulto = 0;
        var li_Costo_Menor  = 0;
    } else {
        // CONOCER EL COSTO DE AULTO DA
        var li_Costo_Adulto_Dia = ( Existe_Estancia (1, 1) == false ) ? 0 : Existe_Estancia (1, 1);
        var li_Costo_Menor_Dia  = ( Existe_Estancia (1, 2) == false ) ? 0 : Existe_Estancia (1, 2);
         
        // A PARTIR DE LOS DAS, CONOCER PRECIOS POR ESTANCIA
        li_Costo_Adulto_Medida = Existe_Estancia (li_Dias, 1);

        if (li_Costo_Adulto_Medida != false) {
            // COSTO DE ADULTO POR DA 
            li_Costo_Adulto = ( li_Costo_Adulto_Medida / li_Dias ); 
        } else {
            // BUSCAR EL VALOR INFERIOR MS PRXIMO
            var li_Valor_Estancia = li_Costo_Adulto_Dia;
            var li_Dias_Proximos  = li_Dias;
            for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
                // BUSCAR EL VALOR DE LA ESTANCIA
                var li_Estancia = Existe_Estancia(li_Valor_Inferior,1);
                if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
            }
            // SI SLO SE TIENE UN VALOR POR REFERENCIA, ENTONCES UTILIZAR EL VALOR DE 1 DA
            if ( li_Dias_Proximos == li_Dias ) {
                li_Costo_Adulto = li_Costo_Adulto_Dia;
            } else {
                // EL COSTO DEL ADULTO SER EL DA PROXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
                li_Costo_Adulto = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * li_Costo_Adulto_Dia ) ) / li_Dias;
            }
        }
        
        // TOMAR EL VALOR DEL MENOR
        li_Costo_Menor_Medida  = Existe_Estancia (li_Dias, 2);
        if (li_Costo_Menor_Medida != false) {
            // COSTO DE ADULTO POR DA 
            li_Costo_Menor = ( li_Costo_Menor_Medida / li_Dias ); 
        } else {
            // BUSCAR EL VALOR INFERIOR MS PRXIMO
            var li_Valor_Estancia = li_Costo_Menor_Dia;
            var li_Dias_Proximos  = li_Dias;
            for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
                // BUSCAR EL VALOR DE LA ESTANCIA
                var li_Estancia = Existe_Estancia(li_Valor_Inferior,1);
                if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
            }
            // SI SLO SE TIENE UN VALOR POR REFERENCIA, ENTONCES UTILIZAR EL VALOR DE 1 DA
            if ( li_Dias_Proximos == li_Dias ) {
                li_Costo_Menor = li_Costo_Menor_Dia;
            } else {
                // EL COSTO DEL ADULTO SER EL DA PROXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
                li_Costo_Menor = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * li_Costo_Menor_Dia ) ) / li_Dias;
            }
        }

        if ( li_Costo_Adulto  == false ) { li_Costo_Adulto  = 0; }
        if ( li_Costo_Menor   == false ) { li_Costo_Menor   = 0; }

        // UNA VEZ QUE SE HA HALLADO EL COSTO DEL ADULTO Y DEL MENOR, BUSCAR QUE EL RANGO DE FECHAS NO POSEAN SOBRECOSTOS
        var ld_Fecha_Inicio       = Crear_Objeto_Fecha( $('#fc_Fecha_Inicio').attr('value') );
        
        // ACUMULADOR DE NUEVO COSTO POR PERODO
        var li_Nuevo_Costo_Adulto = 0;
        var li_Nuevo_Costo_Menor  = 0;
        
        //alert( li_Costo_Adulto + ' ' + ld_Fecha_Inicio.Fecha + ' ' + $('#fc_Fecha_Inicio').attr('value') );
        
        for (var li_Suma_Dia=0; li_Suma_Dia < li_Dias; li_Suma_Dia++ ) {
            // CREAR EL OBJETO FECHA
            var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
            // SUMAR UN DA
            ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
            // CREAR LA CADENA DE LA NUEVA FECHA
            var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1 );
            //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
            
            if ( lb_Resultado != false ) {
                li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
            } else {
                li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
            }
            
            var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2 );
            //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
            
            if ( lb_Resultado != false ) {
                li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
            } else {
                li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
            }
        }
        
        // REASIGNAR EL NUEVO COSTO
        li_Costo_Adulto = li_Nuevo_Costo_Adulto / li_Dias;
        li_Costo_Menor  = li_Nuevo_Costo_Menor / li_Dias;
    }

    // SI EL NMERO MXIMO DE DAS ES CERO, DE DECIR NO TIENE NOCHES
    if ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) { 
        var li_Costo_Adulto = ( Existe_Estancia (0, 1) == false ) ? 0 : Existe_Estancia (0, 1);
        var li_Costo_Menor  = ( Existe_Estancia (0, 2) == false ) ? 0 : Existe_Estancia (0, 2);
    }
    
    var li_Total_Costo_Adulto = ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos * li_Dias);
    var li_Total_Costo_Menor  = ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores * li_Dias); 

    //var li_Cotizacion   = (li_Costo_Adulto * li_Adultos) + (li_Costo_Menor * li_Menores);
    var li_Cotizacion   = (li_Total_Costo_Adulto + li_Total_Costo_Menor);

    //Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion * li_Dias));
    Asignar_Valor('fc_Costo', Math.round( li_Cotizacion) );
    Asignar_Valor('fc_Total_Dias',li_Dias);
    Calcular_Adicionales();
}
*/

function Cotizar() {
    //try { alert("caller is " + arguments.callee.caller.toString()); } catch(exception) {} 

    Iniciar_Objeto_Cotizador();
    
    // TOMAR LOS USUARIOS
    var li_Adultos      = parseInt( $('#fc_Adultos').attr('value') );
    var li_Menores      = parseInt( $('#fc_Menores').attr('value') );

    var lo_Fecha_Inferior = Crear_Objeto_Fecha( $('#fc_Fecha_Inicio').attr('value') );
    var lo_Fecha_Superior = Crear_Objeto_Fecha( $('#fc_Fecha_Limite').attr('value') );

    if (lo_Fecha_Inferior != false && lo_Fecha_Superior != false) { var li_Dias = ((lo_Fecha_Superior.Fecha - lo_Fecha_Inferior.Fecha) / (1000 * 60 * 60 * 24)); } else { li_Dias = 0; } 

    Asignar_Valor('fc_Total_Dias',li_Dias);
    
    go_Objeto_Cotizador.costo_adulto_adicional  = Existe_Estancia (1, 1);
    go_Objeto_Cotizador.costo_menor_adicional   = Existe_Estancia (1, 2);
    
    if ( li_Dias == 0 ) { 
        var li_Costo_Adulto = 0;
        var li_Costo_Menor  = 0;
    } else {
        // CONOCER EL COSTO DE AULTO DA
        var li_Costo_Adulto_Dia = ( Existe_Estancia (1, 1) == false ) ? 0 : Existe_Estancia (1, 1);
        var li_Costo_Menor_Dia  = ( Existe_Estancia (1, 2) == false ) ? 0 : Existe_Estancia (1, 2);
         
        // A PARTIR DE LOS DAS, CONOCER PRECIOS POR ESTANCIA
        li_Costo_Adulto_Medida = Existe_Estancia (li_Dias, 1);

        if (li_Costo_Adulto_Medida != false) {
            // COSTO DE ADULTO POR DA 
            li_Costo_Adulto = ( li_Costo_Adulto_Medida / li_Dias ); 
        } else {
            // BUSCAR EL VALOR INFERIOR MS PRXIMO
            var li_Valor_Estancia = li_Costo_Adulto_Dia;
            var li_Dias_Proximos  = li_Dias;
            for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
                // BUSCAR EL VALOR DE LA ESTANCIA
                var li_Estancia = Existe_Estancia(li_Valor_Inferior,1);
                if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
            }

            // SI SLO SE TIENE UN VALOR POR REFERENCIA, ENTONCES UTILIZAR EL VALOR DE 1 DA
            if ( li_Dias_Proximos == li_Dias ) {
                li_Costo_Adulto = li_Costo_Adulto_Dia;
            } else {
                // EL COSTO DEL ADULTO SER EL DA PROXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
                li_Costo_Adulto = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * li_Costo_Adulto_Dia ) ) / li_Dias;
            }

            // ACTUALIZAR EL OBJETO
            go_Objeto_Cotizador.dias_proximos_adulto    = li_Dias_Proximos;
            go_Objeto_Cotizador.dias_adicionales_adulto = li_Dias - li_Dias_Proximos;
            go_Objeto_Cotizador.costo_adulto_proximos   = li_Valor_Estancia / li_Dias_Proximos;
            go_Objeto_Cotizador.costo_adulto_adicional  = li_Costo_Adulto_Dia;
        }

        // ACTUALIZAR EL OBJETO
        go_Objeto_Cotizador.costo_adulto  = li_Costo_Adulto;

        // TOMAR EL VALOR DEL MENOR
        li_Costo_Menor_Medida  = Existe_Estancia (li_Dias, 2);
        if (li_Costo_Menor_Medida != false) {
            // COSTO DE ADULTO POR DA 
            li_Costo_Menor = ( li_Costo_Menor_Medida / li_Dias ); 
        } else {
            // BUSCAR EL VALOR INFERIOR MS PRXIMO
            var li_Valor_Estancia = li_Costo_Menor_Dia;
            var li_Dias_Proximos  = li_Dias;
            for ( var li_Valor_Inferior = (li_Dias - 1); li_Valor_Inferior > 1; li_Valor_Inferior-- ) {
                // BUSCAR EL VALOR DE LA ESTANCIA
                var li_Estancia = Existe_Estancia(li_Valor_Inferior,2);
                if ( li_Estancia != false ) { li_Dias_Proximos = li_Valor_Inferior; li_Valor_Estancia = li_Estancia; break; }
            }

            // ACTUALIZAR EL OBJETO
            go_Objeto_Cotizador.costo_menor_proximos = li_Valor_Estancia / li_Dias_Proximos;

            // SI SLO SE TIENE UN VALOR POR REFERENCIA, ENTONCES UTILIZAR EL VALOR DE 1 DA
            if ( li_Dias_Proximos == li_Dias ) {
                li_Costo_Menor = li_Costo_Menor_Dia;
            } else {
                // EL COSTO DEL ADULTO SER EL DA PRXIMO POR SU COSTO Y LA DIFERENCIA DE DAS POR EL VALOR DE DA ADICIONAL
                li_Costo_Menor = ( li_Valor_Estancia + ( ( li_Dias - li_Dias_Proximos ) * li_Costo_Menor_Dia ) ) / li_Dias;
            }

            // ACTUALIZAR EL OBJETO
            go_Objeto_Cotizador.dias_proximos_menor     = li_Dias_Proximos;
            go_Objeto_Cotizador.dias_adicionales_menor  = li_Dias - li_Dias_Proximos;
            go_Objeto_Cotizador.costo_menor_proximos    = li_Valor_Estancia / li_Dias_Proximos;
            go_Objeto_Cotizador.costo_menor_adicional   = li_Costo_Menor_Dia;
        }

        // ACTUALIZAR EL OBJETO
        go_Objeto_Cotizador.costo_menor = li_Costo_Menor;

        if ( li_Costo_Adulto  == false ) { li_Costo_Adulto  = 0; }
        if ( li_Costo_Menor   == false ) { li_Costo_Menor   = 0; }

        // UNA VEZ QUE SE HA HALLADO EL COSTO DEL ADULTO Y DEL MENOR, BUSCAR QUE EL RANGO DE FECHAS NO POSEAN SOBRECOSTOS
        var ld_Fecha_Inicio       = Crear_Objeto_Fecha( $('#fc_Fecha_Inicio').attr('value') );

        // ACUMULADOR DE NUEVO COSTO POR PERODO
        var li_Nuevo_Costo_Adulto = 0;
        var li_Nuevo_Costo_Menor  = 0;

        //alert( li_Costo_Adulto + ' ' + ld_Fecha_Inicio.Fecha + ' ' + $('#fc_Fecha_Inicio').attr('value') );

        // EL CASO DE LOS SOBRE COSTOS ES ESPECIAL, DONDE SE APLICA UN SLO GRUPO DE SOBRECOSTOS SOBRE UN VALOR DEFINIDO EN LA CONFIGURACIN
        // O EN EL CASO DE HABER SOBRECOSTOS EN UN RANGO DE FECHAS QUE NO SE HA DEFINIDO, ENTONCES DIVIDIR LOS SOBRECOSTOS EN DOS BLOQUES
        
        if ( go_Objeto_Cotizador.dias_proximos_adulto == 0 ) {
            for (var li_Suma_Dia=0; li_Suma_Dia < li_Dias; li_Suma_Dia++ ) {
                // CREAR EL OBJETO FECHA
                var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
                // SUMAR UN DA
                ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
                // CREAR LA CADENA DE LA NUEVA FECHA
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1 );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
                }
                
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2 );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
                }
            }
        } else {
            // VALOR DEL ADULTO DEL PRIMER RANGO
            li_Costo_Adulto = go_Objeto_Cotizador.costo_adulto_proximos;
            li_Costo_Menor  = go_Objeto_Cotizador.costo_menor_proximos;
        
            // PARA EL CASO EN EL QUE LOS DAS NO ESTN CONFIGURADOS, APLICAR A CADA PLAZO, LO CORRESPONDIENTE
            for (var li_Suma_Dia=0; li_Suma_Dia < go_Objeto_Cotizador.dias_proximos_adulto; li_Suma_Dia++ ) {
                // CREAR EL OBJETO FECHA
                var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
                // SUMAR UN DA
                ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
                // CREAR LA CADENA DE LA NUEVA FECHA
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1, go_Objeto_Cotizador.dias_proximos_adulto );

                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
                }

                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + li_Nuevo_Costo_Adulto );
                
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2, go_Objeto_Cotizador.dias_proximos_menor );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
                    
                    //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + (li_Costo_Menor * lb_Resultado ) );
                } else {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
                    
                    //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + li_Costo_Menor );
                }
            }
            
            go_Objeto_Cotizador.sobrecosto1 = li_Nuevo_Costo_Adulto; 

            // VALOR DEL ADULTO DA ADICIONAL
            li_Costo_Adulto = go_Objeto_Cotizador.costo_adulto_adicional;
            li_Costo_Menor  = go_Objeto_Cotizador.costo_menor_adicional;
            
            for (var li_Suma_Dia=go_Objeto_Cotizador.dias_proximos_adulto; li_Suma_Dia < li_Dias; li_Suma_Dia++ ) {
                // CREAR EL OBJETO FECHA
                var ld_Nueva_Fecha = new Date( $('#fc_Fecha_Inicio').attr('value') );
                // SUMAR UN DA
                ld_Nueva_Fecha.setDate( ld_Fecha_Inicio.Fecha.getDate() + li_Suma_Dia );
                // CREAR LA CADENA DE LA NUEVA FECHA
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 1, 1 );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + ( li_Costo_Adulto * lb_Resultado );
                } else {
                    li_Nuevo_Costo_Adulto = li_Nuevo_Costo_Adulto + li_Costo_Adulto;
                }

                //alert( 'adicional ' + lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                var lb_Resultado = Existe_Sobrecosto ( String_Fecha(ld_Nueva_Fecha) , 2, 1 );
                //alert( lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) );
                
                if ( lb_Resultado != false ) {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + ( li_Costo_Menor * lb_Resultado );
                    
                    //alert( 'adicional ' + lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + ( li_Costo_Menor * lb_Resultado ) );
                } else {
                    li_Nuevo_Costo_Menor = li_Nuevo_Costo_Menor + li_Costo_Menor;
                    
                    //alert( 'adicional ' + lb_Resultado + ' ' + String_Fecha(ld_Nueva_Fecha) + ' ' + li_Costo_Menor );
                }
                
            }
            
            go_Objeto_Cotizador.sobrecosto2 = li_Nuevo_Costo_Adulto;                         
        }
        
        // REASIGNAR EL NUEVO COSTO
        li_Costo_Adulto = li_Nuevo_Costo_Adulto / li_Dias;
        li_Costo_Menor  = li_Nuevo_Costo_Menor / li_Dias;
        
        // ACTUALIZAR EL OBJETO
        go_Objeto_Cotizador.nuevo_costo_adulto  = li_Costo_Adulto;
        go_Objeto_Cotizador.nuevo_costo_menor   = li_Costo_Menor;
    }

    // SI EL NMERO MXIMO DE DAS ES CERO, DE DECIR NO TIENE NOCHES
    if ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) { 
        var li_Costo_Adulto = ( Existe_Estancia (0, 1) == false ) ? 0 : Existe_Estancia (0, 1);
        var li_Costo_Menor  = ( Existe_Estancia (0, 2) == false ) ? 0 : Existe_Estancia (0, 2);
    }
    
    var li_Total_Costo_Adulto = ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) ? (li_Costo_Adulto * li_Adultos) : (li_Costo_Adulto * li_Adultos * li_Dias);
    var li_Total_Costo_Menor  = ( Tomar_Numero( $('#fc_Maximo_Dias').attr('value') ) == 0 ) ? (li_Costo_Menor  * li_Menores) : (li_Costo_Menor  * li_Menores * li_Dias); 

    //var li_Cotizacion   = (li_Costo_Adulto * li_Adultos) + (li_Costo_Menor * li_Menores);
    var li_Cotizacion   = (li_Total_Costo_Adulto + li_Total_Costo_Menor);
    
    //Asignar_Valor('fc_Costo',Formatear_Numero(li_Cotizacion * li_Dias));
    Asignar_Valor('fc_Costo',Formatear_Numero( Math.round( li_Cotizacion) ) );

    Calcular_Adicionales();
    
    // ACTUALIZAR EL OBJETO
    go_Objeto_Cotizador.adultos       = li_Adultos;
    go_Objeto_Cotizador.menores       = li_Menores;
    go_Objeto_Cotizador.dias          = li_Dias;
    go_Objeto_Cotizador.fecha_inicio  = $('#fc_Fecha_Inicio').attr('value');
    go_Objeto_Cotizador.fecha_final   = $('#fc_Fecha_Limite').attr('value');
    go_Objeto_Cotizador.costo_base    = li_Cotizacion;
}

function Ver_Objeto_Cotizador() {
    $('#objeto_validador').remove();

    var la_Objeto = new Array();
    for ( atributo in go_Objeto_Cotizador ) {
        try { la_Objeto[la_Objeto.length] = "<div>" + atributo + " = " + go_Objeto_Cotizador[atributo] + '</div>'; }
        catch (exception) {}
    }
    
    $('body').append("<div id='objeto_validador' style='background:#fff;border:1px solid #000;position:absolute;top:" + lo_Mouse.Y + "px;left:0px;width:300px;'>" + la_Objeto.join("") + "</div><img id='cerrar_objeto_validador' style='float:right;' src='" + gc_Ruta_Aplicativo + "/aplicaciones/cotizador/Iconos/close_circle.png' >");
    $('#cerrar_objeto_validador').click(function(event) { event.preventDefault(); $('#cerrar_objeto_validador').remove(); return false; });
}

/*   CREAR UN STRING A PARTIR DE UN OBJETO FECHA */
function String_Fecha( ld_Fecha ) {
    lc_Mes = ( parseInt( ld_Fecha.getMonth() + 1 ) < 10 ) ? '0' + parseInt( ld_Fecha.getMonth() + 1 ) : parseInt( ld_Fecha.getMonth() + 1 );
    lc_Dia = ( parseInt( ld_Fecha.getDate() ) < 10 ) ? '0' + parseInt( ld_Fecha.getDate() ) : parseInt( ld_Fecha.getDate() );
    return ld_Fecha.getFullYear() + '-' + lc_Mes + '-' + lc_Dia;  
}

function Cargar_Costos_Adicionales(lc_Id_Plan) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion','Tomar_Costos_Adicionales' );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo',lc_Id_Plan );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'tipo_cotizador', $('#fc_Tipo_Cotizador')[0].value );
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Cargar_Costos_Tipo_Calendario() {
    // LOS COSTOS DE LOS PLANES DEBEN SER CARGADOS SLO CUANDO LAS VARIABLES HAYAN SIDO DEFINIDAS O SELECCIONADAS
    
    if ( $('#fc_Plan')[0].value != '' && $('#fc_Temporada')[0].value != '' && $('#fc_Transporte')[0].value != '' && $('#fc_Tipo_Habitacion')[0].value != '' ) {    
        //alert("caller is " + arguments.callee.caller.toString()); 
        var la_Arreglo = new Array();
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion'                 , 'Tomar_Costos_Plan_Calendario');
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo_plan_calendario' , $('#fc_Plan')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Transporte')[0].value + '|' + $('#fc_Tipo_Habitacion')[0].value );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'tipo_cotizador'         , $('#fc_Tipo_Cotizador')[0].value );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'tipo_habitacion'        , $('#fc_Tipo_Habitacion')[0].value );

        Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
    }
}

function Configurar_Adulto(li_Valor) {
    var li_Adultos              = parseInt(document.getElementById('fc_Adultos').value);
    var li_Menor                = 0; //parseInt(document.getElementById('fc_Menores').value);

    var li_Capacidad_Habitacion = Tomar_Numero( Tomar_Numero_Capacidad( $('#fc_Capacidad_Habitacion')[0].value) );

    // VALIDAR CAPACIDAD DE LA HABITACIN
    if ( li_Capacidad_Habitacion > 0 ) {
        if ( ( li_Adultos + li_Menor + li_Valor ) <= li_Capacidad_Habitacion ) {
            Asignar_Valor('fc_Adultos',li_Adultos + li_Valor);
            // BUSCAR UNA HABITACIN QUE POSEA DISPONIBILIDAD
            Cargar_Lista_Desplegable('fc_Tipo_Habitacion','tipo_habitacion_portafolio_capacidad',$('#fc_Plan')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Adultos')[0].value );

            if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Habitaciones_Disponibles(); }

            Cotizar();
        } else {
            var lc_Mensaje = la_Mensaje_Cotizador['Capacidad_Superada_Adulto'];
            
            try { parent.Mostrar_Mensaje( lc_Mensaje ); }
            catch(exception) { alert( lc_Mensaje ); }
            
        } 
    } else {
        if ((li_Adultos + li_Valor) > 0) { 
            Asignar_Valor('fc_Adultos',li_Adultos + li_Valor); 
            Cargar_Lista_Desplegable('fc_Tipo_Habitacion','tipo_habitacion_portafolio_capacidad',$('#fc_Plan')[0].value + '|' + $('#fc_Temporada')[0].value + '|' + $('#fc_Adultos')[0].value );            

            if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Habitaciones_Disponibles(); }

            Cotizar(); 
        }
    }
}

function Cargar_Habitaciones_Disponibles() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'accion'                 , 'Cargar_Habitaciones_Disponibles');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'plan'                   , $('#fc_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'temporada'              , $('#fc_Temporada')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'adultos'                , $('#fc_Adultos')[0].value );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Tomar_Posicion_X( lo_Objeto ) {
    var la_Top = new Array();
    do {
        if ( lo_Objeto.offsetTop ) { la_Top[la_Top.length] = lo_Objeto.offsetTop; }
        lo_Objeto = lo_Objeto.parentNode;
    } while (lo_Objeto.tagName != 'BODY' );
    alert( la_Top );
}

function Seleccion_Habitacion_Disponible() {
    // OCULTAR LA ZONA DE HABITACIN
    $('#habitacion_plan').hide();

    //$('.contenedor_habitacion_disponible').eq(2).css('display:block');
    //$('.contenedor_habitacion_disponible').eq(2).append("<div class='clear:both'></div>");

    $('.contenedor_habitacion_disponible').each(function(index) {
        //alert(index + ': ' + $(this).text());
        $(this).click(function(event) {
            event.preventDefault();

            //alert(  gc_Habitacion_Seleccionada + ' ' + $(this).attr('id') );
            
            // SI LA HABITACIN ES NUEVA, CARGAR LOS DATOS DEL COTIZADOR            
            if ( gc_Habitacion_Seleccionada != $(this).attr('id') ) {
            
                // OCULTAR TODAS LAS HABITACIONES
                $('.contenedor_habitacion_disponible').hide();
                // ACTIVAR LA VISUAL DE LA ACTUAL
                $(this).show();

                // IGUALAR LA VARIABLE GLOBAL
                gc_Habitacion_Seleccionada = $(this).attr('id'); 
            
                // OCULTAR LA ZONA DE LOS SERVICIOS INCLUIDOS
                //$('.contenedor_servicios_habitacion').css('display','none');
                $('.contenedor_servicios_habitacion').hide();
                // LIMPIAR LOS SERVICIOS INCLUIDOS
                $('.contenedor_servicios_habitacion').empty();
                // PRESENTAR LA ZONA DE SERVICIOS INCLUIDOS
                $('#contenedor_servicios_habitacion_' + $(this).attr('id')).show();
                
                // OCULTAR LAS ZONAS DEL COTIZADOR
                //$('.contenedor_cotizador').css('display','none');
                $('.contenedor_cotizador').hide();
    
                // ADICIONAR LOS ELEMENTOS DEL COTIZADOR
                    document.getElementById('zona_cotizar_' + $(this).attr('id')).appendChild( document.getElementById('ciudad_salida') );
                    document.getElementById('zona_cotizar_' + $(this).attr('id')).appendChild( document.getElementById('zona_calendario') );
                    document.getElementById('zona_cotizar_' + $(this).attr('id')).appendChild( document.getElementById('modulo_detalle_disponibilidad') );
                    document.getElementById('zona_cotizar_' + $(this).attr('id')).appendChild( document.getElementById('modulo_servicios_adicionales') );
                    document.getElementById('zona_cotizar_' + $(this).attr('id')).appendChild( document.getElementById('zona_usuario') );
                // FIN ADICIONAR ELEMENTOS COTIZADOR                
    
                // ACTIVAR LA VISUALIZACIN DE LA ZONA DE COTIZACIN
                $('#contenedor_cotizador_' + $(this).attr('id')).show();
    
                $('.contenedor_habitacion_disponible').removeClass("habitacion_disponible_activa");
    
                // ACTIVAR
                $(this).addClass("habitacion_disponible_activa");
    
                // CARGAR LA LISTA DESPLEGABLE
                Asignar_Valor( 'fc_Tipo_Habitacion',$(this).attr('id') );
                // DISPARAR EL EVENTO CHANGE
                $('#fc_Tipo_Habitacion').trigger('change');
            }
            
        });
    });
}

function Activar_Habitaciones_Cotizador( lc_Id_Habitacion ) {
    $('#contenedor_cotizador_' + lc_Id_Habitacion).hide();
    // ACTIVAR LAS HABITACIONES
    $('.contenedor_habitacion_disponible').show();
    //$('.contenedor_servicios_habitacion').css('display','none');
    $('.contenedor_servicios_habitacion').hide();
    // ELIMINAR HABITACIONES ACTIVAS
    $('.contenedor_habitacion_disponible').removeClass("habitacion_disponible_activa");
    //gc_Habitacion_Seleccionada = null;
    return false;
} 

/*
function Configurar_Menor(li_Valor) {
    var li_Adultos              = parseInt(document.getElementById('fc_Adultos').value);
    var li_Menor                = parseInt(document.getElementById('fc_Menores').value);
    
    var li_Capacidad_Habitacion = Tomar_Numero( $('#fc_Capacidad_Habitacion')[0].value );

    // VALIDAR CAPACIDAD DE LA HABITACIN
    if ( li_Capacidad_Habitacion > 0 ) {
        if ( ( li_Adultos + li_Menor + li_Valor ) <= li_Capacidad_Habitacion ) {
            if ( (li_Menor + li_Valor) > 2 ) {
                parent.Mostrar_Mensaje( la_Mensaje_Cotizador['Capacidad_Superada_Menor'] );
            } else {
                Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar();
            }
        } else {
            parent.Mostrar_Mensaje( la_Mensaje_Cotizador['Capacidad_Superada_Menor'] );
        } 
    } else {
        if ((li_Menor + li_Valor) >= 0) { Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar(); }
    }
}
*/
 
function Configurar_Menor(li_Valor) {
    var li_Menor                = parseInt(document.getElementById('fc_Menores').value);
    var li_Capacidad_Habitacion = Tomar_Numero( $('#fc_Capacidad_Habitacion')[0].value );

    // VALIDAR CAPACIDAD DE LA HABITACIN
    if ( li_Capacidad_Habitacion > 0 ) {
        if ( (li_Menor + li_Valor) > 2 ) {
            var lc_Mensaje = la_Mensaje_Cotizador['Capacidad_Superada_Menor'];
            
            try { parent.Mostrar_Mensaje( lc_Mensaje ); }
            catch(exception) { alert( lc_Mensaje ); }
                    
        } else {
            if ((li_Menor + li_Valor) >= 0) { Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar(); }        
            //Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar();
        }
    } else {
        if ((li_Menor + li_Valor) >= 0) { Asignar_Valor('fc_Menores',li_Menor + li_Valor); Cotizar(); }
    }
} 
       
function Tomar_Capacidad_Habitacion() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','capacidad_habitacion' );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Tipo_Habitacion')[0].value );              

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function In_Array(la_Arreglo,lc_Valor) {
    var lb_Resultado = false;
    for (var li_Contador=0; li_Contador < la_Arreglo.length; li_Contador++) {
        if (la_Arreglo[li_Contador] == lc_Valor) { lb_Resultado = li_Contador; break; }
    }
    return lb_Resultado;
}

function Cargar_Datos_Plan_Portafolio() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_plan_portafolio' );              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Datos_Carga_Portafolio()' );              

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Datos_Carga_Portafolio() {
    // SI EL TIPO DE COTIZADOR ES HOTEL
    if ( parseInt( $('#fc_Tipo_Cotizador')[0].value ) == 2 ) { 
        Ocultar_Objeto('habitacion_plan',false);
    } else {
        Ocultar_Objeto('habitacion_plan');
        // PRESENTAR EL SELECTOR DE FECHA
        Ocultar_Objeto('zona_calendario',false);
    }
    // SI EL MXIMO DE DAS DE CERO, ENTONCES OCULTAR EL SEGUNDO RANGO
    if ( Tomar_Numero( $('#fc_Maximo_Dias')[0].value ) == 0 ) {
        Ocultar_Objeto('zona_calendario_limite')
    } else {
        Ocultar_Objeto('zona_calendario_limite',false);              
    }
}

function Carga_Transporte() {

    Iniciar_Fechas_Cotizador();
    // OCULTAR LA DESCRIPCIN DE LA HABITACIN
    //$('#modulo_detalle_disponibilidad').hide();
    
    if ( $('#zona_usuarios')[0].style.display == 'none' ) { $('#zona_usuarios').slideToggle('slow'); }

    Ocultar_Objeto('transporte_temporada',false);
    
    if ( $('#fc_Transporte')[0].length > 1 ) { 
        // SI SE OBTIENE EL CASO DE NO APLICA, OCULTAR    
        if ( $('#fc_Transporte')[0].length == 2 && $('#fc_Transporte')[0].options[1].text.search(/no\x20aplica/i) >= 0 ) {
            // CARGAR LOS DATOS DEL SEGUNDO ITEM
            Asignar_Valor( 'fc_Transporte',$('#fc_Transporte')[0].options[1].value );
            // OCULTAR LA ZONA DE TRANSPORTE
            $('#transporte_temporada').hide();
            
            // CARGAR LOS INCLUIDOS Y NO INCLUDOS
            if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Servicios_Habitacion(); } 
            
        } else {
            // VISUALIZAR EL TIPO DE TRANSPORTE
            $('#transporte_temporada').show();
        }
        Tomar_Proceso_Transporte();       
    } else {
        Ocultar_Objeto('transporte_temporada');
    }
}

// FUNCIN QUE SE EJECUTA UNA VEZ SE HAN TOMADO LOS DATOS DEL SERVIDOR
function Carga_Ciudad_Salida() {
    // SI NO SE OBTIENEN DATOS DE CIUDAD DE SALIDA, ENTONCES OCULTAR    
    if ( $('#fc_Ciudad_Salida')[0].length == 1 ) { Ocultar_Objeto('ciudad_salida'); } else { Ocultar_Objeto('ciudad_salida',false); }
}

function Tomar_Datos_Disponibilidad() {
    // INICIALIZAR EL ARREGLO DE DISPONIBILIDAD
    ga_Rango_Fechas_Cotizaciones  = new Array();
    
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('accion','Construir_Calendario');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('contenedor','contenedor_disponibilidad_plan_portafolio_hotel');
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('plan_portafolio', $('#fc_Plan')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('tipo_habitacion', $('#fc_Tipo_Habitacion')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('rango_fecha', $('#fc_Fecha_Inicio')[0].value.substr(0,7) );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('ejecutar','');
    
    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);
}

function Insertar_Texto_Calendario() {
    var li_Total_Cotizacion = ga_Rango_Fechas_Cotizaciones.length;

    var la_Fecha            = $('#fc_Fecha_Inicio')[0].value.split('-'); 
    var li_Year             = la_Fecha[0];
    // DISMINUIR UN DA AL MES 0-11
    var li_Mes              = Tomar_Numero(la_Fecha[1]) - 1;
    var li_Dia_Calendario   = Tomar_Numero(la_Fecha[2]);
    
    if ( li_Total_Cotizacion > 0 ) {
        for (li_Dia=li_Dia_Calendario; li_Dia < 31; li_Dia++) {
            // TOMAR LA FECHA, SI CORRESPONDE AL MISMO MES, PINTAR
            var lo_Nueva_Fecha    = new Date( li_Year,li_Mes,li_Dia );
            var lo_Existe_Reserva = Buscar_Fecha_Rango( lo_Nueva_Fecha );
            
            // ADICIONAR EL TEXTO DE RESERVAS
            //$('#zona_prueba').append( li_Dia + ' - ' + lo_Existe_Reserva.reservas );
            
            if ( lo_Existe_Reserva.registros > 0 ) {
                if ( ga_Costo_Usuario_Estancia.length > 0 ) {
                    if ( ga_Costo_Usuario_Estancia[0].Disponibilidad <= lo_Existe_Reserva.registros ) {
                        var lc_Fecha_Verificacion = li_Year + '-' + la_Fecha[1] + '-' + li_Dia;

                        if ( In_Array( ga_Fecha_Inhabil, lc_Fecha_Verificacion ) == false ) { ga_Fecha_Inhabil[ga_Fecha_Inhabil.length] = lc_Fecha_Verificacion; }
                        scwDisabledDates[scwDisabledDates.length] = lo_Nueva_Fecha;
                    }
                }
            }            
        }
    }
}

function Buscar_Fecha_Rango( lo_Fecha ) {
    // BUSCAR LA FECHA EN EL ARREGLO DE FECHA COTIZADAS
    var li_Total_Registros    = ga_Rango_Fechas_Cotizaciones.length;
    var li_Total_Cotizaciones = 0;
    var la_Cotizacion         = new Array();
    var lo_Objeto_Salida      = new Object();
    
    for (var li_Registro=0; li_Registro < li_Total_Registros; li_Registro++) {
        // CONVERTIR LAS FECHAS
        lo_Fecha_Inicio = Crear_Objeto_Fecha( ga_Rango_Fechas_Cotizaciones[ li_Registro ].fecha_inicio );
        lo_Fecha_Final  = Crear_Objeto_Fecha( ga_Rango_Fechas_Cotizaciones[ li_Registro ].fecha_final );
        
        // ADICIONAR EL TEXTO DE RESERVAS
        //$('#zona_prueba').append( "<div>" + lo_Fecha + ' ' + lo_Fecha_Inicio.Fecha + ' ' + lo_Fecha_Final.Fecha + "</div>" );        

        if ( lo_Fecha >= lo_Fecha_Inicio.Fecha && lo_Fecha <= lo_Fecha_Final.Fecha ) {
            li_Total_Cotizaciones = li_Total_Cotizaciones + 1;
            // ADICIONAR EL NMERO DE LA COTIZACIN
            la_Cotizacion[ la_Cotizacion.length ] = "<div class='cotizacion'>" + ga_Rango_Fechas_Cotizaciones[ li_Registro ].cotizacion + "</div>"; 
        }
    }
    lo_Objeto_Salida.registros  = li_Total_Cotizaciones;
    lo_Objeto_Salida.reservas   = la_Cotizacion.join('');
    
    return lo_Objeto_Salida; 
}

function Tomar_Proceso_Transporte() {

    Asignar_Valor('posicion_referencia|zona_mensaje_usuario','');

    // CARGAR LOS COSTOS POR PLAN, CALENDARIO Y MEDIO DE TRANSPORTE                  
    Cargar_Datos_Plan_Calendario_Transporte();

    // TOMAR LOS DATOS DE LOS PRECIOS SEGN CALENDARIO
    Cargar_Costos_Tipo_Calendario();

    // PRESENTAR LOS DATOS DE LOS SERVICIOS ADICIONAL
    if ( $('#modulo_servicios_adicionales')[0].style.display == 'none' ) { $('#modulo_servicios_adicionales').slideToggle('slow'); }
}

/*
function Traer_Datos_Habitacion() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_habitacion' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Tipo_Habitacion')[0].value );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}
*/

function Traer_Datos_Habitacion() {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_habitacion' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Tipo_Habitacion')[0].value );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Validar_Menores()' );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}


function Tomar_Numero_Capacidad() {
    var la_Capacidad        = $('#fc_Capacidad_Habitacion').attr('value').split(',');
    var li_Total_Elementos  = la_Capacidad.length;
       
    return la_Capacidad[ (li_Total_Elementos - 1) ];
}

function Validar_Menores() {
    $('#zona_mensaje_usuario').hide();

    if ( $('#fc_Menores_Habitacion').attr('value') != '' ) {
        $('#zona_mensaje_usuario').show();
        if ( Tomar_Numero( $('#fc_Menores_Habitacion').attr('value') ) == 0 ) {
            // CONFIGURAR LOS MENORES EN 0
            $('#fc_Menores').attr('value',0);
            $('#seccion_menores').hide();

            if ( Tomar_Numero( $('#fc_Capacidad_Habitacion').attr('value') ) > 0 ) {
                $('#zona_mensaje_usuario').html('Capacidad adultos : ' + Tomar_Numero_Capacidad() + '<br>No aplica para menores.');
            } else {
                $('#zona_mensaje_usuario').html('No aplica para menores.');
            }
        } else {
            if ( Tomar_Numero( $('#fc_Capacidad_Habitacion').attr('value') ) > 0 ) {
                $('#zona_mensaje_usuario').html('Capacidad adultos : ' + Tomar_Numero_Capacidad() + '<br>Capacidad nios&nbsp;&nbsp;&nbsp; : ' + $('#fc_Menores_Habitacion').attr('value') );
            } else {
                $('#zona_mensaje_usuario').html('Capacidad nios&nbsp; : ' + $('#fc_Menores_Habitacion').attr('value') );
            }            
        }
    }
}

function Activar_Eventos_Campos_Chequeo() {
    $('#recibir_email').click(function() {
        if ( this.checked == false ) {
            if ( $('#contenedor_mensaje')[0].style.display == 'none' ) { Asignar_Valor('mensaje_checkeo', la_Mensaje_Cotizador['Autorizar_Envio_Mail']); $('#contenedor_mensaje').slideToggle('slow'); }                  
        } else {
            Ocultar_Objeto('contenedor_mensaje');
        }
    });
    $('#registrar_datos').click(function() {
        if ( this.checked == false ) {
            if ( $('#contenedor_mensaje')[0].style.display == 'none' ) { 
                Asignar_Valor('fc_No_Registrar_Datos','');    
                Asignar_Valor('mensaje_checkeo', la_Mensaje_Cotizador['No_Permitir_Registro']); 
                $('#contenedor_mensaje').slideToggle('slow'); 
            }
        } else {
            Asignar_Valor('fc_No_Registrar_Datos','true');
            Ocultar_Objeto('contenedor_mensaje');
        }
    });          
}

function showLoading() {
    $('#loading').empty().append( 'Cargando informacin ... ' );
    $('#loading')[0].style.backgroundImage  = "url('http://www.siev.com.co/siev/aplicaciones/importar/images/loading.gif')";
    $("#loading").show();
}

function hideLoading() {
    $("#loading").hide();
}

function Cerrar_Loading() {
    hideLoading();
}

function Cargar_Lista_Desplegable(lc_Objeto_Destino,lc_Detalle_Lista,lc_Parametro,lc_Funcion){
    /*********** PRESENTAR EL LOADING *************/
    showLoading();
    /*********** PRESENTAR EL LOADING *************/            

    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('id',  lc_Detalle_Lista);
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('objeto',  lc_Objeto_Destino);              
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('codigo',  ( String(lc_Parametro) != 'undefined' ) ? lc_Parametro : '' );
    if ( String(lc_Funcion) != 'undefined' ) { la_Arreglo[la_Arreglo.length] = new Objeto_Servidor ('ejecutar' , lc_Funcion ); }
        
    Enviar_Objeto_Servidor( gc_Root + 'php/Cargar_Select.php',la_Arreglo ); 			 
}

function Tomar_Numero (lc_Numero) {
  if ( String(lc_Numero) != 'undefined' ) {
    	var lc_Numero = lc_Numero.replace(/[^0-9]/gi,'').replace(/^0/,'');
    	if (isNaN(parseInt(lc_Numero))) { return 0; } else { return parseInt(lc_Numero); }
  } else {
      return 0;
  }
}

function Ver_Descripcion_Servicio( lc_Id_Servicio ) {
    Tomar_Datos_Servicio_General( lc_Id_Servicio );
}

function Tomar_Datos_Servicio_General( lc_Id_Servicio ) {
    var la_Arreglo = new Array();
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario','datos_servicio_general' );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', lc_Id_Servicio );
    la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'ejecutar', 'Ver_Seccion_Servicio_General()' );

    Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);
}

function Ver_Seccion_Servicio_General() {
    $('#modulo_detalle_disponibilidad').show();
}

// DEFINIR LOS EVENTOS EN LOS OBJETOS DEL COTIZADOR
$(document).ready(function() {
    /*
        $('#boton_recibir_email').click( function () {
            if ( this.checked == true ) { if ( $('#informacion_solicitante')[0].style.display == 'none' ) { $('#informacion_solicitante').slideToggle('slow'); } } else { $('#informacion_solicitante').slideToggle('slow'); }
        });
    */

    // OCULTAR ZONAS A PARTIR DEL TIPO DE DIAGRAMACIN
    if ( document.getElementById('zona_habitaciones_disponibles') != null ) {

        $('#zona_usuarios .zona_mensaje_usuario').remove(); 
        
        $('#panel_contenedor_habitaciones_disponibles').css('display','none');
        // ADICIONAR LOS ELEMENTOS DEL COTIZADOR
            document.getElementById('panel_contenedor_habitaciones_disponibles').appendChild( document.getElementById('habitacion_plan') );        
            document.getElementById('panel_contenedor_habitaciones_disponibles').appendChild( document.getElementById('ciudad_salida') );
            document.getElementById('panel_contenedor_habitaciones_disponibles').appendChild( document.getElementById('zona_calendario') );
            document.getElementById('panel_contenedor_habitaciones_disponibles').appendChild( document.getElementById('modulo_detalle_disponibilidad') );
            // ADICIONAR LOS SERVICIOS ADICIONALES A LA ZONA DE INCLUIDOS Y NO INLUIDOS
            document.getElementById('panel_contenedor_habitaciones_disponibles').appendChild( document.getElementById('modulo_servicios_adicionales') );
            document.getElementById('panel_contenedor_habitaciones_disponibles').appendChild( document.getElementById('zona_usuario') );
        // FIN ADICIONAR ELEMENTOS COTIZADOR                
    }    

    // ADICIONAR EL OBJETO DE SEGUIMIENTO
    $('.siev_form fieldset legend').click( function(event) {
        event.preventDefault();
        Ver_Objeto_Cotizador();
    });

    // LIMPIAR LOS CAMPOS DEL FORMULARIO
    Inicializar_Formato();
    // ACTIVAR LOS CAMPOS DE CHEQUEO DE EMAIL Y REGISTRO DE INFORMACIN
    Activar_Eventos_Campos_Chequeo();

    // SI NO EXISTEN PLANES, ENTONCES INHABILITAR LA OPCIN DE COTIZAR
    var lo_Plan = document.getElementById('fc_Plan');
    if (lo_Plan.length < 1) { Ocultar_Objeto( $('.btn_cotizar')[0] ); } 

    // TRAER LOS DATOS DEL CLIENTE                             
    if ( $('#fc_Custom_Comprador')[0].value != '' ) {
        var la_Arreglo = new Array();
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'formulario', 'datos_cliente_conectado' );              
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor( 'codigo', $('#fc_Custom_Comprador')[0].value );
        Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Traer_Detalle.php',la_Arreglo);                                
    }

    // CARGAR LOS DATOS CUANDO VENGA DIRECTAMENTE DE UN PORTAFOLIO
    if ( $('#fc_Plan')[0].value != '' ) { 
        Cargar_Datos_Plan_Portafolio(); 
        Cargar_Costos_Adicionales($('#fc_Plan')[0].value);
        Cargar_Lista_Desplegable('fc_Temporada','tipo_calendario_portafolio',$('#fc_Plan')[0].value);
    }
    
    $('#fc_Plan').change(function() {
        if ( this.value != '' ) {
            Cargar_Datos_Plan_Portafolio(); 
            Cargar_Costos_Adicionales(this.value);
            Cargar_Datos_Plan_Portafolio(this.value);
            Cargar_Lista_Desplegable('fc_Temporada','tipo_calendario_portafolio',this.value);
        } 
    });
    $('#fc_Temporada').change(function() { 
        Iniciar_Fechas_Cotizador();
        if (this.value != '') {
            // ELIMIAR VALORES DE REFERENCIA
            Asignar_Valor('posicion_referencia|zona_mensaje_usuario',''); 
            Cargar_Lista_Desplegable('fc_Transporte','lista_transporte_calendario',this.value,'Carga_Transporte()');
            //Cargar_Lista_Desplegable('fc_Tipo_Habitacion','tipo_habitacion_portafolio',$('#fc_Plan')[0].value + '|' + this.value);

            // CARGAR LOS DATOS DE LA CIUDAD DE SALIDA
            Cargar_Lista_Desplegable('fc_Ciudad_Salida','lista_ciudad_salida_portafolio', $('#fc_Temporada')[0].value,'Carga_Ciudad_Salida()' );

            Cargar_Fechas_Temporada();
/*                      
            // BUSCAR EL MES Y REEMPLAZAR LOS CALENDARIOS
            var la_Mes = this.options[this.selectedIndex].text.split(' ');
            var li_Mes = In_Array(la_Mes_Calendario, la_Mes[0].toLowerCase() );
             
            if ( li_Mes != false ) {
                //Asignar_Valor('fc_Fecha_Actual',)
                var lc_Fecha = $('#fc_Fecha_Actual')[0].value.replace('/\-[0-9]{2}\-/',)
            }
*/
            
        } else {
            Asignar_Valor('fc_Adultos|fc_Menores|fc_Total_Dias','0');
            Asignar_Valor('fc_Transporte|fc_Tipo_Habitacion','');
        } 
    });

    $('body').mousemove(function(e){
        //var pageCoords = "( " + e.pageX + ", " + e.pageY + " )";
        //$("#mouse:first").text("( e.pageX, e.pageY ) : " + pageCoords);
        lo_Mouse.X = ( String(self.location.href).indexOf('Cotizar_Iframe') != -1 ) ? parseInt(e.pageX) : parseInt(e.pageX) - 280;
        lo_Mouse.Y = ( String(self.location.href).indexOf('Cotizar_Iframe') != -1 ) ? parseInt(e.pageY) : parseInt(e.pageY) - 270;
    });    

    $('#fc_Tipo_Habitacion').change(function( event ) {
        event.preventDefault();
        
        Ocultar_Objeto('seccion_menores',false); 
        Iniciar_Fechas_Cotizador();
        if ( $(this).attr('value') != '' ) {
            // ELIMINAR VALORES DE REFERENCIA
            Asignar_Valor('posicion_referencia|zona_mensaje_usuario','');
            Cargar_Lista_Desplegable( 'fc_Transporte','lista_transporte_calendario', $('#fc_Temporada')[0].value,'Carga_Transporte()' );
            Cargar_Fechas_Temporada();

            // PRESENTAR DATOS DE USUARIO 
            Ocultar_Objeto('zona_usuario|zona_calendario',false);
            
            // TOMAR LOS DATOS DE LA OCUPACIN DE LA HABITACIN
            Tomar_Datos_Disponibilidad();            
            
            //$('#zona_mensaje_usuario').css('margin-left','10px;');
            
            //$('#modulo_detalle_disponibilidad').css({ width: '300px', margin-top: '10px'}); 
            
            //$('#modulo_detalle_disponibilidad').css({ top: (lo_Mouse.Y + 15)+'px', left: (lo_Mouse.X + 15)+'px'}).show();
            //$('#modulo_detalle_disponibilidad').css({ top: (lo_Mouse.Y + 15)+'px', right: '20px'}).show();
            Traer_Datos_Habitacion();
            
            // NO PRESENTAR EL LYTEBOX DE DISPONIBILIDAD EN CASO DE SEGUNDA DIAGRAMACIN
            if ( document.getElementById('zona_habitaciones_disponibles') == null ) { $('#modulo_detalle_disponibilidad').show(); }
        } else {
            // OCULTAR LAS IMGENES DE LA DISPONIBILIDAD
            $('#modulo_detalle_disponibilidad').hide();
            Asignar_Valor('fc_Adultos|fc_Menores|fc_Total_Dias','0');
            Asignar_Valor('fc_Transporte','');
        }
    });              

    $('#fc_Transporte').change(function() { 
        /*
        Iniciar_Fechas_Cotizador();
        // OCULTAR LA DESCRIPCIN DE LA HABITACIN
        $('#modulo_detalle_disponibilidad').hide();
        
        if ( $('#zona_usuarios')[0].style.display == 'none' ) { $('#zona_usuarios').slideToggle('slow'); }
        */
        //if (this.value != '') { Tomar_Proceso_Transporte(); }
        
        if (this.value != '') { 
            Cargar_Costos_Tipo_Calendario();
            //Cargar_Datos_Plan_Calendario_Transporte();
            
            // CARGAR LOS INCLUIDOS Y NO INCLUDOS
            if ( document.getElementById('zona_habitaciones_disponibles') != null ) { Cargar_Servicios_Habitacion(); } 
        }
    });
});          

function Cargar_Servicios_Habitacion() {

    if ( $('#fc_Tipo_Habitacion').attr('value') != '' && $('#fc_Transporte').attr('value') != '' ) {
        var la_Arreglo = new Array();
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('accion','Cargar_Servicio_Habitacion');
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('contenedor', 'contenedor_servicios_habitacion_' + $('#fc_Tipo_Habitacion').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('tipo_habitacion', $('#fc_Tipo_Habitacion').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('tipo_transporte', $('#fc_Transporte').attr('value') );
        la_Arreglo[la_Arreglo.length] = new Objeto_Servidor('ejecutar','');
    
        //alert( $('#fc_Tipo_Habitacion').attr('value') + ' ' + $('#fc_Transporte').attr('value') );
        Enviar_Objeto_Servidor( gc_Ruta_Aplicativo + 'Cgi/Almacenamiento.php',la_Arreglo);    
    }
}

