<?php

if (!headers_sent() && '' == session_id()) {
    session_start();
} // INICIAR LA SESIN



if (!isset($lc_Path) || !file_exists($lc_Path . 'Globales.php')) {

    $lc_Path = "./siev/";
    $lb_Ruta = false;
    $li_Iteraciones = 0;

    // BUSCAR EL ROOT ./siev

    do {
        if (file_exists($lc_Path . "Globales.php")) {
            $lb_Ruta = true;
        } else {
            $lc_Path  = "../" . preg_replace("/^\.\//", "", $lc_Path);
        }
        $li_Iteraciones++;
    } while ($lb_Ruta == false && $li_Iteraciones <= 6);
}



include_once $lc_Path . "../Connections/conexion.php";


if (!defined('DBNAME')) {

    DEFINE("DBNAME", $database_conexion);

    DEFINE("DBUSER", $username_conexion);

    DEFINE("DBPASS", $password_conexion);

    DEFINE("DBHOST", $hostname_conexion);


    //$lc_Mensaje = DBNAME." - user ".DBUSER." - pass ".DBPASS;

    //error_log($lc_Mensaje.' '.date('Y/m/d H:i:s')."\n",3,$lc_Path.'log_cliente.log');


    DEFINE("Path_Host",          $weblider . "siev/");

    //DEFINE( "Path_Host",          "https://".$_SERVER['HTTP_HOST']."/demo/demo/siev/");

    DEFINE("RUTA_SCRIPTS",       $weblider . "siev/js/");

    DEFINE("RUTA_PLACE_TO_PAY",  "https://" . $_SERVER['HTTP_HOST'] . "/pagos/ptop/recibe.php");

    DEFINE("RUTA_ICONOS",        $weblider . "siev/aplicaciones/iconos/");


    // MENSAJES DE ERROR

    $ga_Error_BD = array();

    $ga_Error_BD["UNKNOWN COLUMN"]    = "Error de Aplicacion [10-10]. Favor comunicar al Administrador.";

    $ga_Error_BD["DUPLICATE"]         = "Error de Informacion [Registro Duplicado]";

    $ga_Error_BD["AMBIGUOUS"]         = "Error de Aplicativo [10-20]. Favor comunicar al Administrador";

    $ga_Error_BD["ERROR IN YOUR SQL"] = "Error de Aplicativo [10-30]. Favor comunicar al Administrador";


    // TIPOS DE ARCHIVO QUE PUEDEN SER SUBIDOS AL SERVIDOR

    DEFINE("FILE_UPLOAD", "image/tiff,image/gif,image/jpeg,image/bmp,image/pjpeg,application/pdf,audio/mpeg,video/mpeg,video/quicktime,application/vnd.ms-excel,application/vnd.ms-powerpoint,application/msword,application/zip,application/x-zip-compressed,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/force-download,video/x-ms-wmv,video/x-flv");

    // EXTENSIONES QUE PUEDEN SER VISUALIZADAS

    DEFINE("LIST_FILE", "html,htm,tif,gif,jpg,jpeg,bmp,png,pdf,mpg,mpeg,xls,doc,ppt,pps,zip,rar,xlsx,docx,wmv,flv");

    // CARGAR EL MDULO QUE PERMITE REEMPLAZAR LA DIRECTIVA REGISTER_GLOBALS = ON

    // if (file_exists($lc_Path . 'php/Modulo_Variables_Get.php')) {
    //     include_once $lc_Path . 'php/Modulo_Variables_Get.php';
    // }

    DEFINE("FECHA_ACTUAL", date('Y-m-d'));

    DEFINE("HORA_ACTUAL", date('H:i:s'));

    DEFINE("DEBUG_PHP", "true");

    DEFINE("SMTP", 1);

    DEFINE("CONVERSIONES", 1);

    DEFINE("IP_Nuevo_Servidor", "174.133.42.130");
}


//  Despus de que ya existen las constantes, puedes conectar y limpiar
$conn_seguro = mysqli_connect(DBHOST, DBUSER, DBPASS, DBNAME);
// mysqli_set_charset($conn_seguro, 'utf8mb4');
// mysqli_set_charset($conn_seguro, 'latin1');

// --- Cabeceras HTTP para proteccin del navegador ---

// ?? Poltica de seguridad de contenido:
// Solo permite cargar contenido (imgenes, scripts, estilos, etc.) desde el mismo dominio (self)
// Evita inyecciones de scripts externos y ataques de XSS
// header("Content-Security-Policy: default-src 'self'; script-src 'self'; object-src 'none'; frame-ancestors 'none';");

// ?? Previene que el navegador intente adivinar el tipo MIME de un recurso:
// Por ejemplo, que no intente ejecutar como script un archivo subido como imagen
// header("X-Content-Type-Options: nosniff");

// ?? Previene que tu sitio se embeba en un iframe en otros sitios:
// Evita ataques de clickjacking
// header("X-Frame-Options: DENY");

// ?? Activa el filtro XSS en navegadores antiguos como IE y versiones viejas de Chrome:
// Hoy en da es redundante pero no daa tenerlo como refuerzo
// header("X-XSS-Protection: 1; mode=block");


function limpiarEntradaGlobal(&$entrada, $conn)
{
    $ipUsuario = $_SERVER['REMOTE_ADDR'] ?? 'IP desconocida';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'User-Agent no disponible';
    $hora = date('Y-m-d H:i:s');

    foreach ($entrada as $clave => $valor) {
        if (is_array($valor)) {
            limpiarEntradaGlobal($entrada[$clave], $conn); // Recursivo
        } else {
            // Validacin bsica de tipo
            if (!is_string($valor)) {
                continue;
            }

            // Normalizacin UTF-8 y decodificacin
            $encoding = mb_detect_encoding($valor, ['Windows-1252', 'UTF-8', 'ISO-8859-1', 'ASCII'], true);
            if ($encoding !== false) {
                $valor = mb_convert_encoding($valor, 'UTF-8', $encoding);
            }
            $valor = urldecode($valor);
            $valor = trim($valor);

            // Limpieza HTML
            $valor = strip_tags($valor);
            $valor = htmlspecialchars($valor, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8', false);

            // Patrn sospechoso comn
            if (preg_match('/<script|onerror=|onload=|alert\(|base64|select .* from|union|--|javascript:/i', $valor)) {
                error_log("?? [$hora] Intento malicioso detectado desde $ipUsuario con $userAgent  Clave: $clave  Valor: $valor");
            }

            // Bloqueo activo de amenazas ms peligrosas
            if (preg_match('/(drop\s+table|truncate\s+|eval\(|atob\(|base64_decode|<iframe|<object|<embed|<svg|<img.*onerror=|<.*onload=)/i', $valor)) {
                error_log("? [$hora] Contenido bloqueado por seguridad  Clave: $clave  Valor: $valor  IP: $ipUsuario");
                $valor = '[Contenido bloqueado por seguridad]';
            }

            // Validacin de tamao mximo permitido
            if (strlen($valor) > 1000) {
                error_log("?? [$hora] Entrada excesivamente larga  Clave: $clave  IP: $ipUsuario");
                $valor = '[Texto demasiado extenso]';
            }

            // Escapado para SQL seguro
            $valor = mysqli_real_escape_string($conn, $valor);

            // Asignacin segura
            $entrada[$clave] = $valor;
        }
    }
}


limpiarEntradaGlobal($_POST, $conn_seguro);
limpiarEntradaGlobal($_GET, $conn_seguro);
limpiarEntradaGlobal($_REQUEST, $conn_seguro);




//LIMITAR EL USO DE FORMULARIOS A VARIOS INTENTOS EN IP


function obtenerIP()
{
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}

function puedeEnviarFormulario($limite = 10, $tiempo = 60)
{
    $ip = obtenerIP();
    $archivo = sys_get_temp_dir() . "/limite_ip_" . md5($ip) . ".txt";
    $intentos = [];

    // Cargar intentos existentes si el archivo existe
    if (file_exists($archivo)) {
        $intentos = explode("\n", file_get_contents($archivo));
        $intentos = array_filter($intentos, function ($t) use ($tiempo) {
            return (time() - (int)$t) <= $tiempo;
        });
    }

    // Guardar el intento actual
    $intentos[] = time();
    file_put_contents($archivo, implode("\n", $intentos));

    return count($intentos) <= $limite;
}


// Funcin para limpiar, limitar y convertir a latin1
function limitarTexto($texto, $max = 150)
{
    // Elimina espacios, etiquetas HTML/JS y caracteres invisibles
    $texto = trim(strip_tags($texto));

    // Reemplaza mltiples espacios seguidos por uno solo (opcional)
    $texto = preg_replace('/\s+/', ' ', $texto);

    // Trunca el texto a la longitud mxima permitida
    $texto = mb_substr($texto, 0, $max);

    // Convierte a ISO-8859-1 si est en UTF-8
    return mb_convert_encoding($texto, 'ISO-8859-1', 'UTF-8');
    // return mb_convert_encoding($texto, 'UTF-8', 'Windows-1252');
}


function validarFormularioSeguro()
{
    // Obtener IP del visitante
    $ip = $_SERVER['REMOTE_ADDR'];
    $referer = $_SERVER['HTTP_REFERER'] ?? 'REFERER NO DISPONIBLE';

    // Inicializar o incrementar intentos
    $_SESSION['form_hits'][$ip] = ($_SESSION['form_hits'][$ip] ?? 0) + 1;

    // Solo registrar en log si supera los 6 intentos
    if ($_SESSION['form_hits'][$ip] > 6) {
        error_log("?? FORM_HITS: IP {$ip} => {$_SESSION['form_hits'][$ip]} intentos | URL: {$referer}");

        // Registrar los tokens en log
        $token_post = $_POST['token_validacion'] ?? 'NO ENVIADO';
        $token_session = $_SESSION['form_token'] ?? 'NO DEFINIDO';
        error_log("?? TOKEN EN POST: {$token_post}");
        error_log("?? TOKEN EN SESIN: {$token_session}");
    }

    // Validar nmero de intentos
    if ($_SESSION['form_hits'][$ip] > 10) {
        if ($_SESSION['form_hits'][$ip] > 6) {
            error_log("? Bloqueado por exceso de intentos desde IP {$ip} | URL: {$referer}");
        }
        header('HTTP/1.1 403 Forbidden');
        exit('Has enviado demasiadas solicitudes. Intenta ms tarde.');
    }

    // Validar token CSRF
    if (!isset($_POST['token_validacion']) || $_POST['token_validacion'] !== ($_SESSION['form_token'] ?? '')) {
        if ($_SESSION['form_hits'][$ip] > 6) {
            error_log("? Token invlido o acceso no autorizado. URL: {$referer}");
        }
        header('HTTP/1.1 403 Forbidden');
        exit('Token invlido o acceso no autorizado.');
    }
}
