<?php
// Endpoint para recibir confirmaciones de pago desde Wompi
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

if ($data && isset($data['data']['transaction']['id'])) {
  $transactionId = $data['data']['transaction']['id'];

  // Consultar el estado de la transacción en Wompi
  $wompiUrl = "https://production.wompi.co/v1/transactions/$transactionId";
  $response = file_get_contents($wompiUrl);
  $transactionData = json_decode($response, true);

  if ($transactionData && isset($transactionData['data']['status'])) {
    $status = $transactionData['data']['status'];

    if ($status === "APPROVED") {
      // Pago aprobado, actualizar base de datos
      echo json_encode(["status" => "success", "message" => "Pago aprobado"]);
    } else {
      // Pago fallido o pendiente
      echo json_encode(["status" => "error", "message" => "Pago no aprobado"]);
    }
  }
}
