<?php

if (!function_exists('Combinar_Registro_Plantilla')) {
    /********************************************************************************
    // FUNCIN QUE PERMITE COMBINAR UNA PLANTILLA HTML CON UN ARREGLO ASOCIATIVO
     ********************************************************************************/
    function Combinar_Registro_Plantilla($row, $lc_Html)
    {
        $lb_Encontrado = false;

        if (preg_match_all("/\&lquo\;([0-9a-z\_]{1,})\&rquo\;/i", $lc_Html, $la_Atributos)) {
            $lb_Encontrado = true;
            array_shift($la_Atributos);
        } else {
            if (preg_match_all("/\([0-9a-z\_]{1,})\/i", $lc_Html, $la_Atributos)) {
                $lb_Encontrado = true;
                array_shift($la_Atributos);
            }
        }
        if ($lb_Encontrado == true) {
            $li_Total_Atributos = count($la_Atributos[0]);
            for ($li_Atributo = 0; $li_Atributo < $li_Total_Atributos; $li_Atributo++) {
                $lc_Atributo = $la_Atributos[0][$li_Atributo];
                if (in_array($lc_Atributo, array_keys($row))) {
                    $lc_Html = preg_replace("/\" . $lc_Atributo . "\/i", $row[$lc_Atributo], $lc_Html);
                } else {
                    //print_r( array_keys($row) ); 
                }
            }
            // LIMPIAR LAS REFERENCIAS NULAS
            $lc_Html = preg_replace("/\[A-z]{1,}\/i", "", $lc_Html);
        }
        return $lc_Html;
    }
}



$url_completa = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http")
    . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";


if (!isset($ver) || $ver == '') { ?>
    <title><?php echo $row_micros['metatittle']; ?></title>
    <META name="description" content="<?php echo $row_micros['metadescr']; ?>">
    <META name="keywords" content="<?php echo $row_micros['keywords']; ?>">
    <meta property="og:image" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/cliente/<?php echo $row_micros['ruta_imagen']; ?>">
    <meta name="ROBOTS" content="INDEX,FOLLOW">

    <?php /*?>    <META name="DC.Title" content="<?php echo $row_micros['metatittle']; ?>">    
    <META http-equiv="title" content="<?php echo $row_micros['metatittle']; ?>">
    <META http-equiv="keywords" content="<?php echo $row_micros['keywords']; ?>">
    <META http-equiv="description" content="<?php echo $row_micros['metadescr']; ?>">
    <META http-equiv="DC.Description" content="<?php echo $row_micros['metadescr']; ?>"><?php */ ?>
    <!-- <meta name="ROBOTS" content="INDEX,FOLLOW"> -->
<?php }


if (!empty($id) && $id > 0 && !empty($row_actuprod)) { ?>

    <!-- Ttulo -->
    <?php if (!empty($row_actuprod['titu_busca'])) { ?>
        <title><?php echo $row_actuprod['titu_busca']; ?></title>
        <meta property="og:title" content="<?php echo $row_actuprod['titu_busca']; ?>">
    <?php } ?>

    <!-- Meta Description -->
    <?php if (!empty($row_actuprod['des_busca'])) { ?>
        <meta name="description" content="<?php echo $row_actuprod['des_busca']; ?>">
        <meta property="og:description" content="<?php echo $row_actuprod['des_busca']; ?>">
    <?php } ?>

    <!-- Keywords (Opcional, til para buscadores internos) -->
    <?php if (!empty($row_actuprod['p_clave'])) { ?>
        <meta name="keywords" content="<?php echo $row_actuprod['p_clave']; ?>">
    <?php } ?>

    <!-- Imagen Open Graph -->
    <?php if (!empty($row_micros['custom_dominio2']) && !empty($row_actuprod['ruta_imagen'])) { ?>
        <meta property="og:image" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/portafolio/<?php echo $row_actuprod['ruta_imagen']; ?>">
        <meta property="og:image:secure_url" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/portafolio/<?php echo $row_actuprod['ruta_imagen']; ?>">
        <meta property="og:image:type" content="image/webp">
        <meta property="og:image:width" content="1200">
        <meta property="og:image:height" content="630">
    <?php } ?>

    <!-- URL Cannica -->
    <?php if (!empty($url_completa)) { ?>
        <link rel="canonical" href="<?php echo $url_completa; ?>">
        <meta property="og:url" content="<?php echo $url_completa; ?>">
    <?php } ?>

    <!-- Open Graph Tipo Producto -->
    <meta property="og:type" content="product">

    <?php if (!empty($row_micros['custom_empresa'])) { ?>
        <meta property="og:site_name" content="<?php echo $row_micros['custom_empresa']; ?>">
    <?php } ?>

    <!-- Meta Robots -->
    <?php if (isset($row_actuprod['mostrar'])) { ?>
        <?php if ($row_actuprod['mostrar'] == 'si') { ?>
            <meta name="robots" content="INDEX,FOLLOW">
        <?php } else { ?>
            <meta name="robots" content="NOINDEX,FOLLOW">
        <?php } ?>
    <?php } ?>


<?php } ?>

<?php if (!empty($v_Pgral) && $v_Pgral == 1) { ?>

    <!-- Ttulo -->
    <?php if (!empty($row_menu_gnral['titulo'])) { ?>
        <title><?php echo $row_menu_gnral['titulo']; ?></title>
        <meta property="og:title" content="<?php echo $row_menu_gnral['titulo']; ?>">
    <?php } ?>

    <!-- Meta Description -->
    <?php if (!empty($row_menu_gnral['descripcion'])) { ?>
        <meta name="description" content="<?php echo $row_menu_gnral['descripcion']; ?>">
        <meta property="og:description" content="<?php echo $row_menu_gnral['descripcion']; ?>">
    <?php } ?>

    <!-- Keywords (Opcional, ya que Google no las usa, pero pueden servir para buscadores internos) -->
    <?php if (!empty($row_menu_gnral['palabras'])) { ?>
        <meta name="keywords" content="<?php echo $row_menu_gnral['palabras']; ?>">
    <?php } ?>

    <!-- Imagen Open Graph -->
    <?php if (!empty($row_micros['custom_dominio2']) && !empty($row_micros['ruta_imagen'])) { ?>
        <meta property="og:image" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/cliente/<?php echo $row_micros['ruta_imagen']; ?>">
        <meta property="og:image:secure_url" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/cliente/<?php echo $row_micros['ruta_imagen']; ?>">
        <meta property="og:image:type" content="image/webp">
        <meta property="og:image:width" content="1200">
        <meta property="og:image:height" content="630">
    <?php } ?>

    <!-- URL Cannica -->
    <?php if (!empty($url_completa)) { ?>
        <link rel="canonical" href="<?php echo $url_completa; ?>">
        <meta property="og:url" content="<?php echo $url_completa; ?>">
    <?php } ?>

    <!-- Open Graph General -->
    <meta property="og:type" content="product">


    <?php if (!empty($row_micros['custom_empresa'])) { ?>
        <meta property="og:site_name" content="<?php echo $row_micros['custom_empresa']; ?>">
    <?php } ?>

    <!-- Meta Robots -->
    <?php if (isset($row_menu_gnral['mostrar'])) { ?>
        <?php if ($row_menu_gnral['mostrar'] == 'si') { ?>
            <meta name="robots" content="INDEX,FOLLOW">
        <?php } else { ?>
            <meta name="robots" content="NOINDEX,FOLLOW">
        <?php } ?>
    <?php } ?>
<?php } ?>

<?php if (isset($gal) && $gal == 1) { ?>
    <title><?php echo $row_galmicros['titu_busca']; ?></title>
    <META name="description" content="<?php echo $row_galmicros['des_busca']; ?>">
    <META name="keywords" content="<?php echo $row_micros['keywords']; ?>">
    <meta property="og:image" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/cliente/<?php echo $row_micros['ruta_imagen']; ?>">
    <meta name="ROBOTS" content="INDEX,FOLLOW">
<?php } ?>

<?php if (isset($cat) && $cat == 1) { ?>
    <title><?php echo $row_cateposi['titulo']; ?></title>
    <META name="description" content="<?php echo $row_cateposi['descripcion']; ?>">
    <META name="keywords" content="<?php echo $row_cateposi['palabras']; ?>">
    <meta property="og:image" content="https://<?php echo $row_micros['custom_dominio2']; ?>images/cliente/<?php echo $row_micros['ruta_imagen']; ?>">
    <?php if ($row_actuprod['mostrar'] == 'si') { ?>
        <meta name="ROBOTS" content="INDEX,FOLLOW">
    <?php } else { ?>
        <meta name="robots" content="NOINDEX,FOLLOW">
    <?php } ?>
<?php } ?>
<?php if (isset($f_contacto) && $f_contacto == 1) { ?>
    <title>rea de contacto <?php echo $row_micros['custom_empresa']; ?></title>
    <meta name="ROBOTS" content="INDEX,FOLLOW">
<?php } ?>
<?php if (isset($f_rec) && $f_rec == 1) { ?>
    <title>Recomendar <?php echo $row_micros['custom_empresa']; ?></title>
    <meta name="ROBOTS" content="INDEX,FOLLOW">
<?php } ?>
<?php if (isset($f_usuarios) && $f_usuarios == 1) { ?>
    <title>Inscripcin al Boletn <?php echo $row_micros['custom_empresa']; ?></title>
    <meta name="ROBOTS" content="INDEX,FOLLOW">
<?php } ?>
<?php if (isset($sistema) && $sistema == 1) { ?>
    <title><?php echo $row_micros['metatittle']; ?></title>
    <meta name="ROBOTS" content="INDEX,FOLLOW">
<?php } ?>
<meta property="og:locale" content="es_CO">
<META name="language" content="es">
<META name="author" content="SIEV Sistema Integrado de Empresas Virtuales">
<META name="owner" content="www.siev.co">
<?php echo $row_micros['csitio']; ?>