<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 'On');

$lc_Path = "./siev/";
$lb_Ruta = false;
$li_Iteraciones = 0;

// BUSCAR EL ROOT ./siev
do {
  if (file_exists($lc_Path . "Globales.php")) {
    $lb_Ruta = true;
  } else {
    $lc_Path  = "../" . preg_replace("/^\.\//", "", $lc_Path);
  }
  $li_Iteraciones++;
} while ($lb_Ruta == false && $li_Iteraciones <= 6);

include_once $lc_Path . "Globales.php";
include_once $lc_Path . "php/Conexion_BD.php";

require '../../vendor/autoload.php'; // Cargar Composer

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Claves VAPID
$VAPID_PUBLIC = "BNJHutigtT4tkPAyKuELi1GF1hDdIuHm8648LoC5tUvkrMQaPHZute_-N-CLuXk7Q6yI_wbyZmiYsSsDfJ0dw6g";
$VAPID_PRIVATE = "sRrEsZ3H5h0IyuO22eeUJ-TrxYZh0wc9coHmIq83nkA";

// Obtener todas las suscripciones_push de la base de datos
$query_subscripciones = "SELECT * FROM suscripciones_push";
$lo_Objeto_Subscripciones = HacerConsultaQuery($query_subscripciones);
$subscriptions = [];

if (!empty($lo_Objeto_Subscripciones->DB_resultado)) {
  foreach ($lo_Objeto_Subscripciones->DB_resultado as $row) {
    $subscriptions[] = Subscription::create([
      'endpoint' => $row['endpoint'],
      'keys' => [
        'p256dh' => $row['p256dh'],
        'auth' => $row['auth']
      ]
    ]);
  }
}

// Configurar WebPush
$webPush = new WebPush([
  'VAPID' => [
    'subject' => 'mailto:soporte@todoventa,.com',
    'publicKey' => $VAPID_PUBLIC,
    'privateKey' => $VAPID_PRIVATE,
  ],
]);



// Enviar la notificación a cada usuario suscrito
foreach ($subscriptions as $sub) {
  $webPush->queueNotification(
    $sub,
    json_encode([
      "data" => [ // 🔹 Agregar los datos dentro de "data" para que el Service Worker los procese correctamente
        "title" => "🚀 Notificación Importante",
        "body" => "Tu mensaje personalizado aquí con más detalles.",
        "icon" => "https://www.siev.mobi/images/progressive/icon-maskable.png",
        "image" => "https://www.siev.mobi/images/progressive/icon-maskable.png",
        "badge" => "https://www.siev.mobi/images/progressive/icon-maskable.png",
        "vibrate" => [200, 100, 200],
        "actions" => [
          [
            "action" => "ver",
            "title" => "🔍 Ver Detalles"
          ],
          [
            "action" => "cerrar",
            "title" => "❌ Cerrar"
          ]
        ]
      ]
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) // 🔹 Evita caracteres extraños y corrige las URLs
  );
}




// Procesar los envíos
foreach ($webPush->flush() as $report) {
  if ($report->isSuccess()) {
    echo "✅ Notificación enviada con éxito a: " . $report->getRequest()->getUri() . "\n";
  } else {
    echo "❌ Fallo en la notificación: " . $report->getReason() . "\n";
  }
}
