navigator.serviceWorker.getRegistration().then((registration) => {
    if (registration) {
        registration.unregister().then(() => {
            console.log("🔄 Service Worker actualizado. Recargando...");
            location.reload();
        });
    }
});

navigator.serviceWorker.ready.then(async (registration) => {
    const existingSubscription =
        await registration.pushManager.getSubscription();
    if (existingSubscription) {
        console.log("📌 Eliminando suscripción antigua...");
        await existingSubscription.unsubscribe();
        console.log("✅ Suscripción antigua eliminada.");
    }
});

document.addEventListener("DOMContentLoaded", async function () {
    const btn = document.getElementById("btnNotificaciones");

    if (!btn) {
        console.error("No se encontró el botón de notificaciones.");
        return;
    }

    if ("serviceWorker" in navigator && "PushManager" in window) {
        try {
            const registration = await navigator.serviceWorker.register(
                "/js/pwa/service-worker.js"
            );
            // console.log("Service Worker registrado correctamente.");

            btn.addEventListener("click", async function () {
                try {
                    const permission = await Notification.requestPermission();
                    console.log("Estado del permiso:", permission);

                    if (permission === "granted") {
                        const subscription =
                            await registration.pushManager.subscribe({
                                userVisibleOnly: true,
                                applicationServerKey:
                                    "BNJHutigtT4tkPAyKuELi1GF1hDdIuHm8648LoC5tUvkrMQaPHZute_-N-CLuXk7Q6yI_wbyZmiYsSsDfJ0dw6g",
                            });

                        console.log(
                            "🔔 Subscripción exitosa:",
                            JSON.stringify(subscription)
                        );

                        await fetch("js/pwa/guardar_subscripcion.php", {
                            method: "POST",
                            body: JSON.stringify(subscription),
                            headers: { "Content-Type": "application/json" },
                        });

                        console.log("✅ Subscripción enviada al servidor.");

                        // 🔹 Enviar una notificación local de agradecimiento
                        registration.showNotification(
                            "¡Gracias por suscribirte!",
                            {
                                body: "Ahora recibirás nuestras notificaciones en tiempo real.",
                                icon: "/images/icon.png",
                                badge: "/images/badge.png",
                            }
                        );
                    } else {
                        console.warn(
                            "⚠️ El usuario denegó las notificaciones."
                        );
                    }
                } catch (error) {
                    console.error("❌ Error en la suscripción Push:", error);
                }
            });
        } catch (error) {
            console.error("❌ Error al registrar el Service Worker:", error);
        }
    } else {
        console.error(
            "❌ Notificaciones Push no soportadas en este navegador."
        );
    }
});
