let deferredPrompt;

// Detectar si la PWA ya est instalada al cargar la pgina
document.addEventListener("DOMContentLoaded", () => {
    if (isPWAInstalled()) {
        showInstalledMessage();
    }
});

// Detectar si la PWA est instalada
function isPWAInstalled() {
    return (
        window.matchMedia("(display-mode: standalone)").matches ||
        window.navigator.standalone ||
        document.referrer.includes("android-app://")
    );
}

// Mostrar el mensaje "Aplicacin instalada"
function showInstalledMessage() {
    const btnInstall = document.getElementById("btnInstall");
    if (btnInstall) {
        btnInstall.style.display = "none"; // Oculta el botn

        // Si no existe el mensaje, lo crea
        if (!document.getElementById("installedMessage")) {
            let installedMessage = document.createElement("p");
            installedMessage.id = "installedMessage";
            installedMessage.innerHTML = "Aplicacin instalada";
            installedMessage.style.fontSize = "16px";
            installedMessage.style.color = "#4CAF50";
            installedMessage.style.marginTop = "10px";

            btnInstall.parentNode.insertBefore(
                installedMessage,
                btnInstall.nextSibling
            );
        }
    }
}

// Detectar el evento `beforeinstallprompt`
window.addEventListener("beforeinstallprompt", (e) => {
    e.preventDefault();
    deferredPrompt = e;

    if (!isPWAInstalled()) {
        showInstallButton();
    } else {
        showInstalledMessage();
    }
});

// Mostrar el botn de instalacin solo si la app no est instalada
function showInstallButton() {
    const btnInstall = document.getElementById("btnInstall");
    if (btnInstall) {
        btnInstall.style.display = "block";
        btnInstall.addEventListener("click", async () => {
            hideInstallButton();
            deferredPrompt.prompt();
            const choiceResult = await deferredPrompt.userChoice;
            if (choiceResult.outcome === "accepted") {
                console.log("El usuario acept la instalacin.");
                showInstalledMessage();
            } else {
                console.log("El usuario rechaz la instalacin.");
                btnInstall.style.display = "block";
            }
            deferredPrompt = null;
        });
    }
}

// Ocultar el botn si la PWA ya est instalada
function hideInstallButton() {
    const btnInstall = document.getElementById("btnInstall");
    if (btnInstall) {
        btnInstall.style.display = "none";
    }
}

// Detectar si la PWA ya est instalada en Android (Chrome)
if (document.referrer.includes("android-app://")) {
    showInstalledMessage();
}
