<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

// Buscar el root para incluir Globales.php
if (!isset($lc_Path)) {
      $lc_Path = "../";
      $lb_Ruta = false;
      $li_Iteraciones = 0;
      do {
            if (file_exists($lc_Path . "Globales.php")) {
                  $lb_Ruta = true;
            } else {
                  $lc_Path = "../" . preg_replace("/^\.\//", "", $lc_Path);
            }
            $li_Iteraciones++;
      } while (!$lb_Ruta && $li_Iteraciones <= 6);
}

// Cargar clase de conexin y funciones globales
require_once($lc_Path . "Globales.php");

$response = ['success' => false, 'message' => 'No se pudo procesar la solicitud.'];

try {
      // Conexin
      $conn = new ConexionMySql();
      $conexion = $conn->DB_conexion;

      // Datos desde fetch JSON
      $data = json_decode(file_get_contents("php://input"), true);
      if (!isset($data['nombre'], $data['telefono']) || empty($data['telefono'])) {
            throw new Exception("Faltan datos requeridos.");
      }

      // Sanitizar entradas
      $nombre   = mysqli_real_escape_string($conexion, $data['nombre']);
      $telefono = preg_replace('/\D/', '', $data['telefono']);
      $email    = isset($data['email']) ? mysqli_real_escape_string($conexion, $data['email']) : 'sin_email@no-definido.com';
      $tipo     = isset($data['tipo']) ? mysqli_real_escape_string($conexion, $data['tipo']) : 'Whatsapp';

      // Guardar en la base de datos
      $query = "INSERT INTO callback (fecha, telefono_cliente, telefono_usuario, tipo)
              VALUES (NOW(), '{$telefono}', '{$telefono}', '{$tipo}')";
      if (!mysqli_query($conexion, $query)) {
            throw new Exception("Error al guardar: " . mysqli_error($conexion));
      }

      // Enviar SMS usando tu API
      $sms = [
            'module'     => 'sms',
            'action'     => 'read',
            'id'         => 0,
            'username'   => '890981719',
            'number'     => $telefono, // Solo 1 nmero, puedes concatenar ms separados por coma
            'text'       => 'Gracias por contactarnos. Pronto te responderemos.',
            'referencia' => 'Contacto Web',
      ];
      $sms_result = enviarSMS_API($sms);

      if ($sms_result['success'] != 1) {
            throw new Exception("Error al enviar SMS");
      }

      // Enviar correo
      include($lc_Path . "mailer/class.phpmailer.php");
      include($lc_Path . "mailer/class.smtp.php");

      $mail = new PHPMailer();
      $mail->From     = 'servicioalcliente@tuempresa.com';
      $mail->FromName = 'SIEV';
      $mail->Subject  = 'Nuevo contacto Whatsapp';
      $mail->Body     = "Nombre: $nombre<br>Telfono: $telefono<br>Email: $email<br>Tipo: $tipo";
      $mail->IsHTML(true);
      $mail->AddAddress($email, $nombre);
      $mail->AddBCC("soporte@tuempresa.com");

      if (!$mail->Send()) {
            throw new Exception("Error al enviar correo: " . $mail->ErrorInfo);
      }

      $response['success'] = true;
      $response['message'] = "Mensaje enviado correctamente. Te contactaremos pronto.";
} catch (Exception $e) {
      $response['message'] = $e->getMessage();
}

echo json_encode($response);
exit;


// ?? Funcin para enviar SMS va API Voziphone
function enviarSMS_API(array $req)
{
      $key         = '890981719HZcHidch';
      $secret      = '890981719HZcHidch9511124184';
      $trading_url = 'http://95.111.241.84/voziphone';

      $mt = explode(' ', microtime());
      $req['nonce'] = $mt[1] . substr($mt[0], 2, 6);
      $post_data = http_build_query($req, '', '&');
      $sign = hash_hmac('sha512', $post_data, $secret);
      $headers = ['Key: ' . $key, 'Sign: ' . $sign];

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $trading_url . '/index.php/sms/read');
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

      $res = curl_exec($ch);
      if ($res === false) throw new Exception('Curl error: ' . curl_error($ch));

      $dec = json_decode($res, true);
      if (!$dec) throw new Exception("Respuesta invlida de la API SMS");
      return $dec;
}
