<!--MODULO:: Galera Asociada Home /galeria_home.php -->

<?php

error_reporting(E_ALL);
ini_set('display_errors', 'On');

// Asegurar que $lc_Id_Galeria est definido
$lc_Id_Galeria = isset($lc_Id_Galeria) ? $lc_Id_Galeria : 0; // Valor predeterminado si no est definido

// Asegurar que la consulta existe antes de ejecutarla
if (isset($la_Tabla_Consulta['galeria_home']['Query'])) {
  $la_Resultado = HacerConsultaQuery(Reemplazar_Codigo_Query($la_Tabla_Consulta['galeria_home']['Query'], $lc_Id_Galeria));
} else {
  $la_Resultado = null;
}

if ($la_Resultado && isset($la_Resultado->DB_registros) && $la_Resultado->DB_registros > 0) {

  /***************************************
    // TOMAR LA PLANTILLA DE GALERA
   ***************************************/

  $la_Productos = array();
  $la_Items = array();

  // RECORRER CADA PRODUCTO
  for ($li_Registro = 0; $li_Registro < $la_Resultado->DB_registros; $li_Registro++) {

    // Verificar que el ndice existe antes de acceder
    if (isset($la_Resultado->DB_resultado[$li_Registro])) {
      $lo_Registro = $la_Resultado->DB_resultado[$li_Registro];

      // Verificar si 'enlace' est definido y no es nulo
      if (!isset($lo_Registro['enlace']) || trim($lo_Registro['enlace']) == "") {
        $lo_Registro['enlace'] = "#";
      }

      // ADICIONAR EL PRODUCTO A LA PLANTILLA DE SUBCATEGORAS
      $la_Items[] = Combinar_Registro_Plantilla($lo_Registro, $lc_Plantilla_Item_Home);
    }
  }


  // ADICIONAR LOS ITEMS
  $la_Productos['items_galeria_home'] = implode("", $la_Items);

  // PRESENTAR LA PLANTILLA CON LOS PRODUCTOS
  echo Combinar_Registro_Plantilla($la_Productos, $lc_Plantilla_Galeria_Home);
}

?>