<?php
// ACTIVAR REPORTES DE ERRORES
error_reporting(E_ALL);
ini_set('display_errors', 'On');

// CARGAR ARCHIVOS NECESARIOS
require_once('../Connections/conexion.php');
require_once('../siev/php/Conexion_BD.php');
require_once('../siev/php/Funciones_Generales.php');

// CONECTAR A LA BASE DE DATOS
$conn = new ConexionMySql();
$conexion = $conn->DB_conexion;

// VERIFICAR SI LA CONEXIN ES VLIDA
if (!$conexion) {
    die("Error: No se pudo conectar a la base de datos.");
}

// OBTENER ID DEL CLIENTE DESDE GET
$colname_clientes = isset($_GET['idcliente']) ? $_GET['idcliente'] : '-1';

// CONSULTAR CLIENTE
$query_clientes = "SELECT     custom_cliente,
    custom_dominio2,
    ruta_imagen,
    custom_empresa,
    custom_diremp,
    custom_celemp, plantillaje,email FROM clientes WHERE custom_cliente = ?";
$stmt = mysqli_prepare($conexion, $query_clientes);
mysqli_stmt_bind_param($stmt, "s", $colname_clientes);
mysqli_stmt_execute($stmt);
$result_clientes = mysqli_stmt_get_result($stmt);
$row_clientes = mysqli_fetch_assoc($result_clientes);

// print_r($row_clientes);

if (!$row_clientes) {
    die("Error: Cliente no encontrado.");
}

// OBTENER ID DEL USUARIO DESDE GET
$colname_usuarios = isset($_GET['usu']) ? $_GET['usu'] : '-1';

// CONSULTAR USUARIO
$query_usuarios = "SELECT * FROM usuarios WHERE custom_id = ?";
$stmt = mysqli_prepare($conexion, $query_usuarios);
mysqli_stmt_bind_param($stmt, "i", $colname_usuarios);
mysqli_stmt_execute($stmt);
$result_usuarios = mysqli_stmt_get_result($stmt);
$row_usuarios = mysqli_fetch_assoc($result_usuarios);


if (!$row_usuarios) {
    die("Error: Usuario no encontrado.");
}

function prefijar_array($array, $prefijo)
{
    $nuevo_array = [];
    foreach ($array as $clave => $valor) {
        $nuevo_array[$prefijo . $clave] = $valor;
    }
    return $nuevo_array;
}

$row_clientes_pref = prefijar_array($row_clientes, 'cliente_');
$row_usuarios_pref = prefijar_array($row_usuarios, 'usuario_');

$la_Registro = array_merge($row_clientes_pref, $row_usuarios_pref);

// print_r($la_Registro);


// ADICIONAR LA CLAVE RECUPERADA
$la_Registro['clave'] = isset($_GET['clave']) ? $_GET['clave'] : '';


// print_r($la_Registro);


// VERIFICAR SI EL ARCHIVO DE PLANTILLA EXISTE
$plantilla_path = $weblider . "/" . $row_clientes['plantillaje'] . "/comunicaciones/plantilla_correo_recordar_clave.html";



// CARGAR Y COMBINAR PLANTILLA
$lc_Plantilla_Sugerencia = file_get_contents($plantilla_path);

echo Combinar_Registro_Plantilla($la_Registro, $lc_Plantilla_Sugerencia);

// LIBERAR MEMORIA
mysqli_free_result($result_clientes);
mysqli_free_result($result_usuarios);
