/*
 * Decompiled with CFR 0.152.
 */
package com.vtiger.vtwsclib.helpers;

import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONValue;

public class HTTP_Client
extends DefaultHttpClient {
    private String _serviceurl;

    public HTTP_Client(String url) {
        this._serviceurl = url;
    }

    protected void finalize() throws Throwable {
        this.getConnectionManager().shutdown();
        super.finalize();
    }

    public Object doGet(Object data) {
        return this.doGet(data, false);
    }

    public Object doGet(Object data, boolean convertToJSON) {
        try {
            String uri = this._serviceurl;
            if (data != null) {
                if (!uri.endsWith("?")) {
                    uri = String.valueOf(uri) + "?";
                }
                if (data instanceof String) {
                    uri = String.valueOf(uri) + data;
                } else if (data instanceof Map) {
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    Map dataMap = (Map)data;
                    for (Object key : dataMap.keySet()) {
                        params.add(new BasicNameValuePair(key.toString(), (String)dataMap.get(key)));
                    }
                    uri = String.valueOf(uri) + URLEncodedUtils.format(params, (String)"UTF-8");
                }
            }
            HttpGet httpGet = new HttpGet(uri);
            HttpResponse httpResponse = this.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)httpEntity);
            if (convertToJSON) {
                return this.__jsondecode(response);
            }
            return response;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public Object doPost(Object data) {
        return this.doPost(data, false);
    }

    public Object doPost(Object data, boolean convertToJSON) {
        try {
            String uri = this._serviceurl;
            HttpPost httpPost = new HttpPost(uri);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                for (Object key : dataMap.keySet()) {
                    params.add(new BasicNameValuePair(key.toString(), (String)dataMap.get(key)));
                }
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse httpResponse = this.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)httpEntity);
            if (convertToJSON) {
                return this.__jsondecode(response);
            }
            return response;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public Object __jsondecode(String input) {
        return JSONValue.parse(input);
    }

    public String __jsonencode(Object input) {
        return JSONValue.toJSONString(input);
    }
}

